/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.mainView;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.adtui.stdui.Chunk;
import com.android.tools.adtui.stdui.EmptyStatePanel;
import com.android.tools.adtui.stdui.LabelData;
import com.android.tools.adtui.stdui.NewLineChunk;
import com.android.tools.adtui.stdui.TextChunk;
import com.android.tools.adtui.stdui.UrlData;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.sqlite.controllers.TabId;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseDiffOperation;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorView;
import com.android.tools.idea.sqlite.ui.mainView.LeftPanelView;
import com.android.tools.idea.sqlite.ui.mainView.SchemaDiffOperation;
import com.android.tools.idea.sqlite.ui.mainView.ViewDatabase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBEditorTabsBorder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003OPQB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0016J\u0016\u0010&\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u001e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0(H\u0016J(\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u00104\u001a\u00020#2\u0006\u00100\u001a\u00020\u001dH\u0016J\u0010\u00105\u001a\u00020#2\u0006\u00100\u001a\u00020\u001dH\u0016J\u001a\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020 2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?H\u0016J\b\u0010A\u001a\u00020#H\u0016J\u0010\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020<H\u0016J\u0010\u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020<H\u0016J\u0010\u0010F\u001a\u00020#2\u0006\u00107\u001a\u00020 H\u0016J\u0018\u0010G\u001a\u00020#2\u0006\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020 H\u0002J(\u0010J\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u0010K\u001a\u00020\u0018H\u0002J\u0010\u0010L\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00120NH\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorView;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "listeners", "", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorView$Listener;", "getListeners", "()Ljava/util/List;", "centerPanel", "Ljavax/swing/JPanel;", "leftPanelView", "Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView;", "viewContext", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SqliteViewContext;", "workBench", "Lcom/android/tools/adtui/workbench/WorkBench;", "tabs", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$BorderedTabs;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "openTabs", "", "Lcom/android/tools/idea/sqlite/controllers/TabId;", "Lcom/intellij/ui/tabs/TabInfo;", "databaseInspectorHelpUrl", "", "offlineModeHelpUrl", "addListener", "", "listener", "removeListener", "updateDatabases", "databaseDiffOperations", "", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseDiffOperation;", "updateDatabaseSchema", "viewDatabase", "Lcom/android/tools/idea/sqlite/ui/mainView/ViewDatabase;", "diffOperations", "Lcom/android/tools/idea/sqlite/ui/mainView/SchemaDiffOperation;", "openTab", "tabId", "tabName", "tabIcon", "Ljavax/swing/Icon;", "focusTab", "closeTab", "reportError", "message", "throwable", "", "setRefreshButtonState", "state", "", "showEnterOfflineModePanel", "filesDownloaded", "", "totalFilesToDownload", "showOfflineModeUnavailablePanel", "setForceOpen", "forceOpen", "updateKeepConnectionOpenButton", "keepOpen", "reportSyncProgress", "addEmptyStatePanel", "text", "url", "createTab", "tabContent", "resetCenterPanelAndAddView", "createToolWindowDefinition", "Lcom/android/tools/adtui/workbench/ToolWindowDefinition;", "SchemaPanelToolContent", "SqliteViewContext", "BorderedTabs", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nDatabaseInspectorViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseInspectorViewImpl.kt\ncom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,307:1\n1863#2,2:308\n*S KotlinDebug\n*F\n+ 1 DatabaseInspectorViewImpl.kt\ncom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl\n*L\n189#1:308,2\n*E\n"})
public final class DatabaseInspectorViewImpl
implements DatabaseInspectorView {
    @NotNull
    private final List<DatabaseInspectorView.Listener> listeners;
    @NotNull
    private final JPanel centerPanel;
    @NotNull
    private final LeftPanelView leftPanelView;
    @NotNull
    private final SqliteViewContext viewContext;
    @NotNull
    private final WorkBench<SqliteViewContext> workBench;
    @NotNull
    private final BorderedTabs tabs;
    @NotNull
    private final JComponent component;
    @NotNull
    private final Map<TabId, TabInfo> openTabs;
    @NotNull
    private final String databaseInspectorHelpUrl;
    @NotNull
    private final String offlineModeHelpUrl;

    public DatabaseInspectorViewImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        BorderedTabs borderedTabs;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.listeners = new ArrayList();
        this.centerPanel = new JPanel(new BorderLayout());
        this.leftPanelView = new LeftPanelView(this);
        this.viewContext = new SqliteViewContext(this.leftPanelView.getComponent());
        this.workBench = new WorkBench(project, "Database Inspector", null, parentDisposable);
        this.tabs = new BorderedTabs(project, parentDisposable);
        this.component = (JComponent)this.workBench;
        this.openTabs = new LinkedHashMap();
        this.databaseInspectorHelpUrl = "https://d.android.com/r/studio-ui/db-inspector-help";
        this.offlineModeHelpUrl = "https://d.android.com/r/studio-ui/db-inspector-help/offline";
        this.workBench.init((JComponent)this.centerPanel, (Object)this.viewContext, CollectionsKt.listOf(this.createToolWindowDefinition()), false);
        this.addEmptyStatePanel(DatabaseInspectorBundle.INSTANCE.message("waiting.for.connection", new String[0]), this.databaseInspectorHelpUrl);
        this.tabs.setName("right-panel-tabs-panel");
        BorderedTabs $this$_init__u24lambda_u240 = borderedTabs = this.tabs;
        boolean bl = false;
        $this$_init__u24lambda_u240.setTabDraggingEnabled(true);
        $this$_init__u24lambda_u240.setUiDecorator(new UiDecorator(){

            public UiDecorator.UiDecoration getDecoration() {
                return new UiDecorator.UiDecoration(null, (Insets)JBUI.insets((int)5, (int)6), null, null, 13, null);
            }
        });
        $this$_init__u24lambda_u240.addTabMouseListener(new MouseAdapter($this$_init__u24lambda_u240, this){
            final /* synthetic */ BorderedTabs $this_apply;
            final /* synthetic */ DatabaseInspectorViewImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    TabInfo targetTabInfo;
                    TabInfo tabInfo = targetTabInfo = this.$this_apply.findInfo(e);
                    Object object = tabInfo != null ? tabInfo.getObject() : null;
                    TabId tabId = object instanceof TabId ? (TabId)object : null;
                    if (tabId == null) {
                        return;
                    }
                    TabId tabId2 = tabId;
                    Iterable $this$forEach$iv = this.this$0.getListeners();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
                        boolean bl = false;
                        it.closeTabActionInvoked(tabId2);
                    }
                }
            }
        });
    }

    @NotNull
    public final List<DatabaseInspectorView.Listener> getListeners() {
        return this.listeners;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void addListener(@NotNull DatabaseInspectorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DatabaseInspectorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void updateDatabases(@NotNull List<? extends DatabaseDiffOperation> databaseDiffOperations) {
        Intrinsics.checkNotNullParameter(databaseDiffOperations, (String)"databaseDiffOperations");
        for (DatabaseDiffOperation databaseDiffOperation : databaseDiffOperations) {
            DatabaseDiffOperation databaseDiffOperation2 = databaseDiffOperation;
            if (databaseDiffOperation2 instanceof DatabaseDiffOperation.AddDatabase) {
                this.leftPanelView.addDatabaseSchema(((DatabaseDiffOperation.AddDatabase)databaseDiffOperation).getViewDatabase(), ((DatabaseDiffOperation.AddDatabase)databaseDiffOperation).getSchema(), ((DatabaseDiffOperation.AddDatabase)databaseDiffOperation).getIndex());
                continue;
            }
            if (databaseDiffOperation2 instanceof DatabaseDiffOperation.RemoveDatabase) {
                this.leftPanelView.removeDatabaseSchema(((DatabaseDiffOperation.RemoveDatabase)databaseDiffOperation).getViewDatabase());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (this.openTabs.isEmpty() || this.leftPanelView.getDatabasesCount() == 0) {
            this.addEmptyStatePanel(DatabaseInspectorBundle.INSTANCE.message("default.empty.state.message", new String[0]), this.databaseInspectorHelpUrl);
        }
    }

    @Override
    public void updateDatabaseSchema(@NotNull ViewDatabase viewDatabase, @NotNull List<? extends SchemaDiffOperation> diffOperations) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        Intrinsics.checkNotNullParameter(diffOperations, (String)"diffOperations");
        this.leftPanelView.updateDatabase(viewDatabase, diffOperations);
    }

    @Override
    public void openTab(@NotNull TabId tabId, @NotNull String tabName, @NotNull Icon tabIcon, @NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter((Object)tabIcon, (String)"tabIcon");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.openTabs.isEmpty()) {
            this.resetCenterPanelAndAddView((JComponent)((Object)this.tabs));
        }
        TabInfo tab = this.createTab(tabId, tabName, tabIcon, component);
        this.tabs.addTab(tab);
        this.tabs.select(tab, true);
        this.openTabs.put(tabId, tab);
    }

    @Override
    public void focusTab(@NotNull TabId tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        TabInfo tabInfo = this.openTabs.get(tabId);
        Intrinsics.checkNotNull((Object)tabInfo);
        this.tabs.select(tabInfo, true);
    }

    @Override
    public void closeTab(@NotNull TabId tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        TabInfo tab = this.openTabs.remove(tabId);
        this.tabs.removeTab(tab);
        if (this.openTabs.isEmpty()) {
            this.addEmptyStatePanel(DatabaseInspectorBundle.INSTANCE.message("default.empty.state.message", new String[0]), this.databaseInspectorHelpUrl);
        }
    }

    @Override
    public void reportError(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        UtilsKt.notifyError(message, throwable);
    }

    @Override
    public void setRefreshButtonState(boolean state2) {
        this.leftPanelView.setRefreshButtonState(state2);
    }

    @Override
    public void showEnterOfflineModePanel(int filesDownloaded, int totalFilesToDownload) {
        Chunk[] chunkArray = new Chunk[]{new TextChunk("Moving to offline mode"), NewLineChunk.INSTANCE, new TextChunk("(" + filesDownloaded + "/" + totalFilesToDownload + ") databases downloaded...")};
        EmptyStatePanel enterOfflineModePanel = new EmptyStatePanel(new LabelData(chunkArray), null, new ActionData("Cancel", null, () -> DatabaseInspectorViewImpl.showEnterOfflineModePanel$lambda$2(this), 2, null), null, 10, null);
        enterOfflineModePanel.setName("right-panel-offline-mode");
        this.resetCenterPanelAndAddView((JComponent)enterOfflineModePanel);
    }

    @Override
    public void showOfflineModeUnavailablePanel() {
        this.addEmptyStatePanel("Offline mode unavailable.", this.offlineModeHelpUrl);
    }

    @Override
    public void setForceOpen(boolean forceOpen) {
        this.leftPanelView.setForceOpen(forceOpen);
    }

    @Override
    public void updateKeepConnectionOpenButton(boolean keepOpen) {
        this.leftPanelView.updateKeepConnectionOpenButton(keepOpen);
    }

    @Override
    public void reportSyncProgress(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    private final void addEmptyStatePanel(String text2, String url) {
        EmptyStatePanel emptyStatePanel = new EmptyStatePanel(text2, new UrlData("Learn more", url), null, 4, null);
        emptyStatePanel.setName("right-panel-empty-state");
        this.resetCenterPanelAndAddView((JComponent)emptyStatePanel);
    }

    private final TabInfo createTab(TabId tabId, String tabName, Icon tabIcon, JComponent tabContent) {
        TabInfo tab = new TabInfo(tabContent);
        tab.setObject((Object)tabId);
        DefaultActionGroup tabActionGroup = new DefaultActionGroup();
        String string = DatabaseInspectorBundle.INSTANCE.message("action.close.tab", new String[0]);
        String string2 = DatabaseInspectorBundle.INSTANCE.message("action.close.tab.desc", new String[0]);
        Icon icon = AllIcons.Actions.Close;
        tabActionGroup.add(new AnAction(this, tabId, string, string2, icon){
            final /* synthetic */ DatabaseInspectorViewImpl this$0;
            final /* synthetic */ TabId $tabId;
            {
                this.this$0 = $receiver;
                this.$tabId = $tabId;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable iterable = this.this$0.getListeners();
                TabId tabId = this.$tabId;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it.closeTabActionInvoked(tabId);
                }
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
                e.getPresentation().setVisible(true);
                e.getPresentation().setText(UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]));
            }
        });
        tab.setTabLabelActions((ActionGroup)tabActionGroup, "EditorTab");
        tab.setIcon(tabIcon);
        tab.setText(tabName);
        return tab;
    }

    private final void resetCenterPanelAndAddView(JComponent component) {
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add(component);
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    private final ToolWindowDefinition<SqliteViewContext> createToolWindowDefinition() {
        return new ToolWindowDefinition("Databases", StudioIcons.DatabaseInspector.TABLE, "DATABASES", Side.LEFT, Split.TOP, AutoHide.DOCKED, ToolWindowDefinition.DEFAULT_SIDE_WIDTH, ToolWindowDefinition.DEFAULT_BUTTON_SIZE, 0, arg_0 -> DatabaseInspectorViewImpl.createToolWindowDefinition$lambda$3(this, arg_0));
    }

    private static final Unit showEnterOfflineModePanel$lambda$2(DatabaseInspectorViewImpl this$0) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
            boolean bl = false;
            it.cancelOfflineModeInvoked();
        }
        return Unit.INSTANCE;
    }

    private static final ToolContent createToolWindowDefinition$lambda$3(DatabaseInspectorViewImpl this$0, Disposable it) {
        return this$0.new SchemaPanelToolContent();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$BorderedTabs;", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "createTabBorder", "Lcom/intellij/ui/tabs/impl/JBEditorTabsBorder;", "app-inspection.inspectors.database"})
    private static final class BorderedTabs
    extends JBTabsImpl {
        public BorderedTabs(@NotNull Project project, @NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(project, parent);
        }

        @NotNull
        protected JBEditorTabsBorder createTabBorder() {
            return new JBEditorTabsBorder((JBTabsImpl)this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SchemaPanelToolContent;", "Lcom/android/tools/adtui/workbench/ToolContent;", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SqliteViewContext;", "<init>", "(Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;)V", "component", "Ljavax/swing/JComponent;", "setToolContext", "", "toolContext", "getComponent", "dispose", "getAdditionalActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "app-inspection.inspectors.database"})
    public final class SchemaPanelToolContent
    implements ToolContent<SqliteViewContext> {
        private JComponent component;

        public void setToolContext(@Nullable SqliteViewContext toolContext) {
            Object object = toolContext;
            if (object == null || (object = ((SqliteViewContext)object).getComponent()) == null) {
                object = new JPanel();
            }
            this.component = object;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.component;
            if (jComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
                jComponent = null;
            }
            return jComponent;
        }

        public void dispose() {
        }

        @NotNull
        public List<AnAction> getAdditionalActions() {
            return CollectionsKt.listOf((Object)DatabaseInspectorViewImpl.this.leftPanelView.createCollapseTreeAction());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SqliteViewContext;", "", "component", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "getComponent", "()Ljavax/swing/JComponent;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "app-inspection.inspectors.database"})
    public static final class SqliteViewContext {
        @NotNull
        private final JComponent component;

        public SqliteViewContext(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.component = component;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final JComponent component1() {
            return this.component;
        }

        @NotNull
        public final SqliteViewContext copy(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return new SqliteViewContext(component);
        }

        public static /* synthetic */ SqliteViewContext copy$default(SqliteViewContext sqliteViewContext, JComponent jComponent, int n, Object object) {
            if ((n & 1) != 0) {
                jComponent = sqliteViewContext.component;
            }
            return sqliteViewContext.copy(jComponent);
        }

        @NotNull
        public String toString() {
            return "SqliteViewContext(component=" + this.component + ")";
        }

        public int hashCode() {
            return this.component.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SqliteViewContext)) {
                return false;
            }
            SqliteViewContext sqliteViewContext = (SqliteViewContext)other;
            return Intrinsics.areEqual((Object)this.component, (Object)sqliteViewContext.component);
        }
    }
}

