/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.tableView;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.SqliteColumnValue;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.tableView.OrderBy;
import com.android.tools.idea.sqlite.ui.tableView.RowDiffOperation;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.android.tools.idea.sqlite.ui.tableView.ViewColumn;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0007hijklmnB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020\rH\u0016J\b\u0010@\u001a\u000201H\u0016J\b\u0010A\u001a\u000201H\u0016J\b\u0010B\u001a\u000201H\u0016J\u0016\u0010C\u001a\u0002012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016J\u0016\u0010D\u001a\u0002012\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F0\fH\u0016J\u0010\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020\u0005H\u0016J\u0010\u0010I\u001a\u0002012\u0006\u0010J\u001a\u00020\rH\u0016J\b\u0010K\u001a\u000201H\u0016J\u0010\u0010L\u001a\u0002012\u0006\u00107\u001a\u000206H\u0016J\u0010\u0010M\u001a\u0002012\u0006\u0010N\u001a\u000203H\u0016J\u0010\u0010O\u001a\u0002012\u0006\u0010N\u001a\u000203H\u0016J\u0010\u0010P\u001a\u0002012\u0006\u00105\u001a\u000203H\u0016J\b\u0010Q\u001a\u000203H\u0016J\u001f\u0010R\u001a\u0014 T*\t\u0018\u00010\r\u00a2\u0006\u0002\bS0\r\u00a2\u0006\u0002\bSH\u0016\u00a2\u0006\u0002\u0010UJ\u001a\u0010V\u001a\u0002012\u0006\u0010W\u001a\u00020\u00052\b\u0010X\u001a\u0004\u0018\u00010YH\u0016J\u0010\u0010Z\u001a\u0002012\u0006\u0010[\u001a\u000203H\u0016J\u0010\u0010\\\u001a\u0002012\u0006\u0010[\u001a\u000203H\u0016J\u0010\u0010]\u001a\u0002012\u0006\u0010^\u001a\u000203H\u0016J\u0010\u0010_\u001a\u0002012\u0006\u0010`\u001a\u00020\nH\u0016J\u0010\u0010a\u001a\u0002012\u0006\u0010`\u001a\u00020\nH\u0016J\u0010\u0010b\u001a\u0002012\u0006\u0010c\u001a\u000203H\u0016J\u0010\u0010d\u001a\u0002012\u0006\u0010e\u001a\u000203H\u0002J\b\u0010f\u001a\u000201H\u0002J\b\u0010g\u001a\u000201H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u00107\u001a\u0002062\u0006\u00105\u001a\u0002068G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010:\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "<init>", "()V", "tableIsEmptyText", "", "Lorg/jetbrains/annotations/Nls;", "loadingTableDataText", "listeners", "", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView$Listener;", "pageSizeDefaultValues", "", "", "columns", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "rootPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "readOnlyLabel", "Ljavax/swing/JLabel;", "isForcedBanner", "Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$IsForcedConnectionBanner;", "firstRowsPageButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "lastRowsPageButton", "previousRowsPageButton", "nextRowsPageButton", "pageSizeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "refreshButton", "liveUpdatesCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "exportButton", "table", "Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTable;", "tableScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "progressBar", "Ljavax/swing/JProgressBar;", "topPanel", "centerPanel", "layeredPane", "Ljavax/swing/JLayeredPane;", "myRevertLastTableCellEdit", "Lkotlin/Function0;", "", "isLoading", "", "tableHadFocus", "value", "Lcom/android/tools/idea/sqlite/ui/tableView/OrderBy;", "orderBy", "getOrderBy", "()Lcom/android/tools/idea/sqlite/ui/tableView/OrderBy;", "liveUpdatesEnabled", "refreshEnabled", "createPagingControlsPanel", "Ljava/awt/Component;", "showPageSizeValue", "maxRowCount", "resetView", "startTableLoading", "stopTableLoading", "showTableColumns", "updateRows", "rowDiffOperations", "Lcom/android/tools/idea/sqlite/ui/tableView/RowDiffOperation;", "setEmptyText", "text", "setRowOffset", "rowOffset", "revertLastTableCellEdit", "setColumnSortIndicator", "setLiveUpdatesButtonState", "state", "setRefreshButtonState", "setLiveUpdatesEnabled", "isLiveUpdatesEnabled", "getPageSize", "Lorg/jetbrains/annotations/UnknownNullability;", "kotlin.jvm.PlatformType", "()Ljava/lang/Integer;", "reportError", "message", "t", "", "setFetchPreviousRowsButtonState", "enable", "setFetchNextRowsButtonState", "setEditable", "isEditable", "addListener", "listener", "removeListener", "updateIsForcedBanner", "show", "setControlButtonsEnabled", "enabled", "setAutoResizeMode", "setUpPopUp", "MyTableHeaderRenderer", "MyTable", "MyColoredTableCellRenderer", "MyTableModel", "MatchParentLayoutManager", "MyRow", "IsForcedConnectionBanner", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,776:1\n1#2:777\n1863#3,2:778\n1863#3,2:780\n1863#3,2:782\n1863#3,2:784\n1863#3,2:786\n1863#3,2:788\n1863#3,2:790\n1863#3,2:792\n1863#3,2:794\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl\n*L\n299#1:778,2\n170#1:780,2\n174#1:782,2\n193#1:784,2\n287#1:786,2\n294#1:788,2\n306#1:790,2\n314#1:792,2\n321#1:794,2\n*E\n"})
public final class TableViewImpl
implements TableView {
    @NotNull
    private final String tableIsEmptyText = DatabaseInspectorBundle.INSTANCE.message("table.is.empty", new String[0]);
    @NotNull
    private final String loadingTableDataText = DatabaseInspectorBundle.INSTANCE.message("loading.data", new String[0]);
    @NotNull
    private final List<TableView.Listener> listeners = new ArrayList();
    @NotNull
    private final List<Integer> pageSizeDefaultValues;
    @Nullable
    private List<ViewColumn> columns;
    @NotNull
    private final BorderLayoutPanel rootPanel;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JLabel readOnlyLabel;
    @NotNull
    private final IsForcedConnectionBanner isForcedBanner;
    @NotNull
    private final CommonButton firstRowsPageButton;
    @NotNull
    private final CommonButton lastRowsPageButton;
    @NotNull
    private final CommonButton previousRowsPageButton;
    @NotNull
    private final CommonButton nextRowsPageButton;
    @NotNull
    private final ComboBox<Integer> pageSizeComboBox;
    @NotNull
    private final CommonButton refreshButton;
    @NotNull
    private final JBCheckBox liveUpdatesCheckBox;
    @NotNull
    private final CommonButton exportButton;
    @NotNull
    private final MyTable table;
    @NotNull
    private final JBScrollPane tableScrollPane;
    @NotNull
    private final JProgressBar progressBar;
    @NotNull
    private final BorderLayoutPanel topPanel;
    @NotNull
    private final BorderLayoutPanel centerPanel;
    @NotNull
    private final JLayeredPane layeredPane;
    @Nullable
    private Function0<Unit> myRevertLastTableCellEdit;
    private boolean isLoading;
    private boolean tableHadFocus;
    @NotNull
    private OrderBy orderBy;
    private boolean liveUpdatesEnabled;
    private boolean refreshEnabled;

    public TableViewImpl() {
        JPanel jPanel;
        Object[] objectArray = new Integer[]{5, 10, 20, 25, 50};
        this.pageSizeDefaultValues = CollectionsKt.listOf((Object[])objectArray);
        this.rootPanel = new BorderLayoutPanel();
        this.component = (JComponent)this.rootPanel;
        this.readOnlyLabel = new JLabel("Results are read-only");
        this.isForcedBanner = new IsForcedConnectionBanner();
        this.firstRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.GO_TO_START);
        this.lastRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.GO_TO_END);
        this.previousRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.PREVIOUS_TICK);
        this.nextRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.NEXT_TICK);
        this.pageSizeComboBox = new ComboBox();
        this.refreshButton = new CommonButton(AllIcons.Actions.Refresh);
        this.liveUpdatesCheckBox = new JBCheckBox(DatabaseInspectorBundle.INSTANCE.message("action.live.updates", new String[0]));
        this.exportButton = new CommonButton(AllIcons.ToolbarDecorator.Export);
        this.table = new MyTable();
        this.tableScrollPane = new JBScrollPane((Component)((Object)this.table));
        this.progressBar = new JProgressBar();
        this.topPanel = new BorderLayoutPanel();
        this.centerPanel = new BorderLayoutPanel();
        this.layeredPane = new JLayeredPane();
        this.orderBy = OrderBy.NotOrdered.INSTANCE;
        this.liveUpdatesEnabled = true;
        this.refreshEnabled = true;
        JPanel it = jPanel = new JPanel();
        boolean bl = false;
        it.setLayout(new BoxLayout(it, 0));
        JPanel tableActionsPanel = jPanel;
        this.isForcedBanner.setVisible(false);
        this.topPanel.addToTop((Component)((Object)this.isForcedBanner));
        this.topPanel.addToCenter((Component)tableActionsPanel);
        this.rootPanel.addToTop((Component)this.topPanel);
        this.rootPanel.addToCenter((Component)this.centerPanel);
        this.centerPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        tableActionsPanel.setName("table-actions-panel");
        tableActionsPanel.setBorder(JBUI.Borders.merge((Border)BorderFactory.createEmptyBorder(2, 0, 2, 0), (Border)IdeBorderFactory.createBorder((int)8), (boolean)true));
        Component pagingControlsPanel = this.createPagingControlsPanel();
        this.setFetchNextRowsButtonState(false);
        this.setFetchPreviousRowsButtonState(false);
        this.refreshButton.setName("refresh-button");
        Icon icon = AllIcons.Actions.Refresh;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Refresh");
        this.refreshButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        this.refreshButton.setToolTipText("Refresh table");
        this.refreshButton.setEnabled(false);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add((Component)this.refreshButton);
        this.refreshButton.addActionListener(arg_0 -> TableViewImpl._init_$lambda$2(this, arg_0));
        this.liveUpdatesCheckBox.setName("live-updates-checkbox");
        this.liveUpdatesCheckBox.setEnabled(false);
        this.liveUpdatesCheckBox.addActionListener(arg_0 -> TableViewImpl._init_$lambda$4(this, arg_0));
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add((Component)this.liveUpdatesCheckBox);
        new HelpTooltip().setDescription(DatabaseInspectorBundle.INSTANCE.message("action.live.updates.desc", new String[0])).setLink(DatabaseInspectorBundle.INSTANCE.message("learn.more", new String[0]), TableViewImpl::_init_$lambda$5).installOn((JComponent)this.liveUpdatesCheckBox);
        this.exportButton.setName("export-button");
        Icon icon2 = this.exportButton.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getIcon(...)");
        this.exportButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon2));
        this.exportButton.setEnabled(false);
        new HelpTooltip().setTitle(DatabaseInspectorBundle.INSTANCE.message("action.export.button.tooltip.title", new String[0])).installOn((JComponent)this.exportButton);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add((Component)this.exportButton);
        this.exportButton.addActionListener(arg_0 -> TableViewImpl._init_$lambda$7(this, arg_0));
        this.readOnlyLabel.setVisible(false);
        this.readOnlyLabel.setName("read-only-label");
        this.readOnlyLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.readOnlyLabel.setOpaque(true);
        this.readOnlyLabel.setBackground((Color)new JBColor(new Color(14478846), new Color(4606541)));
        tableActionsPanel.add(Box.createHorizontalGlue());
        tableActionsPanel.add(this.readOnlyLabel);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add(pagingControlsPanel);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        this.table.resetDefaultFocusTraversalKeys();
        this.table.setStriped(true);
        this.table.getEmptyText().setText(this.tableIsEmptyText);
        this.table.getEmptyText().setShowAboveCenter(false);
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new MyColoredTableCellRenderer()));
        this.table.getTableHeader().setDefaultRenderer(new MyTableHeaderRenderer());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (isLoading) {
                    return;
                }
                TableCellEditor tableCellEditor = table.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                int columnIndex = table.columnAtPoint(e.getPoint());
                if (columnIndex <= 0) {
                    return;
                }
                Iterable iterable = listeners;
                TableViewImpl tableViewImpl = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it = (TableView.Listener)element$iv;
                    boolean bl = false;
                    List list = tableViewImpl.columns;
                    Intrinsics.checkNotNull((Object)list);
                    it.toggleOrderByColumnInvoked((ViewColumn)list.get(columnIndex - 1));
                }
            }
        });
        this.table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                TableCellEditor tableCellEditor = table.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                Point mousePoint = new Point(x, y);
                int viewRowIndex = table.rowAtPoint(mousePoint);
                int viewColumnIndex = table.columnAtPoint(mousePoint);
                if (viewRowIndex < 0 || viewColumnIndex < 0) {
                    return;
                }
                table.clearSelection();
                table.addRowSelectionInterval(viewRowIndex, viewRowIndex);
                table.addColumnSelectionInterval(viewColumnIndex, viewColumnIndex);
            }
        });
        this.tableScrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setAutoResizeMode();
            }
        });
        this.centerPanel.add((Component)this.layeredPane, (Object)"Center");
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)this.tableScrollPane, "Center");
        this.tableScrollPane.setBorder((Border)JBUI.Borders.empty());
        JPanel progressBarPanel = new JPanel(new BorderLayout());
        progressBarPanel.add((Component)this.progressBar, "North");
        progressBarPanel.setOpaque(false);
        this.layeredPane.add(tablePanel);
        this.layeredPane.add(progressBarPanel);
        this.layeredPane.setLayout(new MatchParentLayoutManager());
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(true);
        this.progressBar.putClientProperty("ProgressBar.flatEnds", true);
        this.progressBar.putClientProperty("ProgressBar.stripeWidth", JBUI.scale((int)2));
        this.setUpPopUp();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @TestOnly
    @NotNull
    public final OrderBy getOrderBy() {
        return this.orderBy;
    }

    private final Component createPagingControlsPanel() {
        JPanel jPanel;
        JPanel it = jPanel = new JPanel();
        boolean bl = false;
        it.setLayout(new BoxLayout(it, 0));
        JPanel pagingControlsPanel = jPanel;
        Icon icon = StudioIcons.LayoutEditor.Motion.GO_TO_START;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GO_TO_START");
        this.firstRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        this.firstRowsPageButton.setToolTipText("Go to first page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.firstRowsPageButton);
        this.firstRowsPageButton.addActionListener(arg_0 -> TableViewImpl.createPagingControlsPanel$lambda$10(this, arg_0));
        Icon icon2 = StudioIcons.LayoutEditor.Motion.PREVIOUS_TICK;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PREVIOUS_TICK");
        this.previousRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon2));
        this.previousRowsPageButton.setToolTipText("Go to previous page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.previousRowsPageButton);
        this.previousRowsPageButton.addActionListener(arg_0 -> TableViewImpl.createPagingControlsPanel$lambda$12(this, arg_0));
        this.pageSizeComboBox.setName("page-size-combo-box");
        this.pageSizeComboBox.setEnabled(false);
        this.pageSizeComboBox.setEditable(true);
        Iterable $this$forEach$iv = this.pageSizeDefaultValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it2 = ((Number)element$iv).intValue();
            boolean bl2 = false;
            this.pageSizeComboBox.addItem((Object)it2);
        }
        this.pageSizeComboBox.setSelectedIndex(this.pageSizeDefaultValues.size() - 1);
        this.pageSizeComboBox.setPreferredSize((Dimension)JBUI.size((int)80, (int)30));
        this.pageSizeComboBox.setMaximumSize(this.pageSizeComboBox.getPreferredSize());
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.pageSizeComboBox);
        this.pageSizeComboBox.addActionListener(arg_0 -> TableViewImpl.createPagingControlsPanel$lambda$15(this, arg_0));
        Icon icon3 = StudioIcons.LayoutEditor.Motion.NEXT_TICK;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"NEXT_TICK");
        this.nextRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon3));
        this.nextRowsPageButton.setToolTipText("Go to next page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.nextRowsPageButton);
        this.nextRowsPageButton.addActionListener(arg_0 -> TableViewImpl.createPagingControlsPanel$lambda$17(this, arg_0));
        Icon icon4 = StudioIcons.LayoutEditor.Motion.GO_TO_END;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"GO_TO_END");
        this.lastRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon4));
        this.lastRowsPageButton.setToolTipText("Go to last page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.lastRowsPageButton);
        this.lastRowsPageButton.addActionListener(arg_0 -> TableViewImpl.createPagingControlsPanel$lambda$19(this, arg_0));
        return pagingControlsPanel;
    }

    @Override
    public void showPageSizeValue(int maxRowCount) {
        Object currentRowCount = this.pageSizeComboBox.getSelectedItem();
        if (!Intrinsics.areEqual((Object)currentRowCount, (Object)maxRowCount)) {
            this.pageSizeComboBox.setSelectedItem((Object)maxRowCount);
        }
    }

    @Override
    public void resetView() {
        this.columns = null;
        this.table.setModel(new MyTableModel(CollectionsKt.emptyList()));
        this.table.getEmptyText().setText(this.tableIsEmptyText);
        this.orderBy = OrderBy.NotOrdered.INSTANCE;
        this.setEditable(true);
        this.setControlButtonsEnabled(false);
        this.setFetchNextRowsButtonState(false);
        this.setFetchPreviousRowsButtonState(false);
    }

    @Override
    public void startTableLoading() {
        this.setControlButtonsEnabled(false);
        this.progressBar.setVisible(true);
        this.table.setEnabled(false);
        this.table.getEmptyText().setText(this.loadingTableDataText);
        this.tableHadFocus = this.table.hasFocus();
        if (this.table.hasFocus()) {
            this.progressBar.requestFocusInWindow();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.isLoading = true;
    }

    @Override
    public void stopTableLoading() {
        this.myRevertLastTableCellEdit = null;
        this.setControlButtonsEnabled(true);
        this.table.getEmptyText().setText(this.tableIsEmptyText);
        this.isLoading = false;
        this.progressBar.setVisible(false);
        this.table.setEnabled(true);
        if (this.progressBar.hasFocus() && this.tableHadFocus) {
            this.table.requestFocusInWindow();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    @Override
    public void showTableColumns(@NotNull List<ViewColumn> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        if (Intrinsics.areEqual(this.columns, columns2)) {
            return;
        }
        this.columns = columns2;
        this.table.setModel(new MyTableModel(columns2));
        if (!((Collection)columns2).isEmpty()) {
            this.table.getColumnModel().getColumn(0).setMaxWidth(JBUI.scale((int)60));
            this.table.getColumnModel().getColumn(0).setResizable(false);
            int n = this.table.getColumnModel().getColumnCount();
            for (int i = 1; i < n; ++i) {
                this.table.getColumnModel().getColumn(i).setMinWidth(JBUI.scale((int)65));
            }
            this.setAutoResizeMode();
        }
    }

    @Override
    public void updateRows(@NotNull List<? extends RowDiffOperation> rowDiffOperations) {
        Intrinsics.checkNotNullParameter(rowDiffOperations, (String)"rowDiffOperations");
        TableModel tableModel2 = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
        ((MyTableModel)tableModel2).applyRowsDiff(rowDiffOperations);
    }

    @Override
    public void setEmptyText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.table.getEmptyText().setText(text2);
    }

    @Override
    public void setRowOffset(int rowOffset) {
        TableModel tableModel2 = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
        ((MyTableModel)tableModel2).setRowOffset(rowOffset);
    }

    @Override
    public void revertLastTableCellEdit() {
        Function0<Unit> function0 = this.myRevertLastTableCellEdit;
        if (function0 != null) {
            function0.invoke();
        }
        this.myRevertLastTableCellEdit = null;
    }

    @Override
    public void setColumnSortIndicator(@NotNull OrderBy orderBy) {
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        this.orderBy = orderBy;
    }

    @Override
    public void setLiveUpdatesButtonState(boolean state2) {
        this.liveUpdatesEnabled = state2;
    }

    @Override
    public void setRefreshButtonState(boolean state2) {
        this.refreshEnabled = state2;
    }

    @Override
    public void setLiveUpdatesEnabled(boolean value2) {
        this.liveUpdatesCheckBox.setSelected(value2);
    }

    @Override
    public boolean isLiveUpdatesEnabled() {
        return this.liveUpdatesCheckBox.isSelected();
    }

    public Integer getPageSize() {
        return (Integer)this.pageSizeComboBox.getItem();
    }

    @Override
    public void reportError(@NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        UtilsKt.notifyError(message, t);
    }

    @Override
    public void setFetchPreviousRowsButtonState(boolean enable) {
        this.previousRowsPageButton.setEnabled(enable);
        this.firstRowsPageButton.setEnabled(enable);
    }

    @Override
    public void setFetchNextRowsButtonState(boolean enable) {
        this.nextRowsPageButton.setEnabled(enable);
        this.lastRowsPageButton.setEnabled(enable);
    }

    @Override
    public void setEditable(boolean isEditable) {
        TableModel tableModel2 = this.table.getModel();
        MyTableModel myTableModel = tableModel2 instanceof MyTableModel ? (MyTableModel)tableModel2 : null;
        if (myTableModel != null) {
            myTableModel.setEditable(isEditable);
        }
        this.readOnlyLabel.setVisible(!isEditable);
    }

    @Override
    public void addListener(@NotNull TableView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull TableView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void updateIsForcedBanner(boolean show2) {
        this.isForcedBanner.setVisible(show2);
    }

    private final void setControlButtonsEnabled(boolean enabled) {
        this.liveUpdatesCheckBox.setEnabled(this.liveUpdatesEnabled && enabled);
        this.refreshButton.setEnabled(this.refreshEnabled && enabled);
        this.exportButton.setEnabled(enabled);
        this.pageSizeComboBox.setEnabled(enabled);
    }

    private final void setAutoResizeMode() {
        if (this.table.getPreferredSize().width < this.table.getParent().getWidth()) {
            this.table.setAutoResizeMode(2);
        } else {
            this.table.setAutoResizeMode(0);
            int n = this.table.getColumnModel().getColumnCount();
            for (int i = 1; i < n; ++i) {
                this.table.getColumnModel().getColumn(i).setPreferredWidth(JBUI.scale((int)85));
            }
        }
    }

    private final void setUpPopUp() {
        String string = DatabaseInspectorBundle.INSTANCE.message("action.set.to.null", new String[0]);
        AnAction setNullAction2 = new AnAction(this, string){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int rowIndex = TableViewImpl.access$getTable$p(this.this$0).getSelectedRow();
                int columnIndex = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                if (columnIndex > 0) {
                    TableModel tableModel2 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                    Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                    ((MyTableModel)tableModel2).setValueAt(null, rowIndex, columnIndex);
                }
            }

            public void update(AnActionEvent e) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int columnIndex = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                if (columnIndex > 0) {
                    TableModel tableModel2 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                    Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                    ViewColumn column2 = ((MyTableModel)tableModel2).getColumns().get(columnIndex - 1);
                    bl = column2.isNullable();
                } else {
                    bl = false;
                }
                boolean isNullable = bl;
                TableModel tableModel3 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                MyTableModel myTableModel = tableModel3 instanceof MyTableModel ? (MyTableModel)tableModel3 : null;
                e.getPresentation().setEnabled((myTableModel != null ? myTableModel.isEditable() : false) && isNullable);
                super.update(e);
            }
        };
        Shortcut[] shortcutArray = DatabaseInspectorBundle.INSTANCE.message("action.copy.to.clipboard", new String[0]);
        AnAction copyToClipboardAction2 = new AnAction(this, (String)shortcutArray){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = TableViewImpl.access$getTable$p(this.this$0).getSelectedRow();
                int column2 = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                TableModel tableModel2 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                String value2 = ((MyTableModel)tableModel2).getValueAt(row, column2);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(value2), null);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int column2 = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                e.getPresentation().setEnabled(column2 > 0);
                super.update(e);
            }
        };
        shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(78, 576), null)};
        setNullAction2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.table));
        shortcutArray = new AnAction[]{copyToClipboardAction2, setNullAction2};
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this.table)), (ActionGroup)((ActionGroup)new DefaultActionGroup((AnAction[])shortcutArray)), (String)"SqliteTablePopup");
    }

    private static final void _init_$lambda$2(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            it2.refreshDataInvoked();
        }
    }

    private static final void _init_$lambda$4(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            it2.toggleLiveUpdatesInvoked();
        }
    }

    private static final void _init_$lambda$5() {
        BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/db-inspector-help/live-updates");
    }

    private static final void _init_$lambda$7(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            it2.showExportToFileDialogInvoked();
        }
    }

    private static final void createPagingControlsPanel$lambda$10(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            it2.loadFirstRowsInvoked();
        }
    }

    private static final void createPagingControlsPanel$lambda$12(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            it2.loadPreviousRowsInvoked();
        }
    }

    private static final void createPagingControlsPanel$lambda$15(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            Object object = this$0.pageSizeComboBox.getSelectedItem();
            Intrinsics.checkNotNull((Object)object);
            it2.rowCountChanged(object.toString());
        }
    }

    private static final void createPagingControlsPanel$lambda$17(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            it2.loadNextRowsInvoked();
        }
    }

    private static final void createPagingControlsPanel$lambda$19(TableViewImpl this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableView.Listener it2 = (TableView.Listener)element$iv;
            boolean bl = false;
            it2.loadLastRowsInvoked();
        }
    }

    public static final /* synthetic */ void access$setMyRevertLastTableCellEdit$p(TableViewImpl $this, Function0 function0) {
        $this.myRevertLastTableCellEdit = function0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$IsForcedConnectionBanner;", "Lcom/intellij/ui/EditorNotificationPanel;", "<init>", "()V", "app-inspection.inspectors.database"})
    private static final class IsForcedConnectionBanner
    extends EditorNotificationPanel {
        public IsForcedConnectionBanner() {
            super(JBUI.CurrentTheme.Banner.WARNING_BACKGROUND);
            this.setText("Non-native connection. This database has not yet been opened by the app so it may contain an outdated schema.");
            this.setMinimumSize(this.getPreferredSize());
            this.setBorder(BorderFactory.createCompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0), this.getBorder()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MatchParentLayoutManager;", "Ljava/awt/LayoutManager;", "<init>", "()V", "layoutContainer", "", "parent", "Ljava/awt/Container;", "preferredLayoutSize", "Ljava/awt/Dimension;", "minimumLayoutSize", "addLayoutComponent", "name", "", "comp", "Ljava/awt/Component;", "removeLayoutComponent", "app-inspection.inspectors.database"})
    @SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MatchParentLayoutManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,776:1\n13402#2,2:777\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MatchParentLayoutManager\n*L\n740#1:777,2\n*E\n"})
    private static final class MatchParentLayoutManager
    implements LayoutManager {
        @Override
        public void layoutContainer(@NotNull Container parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Rectangle parentBounds = parent.getBounds();
            if (parent.isPreferredSizeSet()) {
                parentBounds.setSize(parent.getPreferredSize());
            }
            Component[] componentArray = parent.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] $this$forEach$iv = componentArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                it.setBounds(parentBounds);
            }
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container parent) {
            Dimension dimension2;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (parent.isPreferredSizeSet()) {
                Dimension dimension3 = parent.getPreferredSize();
                dimension2 = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getPreferredSize(...)");
            } else {
                dimension2 = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return dimension2;
        }

        @Override
        @NotNull
        public Dimension minimumLayoutSize(@NotNull Container parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return new Dimension(0, 0);
        }

        @Override
        public void addLayoutComponent(@Nullable String name2, @Nullable Component comp) {
        }

        @Override
        public void removeLayoutComponent(@Nullable Component comp) {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyColoredTableCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "focused", "viewRowIndex", "", "viewColumnIndex", "app-inspection.inspectors.database"})
    private static final class MyColoredTableCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 == null) {
                this.append("NULL", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            } else {
                SimpleColoredComponent simpleColoredComponent = this.append(StringUtil.shortenPathWithEllipsis((String)value2.toString(), (int)200));
                Intrinsics.checkNotNull((Object)simpleColoredComponent);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow;", "", "values", "", "Lcom/android/tools/idea/sqlite/model/SqliteValue;", "<init>", "(Ljava/util/List;)V", "getValues", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "app-inspection.inspectors.database"})
    private static final class MyRow {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<SqliteValue> values;

        public MyRow(@NotNull List<SqliteValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.values = values;
        }

        @NotNull
        public final List<SqliteValue> getValues() {
            return this.values;
        }

        @NotNull
        public final List<SqliteValue> component1() {
            return this.values;
        }

        @NotNull
        public final MyRow copy(@NotNull List<SqliteValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new MyRow(values);
        }

        public static /* synthetic */ MyRow copy$default(MyRow myRow, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = myRow.values;
            }
            return myRow.copy(list);
        }

        @NotNull
        public String toString() {
            return "MyRow(values=" + this.values + ")";
        }

        public int hashCode() {
            return ((Object)this.values).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyRow)) {
                return false;
            }
            MyRow myRow = (MyRow)other;
            return Intrinsics.areEqual(this.values, myRow.values);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow$Companion;", "", "<init>", "()V", "fromSqliteRow", "Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow;", "sqliteRow", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "app-inspection.inspectors.database"})
        @SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,776:1\n1557#2:777\n1628#2,3:778\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow$Companion\n*L\n758#1:777\n758#1:778,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MyRow fromSqliteRow(@NotNull SqliteRow sqliteRow) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)sqliteRow, (String)"sqliteRow");
                Iterable $this$map$iv = sqliteRow.getValues();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SqliteColumnValue sqliteColumnValue = (SqliteColumnValue)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getValue());
                }
                List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                return new MyRow(list);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTable;", "Lcom/intellij/ui/table/JBTable;", "<init>", "()V", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "app-inspection.inspectors.database"})
    @SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,776:1\n1#2:777\n*E\n"})
    private static final class MyTable
    extends JBTable {
        @Nullable
        public String getToolTipText(@NotNull MouseEvent event) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            int row = this.rowAtPoint(event.getPoint());
            int col = this.columnAtPoint(event.getPoint());
            if (row < 0 || col < 0) {
                object = null;
            } else {
                Object object2 = this.getValueAt(row, col);
                if (object2 != null && (object2 = object2.toString()) != null) {
                    Object object3;
                    Object it = object3 = object2;
                    boolean bl = false;
                    object = ((String)it).length() > 200 ? object3 : null;
                } else {
                    object = null;
                }
            }
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableHeaderRenderer;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "(Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;)V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "focused", "viewRowIndex", "", "viewColumnIndex", "app-inspection.inspectors.database"})
    private final class MyTableHeaderRenderer
    implements TableCellRenderer {
        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            DefaultTableCellRenderer columnNameLabel = new DefaultTableCellRenderer();
            DefaultTableCellRenderer sortIcon = new DefaultTableCellRenderer();
            if (viewColumnIndex == 0) {
                columnNameLabel.setIcon(null);
                columnNameLabel.setIconTextGap(0);
                columnNameLabel.setText("");
            } else {
                Icon icon;
                TableModel tableModel2 = table2.getModel();
                Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                List<ViewColumn> columns2 = ((MyTableModel)tableModel2).getColumns();
                boolean inPk = columns2.get(viewColumnIndex - 1).getInPrimaryKey();
                if (inPk) {
                    columnNameLabel.setIcon(StudioIcons.DatabaseInspector.PRIMARY_KEY);
                    columnNameLabel.setIconTextGap(8);
                } else {
                    columnNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                }
                OrderBy o = TableViewImpl.this.getOrderBy();
                if (o instanceof OrderBy.NotOrdered) {
                    icon = AllIcons.General.ArrowSplitCenterV;
                } else if (o instanceof OrderBy.Asc) {
                    icon = Intrinsics.areEqual((Object)((OrderBy.Asc)o).getColumnName(), (Object)((String)value2)) ? AllIcons.General.ArrowDown : AllIcons.General.ArrowSplitCenterV;
                } else if (o instanceof OrderBy.Desc) {
                    icon = Intrinsics.areEqual((Object)((OrderBy.Desc)o).getColumnName(), (Object)((String)value2)) ? AllIcons.General.ArrowUp : AllIcons.General.ArrowSplitCenterV;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                sortIcon.setIcon(icon);
                columnNameLabel.setText((String)value2);
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBackground(new Color(0, 0, 0, 0));
            panel2.add((Component)columnNameLabel, "Center");
            panel2.add((Component)sortIcon, "East");
            return panel2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\"\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0018\u0010$\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0014\u0010%\u001a\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0003R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableModel;", "Ljavax/swing/table/AbstractTableModel;", "columns", "", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "<init>", "(Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;Ljava/util/List;)V", "getColumns", "()Ljava/util/List;", "rows", "", "Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow;", "isEditable", "", "()Z", "setEditable", "(Z)V", "rowOffset", "", "getRowOffset", "()I", "setRowOffset", "(I)V", "getColumnName", "", "modelColumnIndex", "getColumnClass", "Ljava/lang/Class;", "getColumnCount", "getRowCount", "getValueAt", "modelRowIndex", "setValueAt", "", "newValue", "", "isCellEditable", "applyRowsDiff", "rowDiffOperations", "Lcom/android/tools/idea/sqlite/ui/tableView/RowDiffOperation;", "app-inspection.inspectors.database"})
    @SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,776:1\n1#2:777\n1863#3,2:778\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableModel\n*L\n702#1:778,2\n*E\n"})
    private final class MyTableModel
    extends AbstractTableModel {
        @NotNull
        private final List<ViewColumn> columns;
        @NotNull
        private final List<MyRow> rows;
        private boolean isEditable;
        private int rowOffset;

        public MyTableModel(List<ViewColumn> columns2) {
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            this.columns = columns2;
            this.rows = new ArrayList();
        }

        @NotNull
        public final List<ViewColumn> getColumns() {
            return this.columns;
        }

        public final boolean isEditable() {
            return this.isEditable;
        }

        public final void setEditable(boolean bl) {
            this.isEditable = bl;
        }

        public final int getRowOffset() {
            return this.rowOffset;
        }

        public final void setRowOffset(int n) {
            this.rowOffset = n;
        }

        @Override
        @NotNull
        public String getColumnName(int modelColumnIndex) {
            return modelColumnIndex == 0 ? "" : this.columns.get(modelColumnIndex - 1).getName();
        }

        @NotNull
        public Class<String> getColumnClass(int modelColumnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.columns.isEmpty() ? 0 : this.columns.size() + 1;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        @Nullable
        public String getValueAt(int modelRowIndex, int modelColumnIndex) {
            String string;
            if (modelColumnIndex == 0) {
                string = String.valueOf(this.rowOffset + modelRowIndex + 1);
            } else {
                SqliteValue value2 = this.rows.get(modelRowIndex).getValues().get(modelColumnIndex - 1);
                if (value2 instanceof SqliteValue.StringValue) {
                    string = ((SqliteValue.StringValue)value2).getValue();
                } else if (value2 instanceof SqliteValue.NullValue) {
                    string = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void setValueAt(@Nullable Object newValue, int modelRowIndex, int modelColumnIndex) {
            v0 = var4_4 = modelColumnIndex > 0;
            if (_Assertions.ENABLED && !var4_4) {
                $i$a$-assert-TableViewImpl$MyTableModel$setValueAt$1 = false;
                $i$a$-assert-TableViewImpl$MyTableModel$setValueAt$1 = "Setting value of column at index 0 is not allowed";
                throw new AssertionError((Object)$i$a$-assert-TableViewImpl$MyTableModel$setValueAt$1);
            }
            oldValue = this.getValueAt(modelRowIndex, modelColumnIndex);
            if (Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
                return;
            }
            if (oldValue != null) ** GOTO lbl-1000
            v1 = newValue instanceof String != false ? (String)newValue : null;
            v2 = v1 != null ? ((CharSequence)v1).length() == 0 : false;
            if (v2) {
                v3 = SqliteValue.NullValue.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v3 = SqliteValue.Companion.fromAny(newValue);
            }
            newSqliteValue = v3;
            actualColumnIndex = modelColumnIndex - 1;
            column = this.columns.get(actualColumnIndex);
            this.rows.get(modelRowIndex).getValues().set(actualColumnIndex, newSqliteValue);
            this.fireTableCellUpdated(modelRowIndex, actualColumnIndex);
            TableViewImpl.access$setMyRevertLastTableCellEdit$p(TableViewImpl.this, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, setValueAt$lambda$1(com.android.tools.idea.sqlite.ui.tableView.TableViewImpl$MyTableModel int int java.lang.String ), ()Lkotlin/Unit;)((MyTableModel)this, (int)modelRowIndex, (int)actualColumnIndex, (String)oldValue));
            $this$forEach$iv = TableViewImpl.access$getListeners$p(TableViewImpl.this);
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (TableView.Listener)element$iv;
                $i$a$-forEach-TableViewImpl$MyTableModel$setValueAt$3 = false;
                it.updateCellInvoked(modelRowIndex, column, newSqliteValue);
            }
        }

        @Override
        public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
            return modelColumnIndex != 0 && this.isEditable;
        }

        public final void applyRowsDiff(@NotNull List<? extends RowDiffOperation> rowDiffOperations) {
            Intrinsics.checkNotNullParameter(rowDiffOperations, (String)"rowDiffOperations");
            for (RowDiffOperation rowDiffOperation : rowDiffOperations) {
                RowDiffOperation rowDiffOperation2 = rowDiffOperation;
                if (rowDiffOperation2 instanceof RowDiffOperation.UpdateCell) {
                    this.rows.get(((RowDiffOperation.UpdateCell)rowDiffOperation).getRowIndex()).getValues().set(((RowDiffOperation.UpdateCell)rowDiffOperation).getColIndex(), ((RowDiffOperation.UpdateCell)rowDiffOperation).getNewValue().getValue());
                    this.fireTableCellUpdated(((RowDiffOperation.UpdateCell)rowDiffOperation).getRowIndex(), ((RowDiffOperation.UpdateCell)rowDiffOperation).getColIndex() + 1);
                    continue;
                }
                if (rowDiffOperation2 instanceof RowDiffOperation.AddRow) {
                    this.rows.add(MyRow.Companion.fromSqliteRow(((RowDiffOperation.AddRow)rowDiffOperation).getRow()));
                    this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
                    continue;
                }
                if (rowDiffOperation2 instanceof RowDiffOperation.RemoveLastRows) {
                    int oldRowsSize = this.rows.size();
                    int i = oldRowsSize - 1;
                    int n = ((RowDiffOperation.RemoveLastRows)rowDiffOperation).getStartIndex();
                    if (n <= i) {
                        while (true) {
                            this.rows.remove(i);
                            if (i == n) break;
                            --i;
                        }
                    }
                    this.fireTableRowsDeleted(((RowDiffOperation.RemoveLastRows)rowDiffOperation).getStartIndex(), oldRowsSize - 1);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        private static final Unit setValueAt$lambda$1(MyTableModel this$0, int $modelRowIndex, int $actualColumnIndex, String $oldValue) {
            this$0.rows.get($modelRowIndex).getValues().set($actualColumnIndex, SqliteValue.Companion.fromAny($oldValue));
            this$0.fireTableCellUpdated($modelRowIndex, $actualColumnIndex);
            return Unit.INSTANCE;
        }
    }
}

