/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.EmptyActionGroup;
import org.jetbrains.annotations.NotNull;

public final class Actions {
    private Actions() {
    }

    public static void hideAction(@NotNull ActionManager actionManager, @NotNull String actionId) {
        if (actionManager.getActionOrStub(actionId) == null) {
            return;
        }
        EmptyActionGroup emptyReplacement = actionManager.isGroup(actionId) ? new EmptyActionGroup() : new EmptyAction();
        actionManager.replaceAction(actionId, (AnAction)emptyReplacement);
    }

    public static void replaceAction(@NotNull ActionManager actionManager, @NotNull String actionId, @NotNull AnAction newAction) {
        if (actionManager.getActionOrStub(actionId) != null) {
            actionManager.replaceAction(actionId, newAction);
        } else {
            actionManager.registerAction(actionId, newAction);
        }
    }

    public static void moveAction(@NotNull ActionManager actionManager, @NotNull String actionId, @NotNull String oldGroupId, @NotNull String groupId, @NotNull Constraints constraints) {
        AnAction action2 = actionManager.getActionOrStub(actionId);
        AnAction group2 = actionManager.getAction(groupId);
        AnAction oldGroup = actionManager.getAction(oldGroupId);
        if (action2 != null && oldGroup instanceof DefaultActionGroup && group2 instanceof DefaultActionGroup) {
            ((DefaultActionGroup)oldGroup).remove(action2, actionManager);
            ((DefaultActionGroup)group2).add(action2, constraints, actionManager);
        }
    }
}

