/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.idea.actions.AndroidActionGroupRemover;
import com.android.tools.idea.actions.AndroidOpenFileAction;
import com.android.tools.idea.actions.CreateLibraryFromFilesAction;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectStructureAction;
import com.android.tools.idea.gradle.actions.AssembleIdeaModuleAction;
import com.android.tools.idea.startup.Actions;
import com.android.utils.Pair;
import com.intellij.ide.projectView.actions.MarkRootGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroupTopLevel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class GradleSpecificActionCustomizer
implements ActionConfigurationCustomizer {
    public void customize(@NotNull ActionManager actionManager) {
        GradleSpecificActionCustomizer.setUpNewProjectActions(actionManager);
        GradleSpecificActionCustomizer.setUpWelcomeScreenActions(actionManager);
        GradleSpecificActionCustomizer.disableUnsupportedAction(actionManager);
        GradleSpecificActionCustomizer.replaceProjectPopupActions(actionManager);
        GradleSpecificActionCustomizer.setUpMakeActions(actionManager);
        GradleSpecificActionCustomizer.setUpGradleViewToolbarActions(actionManager);
    }

    private static void disableUnsupportedAction(ActionManager actionManager) {
        actionManager.unregisterAction("LoadUnloadModules");
    }

    private static void setUpMakeActions(ActionManager actionManager) {
        Actions.hideAction(actionManager, "CompileDirty");
        Actions.replaceAction(actionManager, "MakeModule", new AssembleIdeaModuleAction());
        Actions.hideAction(actionManager, "CompileProject");
        Actions.hideAction(actionManager, "Compile");
        Actions.hideAction(actionManager, "Build");
        Actions.hideAction(actionManager, "Groovy.CheckResources.Rebuild");
        Actions.hideAction(actionManager, "Groovy.CheckResources.Make");
        Actions.hideAction(actionManager, "Groovy.CheckResources");
        Actions.hideAction(actionManager, "CompileFile");
    }

    private static void setUpGradleViewToolbarActions(ActionManager actionManager) {
        Actions.hideAction(actionManager, "ExternalSystem.RefreshAllProjects");
        Actions.hideAction(actionManager, "ExternalSystem.SelectProjectDataToImport");
        Actions.hideAction(actionManager, "ExternalSystem.DetachProject");
        Actions.hideAction(actionManager, "ExternalSystem.AttachProject");
    }

    private static void setUpNewProjectActions(ActionManager actionManager) {
        Actions.replaceAction(actionManager, "OpenFile", (AnAction)new AndroidOpenFileAction());
        Actions.replaceAction(actionManager, "CreateLibraryFromFile", new CreateLibraryFromFilesAction());
        Actions.hideAction(actionManager, "AddFrameworkSupport");
        Actions.hideAction(actionManager, "BuildArtifact");
    }

    private static void setUpWelcomeScreenActions(ActionManager actionManager) {
        Actions.replaceAction(actionManager, "WelcomeScreen.OpenProject", (AnAction)new AndroidOpenFileAction("Open"));
        Actions.replaceAction(actionManager, "WelcomeScreen.Configure.ProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.replaceAction(actionManager, "TemplateProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
    }

    private static void replaceProjectPopupActions(ActionManager actionManager) {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.add(Pair.of(null, (Object)actionManager.getAction("ProjectViewPopupMenu")));
        while (!stack.isEmpty()) {
            Pair entry = (Pair)stack.pop();
            DefaultActionGroup parent = (DefaultActionGroup)entry.getFirst();
            AnAction action2 = (AnAction)entry.getSecond();
            if (action2 instanceof DefaultActionGroup) {
                DefaultActionGroup actionGroup2 = (DefaultActionGroup)action2;
                for (AnAction child : actionGroup2.getChildActionsOrStubs()) {
                    stack.push(Pair.of((Object)actionGroup2, (Object)child));
                }
            }
            if (action2 instanceof MoveModuleToGroupTopLevel) {
                parent.remove(action2, actionManager);
                parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Move Module to Group"), new Constraints(Anchor.AFTER, "OpenModuleSettings"), actionManager);
                continue;
            }
            if (!(action2 instanceof MarkRootGroup)) continue;
            parent.remove(action2, actionManager);
            parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Mark Directory As"), new Constraints(Anchor.AFTER, "OpenModuleSettings"), actionManager);
        }
    }
}

