/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndex;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.lint.checks.GradleDetector;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.service.syncContributor.bridge.GradleBridgeData;
import org.jetbrains.plugins.gradle.service.syncContributor.bridge.GradleBridgeProjectDataService;

public class GradleSpecificInitializer
implements AppLifecycleListener {
    public void appFrameCreated(@NotNull List<String> arguments) {
        GradleSpecificInitializer.checkInstallPath();
        if (ConfigImportHelper.isConfigImported()) {
            GradleSpecificInitializer.cleanProjectJdkTableForNewIdeVersion();
            GradleSpecificInitializer.migrateAgpUpgradeAssistantSettingForNewIdeVersion();
        }
        GradleSpecificInitializer.useIdeGooglePlaySdkIndexInGradleDetector();
        GradleSpecificInitializer.initializePhasedSync();
    }

    @VisibleForTesting
    public static void initializePhasedSync() {
        if (!((Boolean)StudioFlags.PHASED_SYNC_ENABLED.get()).booleanValue()) {
            Registry.get((String)"gradle.phased.sync.enabled").setValue(false);
        } else {
            Registry.get((String)"gradle.phased.sync.enabled").setValue(true);
        }
        ProjectDataService.EP_NAME.getPoint().unregisterExtension(GradleBridgeProjectDataService.class);
        ProjectDataService.EP_NAME.getPoint().registerExtension((Object)new AndroidGradleBridgeProjectDataService());
    }

    private static void checkInstallPath() {
        if (PathManager.getHomePath().contains("!")) {
            String message = String.format("%1$s must not be installed in a path containing '!' or Gradle sync will fail!", ApplicationNamesInfo.getInstance().getProductName());
            Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification(message, NotificationType.ERROR);
            notification.setImportant(true);
            Notifications.Bus.notify((Notification)notification);
        }
    }

    private static NotificationGroup getNotificationGroup() {
        NotificationGroupManager notificationGroupManager = NotificationGroupManager.getInstance();
        NotificationGroup group2 = notificationGroupManager.getNotificationGroup("System Health");
        return group2 != null ? group2 : notificationGroupManager.getNotificationGroup("Gradle Initializer");
    }

    private static void cleanProjectJdkTableForNewIdeVersion() {
        block3: {
            block2: {
                IdeInfo ideInfo = IdeInfo.getInstance();
                if (ideInfo.isAndroidStudio()) break block2;
                if (!ideInfo.isGameTools()) break block3;
            }
            ApplicationManager.getApplication().invokeLater(IdeSdks.getInstance()::recreateProjectJdkTable);
        }
    }

    private static void migrateAgpUpgradeAssistantSettingForNewIdeVersion() {
        String propertyKey;
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (properties.isValueSet(propertyKey = "recommended.upgrade.do.not.show.again")) {
            if (properties.getBoolean(propertyKey, false)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    String groupId = "Android Gradle Upgrade Notification";
                    NotificationsConfiguration.getNotificationsConfiguration().changeSettings(groupId, NotificationDisplayType.NONE, false, false);
                });
            }
            properties.unsetValue(propertyKey);
        }
    }

    private static void useIdeGooglePlaySdkIndexInGradleDetector() {
        GradleDetector.setPlaySdkIndexFactory((path, client) -> {
            IdeGooglePlaySdkIndex playIndex = IdeGooglePlaySdkIndex.INSTANCE;
            playIndex.initializeAndSetFlags();
            return playIndex;
        });
    }

    public static final class AndroidGradleBridgeProjectDataService
    extends AbstractProjectDataService<GradleBridgeData, Void> {
        GradleBridgeProjectDataService delegate = new GradleBridgeProjectDataService();

        @NotNull
        public Key<GradleBridgeData> getTargetDataKey() {
            return GradleBridgeData.INSTANCE.getKEY();
        }

        public void importData(@NotNull Collection<? extends DataNode<GradleBridgeData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            if (((Boolean)StudioFlags.PHASED_SYNC_BRIDGE_DATA_SERVICE_DISABLED.get()).booleanValue()) {
                return;
            }
            this.delegate.importData(toImport, projectData, project, modelsProvider);
        }
    }
}

