/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.benchmark;

import com.android.tools.idea.util.fsm.StateMachine;
import com.google.common.math.Quantiles;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 6*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u000523456B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010+J\u0014\u0010,\u001a\u00020(2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000!J\u0006\u0010-\u001a\u00020(J\u0006\u0010.\u001a\u00020(J\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020(H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00168B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e*\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020&0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker;", "InputType", "", "adapter", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter;", "inputRateHz", "", "timeSource", "Lkotlin/time/TimeSource;", "timer", "Ljava/util/Timer;", "<init>", "(Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter;ILkotlin/time/TimeSource;Ljava/util/Timer;)V", "value", "", "failureMsg", "getFailureMsg", "()Ljava/lang/String;", "frameDurationMillis", "", "stateMachine", "Lcom/android/tools/idea/util/fsm/StateMachine;", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;", "<set-?>", "state", "getState$delegate", "(Lcom/android/tools/idea/streaming/benchmark/Benchmarker;)Ljava/lang/Object;", "getState", "()Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;", "setState", "(Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;)V", "callbacks", "", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Callbacks;", "outstandingInputs", "", "Lkotlin/time/TimeMark;", "inputRoundTrips", "Lkotlin/time/Duration;", "inputReturned", "", "input", "effectiveDispatchTime", "(Ljava/lang/Object;Lkotlin/time/TimeMark;)V", "addCallbacks", "start", "stop", "isDone", "", "dispatchNextInput", "Results", "Callbacks", "Adapter", "State", "Companion", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nBenchmarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Benchmarker.kt\ncom/android/tools/idea/streaming/benchmark/Benchmarker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1863#2,2:254\n1863#2,2:256\n1863#2,2:258\n*S KotlinDebug\n*F\n+ 1 Benchmarker.kt\ncom/android/tools/idea/streaming/benchmark/Benchmarker\n*L\n131#1:254,2\n71#1:256,2\n79#1:258,2\n*E\n"})
public final class Benchmarker<InputType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Adapter<InputType> adapter;
    @NotNull
    private final TimeSource timeSource;
    @NotNull
    private String failureMsg;
    private final long frameDurationMillis;
    @NotNull
    private final StateMachine<State> stateMachine;
    @NotNull
    private final List<Callbacks<InputType>> callbacks;
    @NotNull
    private final Map<InputType, TimeMark> outstandingInputs;
    @NotNull
    private final Map<InputType, Duration> inputRoundTrips;
    @NotNull
    private static final Logger LOG;

    public Benchmarker(@NotNull Adapter<InputType> adapter, int inputRateHz, @NotNull TimeSource timeSource, @NotNull Timer timer) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        this.adapter = adapter;
        this.timeSource = timeSource;
        this.failureMsg = "Benchmarking terminated unexpectedly";
        this.frameDurationMillis = MathKt.roundToLong((double)((double)1000 / (double)inputRateHz));
        this.stateMachine = StateMachine.Companion.stateMachine$default((StateMachine.Companion)StateMachine.Companion, (Enum)State.INITIALIZED, (StateMachine.Config)new StateMachine.Config(null, LOG, this.timeSource, 1, null), null, arg_0 -> Benchmarker.stateMachine$lambda$10(this, timer, arg_0), (int)4, null);
        this.callbacks = new ArrayList();
        this.outstandingInputs = new LinkedHashMap();
        this.inputRoundTrips = new LinkedHashMap();
        Adapter.Callbacks callbacks2 = new Adapter.Callbacks<InputType>(this){
            final /* synthetic */ Benchmarker<InputType> this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputReturned(InputType input2, TimeMark effectiveDispatchTime) {
                Intrinsics.checkNotNullParameter((Object)effectiveDispatchTime, (String)"effectiveDispatchTime");
                Benchmarker.access$inputReturned(this.this$0, input2, effectiveDispatchTime);
            }

            public void onReady() {
                Iterable $this$forEach$iv = Benchmarker.access$getCallbacks$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Callbacks it = (Callbacks)element$iv;
                    boolean bl = false;
                    it.onProgress(0.0, 0.0);
                }
                Benchmarker.access$setState(this.this$0, State.SENDING_INPUTS);
            }

            public void onFailedToBecomeReady(String msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                Benchmarker.access$getLOG$cp().warn(msg);
                Benchmarker.access$setFailureMsg$p(this.this$0, msg);
                Benchmarker.access$setState(this.this$0, State.STOPPED);
            }
        };
        this.adapter.setCallbacks(callbacks2);
    }

    public /* synthetic */ Benchmarker(Adapter adapter, int n, TimeSource timeSource, Timer timer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 60;
        }
        if ((n2 & 4) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            timer = new Timer();
        }
        this(adapter, n, timeSource, timer);
    }

    @NotNull
    public final String getFailureMsg() {
        return this.failureMsg;
    }

    private final State getState() {
        return (State)this.stateMachine.getState();
    }

    private final void setState(State state2) {
        this.stateMachine.setState((Enum)state2);
    }

    private static Object getState$delegate(Benchmarker<Object> benchmarker) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl(benchmarker.stateMachine, StateMachine.class, "state", "getState()Ljava/lang/Enum;", 0)));
    }

    private final synchronized void inputReturned(InputType input2, TimeMark effectiveDispatchTime) {
        State[] stateArray = new State[]{State.INITIALIZED, State.STOPPED, State.COMPLETE};
        if (CollectionsKt.listOf((Object[])stateArray).contains((Object)this.getState())) {
            return;
        }
        LOG.trace("Got input " + input2);
        if (this.outstandingInputs.containsKey(input2)) {
            Iterator<Map.Entry<InputType, TimeMark>> iterator2 = this.outstandingInputs.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<InputType, TimeMark> cur = iterator2.next();
                iterator2.remove();
                this.inputRoundTrips.put(cur.getKey(), Duration.box-impl((long)Duration.minus-LRDsOJo((long)cur.getValue().elapsedNow-UwyO8pc(), (long)effectiveDispatchTime.elapsedNow-UwyO8pc())));
                if (!Intrinsics.areEqual(cur.getKey(), input2)) continue;
            }
        }
        double denominator = this.adapter.numInputs();
        double dispatchedProgress = (double)(this.inputRoundTrips.size() + this.outstandingInputs.size()) / denominator;
        double returnedProgress = (double)this.inputRoundTrips.size() / denominator;
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Callbacks it = (Callbacks)element$iv;
            boolean bl = false;
            it.onProgress(dispatchedProgress, returnedProgress);
        }
        if (this.getState() == State.WAITING_FOR_OUTSTANDING_INPUTS && this.outstandingInputs.isEmpty()) {
            this.setState(State.COMPLETE);
        }
    }

    public final synchronized void addCallbacks(@NotNull Callbacks<InputType> callbacks2) {
        Intrinsics.checkNotNullParameter(callbacks2, (String)"callbacks");
        this.callbacks.add(callbacks2);
    }

    public final synchronized void start() {
        this.setState(State.GETTING_READY);
    }

    public final synchronized void stop() {
        this.failureMsg = "";
        this.setState(State.STOPPED);
    }

    public final synchronized boolean isDone() {
        return this.getState() == State.COMPLETE;
    }

    private final synchronized void dispatchNextInput() {
        if (this.adapter.inputs().hasNext()) {
            InputType it = this.adapter.inputs().next();
            boolean bl = false;
            this.outstandingInputs.put(it, this.timeSource.markNow());
            LOG.trace("Dispatching input " + it + ".");
            this.adapter.dispatch(it);
            if (!this.adapter.inputs().hasNext()) {
                this.setState(State.WAITING_FOR_OUTSTANDING_INPUTS);
            }
        }
    }

    private static final Unit stateMachine$lambda$10$lambda$1$lambda$0(Benchmarker this$0) {
        this$0.adapter.ready();
        return Unit.INSTANCE;
    }

    private static final Unit stateMachine$lambda$10$lambda$1(StateMachine.StateMachineBuilderScope $this_stateMachine, Benchmarker this$0, State $this$GETTING_READY) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$GETTING_READY), (String)"$this$GETTING_READY");
        State[] stateArray = new State[]{State.SENDING_INPUTS, State.STOPPED};
        StateMachine.StateMachineBuilderScope.transitionsTo$default((StateMachine.StateMachineBuilderScope)$this_stateMachine, (Enum)$this$GETTING_READY, (Enum[])stateArray, null, (int)2, null);
        $this_stateMachine.onEnter((Enum)$this$GETTING_READY, () -> Benchmarker.stateMachine$lambda$10$lambda$1$lambda$0(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit stateMachine$lambda$10$lambda$5$lambda$3(Benchmarker this$0, Timer $timer) {
        this$0.adapter.prepareForInputs();
        Timer timer = $timer;
        long l = 0L;
        long l2 = this$0.frameDurationMillis;
        TimerTask timerTask = new TimerTask(this$0){
            final /* synthetic */ Benchmarker this$0;
            {
                this.this$0 = benchmarker;
            }

            public void run() {
                TimerTask $this$stateMachine_u24lambda_u2410_u24lambda_u245_u24lambda_u243_u24lambda_u242 = this;
                boolean bl = false;
                Benchmarker.access$dispatchNextInput(this.this$0);
            }
        };
        timer.scheduleAtFixedRate(timerTask, l, l2);
        return Unit.INSTANCE;
    }

    private static final Unit stateMachine$lambda$10$lambda$5$lambda$4(Benchmarker this$0, Timer $timer) {
        this$0.adapter.finalizeInputs();
        $timer.cancel();
        return Unit.INSTANCE;
    }

    private static final Unit stateMachine$lambda$10$lambda$5(StateMachine.StateMachineBuilderScope $this_stateMachine, Benchmarker this$0, Timer $timer, State $this$SENDING_INPUTS) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$SENDING_INPUTS), (String)"$this$SENDING_INPUTS");
        State[] stateArray = new State[]{State.WAITING_FOR_OUTSTANDING_INPUTS, State.STOPPED};
        StateMachine.StateMachineBuilderScope.transitionsTo$default((StateMachine.StateMachineBuilderScope)$this_stateMachine, (Enum)$this$SENDING_INPUTS, (Enum[])stateArray, null, (int)2, null);
        $this_stateMachine.onEnter((Enum)$this$SENDING_INPUTS, () -> Benchmarker.stateMachine$lambda$10$lambda$5$lambda$3(this$0, $timer));
        $this_stateMachine.onExit((Enum)$this$SENDING_INPUTS, () -> Benchmarker.stateMachine$lambda$10$lambda$5$lambda$4(this$0, $timer));
        return Unit.INSTANCE;
    }

    private static final Unit stateMachine$lambda$10$lambda$7(Benchmarker this$0) {
        this$0.adapter.cleanUp();
        Iterable $this$forEach$iv = this$0.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Callbacks it = (Callbacks)element$iv;
            boolean bl = false;
            it.onStopped();
            it.onFailure(this$0.failureMsg);
        }
        return Unit.INSTANCE;
    }

    private static final Unit stateMachine$lambda$10$lambda$9(Benchmarker this$0) {
        this$0.adapter.cleanUp();
        Results results2 = new Results(this$0.inputRoundTrips);
        Iterable $this$forEach$iv = this$0.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Callbacks it = (Callbacks)element$iv;
            boolean bl = false;
            it.onStopped();
            it.onComplete(results2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit stateMachine$lambda$10(Benchmarker this$0, Timer $timer, StateMachine.StateMachineBuilderScope $this$stateMachine) {
        Intrinsics.checkNotNullParameter((Object)$this$stateMachine, (String)"$this$stateMachine");
        State[] stateArray = new State[]{State.GETTING_READY, State.STOPPED};
        StateMachine.StateMachineBuilderScope.transitionsTo$default((StateMachine.StateMachineBuilderScope)$this$stateMachine, (Enum)State.INITIALIZED, (Enum[])stateArray, null, (int)2, null);
        $this$stateMachine.invoke((Enum)State.GETTING_READY, arg_0 -> Benchmarker.stateMachine$lambda$10$lambda$1($this$stateMachine, this$0, arg_0));
        $this$stateMachine.invoke((Enum)State.SENDING_INPUTS, arg_0 -> Benchmarker.stateMachine$lambda$10$lambda$5($this$stateMachine, this$0, $timer, arg_0));
        stateArray = new State[]{State.STOPPED, State.COMPLETE};
        StateMachine.StateMachineBuilderScope.transitionsTo$default((StateMachine.StateMachineBuilderScope)$this$stateMachine, (Enum)State.WAITING_FOR_OUTSTANDING_INPUTS, (Enum[])stateArray, null, (int)2, null);
        $this$stateMachine.onEnter((Enum)State.STOPPED, () -> Benchmarker.stateMachine$lambda$10$lambda$7(this$0));
        $this$stateMachine.onEnter((Enum)State.COMPLETE, () -> Benchmarker.stateMachine$lambda$10$lambda$9(this$0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$dispatchNextInput(Benchmarker $this) {
        $this.dispatchNextInput();
    }

    public static final /* synthetic */ void access$inputReturned(Benchmarker $this, Object input2, TimeMark effectiveDispatchTime) {
        $this.inputReturned(input2, effectiveDispatchTime);
    }

    public static final /* synthetic */ List access$getCallbacks$p(Benchmarker $this) {
        return $this.callbacks;
    }

    public static final /* synthetic */ void access$setState(Benchmarker $this, State state2) {
        $this.setState(state2);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$setFailureMsg$p(Benchmarker $this, String string) {
        $this.failureMsg = string;
    }

    static {
        Logger logger = Logger.getInstance(Benchmarker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0001\u0012J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H&J\b\u0010\u0005\u001a\u00020\u0006H&J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rH&J\b\u0010\u000e\u001a\u00020\bH&J\b\u0010\u000f\u001a\u00020\bH&J\b\u0010\u0010\u001a\u00020\bH&J\b\u0010\u0011\u001a\u00020\bH&\u00a8\u0006\u0013\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter;", "InputType", "", "inputs", "", "numInputs", "", "dispatch", "", "input", "(Ljava/lang/Object;)V", "setCallbacks", "callbacks", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter$Callbacks;", "ready", "prepareForInputs", "finalizeInputs", "cleanUp", "Callbacks", "intellij.android.streaming"})
    public static interface Adapter<InputType> {
        @NotNull
        public Iterator<InputType> inputs();

        public int numInputs();

        public void dispatch(InputType var1);

        public void setCallbacks(@NotNull Callbacks<InputType> var1);

        public void ready();

        public void prepareForInputs();

        public void finalizeInputs();

        public void cleanUp();

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\bf\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00022\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0004H&J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter$Callbacks;", "InputType", "", "inputReturned", "", "input", "effectiveDispatchTime", "Lkotlin/time/TimeMark;", "(Ljava/lang/Object;Lkotlin/time/TimeMark;)V", "onReady", "onFailedToBecomeReady", "msg", "", "intellij.android.streaming"})
        public static interface Callbacks<InputType> {
            public void inputReturned(InputType var1, @NotNull TimeMark var2);

            public void onReady();

            public void onFailedToBecomeReady(@NotNull String var1);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H&J\b\u0010\b\u001a\u00020\u0004H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&J\u0016\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eH&\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Callbacks;", "InputType", "", "onProgress", "", "dispatched", "", "returned", "onStopped", "onFailure", "failureMessage", "", "onComplete", "results", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Results;", "intellij.android.streaming"})
    public static interface Callbacks<InputType> {
        public void onProgress(double var1, double var3);

        public void onStopped();

        public void onFailure(@NotNull String var1);

        public void onComplete(@NotNull Results<InputType> var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Results;", "InputType", "", "raw", "", "Lkotlin/time/Duration;", "<init>", "(Ljava/util/Map;)V", "getRaw", "()Ljava/util/Map;", "percentiles", "", "", "getPercentiles$annotations", "()V", "getPercentiles", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nBenchmarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Benchmarker.kt\ncom/android/tools/idea/streaming/benchmark/Benchmarker$Results\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1557#2:254\n1628#2,3:255\n*S KotlinDebug\n*F\n+ 1 Benchmarker.kt\ncom/android/tools/idea/streaming/benchmark/Benchmarker$Results\n*L\n172#1:254\n172#1:255,3\n*E\n"})
    public static final class Results<InputType> {
        @NotNull
        private final Map<InputType, Duration> raw;
        @NotNull
        private final Map<Integer, Double> percentiles;

        /*
         * WARNING - void declaration
         */
        public Results(@NotNull Map<InputType, Duration> raw) {
            Collection<Long> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(raw, (String)"raw");
            this.raw = raw;
            Iterable iterable = this.raw.values();
            Quantiles.ScaleAndIndexes scaleAndIndexes = Quantiles.percentiles().indexes((Collection)CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, 100))));
            Results results2 = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Duration)item$iv$iv).unbox-impl();
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(Duration.getInWholeMilliseconds-impl((long)it));
            }
            collection2 = (List)destination$iv$iv;
            Map map2 = scaleAndIndexes.compute((Collection)collection2);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"compute(...)");
            results2.percentiles = map2;
        }

        @NotNull
        public final Map<InputType, Duration> getRaw() {
            return this.raw;
        }

        @NotNull
        public final Map<Integer, Double> getPercentiles() {
            return this.percentiles;
        }

        public static /* synthetic */ void getPercentiles$annotations() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;", "", "<init>", "(Ljava/lang/String;I)V", "INITIALIZED", "GETTING_READY", "SENDING_INPUTS", "WAITING_FOR_OUTSTANDING_INPUTS", "STOPPED", "COMPLETE", "intellij.android.streaming"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIALIZED = new State();
        public static final /* enum */ State GETTING_READY = new State();
        public static final /* enum */ State SENDING_INPUTS = new State();
        public static final /* enum */ State WAITING_FOR_OUTSTANDING_INPUTS = new State();
        public static final /* enum */ State STOPPED = new State();
        public static final /* enum */ State COMPLETE = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIALIZED, State.GETTING_READY, State.SENDING_INPUTS, State.WAITING_FOR_OUTSTANDING_INPUTS, State.STOPPED, State.COMPLETE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

