/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.adblib.AdbDeviceServices;
import com.android.adblib.DeviceSelector;
import com.android.adblib.tools.InstallException;
import com.android.adblib.tools.InstallerKt;
import com.android.tools.idea.adblib.AdbLibApplicationService;
import com.android.tools.idea.streaming.core.AbstractDisplayView;
import com.android.tools.idea.streaming.core.StreamingConstants;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\f\u0010\u001b\u001a\u00020\u000f*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u0003*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/streaming/core/DeviceFileDropHandler;", "Lcom/intellij/ide/dnd/DnDDropHandler;", "deviceSerialNumber", "", "displayView", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/android/tools/idea/streaming/core/AbstractDisplayView;Lcom/intellij/openapi/project/Project;)V", "drop", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "checkFiles", "", "files", "", "Ljava/nio/file/Path;", "formatForDisplay", "prefixForPluralCase", "getFileTypes", "", "Lcom/android/tools/idea/streaming/core/DeviceFileDropHandler$FileType;", "notifyOfSuccess", "message", "notifyOfError", "isInvalidCompoundApk", "Lcom/android/adblib/tools/InstallException;", "fileNameForDisplay", "FileType", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nDeviceFileDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceFileDropHandler.kt\ncom/android/tools/idea/streaming/core/DeviceFileDropHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1557#2:187\n1628#2,3:188\n*S KotlinDebug\n*F\n+ 1 DeviceFileDropHandler.kt\ncom/android/tools/idea/streaming/core/DeviceFileDropHandler\n*L\n77#1:187\n77#1:188,3\n*E\n"})
final class DeviceFileDropHandler
implements DnDDropHandler {
    @NotNull
    private final String deviceSerialNumber;
    @NotNull
    private final AbstractDisplayView displayView;
    @NotNull
    private final Project project;

    public DeviceFileDropHandler(@NotNull String deviceSerialNumber, @NotNull AbstractDisplayView displayView, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)displayView, (String)"displayView");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.deviceSerialNumber = deviceSerialNumber;
        this.displayView = displayView;
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    public void drop(@NotNull DnDEvent event) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List list = FileCopyPasteUtil.getFileListFromAttachedObject((Object)event.getAttachedObject());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFileListFromAttachedObject(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            File file = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(p0.toPath());
        }
        List files2 = (List)destination$iv$iv;
        if (!this.checkFiles(files2)) {
            return;
        }
        Set<FileType> fileTypes = this.getFileTypes(files2);
        if (fileTypes.size() > 1) {
            this.notifyOfError("Drag-and-drop can either install an APK, or copy one or more non-APK files to the device.");
            return;
        }
        AdbDeviceServices adb = AdbLibApplicationService.Companion.getInstance().getSession().getDeviceServices();
        DeviceSelector deviceSelector = DeviceSelector.Companion.fromSerialNumber(this.deviceSerialNumber);
        if (fileTypes.contains((Object)FileType.APK)) {
            this.displayView.showLongRunningOperationIndicator("Installing " + this.formatForDisplay("app consisting of ", files2));
            v1 = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(adb, deviceSelector, (List<? extends Path>)files2, this, null){
                int label;
                final /* synthetic */ AdbDeviceServices $adb;
                final /* synthetic */ DeviceSelector $deviceSelector;
                final /* synthetic */ List<Path> $files;
                final /* synthetic */ DeviceFileDropHandler this$0;
                {
                    this.$adb = $adb;
                    this.$deviceSelector = $deviceSelector;
                    this.$files = $files;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = new String[]{"-t", "--user", "current", "--full"};
                            this.label = 1;
                            v0 = InstallerKt.install$default((AdbDeviceServices)this.$adb, (DeviceSelector)this.$deviceSelector, this.$files, (List)CollectionsKt.listOf((Object[])var2_3), null, (Continuation)((Continuation)this), (int)8, null);
                            ** if (v0 != var4_2) goto lbl12
lbl11:
                            // 1 sources

                            return var4_2;
lbl12:
                            // 1 sources

                            ** GOTO lbl18
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl18:
                                // 2 sources

                                DeviceFileDropHandler.access$notifyOfSuccess(this.this$0, DeviceFileDropHandler.access$formatForDisplay(this.this$0, "App consisting of ", this.$files) + " installed");
                            }
                            catch (Throwable e) {
                                if (e instanceof InstallException && DeviceFileDropHandler.access$isInvalidCompoundApk(this.this$0, (InstallException)e) && this.$files.size() > 1) {
                                    v1 = "The " + this.$files.size() + " files don't belong to the same app";
                                } else {
                                    v1 = e.getMessage();
                                    if (v1 == null) {
                                        v1 = "Installation failed - " + e.getClass().getSimpleName();
                                    }
                                }
                                message = v1;
                                DeviceFileDropHandler.access$notifyOfError(this.this$0, message);
                            }
                            UIUtil.invokeLaterIfNeeded((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(com.android.tools.idea.streaming.core.DeviceFileDropHandler ), ()V)((DeviceFileDropHandler)this.this$0));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$0(DeviceFileDropHandler this$0) {
                    DeviceFileDropHandler.access$getDisplayView$p(this$0).hideLongRunningOperationIndicator();
                }
            }), (int)3, null);
        } else {
            String fileList = this.formatForDisplay("", files2);
            this.displayView.showLongRunningOperationIndicator("Copying " + fileList);
            v1 = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends Path>)files2, adb, deviceSelector, this, fileList, null){
                Object L$0;
                int label;
                final /* synthetic */ List<Path> $files;
                final /* synthetic */ AdbDeviceServices $adb;
                final /* synthetic */ DeviceSelector $deviceSelector;
                final /* synthetic */ DeviceFileDropHandler this$0;
                final /* synthetic */ String $fileList;
                {
                    this.$files = $files;
                    this.$adb = $adb;
                    this.$deviceSelector = $deviceSelector;
                    this.this$0 = $receiver;
                    this.$fileList = $fileList;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                public final Object invokeSuspend(Object var1_1) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:65)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$0(DeviceFileDropHandler this$0) {
                    DeviceFileDropHandler.access$getDisplayView$p(this$0).hideLongRunningOperationIndicator();
                }
            }), (int)3, null);
        }
    }

    private final boolean checkFiles(List<? extends Path> files2) {
        for (Path path : files2) {
            String string;
            if (Files.isDirectory(path, new LinkOption[0])) {
                string = "is a directory";
            } else {
                if (Files.isReadable(path)) continue;
                string = "is not readable";
            }
            String problemMessage = string;
            String fileForDisplay = ((Object)path).toString();
            if (fileForDisplay.length() > 30) {
                fileForDisplay = ((Object)path.getFileName()).toString();
            }
            this.notifyOfError(fileForDisplay + " " + problemMessage);
            return false;
        }
        return true;
    }

    private final String formatForDisplay(String prefixForPluralCase, List<? extends Path> files2) {
        return files2.size() == 1 ? this.fileNameForDisplay((Path)CollectionsKt.first(files2)) : prefixForPluralCase + files2.size() + " files";
    }

    private final Set<FileType> getFileTypes(List<? extends Path> files2) {
        EnumSet<FileType> types = EnumSet.noneOf(FileType.class);
        for (Path path : files2) {
            types.add(StringsKt.endsWith((String)((Object)path).toString(), (String)".apk", (boolean)true) ? FileType.APK : FileType.OTHER);
            if (!types.contains((Object)FileType.APK) || !types.contains((Object)FileType.OTHER)) continue;
        }
        Intrinsics.checkNotNull(types);
        return types;
    }

    private final void notifyOfSuccess(String message) {
        StreamingConstants.getRUNNING_DEVICES_NOTIFICATION_GROUP().createNotification(message, NotificationType.INFORMATION).notify(this.project);
    }

    private final void notifyOfError(String message) {
        StreamingConstants.getRUNNING_DEVICES_NOTIFICATION_GROUP().createNotification(message, NotificationType.WARNING).notify(this.project);
    }

    private final boolean isInvalidCompoundApk(InstallException $this$isInvalidCompoundApk) {
        return Intrinsics.areEqual((Object)$this$isInvalidCompoundApk.getErrorCode(), (Object)"INSTALL_FAILED_INVALID_APK") && StringsKt.endsWith$default((String)$this$isInvalidCompoundApk.getErrorMessage(), (String)" Split null was defined multiple times", (boolean)false, (int)2, null);
    }

    private final String fileNameForDisplay(Path $this$fileNameForDisplay) {
        String filename = ((Object)$this$fileNameForDisplay.getFileName()).toString();
        int dotOffset = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
        int suffixLength = dotOffset >= 0 ? filename.length() - dotOffset : 0;
        String string = StringUtil.shortenTextWithEllipsis((String)filename, (int)32, (int)suffixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    public static final /* synthetic */ void access$notifyOfSuccess(DeviceFileDropHandler $this, String message) {
        $this.notifyOfSuccess(message);
    }

    public static final /* synthetic */ String access$formatForDisplay(DeviceFileDropHandler $this, String prefixForPluralCase, List files2) {
        return $this.formatForDisplay(prefixForPluralCase, files2);
    }

    public static final /* synthetic */ boolean access$isInvalidCompoundApk(DeviceFileDropHandler $this, InstallException $receiver) {
        return $this.isInvalidCompoundApk($receiver);
    }

    public static final /* synthetic */ void access$notifyOfError(DeviceFileDropHandler $this, String message) {
        $this.notifyOfError(message);
    }

    public static final /* synthetic */ AbstractDisplayView access$getDisplayView$p(DeviceFileDropHandler $this) {
        return $this.displayView;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/streaming/core/DeviceFileDropHandler$FileType;", "", "<init>", "(Ljava/lang/String;I)V", "APK", "OTHER", "intellij.android.streaming"})
    private static final class FileType
    extends Enum<FileType> {
        public static final /* enum */ FileType APK = new FileType();
        public static final /* enum */ FileType OTHER = new FileType();
        private static final /* synthetic */ FileType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String value2) {
            return Enum.valueOf(FileType.class, value2);
        }

        @NotNull
        public static EnumEntries<FileType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fileTypeArray = new FileType[]{FileType.APK, FileType.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

