/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.idea.streaming.core.LayoutNode;
import com.android.tools.idea.streaming.core.LayoutOptimizer;
import com.android.tools.idea.streaming.core.LeafNode;
import com.android.tools.idea.streaming.core.SplitType;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0000\u001a \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"computeBestLayout", "Lcom/android/tools/idea/streaming/core/LayoutNode;", "availableSpace", "Ljava/awt/Dimension;", "rectangleSizes", "", "computeSize", "splitType", "Lcom/android/tools/idea/streaming/core/SplitType;", "firstChild", "secondChild", "EM_DASH", "", "intellij.android.streaming"})
public final class MultiDisplayLayoutOptimizerKt {
    private static final char EM_DASH = '\u2014';

    @NotNull
    public static final LayoutNode computeBestLayout(@NotNull Dimension availableSpace, @NotNull List<? extends Dimension> rectangleSizes) {
        Intrinsics.checkNotNullParameter((Object)availableSpace, (String)"availableSpace");
        Intrinsics.checkNotNullParameter(rectangleSizes, (String)"rectangleSizes");
        if (!(!((Collection)rectangleSizes).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (rectangleSizes.size() < 2) {
            return new LeafNode(0, availableSpace);
        }
        LayoutOptimizer optimizer = new LayoutOptimizer(rectangleSizes);
        return optimizer.optimize(availableSpace);
    }

    private static final Dimension computeSize(SplitType splitType, LayoutNode firstChild, LayoutNode secondChild) {
        return switch (WhenMappings.$EnumSwitchMapping$0[splitType.ordinal()]) {
            case 1 -> new Dimension(firstChild.getSize().width + secondChild.getSize().width, Math.max(firstChild.getSize().height, secondChild.getSize().height));
            case 2 -> new Dimension(Math.max(firstChild.getSize().width, secondChild.getSize().width), firstChild.getSize().height + secondChild.getSize().height);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ Dimension access$computeSize(SplitType splitType, LayoutNode firstChild, LayoutNode secondChild) {
        return MultiDisplayLayoutOptimizerKt.computeSize(splitType, firstChild, secondChild);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SplitType.values().length];
            try {
                nArray[SplitType.HORIZONTAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SplitType.VERTICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

