/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.idea.streaming.device.DeviceConfigurationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0014\u0010\u001d\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "", "deviceProperties", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "useTitleAsName", "", "<init>", "(Lcom/android/sdklib/deviceprovisioner/DeviceProperties;Z)V", "getDeviceProperties", "()Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "apiLevel", "", "getApiLevel", "()I", "featureLevel", "getFeatureLevel", "deviceModel", "", "getDeviceModel", "()Ljava/lang/String;", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "isWatch", "()Z", "isAutomotive", "deviceName", "getDeviceName", "hasOrientationSensors", "getHasOrientationSensors", "intellij.android.streaming"})
public final class DeviceConfiguration {
    @NotNull
    private final DeviceProperties deviceProperties;
    @NotNull
    private final String deviceName;
    private final boolean hasOrientationSensors;

    public DeviceConfiguration(@NotNull DeviceProperties deviceProperties, boolean useTitleAsName) {
        Intrinsics.checkNotNullParameter((Object)deviceProperties, (String)"deviceProperties");
        this.deviceProperties = deviceProperties;
        this.deviceName = DeviceConfigurationKt.composeDeviceName(this.deviceProperties, useTitleAsName);
        this.hasOrientationSensors = true;
    }

    public /* synthetic */ DeviceConfiguration(DeviceProperties deviceProperties, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(deviceProperties, bl);
    }

    @NotNull
    public final DeviceProperties getDeviceProperties() {
        return this.deviceProperties;
    }

    public final int getApiLevel() {
        AndroidVersion androidVersion = this.deviceProperties.getAndroidVersion();
        return androidVersion != null ? androidVersion.getApiLevel() : 36;
    }

    public final int getFeatureLevel() {
        AndroidVersion androidVersion = this.deviceProperties.getAndroidVersion();
        return androidVersion != null ? androidVersion.getFeatureLevel() : 36;
    }

    @Nullable
    public final String getDeviceModel() {
        return this.deviceProperties.getModel();
    }

    @NotNull
    public final DeviceType getDeviceType() {
        DeviceType deviceType = this.deviceProperties.getDeviceType();
        if (deviceType == null) {
            deviceType = DeviceType.HANDHELD;
        }
        return deviceType;
    }

    public final boolean isWatch() {
        return this.deviceProperties.getDeviceType() == DeviceType.WEAR;
    }

    public final boolean isAutomotive() {
        return this.deviceProperties.getDeviceType() == DeviceType.AUTOMOTIVE;
    }

    @NotNull
    public final String getDeviceName() {
        return this.deviceName;
    }

    public final boolean getHasOrientationSensors() {
        return this.hasOrientationSensors;
    }
}

