/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.SdkConstants;
import com.android.annotations.concurrency.UiThread;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.DeviceMirroringSettingsListener;
import com.android.tools.idea.streaming.core.AbstractDisplayView;
import com.android.tools.idea.streaming.core.AbstractDisplayViewKt;
import com.android.tools.idea.streaming.core.DeviceId;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.AgentTerminatedException;
import com.android.tools.idea.streaming.device.AndroidKeyCodesKt;
import com.android.tools.idea.streaming.device.AndroidKeyEventActionType;
import com.android.tools.idea.streaming.device.AndroidKeyStroke;
import com.android.tools.idea.streaming.device.AndroidKeyStrokeKt;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceClipboardSynchronizer;
import com.android.tools.idea.streaming.device.DeviceConfiguration;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.DeviceViewKt;
import com.android.tools.idea.streaming.device.InvalidFrameException;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import com.android.tools.idea.streaming.device.MotionEventMessage;
import com.android.tools.idea.streaming.device.TextInputMessage;
import com.android.tools.idea.streaming.device.VideoDecoder;
import com.android.tools.idea.streaming.device.xr.DeviceXrInputController;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u0098\u00012\u00020\u00012\u00020\u0002:\u000e\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010[\u001a\u00020\n2\u0006\u0010\\\u001a\u00020\nH\u0016J\u0010\u0010]\u001a\u00020X2\u0006\u0010\u000b\u001a\u00020\nH\u0002J&\u0010^\u001a\u00020X2\u0006\u0010_\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010`\u001a\u00020<H\u0082@\u00a2\u0006\u0002\u0010aJ\b\u0010b\u001a\u00020XH\u0002J\b\u0010c\u001a\u00020XH\u0002J$\u0010d\u001a\u00020X2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010f2\u0006\u0010`\u001a\u00020<H\u0002J\u0012\u0010g\u001a\u00020X2\b\u0010e\u001a\u0004\u0018\u00010fH\u0002J\u0012\u0010h\u001a\u00020i2\b\u0010e\u001a\u0004\u0018\u00010fH\u0002J\u0012\u0010j\u001a\u00020i2\b\u0010e\u001a\u0004\u0018\u00010fH\u0002J\b\u0010k\u001a\u00020XH\u0016J\b\u0010l\u001a\u00020\u0013H\u0014J\b\u0010m\u001a\u00020XH\u0014J\b\u0010n\u001a\u000200H\u0014J\u0010\u0010n\u001a\u0002002\u0006\u0010o\u001a\u00020\nH\u0002J\u0010\u0010p\u001a\u00020X2\u0006\u0010q\u001a\u00020rH\u0014J\b\u0010s\u001a\u00020XH\u0002J\u0010\u0010t\u001a\u00020X2\u0006\u0010u\u001a\u00020vH\u0017J\u001d\u0010w\u001a\u00020X2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b{J\b\u0010|\u001a\u00020XH\u0002J\b\u0010}\u001a\u00020XH\u0002J;\u0010~\u001a\u00020X2\u0006\u0010\u007f\u001a\u00020G2\u0007\u0010\u0080\u0001\u001a\u00020\n2\u0007\u0010\u0081\u0001\u001a\u00020\n2\t\b\u0002\u0010\u0082\u0001\u001a\u00020\n2\f\b\u0002\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001H\u0002J;\u0010\u0085\u0001\u001a\u00020X2\u0007\u0010\u0086\u0001\u001a\u00020G2\u0007\u0010\u0080\u0001\u001a\u00020\n2\u0007\u0010\u0081\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\n2\f\b\u0002\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001H\u0002J%\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0089\u00010\u0088\u00012\u0006\u0010\u007f\u001a\u00020G2\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001H\u0002J\u0019\u0010\u008a\u0001\u001a\n\u0012\u0005\u0012\u00030\u0089\u00010\u0088\u00012\u0006\u0010\u007f\u001a\u00020GH\u0002J\u0012\u0010\u008b\u0001\u001a\u00020\u00132\u0007\u0010x\u001a\u00030\u008c\u0001H\u0002J\u0012\u0010\u008d\u0001\u001a\u00020X2\u0007\u0010\u008e\u0001\u001a\u000209H\u0007J\u0012\u0010\u008f\u0001\u001a\u00020X2\u0007\u0010\u008e\u0001\u001a\u000209H\u0007J\u0012\u0010\u0090\u0001\u001a\u00020X2\u0007\u0010x\u001a\u00030\u0091\u0001H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u001e\u0010$\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020#@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b%\u0010&R\u0016\u0010'\u001a\u0004\u0018\u00010(8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010=\u001a\u00060>R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010C\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bD\u0010ER\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\u00020NX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u001e\u0010Q\u001a\u0004\u0018\u00010R8PX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010V\u00a8\u0006\u0099\u0001"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView;", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView;", "Lcom/android/tools/idea/streaming/DeviceMirroringSettingsListener;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "project", "Lcom/intellij/openapi/project/Project;", "displayId", "", "initialDisplayOrientation", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/device/DeviceClient;Lcom/intellij/openapi/project/Project;II)V", "getDeviceClient", "()Lcom/android/tools/idea/streaming/device/DeviceClient;", "getProject", "()Lcom/intellij/openapi/project/Project;", "isConnected", "", "()Z", "deviceId", "Lcom/android/tools/idea/streaming/core/DeviceId;", "getDeviceId", "()Lcom/android/tools/idea/streaming/core/DeviceId;", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "value", "displayOrientationQuadrants", "getDisplayOrientationQuadrants", "()I", "apiLevel", "getApiLevel", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "connectionState", "setConnectionState", "(Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;)V", "deviceController", "Lcom/android/tools/idea/streaming/device/DeviceController;", "getDeviceController$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/device/DeviceController;", "deviceConfig", "Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "getDeviceConfig", "()Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "deviceDisplaySize", "Ljava/awt/Dimension;", "getDeviceDisplaySize$intellij_android_streaming", "()Ljava/awt/Dimension;", "deviceScaleFactor", "", "clipboardSynchronizer", "Lcom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer;", "connectionStateListeners", "", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionStateListener;", "agentTerminationListener", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/streaming/device/DeviceClient$AgentTerminationListener;", "frameListener", "Lcom/android/tools/idea/streaming/device/DeviceView$MyFrameListener;", "displayTransform", "Ljava/awt/geom/AffineTransform;", "disposed", "maxVideoSize", "multiTouchMode", "setMultiTouchMode", "(Z)V", "lastTouchCoordinates", "Ljava/awt/Point;", "wasInsideDisplay", "mouseHovering", "repaintAlarm", "Lcom/intellij/util/Alarm;", "highQualityRenderingRequested", "hardwareInput", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput;", "getHardwareInput", "()Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput;", "xrInputController", "Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputController;", "getXrInputController$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputController;", "setXrInputController$intellij_android_streaming", "(Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputController;)V", "setBounds", "", "x", "y", "width", "height", "connectToAgentAsync", "connectToAgent", "maxOutputSize", "disconnectionListener", "(Ljava/awt/Dimension;ILcom/android/tools/idea/streaming/device/DeviceClient$AgentTerminationListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateVideoSize", "connected", "disconnected", "exception", "", "logConnectionError", "getConnectionErrorMessage", "", "getDisconnectionErrorMessage", "dispose", "canZoom", "onScreenScaleChanged", "computeActualSize", "rotationQuadrants", "paintComponent", "graphics", "Ljava/awt/Graphics;", "requestHighQualityRepaint", "settingsChanged", "settings", "Lcom/android/tools/idea/streaming/DeviceMirroringSettings;", "hardwareInputStateChanged", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "enabled", "hardwareInputStateChanged$intellij_android_streaming", "startClipboardSynchronization", "stopClipboardSynchronization", "sendMotionEvent", "p", "action", "modifiers", "button", "axisValues", "Lit/unimi/dsi/fastutil/ints/Int2FloatOpenHashMap;", "sendMotionEventDisplayCoordinates", "point", "originalPointer", "", "Lcom/android/tools/idea/streaming/device/MotionEventMessage$Pointer;", "originalAndMirroredPointer", "isInsideDisplay", "Ljava/awt/event/MouseEvent;", "addConnectionStateListener", "listener", "removeConnectionStateListener", "updateMultiTouchMode", "Ljava/awt/event/InputEvent;", "ConnectionState", "ConnectionStateListener", "MyFrameListener", "MyKeyListener", "MyMouseListener", "MyAgentTerminationListener", "Companion", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nDeviceView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceView.kt\ncom/android/tools/idea/streaming/device/DeviceView\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,979:1\n25#2:980\n25#2:981\n1#3:982\n*S KotlinDebug\n*F\n+ 1 DeviceView.kt\ncom/android/tools/idea/streaming/device/DeviceView\n*L\n386#1:980\n388#1:981\n*E\n"})
public final class DeviceView
extends AbstractDisplayView
implements DeviceMirroringSettingsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceClient deviceClient;
    @NotNull
    private final Project project;
    private final int initialDisplayOrientation;
    @NotNull
    private final DeviceId deviceId;
    @NotNull
    private final DeviceType deviceType;
    private int displayOrientationQuadrants;
    @NotNull
    private ConnectionState connectionState;
    @NotNull
    private final Dimension deviceDisplaySize;
    private double deviceScaleFactor;
    @Nullable
    private DeviceClipboardSynchronizer clipboardSynchronizer;
    @NotNull
    private final List<ConnectionStateListener> connectionStateListeners;
    @NotNull
    private AtomicReference<DeviceClient.AgentTerminationListener> agentTerminationListener;
    @NotNull
    private final MyFrameListener frameListener;
    @NotNull
    private final AffineTransform displayTransform;
    private boolean disposed;
    @NotNull
    private Dimension maxVideoSize;
    private boolean multiTouchMode;
    @Nullable
    private Point lastTouchCoordinates;
    private boolean wasInsideDisplay;
    private boolean mouseHovering;
    @NotNull
    private final Alarm repaintAlarm;
    private boolean highQualityRenderingRequested;
    @NotNull
    private final AbstractDisplayView.HardwareInput hardwareInput;
    @Nullable
    private DeviceXrInputController xrInputController;
    private static final int MAX_INVALID_FRAME_RETRIES = 3;

    public DeviceView(@NotNull Disposable disposableParent, @NotNull DeviceClient deviceClient, @NotNull Project project, int displayId, int initialDisplayOrientation) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)deviceClient, (String)"deviceClient");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, displayId, "StreamingContextMenuPhysicalDevice");
        this.deviceClient = deviceClient;
        this.project = project;
        this.initialDisplayOrientation = initialDisplayOrientation;
        this.deviceId = DeviceId.Companion.ofPhysicalDevice(this.deviceClient.getDeviceSerialNumber());
        this.deviceType = this.getDeviceConfig().getDeviceType();
        this.connectionState = ConnectionState.INITIAL;
        this.deviceDisplaySize = new Dimension();
        this.deviceScaleFactor = 1.0;
        this.connectionStateListeners = new ArrayList();
        this.agentTerminationListener = new AtomicReference();
        this.frameListener = new MyFrameListener();
        this.displayTransform = new AffineTransform();
        this.maxVideoSize = new Dimension();
        this.repaintAlarm = new Alarm((Disposable)this);
        this.hardwareInput = new AbstractDisplayView.HardwareInput(this){
            final /* synthetic */ DeviceView this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendToDevice(int id2, int keyCode, int modifiersEx) {
                block6: {
                    AndroidKeyEventActionType androidKeyEventActionType;
                    if (!this.this$0.isConnected()) {
                        return;
                    }
                    switch (id2) {
                        case 401: {
                            androidKeyEventActionType = AndroidKeyEventActionType.ACTION_DOWN;
                            break;
                        }
                        case 402: {
                            androidKeyEventActionType = AndroidKeyEventActionType.ACTION_UP;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    AndroidKeyEventActionType action2 = androidKeyEventActionType;
                    int metaState = com.android.tools.idea.streaming.device.DeviceView$Companion.access$modifiersToMetaState(DeviceView.Companion, modifiersEx);
                    Integer n = AndroidKeyCodesKt.getVK_TO_AKEYCODE().get(keyCode);
                    if (n == null) {
                        return;
                    }
                    int akeycode = n;
                    DeviceController deviceController = this.this$0.getDeviceController$intellij_android_streaming();
                    if (deviceController == null) break block6;
                    deviceController.sendControlMessage(new KeyEventMessage(action2, akeycode, metaState));
                }
            }
        };
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.getPhysicalWidth() > 0 && this.getPhysicalHeight() > 0 && connectionState == ConnectionState.INITIAL) {
                    this.connectToAgentAsync(initialDisplayOrientation);
                }
            }
        });
        MyMouseListener mouseListener2 = new MyMouseListener();
        this.addMouseListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
        this.addMouseWheelListener(mouseListener2);
        this.addKeyListener(new MyKeyListener());
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic<DeviceMirroringSettingsListener> topic = DeviceMirroringSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    @NotNull
    public final DeviceClient getDeviceClient() {
        return this.deviceClient;
    }

    @Override
    @NotNull
    protected Project getProject() {
        return this.project;
    }

    public final boolean isConnected() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    @Override
    @NotNull
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    @Override
    @NotNull
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public int getDisplayOrientationQuadrants() {
        return this.displayOrientationQuadrants;
    }

    @Override
    public int getApiLevel() {
        return this.deviceClient.getDeviceConfig().getApiLevel();
    }

    private final void setConnectionState(ConnectionState value2) {
        block6: {
            if (this.connectionState == value2) break block6;
            this.connectionState = value2;
            DeviceXrInputController deviceXrInputController = this.getXrInputController$intellij_android_streaming();
            if (deviceXrInputController != null) {
                DeviceXrInputController it = deviceXrInputController;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[value2.ordinal()]) {
                    case 1: {
                        DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
                        if (deviceController != null) {
                            deviceController.addXrEnvironmentListener$intellij_android_streaming(it);
                        }
                        break;
                    }
                    case 2: {
                        DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
                        if (deviceController == null) break;
                        deviceController.removeXrEnvironmentListener$intellij_android_streaming(it);
                        break;
                    }
                }
            }
            ActivityTracker.getInstance().inc();
            UIUtil.invokeLaterIfNeeded(() -> DeviceView._set_connectionState_$lambda$1(this));
        }
    }

    @Nullable
    public final DeviceController getDeviceController$intellij_android_streaming() {
        return this.deviceClient.getDeviceController$intellij_android_streaming();
    }

    private final DeviceConfiguration getDeviceConfig() {
        return this.deviceClient.getDeviceConfig();
    }

    @Override
    @NotNull
    public Dimension getDeviceDisplaySize$intellij_android_streaming() {
        return this.deviceDisplaySize;
    }

    private final void setMultiTouchMode(boolean value2) {
        if (value2 != this.multiTouchMode) {
            this.multiTouchMode = value2;
            this.repaint();
            Point point = this.lastTouchCoordinates;
            if (point != null) {
                int action2 = value2 ? 5 : 6;
                DeviceView.sendMotionEvent$default(this, point, action2, 0, 0, null, 24, null);
            }
        }
    }

    @Override
    @NotNull
    protected AbstractDisplayView.HardwareInput getHardwareInput() {
        return this.hardwareInput;
    }

    @Override
    @Nullable
    public DeviceXrInputController getXrInputController$intellij_android_streaming() {
        if (this.xrInputController == null && this.isConnected() && this.getDeviceConfig().getDeviceType() == DeviceType.XR_HEADSET) {
            this.xrInputController = DeviceXrInputController.Companion.getInstance(this.getProject(), this.deviceClient);
        }
        return this.xrInputController;
    }

    public void setXrInputController$intellij_android_streaming(@Nullable DeviceXrInputController deviceXrInputController) {
        this.xrInputController = deviceXrInputController;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resized = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (resized && this.getPhysicalWidth() > 0 && this.getPhysicalHeight() > 0) {
            if (this.connectionState == ConnectionState.INITIAL) {
                this.connectToAgentAsync(this.initialDisplayOrientation);
            } else {
                this.updateVideoSize();
            }
        }
    }

    private final void connectToAgentAsync(int initialDisplayOrientation) {
        this.setFrameNumber-WZ4Q5Ns(0);
        MyAgentTerminationListener disconnectionListener = new MyAgentTerminationListener();
        if (!this.agentTerminationListener.compareAndSet(null, disconnectionListener)) {
            throw new IllegalStateException("Agent termination listener already set");
        }
        this.setConnectionState(ConnectionState.CONNECTING);
        this.maxVideoSize = this.getPhysicalSize();
        this.deviceClient.addAgentTerminationListener(disconnectionListener);
        BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.createCoroutineScope$default((Disposable)this, null, null, (int)3, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, initialDisplayOrientation, disconnectionListener, null){
            int label;
            final /* synthetic */ DeviceView this$0;
            final /* synthetic */ int $initialDisplayOrientation;
            final /* synthetic */ MyAgentTerminationListener $disconnectionListener;
            {
                this.this$0 = $receiver;
                this.$initialDisplayOrientation = $initialDisplayOrientation;
                this.$disconnectionListener = $disconnectionListener;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DeviceView.access$connectToAgent(this.this$0, DeviceView.access$getMaxVideoSize$p(this.this$0), this.$initialDisplayOrientation, this.$disconnectionListener, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Exception decompiling
     */
    private final Object connectToAgent(Dimension var1_1, int var2_2, DeviceClient.AgentTerminationListener var3_3, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void updateVideoSize() {
        Dimension maxSize = this.getPhysicalSize();
        if (!Intrinsics.areEqual((Object)this.maxVideoSize, (Object)maxSize)) {
            this.maxVideoSize = maxSize;
            this.deviceClient.setMaxVideoResolution(this.getProject(), this.getDisplayId(), maxSize);
        }
    }

    private final void connected() {
        if (this.connectionState == ConnectionState.CONNECTING) {
            this.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
            this.hideDisconnectedStateMessage();
            this.setConnectionState(ConnectionState.CONNECTED);
            if (this.getDisplayId() == SdkConstants.PRIMARY_DISPLAY_ID && DeviceMirroringSettings.Companion.getInstance().getSynchronizeClipboard()) {
                this.startClipboardSynchronization();
            }
        }
    }

    private final void disconnected(int initialDisplayOrientation, Throwable exception, DeviceClient.AgentTerminationListener disconnectionListener) {
        if (!this.agentTerminationListener.compareAndSet(disconnectionListener, null)) {
            return;
        }
        if (this.getDisplayId() != SdkConstants.PRIMARY_DISPLAY_ID) {
            return;
        }
        this.deviceClient.getStreamingSessionTracker$intellij_android_streaming().streamingEnded();
        UIUtil.invokeLaterIfNeeded(() -> DeviceView.disconnected$lambda$3(this, exception, initialDisplayOrientation));
    }

    static /* synthetic */ void disconnected$default(DeviceView deviceView, int n, Throwable throwable, DeviceClient.AgentTerminationListener agentTerminationListener, int n2, Object object) {
        if ((n2 & 2) != 0) {
            throwable = null;
        }
        deviceView.disconnected(n, throwable, agentTerminationListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void logConnectionError(Throwable exception) {
        block3: {
            block2: {
                Integer n;
                AgentTerminatedException agentTerminatedException = exception instanceof AgentTerminatedException ? (AgentTerminatedException)exception : null;
                Integer n2 = n = agentTerminatedException != null ? Integer.valueOf(agentTerminatedException.getExitCode()) : null;
                int n3 = 33;
                if (n2 != null && n2 == n3) break block2;
                Integer n4 = n;
                n3 = 34;
                if (n4 != null && n4 == n3) break block2;
                Integer n5 = n;
                n3 = 54;
                if (n5 == null || n5 != n3) break block3;
            }
            DeviceView $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DeviceView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to initialize the screen sharing agent");
            return;
        }
        DeviceView $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(DeviceView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Failed to initialize the screen sharing agent", exception);
    }

    private final String getConnectionErrorMessage(Throwable exception) {
        Object object;
        Integer n;
        AgentTerminatedException agentTerminatedException = exception instanceof AgentTerminatedException ? (AgentTerminatedException)exception : null;
        Integer n2 = n = agentTerminatedException != null ? Integer.valueOf(agentTerminatedException.getExitCode()) : null;
        int n3 = 33;
        if (n2 != null && n2 == n3) {
            object = "The device may not have sufficient computing power for encoding display contents. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
        } else {
            Integer n4 = n;
            n3 = 34;
            if (n4 != null && n4 == n3) {
                object = "Repeated video encoder errors during initialization of the device agent. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
            } else {
                Integer n5 = n;
                n3 = 54;
                if (n5 != null && n5 == n3) {
                    object = "The XR device is not configured for mirroring. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
                } else {
                    object = exception instanceof TimeoutException ? (TimeoutException)exception : null;
                    if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                        object = "Failed to initialize the device agent. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
                    }
                }
            }
        }
        return object;
    }

    private final String getDisconnectionErrorMessage(Throwable exception) {
        String string;
        Integer n;
        if (exception instanceof InvalidFrameException) {
            return "Too many invalid video frames. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
        }
        AgentTerminatedException agentTerminatedException = exception instanceof AgentTerminatedException ? (AgentTerminatedException)exception : null;
        Integer n2 = n = agentTerminatedException != null ? Integer.valueOf(agentTerminatedException.getExitCode()) : null;
        int n3 = 33;
        if (n2 != null && n2 == n3) {
            string = "Repeated video encoder errors. The device may not have sufficient computing power for encoding display contents. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
        } else {
            Integer n4 = n;
            n3 = 34;
            if (n4 != null && n4 == n3) {
                string = "Repeated video encoder errors. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
            } else {
                Integer n5 = n;
                n3 = 54;
                string = n5 != null && n5 == n3 ? "The XR device is not configured for mirroring. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details." : "Lost connection to the device. See " + StreamingUtilsKt.getShowLogHyperlink() + " for details.";
            }
        }
        return string;
    }

    public void dispose() {
        VideoDecoder videoDecoder = this.deviceClient.getVideoDecoder();
        if (videoDecoder != null) {
            videoDecoder.removeFrameListener(this.getDisplayId(), this.frameListener);
        }
        this.deviceClient.stopVideoStream(this.getProject(), this.getDisplayId());
        DeviceClient.AgentTerminationListener agentTerminationListener = this.agentTerminationListener.get();
        if (agentTerminationListener != null) {
            DeviceClient.AgentTerminationListener it = agentTerminationListener;
            boolean bl = false;
            this.deviceClient.removeAgentTerminationListener(it);
        }
        this.disposed = true;
    }

    @Override
    protected boolean canZoom() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    @Override
    protected void onScreenScaleChanged() {
        if (this.isConnected() && this.getPhysicalWidth() > 0 && this.getPhysicalHeight() > 0) {
            this.updateVideoSize();
        }
    }

    @Override
    @NotNull
    protected Dimension computeActualSize() {
        return this.computeActualSize(this.getDisplayOrientationQuadrants());
    }

    private final Dimension computeActualSize(int rotationQuadrants) {
        return AwtUtilsKt.rotatedByQuadrants((Dimension)this.getDeviceDisplaySize$intellij_android_streaming(), (int)rotationQuadrants);
    }

    protected void paintComponent(@NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        super.paintComponent(graphics);
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        VideoDecoder videoDecoder = this.deviceClient.getVideoDecoder();
        if (videoDecoder == null) {
            return;
        }
        VideoDecoder decoder = videoDecoder;
        decoder.consumeDisplayFrame(this.getDisplayId(), arg_0 -> DeviceView.paintComponent$lambda$5(this, graphics, arg_0));
    }

    private final void requestHighQualityRepaint() {
        this.highQualityRenderingRequested = true;
        this.repaint();
    }

    @Override
    @UiThread
    public void settingsChanged(@NotNull DeviceMirroringSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (this.disposed || this.getDeviceController$intellij_android_streaming() == null) {
            return;
        }
        if (settings.getSynchronizeClipboard()) {
            this.startClipboardSynchronization();
        } else {
            this.stopClipboardSynchronization();
        }
    }

    @Override
    public void hardwareInputStateChanged$intellij_android_streaming(@NotNull AnActionEvent event, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.hardwareInputStateChanged$intellij_android_streaming(event, enabled);
        InputEvent inputEvent = event.getInputEvent();
        Intrinsics.checkNotNull((Object)inputEvent);
        this.updateMultiTouchMode(inputEvent);
    }

    private final void startClipboardSynchronization() {
        if (this.clipboardSynchronizer == null) {
            this.clipboardSynchronizer = new DeviceClipboardSynchronizer(this, this.deviceClient);
        }
    }

    private final void stopClipboardSynchronization() {
        block0: {
            DeviceClipboardSynchronizer deviceClipboardSynchronizer = this.clipboardSynchronizer;
            if (deviceClipboardSynchronizer == null) break block0;
            DeviceClipboardSynchronizer it = deviceClipboardSynchronizer;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
            this.clipboardSynchronizer = null;
        }
    }

    private final void sendMotionEvent(Point p, int action2, int modifiers, int button, Int2FloatOpenHashMap axisValues) {
        Point point = this.toDeviceDisplayCoordinates$intellij_android_streaming(p);
        if (point == null) {
            return;
        }
        Point displayCoordinates = point;
        if (StreamingUtilsKt.contains(this.getDeviceDisplaySize$intellij_android_streaming(), displayCoordinates)) {
            this.sendMotionEventDisplayCoordinates(displayCoordinates, action2, modifiers, button, axisValues);
        } else if (action2 == 2) {
            this.lastTouchCoordinates = null;
            Point adjusted = StreamingUtilsKt.constrainInside(displayCoordinates, this.getDeviceDisplaySize$intellij_android_streaming());
            DeviceView.sendMotionEventDisplayCoordinates$default(this, adjusted, action2, modifiers, button, null, 16, null);
            DeviceView.sendMotionEventDisplayCoordinates$default(this, adjusted, 1, modifiers, button, null, 16, null);
        } else if (action2 == 10) {
            this.sendMotionEventDisplayCoordinates(StreamingUtilsKt.constrainInside(displayCoordinates, this.getDeviceDisplaySize$intellij_android_streaming()), action2, modifiers, button, axisValues);
        }
    }

    static /* synthetic */ void sendMotionEvent$default(DeviceView deviceView, Point point, int n, int n2, int n3, Int2FloatOpenHashMap int2FloatOpenHashMap, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x10) != 0) {
            int2FloatOpenHashMap = null;
        }
        deviceView.sendMotionEvent(point, n, n2, n3, int2FloatOpenHashMap);
    }

    private final void sendMotionEventDisplayCoordinates(Point point, int action2, int modifiers, int button, Int2FloatOpenHashMap axisValues) {
        block7: {
            if (!this.isConnected()) {
                return;
            }
            boolean isMouse = this.getDeviceConfig().getDeviceType() == DeviceType.XR_HEADSET || this.isHardwareInputEnabled();
            int buttonState = ((modifiers & 0x400) != 0 && isMouse ? 1 : 0) | ((modifiers & 0x800) != 0 ? 4 : 0) | ((modifiers & 0x1000) != 0 ? 2 : 0);
            int androidActionButton = switch (button) {
                case 1 -> {
                    if (isMouse) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> 4;
                case 3 -> 2;
                default -> 0;
            };
            MotionEventMessage message = this.multiTouchMode ? new MotionEventMessage(this.originalAndMirroredPointer(point), action2, 0, 0, this.getDisplayId(), isMouse) : (action2 == 5 || action2 == 6 ? new MotionEventMessage(this.originalAndMirroredPointer(point), action2 | 0x100, 0, 0, this.getDisplayId(), isMouse) : (action2 == 0 || action2 == 1 || action2 == 2 ? new MotionEventMessage(this.originalPointer(point, axisValues), action2, buttonState, androidActionButton, this.getDisplayId(), isMouse) : new MotionEventMessage(this.originalPointer(point, axisValues), action2, 0, 0, this.getDisplayId(), isMouse)));
            DeviceController deviceController = this.getDeviceController$intellij_android_streaming();
            if (deviceController == null) break block7;
            deviceController.sendControlMessage(message);
        }
    }

    static /* synthetic */ void sendMotionEventDisplayCoordinates$default(DeviceView deviceView, Point point, int n, int n2, int n3, Int2FloatOpenHashMap int2FloatOpenHashMap, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            int2FloatOpenHashMap = null;
        }
        deviceView.sendMotionEventDisplayCoordinates(point, n, n2, n3, int2FloatOpenHashMap);
    }

    private final List<MotionEventMessage.Pointer> originalPointer(Point p, Int2FloatOpenHashMap axisValues) {
        return CollectionsKt.listOf((Object)new MotionEventMessage.Pointer(p.x, p.y, 0, axisValues));
    }

    private final List<MotionEventMessage.Pointer> originalAndMirroredPointer(Point p) {
        Object[] objectArray = new MotionEventMessage.Pointer[]{new MotionEventMessage.Pointer(p.x, p.y, 0, null, 8, null), new MotionEventMessage.Pointer(this.getDeviceDisplaySize$intellij_android_streaming().width - p.x, this.getDeviceDisplaySize$intellij_android_streaming().height - p.y, 1, null, 8, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean isInsideDisplay(MouseEvent event) {
        Rectangle rectangle = this.getDisplayRectangle();
        return rectangle != null ? rectangle.contains((double)event.getX() * this.getScreenScale(), (double)event.getY() * this.getScreenScale()) : false;
    }

    @UiThread
    public final void addConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.add(listener2);
        listener2.connectionStateChanged(this.getDeviceSerialNumber(), this.connectionState);
    }

    @UiThread
    public final void removeConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.remove(listener2);
    }

    private final void updateMultiTouchMode(InputEvent event) {
        boolean oldMultiTouchMode = this.multiTouchMode;
        if (event instanceof MouseEvent) {
            this.wasInsideDisplay = this.isInsideDisplay((MouseEvent)event);
        }
        this.setMultiTouchMode(this.wasInsideDisplay && (event.getModifiersEx() & 0x80) != 0 && !this.isHardwareInputEnabled() && this.getXrInputController$intellij_android_streaming() == null);
        if (this.multiTouchMode && oldMultiTouchMode) {
            this.repaint();
        }
    }

    private static final void _set_connectionState_$lambda$1(DeviceView this$0) {
        if (!this$0.disposed) {
            for (ConnectionStateListener listener2 : this$0.connectionStateListeners) {
                listener2.connectionStateChanged(this$0.getDeviceSerialNumber(), this$0.connectionState);
            }
        }
    }

    private static final void connectToAgent$lambda$2(DeviceView this$0) {
        if (!this$0.disposed) {
            this$0.connected();
            this$0.repaint();
            this$0.updateVideoSize();
        }
    }

    private static final void disconnected$lambda$3(DeviceView this$0, Throwable $exception, int $initialDisplayOrientation) {
        if (this$0.disposed || this$0.connectionState == ConnectionState.DISCONNECTED) {
            return;
        }
        this$0.setXrInputController$intellij_android_streaming(null);
        this$0.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
        this$0.stopClipboardSynchronization();
        String message = null;
        AbstractDisplayView.Reconnector reconnector = null;
        if (this$0.getFrameNumber-pVg5ArA() == 0) {
            this$0.logConnectionError($exception);
            message = this$0.getConnectionErrorMessage($exception);
            reconnector = this$0.new AbstractDisplayView.Reconnector("Retry", "Connecting to the device", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this$0, $initialDisplayOrientation, null){
                int label;
                final /* synthetic */ DeviceView this$0;
                final /* synthetic */ int $initialDisplayOrientation;
                {
                    this.this$0 = $receiver;
                    this.$initialDisplayOrientation = $initialDisplayOrientation;
                    super(1, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DeviceView.access$connectToAgentAsync(this.this$0, this.$initialDisplayOrientation);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            message = this$0.getDisconnectionErrorMessage($exception);
            reconnector = this$0.new AbstractDisplayView.Reconnector("Reconnect", "Attempting to reconnect", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this$0, null){
                int label;
                final /* synthetic */ DeviceView this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DeviceView.access$connectToAgentAsync(this.this$0, -1);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        this$0.setConnectionState(ConnectionState.DISCONNECTED);
        this$0.showDisconnectedStateMessage(message, StreamingUtilsKt.createShowLogHyperlinkListener(), reconnector);
    }

    private static final void paintComponent$lambda$5(DeviceView this$0, Graphics $graphics, VideoDecoder.VideoFrame displayFrame) {
        Intrinsics.checkNotNullParameter((Object)displayFrame, (String)"displayFrame");
        if (this$0.getFrameNumber-pVg5ArA() == 0) {
            this$0.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
        }
        this$0.repaintAlarm.cancelAllRequests();
        if (this$0.getDisplayOrientationQuadrants() != displayFrame.getOrientation() || this$0.getDeviceDisplaySize$intellij_android_streaming().width != 0 && this$0.getDeviceDisplaySize$intellij_android_streaming().width != displayFrame.getDisplaySize().width || this$0.getDeviceDisplaySize$intellij_android_streaming().height != 0 && this$0.getDeviceDisplaySize$intellij_android_streaming().height != displayFrame.getDisplaySize().height) {
            this$0.zoom(ZoomType.FIT);
        }
        Dimension rotatedDisplaySize = AwtUtilsKt.rotatedByQuadrants((Dimension)displayFrame.getDisplaySize(), (int)displayFrame.getOrientation());
        Dimension maxSize = this$0.computeMaxImageSize();
        double scaleFactor = this$0.roundScale(Math.min((double)maxSize.width / (double)rotatedDisplaySize.width, (double)maxSize.height / (double)rotatedDisplaySize.height));
        int w = RangesKt.coerceAtMost((int)AwtUtilsKt.scaled((int)rotatedDisplaySize.width, (double)scaleFactor), (int)this$0.getPhysicalWidth());
        int h = RangesKt.coerceAtMost((int)AwtUtilsKt.scaled((int)rotatedDisplaySize.height, (double)scaleFactor), (int)this$0.getPhysicalHeight());
        Rectangle displayRect = new Rectangle((this$0.getPhysicalWidth() - w) / 2, (this$0.getPhysicalHeight() - h) / 2, w, h);
        this$0.setDisplayRectangle(displayRect);
        BufferedImage image = displayFrame.getImage();
        Graphics2D g = this$0.createAdjustedGraphicsContext($graphics);
        if (displayRect.width == image.getWidth() && displayRect.height == image.getHeight()) {
            g.drawImage(image, null, displayRect.x, displayRect.y);
        } else {
            double xScale = (double)displayRect.width / (double)image.getWidth();
            double yScale = (double)displayRect.height / (double)image.getHeight();
            if (this$0.highQualityRenderingRequested && (xScale < 0.5 || yScale < 0.5)) {
                g.drawImage(ImageUtils.scale((BufferedImage)image, (double)xScale, (double)yScale), null, displayRect.x, displayRect.y);
            } else {
                this$0.displayTransform.setToTranslation(displayRect.x, displayRect.y);
                this$0.displayTransform.scale(xScale, yScale);
                g.drawImage(image, this$0.displayTransform, null);
                if (DeviceViewKt.access$isUnitTestMode()) {
                    this$0.requestHighQualityRepaint();
                } else {
                    this$0.repaintAlarm.addRequest(this$0::requestHighQualityRepaint, 500);
                }
            }
        }
        if (!Intrinsics.areEqual((Object)this$0.getDeviceDisplaySize$intellij_android_streaming(), (Object)displayFrame.getDisplaySize()) || this$0.getDisplayOrientationQuadrants() != displayFrame.getOrientation()) {
            this$0.getDeviceDisplaySize$intellij_android_streaming().setSize(displayFrame.getDisplaySize());
            this$0.displayOrientationQuadrants = displayFrame.getOrientation();
            ActivityTracker.getInstance().inc();
        }
        this$0.deviceScaleFactor = (double)Math.min(this$0.getDeviceDisplaySize$intellij_android_streaming().width, this$0.getDeviceDisplaySize$intellij_android_streaming().height) * this$0.getScreenScale() / (double)Math.min(displayRect.width, displayRect.height);
        this$0.setDisplayOrientationCorrectionQuadrants(displayFrame.getOrientationCorrection());
        this$0.setFrameNumber-WZ4Q5Ns(displayFrame.getFrameNumber-pVg5ArA());
        this$0.notifyFrameListeners(displayRect, displayFrame.getImage());
        if (this$0.multiTouchMode) {
            this$0.drawMultiTouchFeedback(g, displayRect, this$0.lastTouchCoordinates != null);
        }
    }

    public static final /* synthetic */ Object access$connectToAgent(DeviceView $this, Dimension maxOutputSize, int initialDisplayOrientation, DeviceClient.AgentTerminationListener disconnectionListener, Continuation $completion) {
        return $this.connectToAgent(maxOutputSize, initialDisplayOrientation, disconnectionListener, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$Companion;", "", "<init>", "()V", "MAX_INVALID_FRAME_RETRIES", "", "modifiersToMetaState", "modifiers", "modifierToMetaState", "modifierMask", "metaState", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        private final int modifiersToMetaState(int modifiers) {
            return this.modifierToMetaState(modifiers, 64, 1) | this.modifierToMetaState(modifiers, 128, 4096) | this.modifierToMetaState(modifiers, 256, 65536) | this.modifierToMetaState(modifiers, 512, 2);
        }

        private final int modifierToMetaState(int modifiers, int modifierMask, int metaState) {
            return (modifiers & modifierMask) != 0 ? metaState : 0;
        }

        public static final /* synthetic */ int access$modifiersToMetaState(Companion $this, int modifiers) {
            return $this.modifiersToMetaState(modifiers);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "", "<init>", "(Ljava/lang/String;I)V", "INITIAL", "CONNECTING", "CONNECTED", "DISCONNECTED", "intellij.android.streaming"})
    public static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState INITIAL = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTING = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTED = new ConnectionState();
        public static final /* enum */ ConnectionState DISCONNECTED = new ConnectionState();
        private static final /* synthetic */ ConnectionState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String value2) {
            return Enum.valueOf(ConnectionState.class, value2);
        }

        @NotNull
        public static EnumEntries<ConnectionState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = connectionStateArray = new ConnectionState[]{ConnectionState.INITIAL, ConnectionState.CONNECTING, ConnectionState.CONNECTED, ConnectionState.DISCONNECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionStateListener;", "", "connectionStateChanged", "", "deviceSerialNumber", "", "connectionState", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "intellij.android.streaming"})
    public static interface ConnectionStateListener {
        @UiThread
        public void connectionStateChanged(@NotNull String var1, @NotNull ConnectionState var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyAgentTerminationListener;", "Lcom/android/tools/idea/streaming/device/DeviceClient$AgentTerminationListener;", "<init>", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "agentTerminated", "", "exitCode", "", "deviceDisconnected", "intellij.android.streaming"})
    private final class MyAgentTerminationListener
    implements DeviceClient.AgentTerminationListener {
        @Override
        public void agentTerminated(int exitCode2) {
            DeviceView.this.disconnected(DeviceView.this.initialDisplayOrientation, new AgentTerminatedException(exitCode2), this);
        }

        @Override
        public void deviceDisconnected() {
            DeviceView.this.disconnected(DeviceView.this.initialDisplayOrientation, null, this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyFrameListener;", "Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "<init>", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "consecutiveInvalidFrames", "", "onNewFrameAvailable", "", "onEndOfVideoStream", "onInvalidFrame", "e", "Lcom/android/tools/idea/streaming/device/InvalidFrameException;", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nDeviceView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceView.kt\ncom/android/tools/idea/streaming/device/DeviceView$MyFrameListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,979:1\n25#2:980\n1#3:981\n*S KotlinDebug\n*F\n+ 1 DeviceView.kt\ncom/android/tools/idea/streaming/device/DeviceView$MyFrameListener\n*L\n670#1:980\n*E\n"})
    private final class MyFrameListener
    implements VideoDecoder.FrameListener {
        private int consecutiveInvalidFrames;

        @Override
        public void onNewFrameAvailable() {
            EventQueue.invokeLater(() -> MyFrameListener.onNewFrameAvailable$lambda$0(DeviceView.this));
        }

        @Override
        public void onEndOfVideoStream() {
        }

        @Override
        public void onInvalidFrame(@NotNull InvalidFrameException e) {
            block1: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    MyFrameListener $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(MyFrameListener.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn((Throwable)e);
                    ++this.consecutiveInvalidFrames;
                    if (this.consecutiveInvalidFrames > 3) break block0;
                    DeviceView.this.getDeviceClient().stopVideoStream(DeviceView.this.getProject(), DeviceView.this.getDisplayId());
                    DeviceView.this.getDeviceClient().startVideoStream(DeviceView.this.getProject(), DeviceView.this.getDisplayId(), DeviceView.this.maxVideoSize);
                    break block1;
                }
                DeviceClient.AgentTerminationListener agentTerminationListener = (DeviceClient.AgentTerminationListener)DeviceView.this.agentTerminationListener.get();
                if (agentTerminationListener == null) break block1;
                DeviceClient.AgentTerminationListener agentTerminationListener2 = agentTerminationListener;
                DeviceView deviceView = DeviceView.this;
                DeviceClient.AgentTerminationListener it = agentTerminationListener2;
                boolean bl = false;
                deviceView.disconnected(deviceView.initialDisplayOrientation, e, it);
            }
        }

        private static final void onNewFrameAvailable$lambda$0(DeviceView this$0) {
            this$0.connected();
            if (this$0.getWidth() != 0 && this$0.getHeight() != 0) {
                this$0.highQualityRenderingRequested = false;
                this$0.repaint();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J(\u0010\u0019\u001a\u00020\u000f*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyKeyListener;", "Ljava/awt/event/KeyAdapter;", "<init>", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "cachedKeyStrokeMap", "", "Ljavax/swing/KeyStroke;", "Lcom/android/tools/idea/streaming/device/AndroidKeyStroke;", "getCachedKeyStrokeMap", "()Ljava/util/Map;", "setCachedKeyStrokeMap", "(Ljava/util/Map;)V", "keyStrokeMap", "getKeyStrokeMap", "keyTyped", "", "event", "Ljava/awt/event/KeyEvent;", "keyPressed", "keyReleased", "hostKeyStrokeToAndroidKeyStroke", "hostKeyCode", "", "modifiers", "buildKeyStrokeMap", "addKeyStrokesForAction", "", "actionId", "", "androidKeyStroke", "intellij.android.streaming"})
    private final class MyKeyListener
    extends KeyAdapter {
        @Nullable
        private Map<KeyStroke, AndroidKeyStroke> cachedKeyStrokeMap;

        public MyKeyListener() {
            DeviceView.this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.setCachedKeyStrokeMap(null);
                }
            });
        }

        @Nullable
        public final Map<KeyStroke, AndroidKeyStroke> getCachedKeyStrokeMap() {
            return this.cachedKeyStrokeMap;
        }

        public final void setCachedKeyStrokeMap(@Nullable Map<KeyStroke, AndroidKeyStroke> map2) {
            this.cachedKeyStrokeMap = map2;
        }

        private final Map<KeyStroke, AndroidKeyStroke> getKeyStrokeMap() {
            Map<KeyStroke, AndroidKeyStroke> map2 = this.cachedKeyStrokeMap;
            if (map2 == null) {
                this.cachedKeyStrokeMap = map2 = this.buildKeyStrokeMap();
            }
            return map2;
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!DeviceView.this.isConnected()) {
                return;
            }
            if (DeviceView.this.isHardwareInputEnabled()) {
                return;
            }
            if (event.isControlDown() || event.isMetaDown() || !SystemInfo.isMac && event.isAltDown()) {
                return;
            }
            char c = event.getKeyChar();
            if (c == '\uffff' || Character.isISOControl(c)) {
                return;
            }
            TextInputMessage message = new TextInputMessage(String.valueOf(c));
            DeviceController deviceController = DeviceView.this.getDeviceController$intellij_android_streaming();
            if (deviceController != null) {
                deviceController.sendControlMessage(message);
            }
            event.consume();
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceView.this.updateMultiTouchMode(event);
            if (!DeviceView.this.isConnected()) {
                return;
            }
            if (DeviceView.this.isHardwareInputEnabled()) {
                DeviceView.this.getHardwareInput().forwardEvent(event);
                return;
            }
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.keyPressed(event) : false;
            if (bl) {
                return;
            }
            AndroidKeyStroke androidKeyStroke = this.hostKeyStrokeToAndroidKeyStroke(event.getKeyCode(), event.getModifiersEx());
            if (androidKeyStroke != null) {
                DeviceController deviceController = DeviceView.this.getDeviceController$intellij_android_streaming();
                if (deviceController != null) {
                    AndroidKeyStrokeKt.sendKeyStroke(deviceController, androidKeyStroke);
                }
                event.consume();
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DeviceView.this.updateMultiTouchMode(event);
                if (!DeviceView.this.isConnected()) {
                    return;
                }
                if (DeviceView.this.isHardwareInputEnabled()) {
                    DeviceView.this.getHardwareInput().forwardEvent(event);
                    return;
                }
                DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
                if (deviceXrInputController == null) break block2;
                deviceXrInputController.keyReleased(event);
            }
        }

        private final AndroidKeyStroke hostKeyStrokeToAndroidKeyStroke(int hostKeyCode, int modifiers) {
            int canonicalKeyCode = switch (hostKeyCode) {
                case 226 -> 37;
                case 227 -> 39;
                case 224 -> 38;
                case 225 -> 40;
                default -> hostKeyCode;
            };
            return this.getKeyStrokeMap().get(KeyStroke.getKeyStroke(canonicalKeyCode, modifiers));
        }

        private final Map<KeyStroke, AndroidKeyStroke> buildKeyStrokeMap() {
            Map map2;
            Map $this$buildKeyStrokeMap_u24lambda_u240 = map2 = (Map)new LinkedHashMap();
            boolean bl = false;
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Copy", new AndroidKeyStroke(278, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Cut", new AndroidKeyStroke(277, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Delete", new AndroidKeyStroke(112, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Paste", new AndroidKeyStroke(279, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$SelectAll", new AndroidKeyStroke(29, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorEnter", new AndroidKeyStroke(66, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorEscape", new AndroidKeyStroke(111, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorBackSpace", new AndroidKeyStroke(67, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLeft", new AndroidKeyStroke(21, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorRight", new AndroidKeyStroke(22, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLeftWithSelection", new AndroidKeyStroke(21, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorRightWithSelection", new AndroidKeyStroke(22, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorUp", new AndroidKeyStroke(19, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorDown", new AndroidKeyStroke(20, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorUpWithSelection", new AndroidKeyStroke(19, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorDownWithSelection", new AndroidKeyStroke(20, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPreviousWord", new AndroidKeyStroke(21, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorNextWord", new AndroidKeyStroke(22, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPreviousWordWithSelection", new AndroidKeyStroke(21, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorNextWordWithSelection", new AndroidKeyStroke(22, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineStart", new AndroidKeyStroke(122, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineEnd", new AndroidKeyStroke(123, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineStartWithSelection", new AndroidKeyStroke(122, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineEndWithSelection", new AndroidKeyStroke(123, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageUp", new AndroidKeyStroke(92, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageDown", new AndroidKeyStroke(93, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageUpWithSelection", new AndroidKeyStroke(92, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageDownWithSelection", new AndroidKeyStroke(93, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTab", new AndroidKeyStroke(61, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextStart", new AndroidKeyStroke(122, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextEnd", new AndroidKeyStroke(123, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextStartWithSelection", new AndroidKeyStroke(122, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextEndWithSelection", new AndroidKeyStroke(123, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Undo", new AndroidKeyStroke(54, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Redo", new AndroidKeyStroke(54, 4097));
            return map2;
        }

        private final void addKeyStrokesForAction(Map<KeyStroke, AndroidKeyStroke> $this$addKeyStrokesForAction, String actionId, AndroidKeyStroke androidKeyStroke) {
            for (KeyStroke keyStroke : KeymapUtil.getKeyStrokes((ShortcutSet)KeymapUtil.getActiveKeymapShortcuts((String)actionId))) {
                Intrinsics.checkNotNull((Object)keyStroke);
                $this$addKeyStrokesForAction.put(keyStroke, androidKeyStroke);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0005*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "currentModifiers", "", "mousePressed", "", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "terminateHovering", "adjustedModifiers", "getAdjustedModifiers", "(Ljava/awt/event/MouseEvent;)I", "toSign", "", "intellij.android.streaming"})
    private final class MyMouseListener
    extends MouseAdapter {
        private int currentModifiers;

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceView.this.requestFocusInWindow();
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.mousePressed(event, DeviceView.this.getDeviceDisplaySize$intellij_android_streaming(), DeviceView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            boolean insideDisplay = DeviceView.this.isInsideDisplay(event);
            if (DeviceView.this.handlePopup(event, insideDisplay)) {
                return;
            }
            if (insideDisplay && (this.currentModifiers & AbstractDisplayViewKt.buttonToMask(event.getButton())) == 0) {
                this.terminateHovering(event);
                if (event.getButton() == 1) {
                    DeviceView.this.lastTouchCoordinates = StreamingUtilsKt.getLocation(event);
                }
                DeviceView.this.updateMultiTouchMode(event);
                this.currentModifiers = event.getModifiersEx();
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 0, this.currentModifiers, event.getButton(), null, 16, null);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.mouseReleased(event, DeviceView.this.getDeviceDisplaySize$intellij_android_streaming(), DeviceView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            boolean insideDisplay = DeviceView.this.isInsideDisplay(event);
            if (DeviceView.this.handlePopup(event, insideDisplay)) {
                return;
            }
            if (insideDisplay && (this.currentModifiers & AbstractDisplayViewKt.buttonToMask(event.getButton())) != 0) {
                if (event.getButton() == 1) {
                    DeviceView.this.lastTouchCoordinates = null;
                }
                DeviceView.this.updateMultiTouchMode(event);
                this.currentModifiers = event.getModifiersEx();
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 1, this.currentModifiers, event.getButton(), null, 16, null);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.mouseEntered(event, DeviceView.this.getDeviceDisplaySize$intellij_android_streaming(), DeviceView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            DeviceView.this.updateMultiTouchMode(event);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.mouseExited(event, DeviceView.this.getDeviceDisplaySize$intellij_android_streaming(), DeviceView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            if ((this.currentModifiers & 0x1C00) != 0) {
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 2, this.getAdjustedModifiers(event), 0, null, 24, null);
                this.currentModifiers &= 0xFFFFE3FF;
            }
            DeviceView.this.lastTouchCoordinates = null;
            this.terminateHovering(event);
            DeviceView.this.updateMultiTouchMode(event);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.mouseDragged(event, DeviceView.this.getDeviceDisplaySize$intellij_android_streaming(), DeviceView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            DeviceView.this.updateMultiTouchMode(event);
            if ((this.currentModifiers & 0x1C00) != 0) {
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 2, this.getAdjustedModifiers(event), 0, null, 24, null);
                if (!DeviceView.this.isInsideDisplay(event)) {
                    this.currentModifiers &= 0xFFFFE3FF;
                }
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.mouseMoved(event, DeviceView.this.getDeviceDisplaySize$intellij_android_streaming(), DeviceView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            DeviceView.this.updateMultiTouchMode(event);
            if (DeviceView.this.isInsideDisplay(event)) {
                if (!DeviceView.this.multiTouchMode && (this.currentModifiers & 0x1C00) == 0) {
                    if (!DeviceView.this.mouseHovering) {
                        DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 9, this.getAdjustedModifiers(event), 0, null, 24, null);
                        DeviceView.this.mouseHovering = true;
                    }
                    DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 7, this.getAdjustedModifiers(event), 0, null, 24, null);
                }
            } else {
                this.terminateHovering(event);
            }
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceXrInputController deviceXrInputController = DeviceView.this.getXrInputController$intellij_android_streaming();
            boolean bl = deviceXrInputController != null ? deviceXrInputController.mouseWheelMoved(event, DeviceView.this.getDeviceDisplaySize$intellij_android_streaming(), DeviceView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            if (!DeviceView.this.isInsideDisplay(event)) {
                return;
            }
            this.terminateHovering(event);
            int axis = event.isShiftDown() ? 10 : 9;
            int direction = this.toSign(event.getPreciseWheelRotation() > 0.0 ^ axis == 9 ^ DeviceView.this.getDisplayOrientationCorrectionQuadrants() == 2);
            for (double remainingRotation = Math.abs(DeviceView.this.getNormalizedScrollAmount(event)); remainingRotation > 0.0; remainingRotation -= 1.0) {
                double scrollAmount = RangesKt.coerceAtMost((double)remainingRotation, (double)1.0) * (double)direction;
                Int2FloatOpenHashMap axisValues = new Int2FloatOpenHashMap(1);
                axisValues.put(axis, (float)scrollAmount);
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 8, this.getAdjustedModifiers(event), 0, axisValues, 8, null);
            }
        }

        private final void terminateHovering(MouseEvent event) {
            if (DeviceView.this.mouseHovering) {
                boolean savedMultiTouchMode = DeviceView.this.multiTouchMode;
                DeviceView.this.setMultiTouchMode(false);
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event), 10, 0, 0, null, 24, null);
                DeviceView.this.setMultiTouchMode(savedMultiTouchMode);
                DeviceView.this.mouseHovering = false;
            }
        }

        private final int getAdjustedModifiers(MouseEvent $this$adjustedModifiers) {
            return ($this$adjustedModifiers.getModifiersEx() & 0xFFFFE3FF | this.currentModifiers) & 0x1C00;
        }

        private final int toSign(boolean $this$toSign) {
            return $this$toSign ? 1 : -1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionState.values().length];
            try {
                nArray[ConnectionState.CONNECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionState.DISCONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

