/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.actions;

import com.android.emulator.control.KeyboardEvent;
import com.android.emulator.control.Posture;
import com.android.tools.adtui.device.SkinButton;
import com.android.tools.adtui.device.SkinDefinition;
import com.android.tools.idea.streaming.core.PushButtonAction;
import com.android.tools.idea.streaming.emulator.EmulatorConfiguration;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorKeyStrokeKt;
import com.android.tools.idea.streaming.emulator.EmulatorView;
import com.android.tools.idea.streaming.emulator.actions.AbstractEmulatorAction;
import com.android.tools.idea.streaming.emulator.actions.AbstractEmulatorActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.function.Predicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/emulator/actions/EmulatorPushButtonAction;", "Lcom/android/tools/idea/streaming/emulator/actions/AbstractEmulatorAction;", "Lcom/android/tools/idea/streaming/core/PushButtonAction;", "keyName", "", "modifierKeyName", "configFilter", "Ljava/util/function/Predicate;", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "skinOverridesConfigFilter", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Predicate;Z)V", "buttonPressed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buttonReleased", "buttonPressedAndReleased", "actionPerformed", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nEmulatorPushButtonAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorPushButtonAction.kt\ncom/android/tools/idea/streaming/emulator/actions/EmulatorPushButtonAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public class EmulatorPushButtonAction
extends AbstractEmulatorAction
implements PushButtonAction {
    @NotNull
    private final String keyName;
    @Nullable
    private final String modifierKeyName;
    private final boolean skinOverridesConfigFilter;

    public EmulatorPushButtonAction(@NotNull String keyName, @Nullable String modifierKeyName, @Nullable Predicate<EmulatorConfiguration> configFilter, boolean skinOverridesConfigFilter) {
        Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
        super(configFilter);
        this.keyName = keyName;
        this.modifierKeyName = modifierKeyName;
        this.skinOverridesConfigFilter = skinOverridesConfigFilter;
    }

    public /* synthetic */ EmulatorPushButtonAction(String string, String string2, Predicate predicate, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            predicate = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, string2, predicate, bl);
    }

    @Override
    public final void buttonPressed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event);
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulatorController2 = emulatorController;
        if (this.modifierKeyName != null) {
            EmulatorKeyStrokeKt.sendKeyEvent(emulatorController2, this.modifierKeyName, KeyboardEvent.KeyEventType.keydown);
        }
        EmulatorKeyStrokeKt.sendKeyEvent(emulatorController2, this.keyName, KeyboardEvent.KeyEventType.keydown);
    }

    @Override
    public final void buttonReleased(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event);
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulatorController2 = emulatorController;
        EmulatorKeyStrokeKt.sendKeyEvent(emulatorController2, this.keyName, KeyboardEvent.KeyEventType.keyup);
        if (this.modifierKeyName != null) {
            EmulatorKeyStrokeKt.sendKeyEvent(emulatorController2, this.modifierKeyName, KeyboardEvent.KeyEventType.keyup);
        }
    }

    @Override
    public final void buttonPressedAndReleased(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event);
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulatorController2 = emulatorController;
        if (this.modifierKeyName != null) {
            EmulatorKeyStrokeKt.sendKeyEvent(emulatorController2, this.modifierKeyName, KeyboardEvent.KeyEventType.keydown);
        }
        EmulatorKeyStrokeKt.sendKeyEvent(emulatorController2, this.keyName, KeyboardEvent.KeyEventType.keypress);
        if (this.modifierKeyName != null) {
            EmulatorKeyStrokeKt.sendKeyEvent(emulatorController2, this.modifierKeyName, KeyboardEvent.KeyEventType.keyup);
        }
    }

    public final void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.actionPerformedImpl(event);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        if (this.skinOverridesConfigFilter) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            if (!presentation2.isVisible()) {
                EmulatorView emulatorView = AbstractEmulatorActionKt.getEmulatorView(event);
                if (emulatorView == null) {
                    return;
                }
                EmulatorView emulatorView2 = emulatorView;
                EmulatorController emulatorController = emulatorView2.getEmulator();
                if (emulatorController.getConnectionState() == EmulatorController.ConnectionState.CONNECTED) {
                    Object v4;
                    block7: {
                        EmulatorConfiguration.PostureDescriptor postureDescriptor = emulatorView2.getCurrentPosture$intellij_android_streaming();
                        SkinDefinition skinDefinition = emulatorController.getSkin$intellij_android_streaming((Posture.PostureValue)(postureDescriptor != null ? postureDescriptor.getPosture() : null));
                        if (skinDefinition == null) {
                            return;
                        }
                        SkinDefinition skin = skinDefinition;
                        Iterable iterable = skin.getLayout().getButtons();
                        for (Object t : iterable) {
                            SkinButton it = (SkinButton)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getKeyName(), (Object)this.keyName)) continue;
                            v4 = t;
                            break block7;
                        }
                        v4 = null;
                    }
                    if (v4 != null) {
                        presentation2.setEnabledAndVisible(true);
                    }
                }
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        return PushButtonAction.super.createCustomComponent(presentation, place);
    }

    @Override
    public void actionPerformedImpl(@NotNull AnActionEvent event) {
        PushButtonAction.super.actionPerformedImpl(event);
    }
}

