/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.actions;

import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.DeviceType;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.ImportUtpResultActionKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.UtpTestResultAdapter;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteView;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB3\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/actions/ImportUtpResultAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "icon", "Ljavax/swing/Icon;", "text", "", "toolWindowDisplayName", "importFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getToolWindowDisplayName", "()Ljava/lang/String;", "getImportFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "parseResultsAndDisplay", "", "file", "Ljava/io/File;", "disposable", "Lcom/intellij/openapi/Disposable;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.android.core"})
public final class ImportUtpResultAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toolWindowDisplayName;
    @Nullable
    private final VirtualFile importFile;
    @NotNull
    public static final String IMPORTED_TEST_WINDOW_ID = "Imported Tests";
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Import Android Test Results");

    public ImportUtpResultAction(@Nullable Icon icon, @NotNull String text2, @NotNull String toolWindowDisplayName, @Nullable VirtualFile importFile) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)toolWindowDisplayName, (String)"toolWindowDisplayName");
        super(text2, text2, icon);
        this.toolWindowDisplayName = toolWindowDisplayName;
        this.importFile = importFile;
    }

    public /* synthetic */ ImportUtpResultAction(Icon icon, String string, String string2, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            icon = null;
        }
        if ((n & 2) != 0) {
            string = "Import Android Test Results...";
        }
        if ((n & 4) != 0) {
            string2 = "Imported Android Test Results";
        }
        if ((n & 8) != 0) {
            virtualFile = null;
        }
        this(icon, string, string2, virtualFile);
    }

    @NotNull
    public final String getToolWindowDisplayName() {
        return this.toolWindowDisplayName;
    }

    @Nullable
    public final VirtualFile getImportFile() {
        return this.importFile;
    }

    @VisibleForTesting
    @NotNull
    public final ToolWindow getToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(IMPORTED_TEST_WINDOW_ID);
        if (toolWindow != null) {
            return toolWindow;
        }
        return toolWindowManager.registerToolWindow(new RegisterToolWindowTask(IMPORTED_TEST_WINDOW_ID, null, null, false, false, false, false, null, null, null, 1022, null));
    }

    @VisibleForTesting
    public final void parseResultsAndDisplay(@NotNull File file, @NotNull Disposable disposable, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunContentManager.getInstance((Project)project);
        try {
            Module module;
            UtpTestResultAdapter testAdapter;
            block6: {
                testAdapter = new UtpTestResultAdapter(file);
                String packageName = testAdapter.getPackageName();
                if (packageName != null) {
                    Module[] moduleArray = ModuleManager.Companion.getInstance(project).getModules();
                    int n = moduleArray.length;
                    for (int i = 0; i < n; ++i) {
                        Module module2;
                        Module it = module2 = moduleArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)ProjectSystemUtil.getModuleSystem(it).getPackageName(), (Object)packageName)) continue;
                        v0 = module2;
                        break block6;
                    }
                    v0 = null;
                } else {
                    v0 = module = null;
                }
            }
            if (module == null) {
                NOTIFICATION_GROUP.createNotification("Cannot find corresponding module. Some features might not be available. Did you import the test results from a different project?", NotificationType.WARNING).notify(project);
            }
            AndroidTestSuiteView testSuiteView = new AndroidTestSuiteView(disposable, project, module, IMPORTED_TEST_WINDOW_ID, null, null, true, false, 176, null);
            ToolWindow toolWindow = this.getToolWindow(project);
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            ContentManager contentManager2 = contentManager;
            Content content2 = contentManager2.getFactory().createContent(testSuiteView.getComponent(), this.toolWindowDisplayName, true);
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
            Content content3 = content2;
            contentManager2.addContent(content3);
            contentManager2.setSelectedContent(content3);
            BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.getCoroutineScope((Project)project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(testAdapter, testSuiteView, null){
                int label;
                final /* synthetic */ UtpTestResultAdapter $testAdapter;
                final /* synthetic */ AndroidTestSuiteView $testSuiteView;
                {
                    this.$testAdapter = $testAdapter;
                    this.$testSuiteView = $testSuiteView;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$testAdapter.forwardResults(this.$testSuiteView);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            toolWindow.activate(null);
        }
        catch (InvalidProtocolBufferException exception) {
            NOTIFICATION_GROUP.createNotification("Failed to import protobuf with exception: " + exception, NotificationType.ERROR).notify(project);
            throw exception;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (this.importFile != null) {
            this.parseResultsAndDisplay(FileExtensions.toIoFile(this.importFile), (Disposable)project2, project2);
            return;
        }
        VirtualFile virtualFile2 = ImportUtpResultActionKt.access$getDefaultAndroidGradlePluginTestDirectory(project2);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)ImportUtpResultActionKt.access$findTestResultProto(it, DeviceType.EMPTY));
        } else {
            virtualFile = null;
        }
        VirtualFile defaultPath = virtualFile;
        FileChooser.chooseFile((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(arg_0 -> ImportUtpResultAction.actionPerformed$lambda$3(ImportUtpResultAction::actionPerformed$lambda$2, arg_0)), (Project)e.getProject(), (VirtualFile)defaultPath, arg_0 -> ImportUtpResultAction.actionPerformed$lambda$5(arg_0 -> ImportUtpResultAction.actionPerformed$lambda$4(this, project2, arg_0), arg_0));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    private static final boolean actionPerformed$lambda$2(VirtualFile it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)"test-result.pb");
    }

    private static final boolean actionPerformed$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit actionPerformed$lambda$4(ImportUtpResultAction this$0, Project $project, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this$0.parseResultsAndDisplay(FileExtensions.toIoFile(file), (Disposable)$project, $project);
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public ImportUtpResultAction() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/actions/ImportUtpResultAction$Companion;", "", "<init>", "()V", "IMPORTED_TEST_WINDOW_ID", "", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

