/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.idea.transport.Constants;
import com.android.tools.idea.transport.DeployableFile;
import com.android.tools.idea.transport.TransportConfigContributor;
import com.android.tools.idea.transport.TransportFileCopier;
import com.android.tools.idea.transport.TransportNonExistingFileException;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransportFileManager
implements TransportFileCopier {
    static final String DEVICE_DIR = "/data/local/tmp/perfd/";
    private static final String CODE_CACHE_DIR = "code_cache";
    private static final String DAEMON_CONFIG_FILE = "daemon.config";
    private static final String AGENT_CONFIG_FILE = "agent.config";
    private static final int DEVICE_PORT = 12389;
    @NotNull
    private final IDevice myDevice;

    private static Logger getLogger() {
        return Logger.getInstance(TransportFileManager.class);
    }

    public TransportFileManager(@NotNull IDevice device2) {
        this.myDevice = device2;
    }

    public void copyFilesToDevice() throws AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException, SyncException, TimeoutException {
        if (!((Boolean)StudioFlags.TRANSPORT_CONSERVATIVE_COPY.get()).booleanValue()) {
            this.myDevice.executeShellCommand("rm -rf /data/local/tmp/perfd/", (IShellOutputReceiver)new NullOutputReceiver());
        }
        this.copyFileToDevice(HostFiles.TRANSPORT);
        if (TransportFileManager.isAtLeastO(this.myDevice)) {
            this.copyFileToDevice(HostFiles.PERFA);
            this.copyFileToDevice(HostFiles.JVMTI_AGENT);
            if (this.myDevice.getVersion().getFeatureLevel() < 29) {
                this.copyFileToDevice(HostFiles.SIMPLEPERF);
            }
        }
        if (((Boolean)StudioFlags.PROFILER_TRACEBOX.get()).booleanValue()) {
            if (TransportFileManager.isBetweenMAndP(this.myDevice)) {
                this.copyFileToDevice(HostFiles.TRACEBOX);
            }
        } else if (this.myDevice.getVersion().getFeatureLevel() == 28) {
            this.copyFileToDevice(HostFiles.PERFETTO);
            this.copyFileToDevice(HostFiles.PERFETTO_SO);
            this.copyFileToDevice(HostFiles.TRACED);
            this.copyFileToDevice(HostFiles.TRACED_PROBE);
        }
        this.pushDaemonConfig();
        this.pushAgentConfig(AGENT_CONFIG_FILE, null);
    }

    @NotNull
    static String getTransportExecutablePath() {
        return DEVICE_DIR + HostFiles.TRANSPORT.getFileName();
    }

    @NotNull
    public static String getDaemonConfigPath() {
        return "/data/local/tmp/perfd/daemon.config";
    }

    @NotNull
    public static String getAgentConfigFile() {
        return "/data/local/tmp/perfd/agent.config";
    }

    @VisibleForTesting
    void copyHostFileToDevice(@NotNull DeployableFile hostFile) throws AdbCommandRejectedException, IOException {
        this.copyFileToDevice(hostFile);
    }

    private static boolean isAtLeastO(IDevice device2) {
        return device2.getVersion().getFeatureLevel() >= 26;
    }

    private static boolean isBetweenMAndP(IDevice device2) {
        return device2.getVersion().getFeatureLevel() >= 23 && device2.getVersion().getFeatureLevel() <= 28;
    }

    private void pushDaemonConfig() throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        Transport.DaemonConfig.Builder configBuilder = Transport.DaemonConfig.newBuilder().setCommon(this.buildCommonConfig());
        for (TransportConfigContributor extension : (TransportConfigContributor[])TransportConfigContributor.EP_NAME.getExtensions()) {
            extension.customizeDaemonConfig(configBuilder);
        }
        File configFile = FileUtil.createTempFile((String)DAEMON_CONFIG_FILE, null, (boolean)true);
        FileOutputStream oStream = new FileOutputStream(configFile);
        configBuilder.build().writeTo((OutputStream)oStream);
        this.myDevice.executeShellCommand("rm -f /data/local/tmp/perfd/daemon.config", (IShellOutputReceiver)new NullOutputReceiver());
        this.myDevice.pushFile(configFile.getAbsolutePath(), "/data/local/tmp/perfd/daemon.config");
        this.myDevice.executeShellCommand("chown shell:shell /data/local/tmp/perfd/daemon.config", (IShellOutputReceiver)new NullOutputReceiver());
    }

    public void pushAgentConfig(@NotNull String configName, @Nullable AndroidRunConfigurationBase runConfig) throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        Agent.AgentConfig.Builder agentConfigBuilder = Agent.AgentConfig.newBuilder().setCommon(this.buildCommonConfig());
        for (TransportConfigContributor extension : (TransportConfigContributor[])TransportConfigContributor.EP_NAME.getExtensions()) {
            extension.customizeAgentConfig(agentConfigBuilder, runConfig);
        }
        File configFile = FileUtil.createTempFile((String)configName, null, (boolean)true);
        FileOutputStream oStream = new FileOutputStream(configFile);
        agentConfigBuilder.build().writeTo((OutputStream)oStream);
        this.myDevice.executeShellCommand("rm -f /data/local/tmp/perfd/" + configName, (IShellOutputReceiver)new NullOutputReceiver());
        this.myDevice.pushFile(configFile.getAbsolutePath(), DEVICE_DIR + configName);
        this.myDevice.executeShellCommand("chown shell:shell /data/local/tmp/perfd/" + configName, (IShellOutputReceiver)new NullOutputReceiver());
    }

    @NotNull
    private Common.CommonConfig.Builder buildCommonConfig() {
        Common.CommonConfig.SocketType socketType = TransportFileManager.isAtLeastO(this.myDevice) ? Common.CommonConfig.SocketType.ABSTRACT_SOCKET : Common.CommonConfig.SocketType.UNSPECIFIED_SOCKET;
        return Common.CommonConfig.newBuilder().setSocketType(socketType).setServiceAddress("127.0.0.1:12389").setServiceSocketName("AndroidStudioTransport");
    }

    @Override
    public List<String> copyFileToDevice(@NotNull DeployableFile hostFile) throws AdbCommandRejectedException, IOException {
        Path dirPath = hostFile.getDir().toPath();
        ArrayList<String> paths = new ArrayList<String>();
        if (!hostFile.isExecutable()) {
            Path path = dirPath.resolve(hostFile.getFileName());
            paths.add(this.pushFileToDevice(path, hostFile.getFileName(), hostFile.isExecutable()));
            return paths;
        }
        if (!hostFile.isAbiDependent()) {
            Abi abi = this.getBestAbi(hostFile);
            Path path = dirPath.resolve(abi + "/" + hostFile.getFileName());
            paths.add(this.pushFileToDevice(path, hostFile.getFileName(), true));
        } else {
            String format = hostFile.getOnDeviceAbiFileNameFormat();
            assert (format != null);
            for (Abi abi : this.getBestAbis(hostFile)) {
                Path path = dirPath.resolve(abi + "/" + hostFile.getFileName());
                paths.add(this.pushFileToDevice(path, String.format(format, abi.getCpuArch()), true));
            }
        }
        return paths;
    }

    private String pushFileToDevice(Path localPath, String fileName, boolean executable) throws AdbCommandRejectedException, IOException {
        String deviceFilePath = DEVICE_DIR + fileName;
        try {
            if (!Files.exists(localPath, new LinkOption[0])) {
                throw new TransportNonExistingFileException(String.format("File %s could not be found for device: %s", localPath, this.myDevice), localPath.toString());
            }
            String fileHash = "";
            Object hashFilePath = "";
            if (((Boolean)StudioFlags.TRANSPORT_CONSERVATIVE_COPY.get()).booleanValue()) {
                fileHash = TransportFileManager.generateHash(localPath.toFile());
                hashFilePath = deviceFilePath + "_hash";
                boolean hasSameHash = this.compareOnDeviceTextFile((String)hashFilePath, fileHash);
                boolean isFileOnDevice = this.isFileOnDevice(deviceFilePath);
                if (hasSameHash && isFileOnDevice) {
                    TransportFileManager.getLogger().info(String.format("Identical copy of %s is already on the device, no need to push it", deviceFilePath));
                    return deviceFilePath;
                }
            }
            TransportFileManager.getLogger().info(String.format("Pushing %s to %s...", fileName, DEVICE_DIR));
            this.myDevice.executeShellCommand("rm -f " + deviceFilePath + " " + deviceFilePath + "_hash", (IShellOutputReceiver)new NullOutputReceiver());
            String folder = deviceFilePath.substring(0, deviceFilePath.lastIndexOf(47));
            this.myDevice.executeShellCommand("mkdir -p -m 755 " + folder + "; chown shell:shell " + folder, (IShellOutputReceiver)new NullOutputReceiver());
            this.myDevice.pushFile(localPath.toString(), deviceFilePath);
            this.myDevice.executeShellCommand("chown shell:shell " + deviceFilePath, (IShellOutputReceiver)new NullOutputReceiver());
            if (((Boolean)StudioFlags.TRANSPORT_CONSERVATIVE_COPY.get()).booleanValue()) {
                this.myDevice.executeShellCommand("echo " + fileHash + " > " + (String)hashFilePath, (IShellOutputReceiver)new NullOutputReceiver());
            }
            if (executable) {
                String cmd = "chmod 755 " + deviceFilePath;
                this.myDevice.executeShellCommand(cmd, (IShellOutputReceiver)new NullOutputReceiver());
            } else if (fileName.endsWith(".jar")) {
                String cmd = "chmod 444 " + deviceFilePath;
                this.myDevice.executeShellCommand(cmd, (IShellOutputReceiver)new NullOutputReceiver());
            }
            TransportFileManager.getLogger().info(String.format("Successfully pushed %s to %s.", fileName, DEVICE_DIR));
        }
        catch (ShellCommandUnresponsiveException | SyncException | TimeoutException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return deviceFilePath;
    }

    private boolean isFileOnDevice(final String filePath) throws ShellCommandUnresponsiveException, AdbCommandRejectedException, IOException, TimeoutException {
        final boolean[] fileFound = new boolean[]{false};
        this.myDevice.executeShellCommand("ls " + filePath, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(@NotNull String[] lines) {
                for (String line : lines) {
                    if (!line.equals(filePath)) continue;
                    fileFound[0] = true;
                    break;
                }
            }

            public boolean isCancelled() {
                return false;
            }
        });
        return fileFound[0];
    }

    private boolean compareOnDeviceTextFile(String filePath, String expectedContent) throws IOException, NoSuchAlgorithmException, ShellCommandUnresponsiveException, AdbCommandRejectedException, TimeoutException {
        final StringBuilder fileContent = new StringBuilder();
        this.myDevice.executeShellCommand("cat " + filePath, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(@NotNull String[] lines) {
                for (String line : lines) {
                    fileContent.append(line);
                }
            }

            public boolean isCancelled() {
                return false;
            }
        });
        return fileContent.toString().trim().equals(expectedContent);
    }

    private static String generateHash(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] bytes = Files.readAllBytes(file.toPath());
        byte[] hashBytes = digest.digest(bytes);
        StringBuilder hashString = new StringBuilder();
        for (byte b : hashBytes) {
            hashString.append(String.format("%02x", b));
        }
        return hashString.toString();
    }

    public String configureStartupAgent(@NotNull String packageName, @NotNull String configName, @NotNull String executorId) {
        if (this.myDevice.getVersion().getFeatureLevel() < 27) {
            return "";
        }
        AbstractProfilerExecutorGroup.AbstractProfilerSetting setting = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executorId);
        if (setting != null && setting.getProfilingMode() == ProfilingMode.PROFILEABLE) {
            return "";
        }
        String packageDataPath = this.getPackageDataPath(packageName);
        if (packageDataPath.isEmpty()) {
            return "";
        }
        String agentName = String.format(HostFiles.JVMTI_AGENT.getOnDeviceAbiFileNameFormat(), this.getBestAbi(HostFiles.JVMTI_AGENT).getCpuArch());
        String[] requiredAgentFiles = new String[]{agentName, HostFiles.PERFA.getFileName()};
        try {
            for (String agentFile : requiredAgentFiles) {
                this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, String.format("rm -rf ./%s/%s", CODE_CACHE_DIR, agentFile)), (IShellOutputReceiver)new NullOutputReceiver());
                this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, String.format("cp %s ./%s/", DEVICE_DIR + agentFile, CODE_CACHE_DIR)), (IShellOutputReceiver)new NullOutputReceiver());
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException ignored) {
            return "";
        }
        return String.format("--attach-agent %s/%s/%s=%s", packageDataPath, CODE_CACHE_DIR, agentName, DEVICE_DIR + configName);
    }

    @NotNull
    private String getPackageDataPath(@NotNull String packageName) {
        final String[] result2 = new String[1];
        try {
            this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, "pwd"), (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    if (result2[0] == null) {
                        result2[0] = lines[0];
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException throwable) {
            // empty catch block
        }
        if (result2[0] == null || result2[0].startsWith("run-as: ")) {
            return "";
        }
        return result2[0];
    }

    @NotNull
    private String buildRunAsCommand(@NotNull String packageName, @NotNull String command) {
        return String.format("run-as %s sh -c '%s'", packageName, command);
    }

    @NotNull
    private Abi getBestAbi(@NotNull DeployableFile hostFile) {
        List<Abi> abis = this.getBestAbis(hostFile);
        if (abis.isEmpty()) {
            throw new RuntimeException("Could not find ABI file for: " + hostFile.getFileName());
        }
        return abis.get(0);
    }

    @NotNull
    private List<Abi> getBestAbis(@NotNull DeployableFile hostFile) {
        File dir = hostFile.getDir();
        List supportedAbis = this.myDevice.getAbis().stream().map(abi -> Abi.getEnum((String)abi)).filter(abi -> new File(dir, abi + "/" + hostFile.getFileName()).exists()).collect(Collectors.toList());
        ArrayList<Abi> bestAbis = new ArrayList<Abi>();
        HashSet<String> seenCpuArch = new HashSet<String>();
        for (Abi abi2 : supportedAbis) {
            if (seenCpuArch.contains(abi2.getCpuArch())) continue;
            seenCpuArch.add(abi2.getCpuArch());
            bestAbis.add(abi2);
        }
        return bestAbis;
    }

    @NotNull
    public static String getShortAbiName(@NotNull String longAbi) {
        Abi abi = Abi.getEnum((String)longAbi);
        if (abi == null) {
            return "invalid_abi";
        }
        return abi.getCpuArch();
    }

    private static class HostFiles {
        @NotNull
        static final DeployableFile TRANSPORT = new DeployableFile.Builder("transport").setReleaseDir(Constants.TRANSPORT_RELEASE_DIR).setDevDir(Constants.TRANSPORT_DEV_DIR).setExecutable(true).build();
        @NotNull
        static final DeployableFile PERFA = new DeployableFile.Builder("perfa.jar").build();
        @NotNull
        static final DeployableFile JVMTI_AGENT = new DeployableFile.Builder("libjvmtiagent.so").setReleaseDir(Constants.JVMTI_AGENT_RELEASE_DIR).setDevDir(Constants.JVMTI_AGENT_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("libjvmtiagent_%s.so").build();
        @NotNull
        static final DeployableFile SIMPLEPERF = new DeployableFile.Builder("simpleperf").setReleaseDir(Constants.SIMPLEPERF_RELEASE_DIR).setDevDir(Constants.SIMPLEPERF_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("simpleperf_%s").build();
        @NotNull
        static final DeployableFile PERFETTO = new DeployableFile.Builder("perfetto").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("perfetto_%s").build();
        @NotNull
        static final DeployableFile PERFETTO_SO = new DeployableFile.Builder("libperfetto.so").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("%s/libperfetto.so").build();
        @NotNull
        static final DeployableFile TRACED = new DeployableFile.Builder("traced").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("traced_%s").build();
        @NotNull
        static final DeployableFile TRACED_PROBE = new DeployableFile.Builder("traced_probes").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("traced_probes_%s").build();
        @NotNull
        static final DeployableFile TRACEBOX = new DeployableFile.Builder("tracebox").setReleaseDir(Constants.TRACEBOX_RELEASE_DIR).setDevDir(Constants.TRACEBOX_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("tracebox_%s").build();

        private HostFiles() {
        }
    }
}

