/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.stats.Distribution;
import com.android.tools.idea.stats.DistributionService;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributionChartComponent
extends JPanel {
    private static final Color TEXT_COLOR = new Color(0xFEFEFE);
    private static final Color API_LEVEL_COLOR = new Color(0, 0, 0, 77);
    private final int INTER_SECTION_SPACING = JBUIScale.scale((int)1);
    private final int HEADER_TO_BODY_SPACING = JBUIScale.scale((int)4);
    private static final String STR_ANDROID_PLATFORM = "ANDROID PLATFORM";
    private static final String STR_VERSION = "VERSION";
    private static final String STR_API_LEVEL = "API LEVEL";
    private static final String STR_CUMULATIVE = "CUMULATIVE";
    private static final String STR_DISTRIBUTION = "DISTRIBUTION";
    private static final String STR_LOADING = "Loading distribution data ...";
    private static final double MIN_PERCENTAGE_HEIGHT = 0.01;
    private static final double EXPANSION_ON_SELECTION = 1.06;
    private static final double RIGHT_GUTTER_PERCENTAGE = 0.21;
    private final int TOP_PADDING = JBUIScale.scale((int)40);
    private final int NAME_OFFSET = JBUIScale.scale((int)50);
    private final int MIN_API_FONT_SIZE = JBUIScale.scale((int)18);
    private final int MAX_API_FONT_SIZE = JBUIScale.scale((int)45);
    private final int API_OFFSET = JBUIScale.scale((int)120);
    private final int NUMBER_OFFSET = JBUIScale.scale((int)10);
    private static Font MEDIUM_WEIGHT_FONT;
    private static Font REGULAR_WEIGHT_FONT;
    private static Font VERSION_NAME_FONT;
    private static Font VERSION_NUMBER_FONT;
    private static Font TITLE_FONT;
    private static final Color[] RECT_COLORS;
    private int[] myCurrentBottoms;
    private Distribution mySelectedDistribution;
    private SelectionChangedListener myListener;
    private int mySelectedApiLevel = -1;

    public void init() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                List<Distribution> distributions = DistributionChartComponent.getDistributions();
                assert (distributions != null);
                if (DistributionChartComponent.this.myCurrentBottoms == null || DistributionChartComponent.this.myCurrentBottoms.length != distributions.size()) {
                    return;
                }
                int y = mouseEvent.getY();
                for (int i = 0; i < DistributionChartComponent.this.myCurrentBottoms.length; ++i) {
                    if (y > DistributionChartComponent.this.myCurrentBottoms[i]) continue;
                    DistributionChartComponent.this.selectDistribution(distributions.get(i));
                    break;
                }
            }
        });
        DistributionChartComponent.loadFonts();
    }

    @Nullable
    private static List<Distribution> getDistributions() {
        return DistributionService.getInstance().getDistributions();
    }

    public void selectDistributionApiLevel(int api) {
        this.mySelectedApiLevel = api;
        List<Distribution> distributions = DistributionChartComponent.getDistributions();
        if (distributions != null) {
            for (Distribution d : distributions) {
                if (d.getApiLevel() != api) continue;
                this.selectDistribution(d);
                break;
            }
        }
    }

    public void selectDistribution(@NotNull Distribution d) {
        this.mySelectedDistribution = d;
        this.mySelectedApiLevel = d.getApiLevel();
        if (this.myListener != null) {
            this.myListener.onDistributionSelected(this.mySelectedDistribution);
        }
        this.repaint();
    }

    private static void loadFonts() {
        if (MEDIUM_WEIGHT_FONT == null) {
            REGULAR_WEIGHT_FONT = new Font("DroidSans", 0, 12);
            MEDIUM_WEIGHT_FONT = new Font("DroidSans", 1, 12);
            VERSION_NAME_FONT = REGULAR_WEIGHT_FONT.deriveFont(JBUIScale.scale((float)14.0f));
            VERSION_NUMBER_FONT = REGULAR_WEIGHT_FONT.deriveFont(JBUIScale.scale((float)14.0f));
            TITLE_FONT = MEDIUM_WEIGHT_FONT.deriveFont(JBUIScale.scale((float)14.0f));
        }
    }

    public void registerDistributionSelectionChangedListener(@NotNull SelectionChangedListener listener2) {
        this.myListener = listener2;
    }

    @Override
    public Dimension getMinimumSize() {
        return JBUI.size((int)450, (int)450);
    }

    @Override
    public void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g, (boolean)true, (boolean)true);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        List<Distribution> distributions = DistributionChartComponent.getDistributions();
        if (distributions == null) {
            DistributionService service = DistributionService.getInstance();
            Runnable update2 = () -> {
                Distribution distribution;
                if (this.mySelectedApiLevel > -1 && this.mySelectedDistribution == null && (distribution = service.getDistributionForApiLevel(this.mySelectedApiLevel)) != null) {
                    UIUtil.invokeLaterIfNeeded(() -> this.selectDistribution(distribution));
                }
                this.repaint();
            };
            service.refresh(update2, update2);
            g.setFont(VERSION_NAME_FONT);
            g.drawString(STR_LOADING, this.NAME_OFFSET, this.TOP_PADDING);
            return;
        }
        if (this.myCurrentBottoms == null) {
            this.myCurrentBottoms = new int[distributions.size()];
        }
        int totalWidth = this.getBounds().width;
        int rightGutter = (int)Math.round((double)totalWidth * 0.21);
        int width = totalWidth - rightGutter;
        int normalBoxSize = (int)Math.round((double)width / 1.06);
        int leftGutter = (width - normalBoxSize) / 2;
        FontMetrics titleMetrics = g.getFontMetrics(TITLE_FONT);
        int titleHeight = titleMetrics.getHeight();
        FontMetrics versionNumberMetrics = g.getFontMetrics(VERSION_NUMBER_FONT);
        int halfVersionNumberHeight = (versionNumberMetrics.getHeight() - versionNumberMetrics.getDescent()) / 2;
        FontMetrics versionNameMetrics = g.getFontMetrics(VERSION_NAME_FONT);
        int halfVersionNameHeight = (versionNameMetrics.getHeight() - versionNameMetrics.getDescent()) / 2;
        g.setFont(TITLE_FONT);
        g.drawString(STR_ANDROID_PLATFORM, leftGutter + this.API_OFFSET - titleMetrics.stringWidth(STR_ANDROID_PLATFORM) / 2, titleHeight);
        g.drawString(STR_VERSION, leftGutter + this.API_OFFSET - titleMetrics.stringWidth(STR_VERSION) / 2, titleHeight * 2);
        g.drawString(STR_API_LEVEL, width - this.API_OFFSET, titleHeight);
        int lastColumnLeftOffset = totalWidth - Math.max(titleMetrics.stringWidth(STR_CUMULATIVE), titleMetrics.stringWidth(STR_DISTRIBUTION));
        g.drawString(STR_CUMULATIVE, (lastColumnLeftOffset + totalWidth - titleMetrics.stringWidth(STR_CUMULATIVE)) / 2, titleHeight);
        g.drawString(STR_DISTRIBUTION, (lastColumnLeftOffset + totalWidth - titleMetrics.stringWidth(STR_DISTRIBUTION)) / 2, titleHeight * 2);
        double percentageToDistribute = 0.0;
        for (Distribution d : distributions) {
            double percentageAboveMin = d.getDistributionPercentage() - 0.01;
            if (!(percentageAboveMin > 0.0)) continue;
            percentageToDistribute += percentageAboveMin;
        }
        int heightToDistribute = this.getBounds().height - this.INTER_SECTION_SPACING * (distributions.size() - 1) - this.TOP_PADDING;
        Font minApiLevelFont = REGULAR_WEIGHT_FONT.deriveFont(this.logistic(0.01));
        int minBoxHeight = Math.max((int)Math.round(0.01 * (double)heightToDistribute), g.getFontMetrics(minApiLevelFont).getHeight());
        heightToDistribute = Math.max(0, heightToDistribute - distributions.size() * minBoxHeight);
        double percentageSum = 0.0;
        int startY = 2 * titleHeight + this.HEADER_TO_BODY_SPACING;
        int recColorIdx = 0;
        for (Distribution d : distributions) {
            Font apiLevelFont;
            int calculatedHeight;
            if (d.getDistributionPercentage() <= 0.01) {
                calculatedHeight = minBoxHeight;
                apiLevelFont = minApiLevelFont;
            } else {
                double extraPercentage = d.getDistributionPercentage() - 0.01;
                calculatedHeight = minBoxHeight + (int)Math.round((double)heightToDistribute * extraPercentage / percentageToDistribute);
                apiLevelFont = REGULAR_WEIGHT_FONT.deriveFont(this.logistic(0.01 + extraPercentage / percentageToDistribute));
            }
            int bottom = startY + calculatedHeight;
            g.setColor(RECT_COLORS[recColorIdx % RECT_COLORS.length]);
            if (d.equals(this.mySelectedDistribution)) {
                g.fillRect(0, bottom - calculatedHeight, width, calculatedHeight);
            } else {
                g.fillRect(leftGutter, bottom - calculatedHeight, normalBoxSize, calculatedHeight);
            }
            FontMetrics apiLevelMetrics = g.getFontMetrics(apiLevelFont);
            int halfApiFontHeight = apiLevelMetrics.getAscent() * 43 / 100;
            int currentMidY = startY + calculatedHeight / 2;
            g.setColor(TEXT_COLOR);
            g.setFont(VERSION_NAME_FONT);
            this.myCurrentBottoms[recColorIdx] = bottom;
            g.drawString(d.getName(), leftGutter + this.NAME_OFFSET, currentMidY + halfVersionNameHeight);
            g.setColor(API_LEVEL_COLOR);
            g.setFont(VERSION_NUMBER_FONT);
            String versionString = d.getVersion().toShortString();
            g.drawString(versionString, leftGutter + this.NUMBER_OFFSET, currentMidY + halfVersionNumberHeight);
            g.setFont(apiLevelFont);
            g.drawString(Integer.toString(d.getApiLevel()), width - this.API_OFFSET, currentMidY + halfApiFontHeight);
            percentageSum += d.getDistributionPercentage();
            if (recColorIdx < distributions.size() - 1) {
                g.setColor(JBColor.foreground());
                g.setFont(VERSION_NUMBER_FONT);
                String percentageStr = percentageSum > 0.999 ? "< 0.1%" : new DecimalFormat("0.0%").format(1.0 - percentageSum);
                int percentStringWidth = versionNumberMetrics.stringWidth(percentageStr);
                g.drawString(percentageStr, totalWidth - percentStringWidth - 2, versionNameMetrics.getAscent() + bottom);
                g.setColor((Color)JBColor.darkGray);
                g.drawLine(leftGutter + normalBoxSize, startY + calculatedHeight, totalWidth, startY + calculatedHeight);
            }
            startY += calculatedHeight + this.INTER_SECTION_SPACING;
            ++recColorIdx;
        }
    }

    private float logistic(double normalizedValue) {
        double exp = Math.exp((double)this.MIN_API_FONT_SIZE * normalizedValue);
        return (float)((double)(this.MAX_API_FONT_SIZE * this.MIN_API_FONT_SIZE) * exp / ((double)this.MAX_API_FONT_SIZE + (double)this.MIN_API_FONT_SIZE * exp));
    }

    static {
        RECT_COLORS = new Color[]{new Color(13361099), new Color(8242833), new Color(9614007), new Color(14596672), new Color(15031647), new Color(7258322), new Color(14191971), new Color(0xFF9229), new Color(15383853)};
    }

    public static interface SelectionChangedListener {
        public void onDistributionSelected(@NotNull Distribution var1);
    }
}

