/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.designer.overlays;

import com.android.tools.idea.ui.designer.overlays.OverlayData;
import com.android.tools.idea.ui.designer.overlays.OverlayEntry;
import com.android.tools.idea.ui.designer.overlays.OverlayPersistentStateService;
import com.android.tools.idea.ui.designer.overlays.OverlayProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class OverlayConfiguration {
    public static final ExtensionPointName<OverlayProvider> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.ui.designer.overlays.overlayProvider");
    private static final OverlayData PLACEHOLDER_OVERLAY = new OverlayData(new OverlayEntry("", null), "", null);
    private float myOverlayAlpha = 0.5f;
    private final List<OverlayData> myOverlays = new ArrayList<OverlayData>();
    private BufferedImage myOverlayImage = null;
    private OverlayEntry myCurrentOverlayEntry;
    private boolean myOverlayVisible = false;

    public OverlayConfiguration() {
        this.loadOverlayList();
    }

    public boolean getOverlayVisibility() {
        return this.myOverlayVisible;
    }

    public List<OverlayData> getAllOverlays() {
        return ImmutableList.copyOf(this.myOverlays);
    }

    public BufferedImage getOverlayImage() {
        return this.myOverlayImage;
    }

    public OverlayEntry getCurrentOverlayEntry() {
        return this.myCurrentOverlayEntry;
    }

    public float getOverlayAlpha() {
        return this.myOverlayAlpha;
    }

    public void updateOverlay(OverlayData overlayData) {
        this.myOverlayImage = overlayData.getOverlayImage();
        this.myCurrentOverlayEntry = overlayData.getOverlayEntry();
        this.myOverlayVisible = true;
        if (!overlayData.equals(PLACEHOLDER_OVERLAY)) {
            int index = this.myOverlays.indexOf(overlayData);
            if (index != -1) {
                this.myOverlays.get(index).setOverlayName(overlayData.getOverlayName());
                OverlayPersistentStateService overlayPersistentStateService = OverlayPersistentStateService.getInstance();
                overlayPersistentStateService.updateOverlayName(this.myCurrentOverlayEntry, overlayData.getOverlayName());
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Internal error", "Overlay does not exist.", NotificationType.ERROR));
            }
        }
    }

    public void clearCurrentOverlay() {
        this.myCurrentOverlayEntry = null;
        this.myOverlayImage = null;
        this.myOverlayVisible = false;
    }

    public void addOverlay(OverlayData overlay) {
        if (!this.myOverlays.contains(overlay)) {
            this.myOverlays.add(overlay);
            OverlayPersistentStateService overlayPersistentStateService = OverlayPersistentStateService.getInstance();
            overlayPersistentStateService.addOverlayData(overlay.getOverlayEntry(), overlay.getOverlayName());
        }
        this.updateOverlay(overlay);
    }

    public boolean isPlaceholderVisible() {
        return Objects.equals(this.myCurrentOverlayEntry, PLACEHOLDER_OVERLAY.getOverlayEntry());
    }

    public void showPlaceholder() {
        this.updateOverlay(PLACEHOLDER_OVERLAY);
    }

    public void hidePlaceholder() {
        if (this.isPlaceholderVisible()) {
            this.clearCurrentOverlay();
        }
    }

    public void showCachedOverlay() {
        this.myOverlayVisible = true;
    }

    public void hideCachedOverlay() {
        this.myOverlayVisible = false;
    }

    public boolean isOverlayPresent() {
        return this.myOverlayImage != null || this.isPlaceholderVisible();
    }

    public void removeOverlays(List<OverlayData> overlays) {
        for (OverlayData overlay : overlays) {
            this.removeOverlayFromList(overlay.getOverlayEntry());
        }
    }

    public void removeOverlayFromList(OverlayEntry overlayEntry) {
        this.myOverlays.removeIf(overlayData -> overlayData.getOverlayEntry().equals(overlayEntry));
        if (Objects.equals(this.myCurrentOverlayEntry, overlayEntry)) {
            this.clearCurrentOverlay();
        }
        OverlayPersistentStateService overlayPersistentStateService = OverlayPersistentStateService.getInstance();
        overlayPersistentStateService.deleteOverlayData(overlayEntry);
    }

    public void loadOverlayList() {
        OverlayPersistentStateService overlayPersistentStateService = OverlayPersistentStateService.getInstance();
        List providers = EP_NAME.getExtensionsIfPointIsRegistered();
        if (!providers.isEmpty() && overlayPersistentStateService != null) {
            for (int i = 0; i < overlayPersistentStateService.getSize(); ++i) {
                String persistedProvider = overlayPersistentStateService.providers.get(i);
                OverlayProvider provider = (OverlayProvider)Iterables.find((Iterable)providers, p -> p.getClass().getSimpleName().equals(persistedProvider), null);
                if (provider == null) continue;
                OverlayEntry overlayEntry = new OverlayEntry(overlayPersistentStateService.overlayIds.get(i), provider);
                OverlayData data2 = new OverlayData(overlayEntry, overlayPersistentStateService.overlayNames.get(i), null);
                this.myOverlays.add(data2);
            }
        }
    }
}

