/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.designer.overlays;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.ui.designer.overlays.ChooseOverlayDialog;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayData;
import com.android.tools.idea.ui.designer.overlays.OverlayEntry;
import com.android.tools.idea.ui.designer.overlays.OverlayNotFoundException;
import com.android.tools.idea.ui.designer.overlays.OverlayProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Toggleable;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class OverlayMenuAction
extends DropDownAction {
    private final OverlayConfiguration myOverlayConfiguration;
    private final Runnable myRepaint;

    public OverlayMenuAction(@NotNull OverlayConfiguration overlayConfiguration, @NotNull Runnable repaint) {
        super("Overlays Menu", "Overlays Menu", StudioIcons.LayoutInspector.Toolbar.MODE_3D);
        this.myOverlayConfiguration = overlayConfiguration;
        this.myRepaint = repaint;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        List providers = OverlayConfiguration.EP_NAME.getExtensionsIfPointIsRegistered();
        this.removeAll();
        if (!providers.isEmpty()) {
            DefaultActionGroup overlayGroup = DefaultActionGroup.createPopupGroup(() -> "Overlays");
            OverlayEntry currentOverlay = this.myOverlayConfiguration.getCurrentOverlayEntry();
            for (OverlayData overlay : this.myOverlayConfiguration.getAllOverlays()) {
                boolean isCurrentlySelected = false;
                if (overlay.getOverlayEntry().equals(currentOverlay)) {
                    isCurrentlySelected = true;
                }
                overlayGroup.add((AnAction)new ToggleOverlayAction(this.myOverlayConfiguration, overlay.getOverlayName(), overlay.getOverlayEntry(), isCurrentlySelected));
            }
            this.add((AnAction)overlayGroup);
            for (OverlayProvider provider : providers) {
                this.add(new AddOverlayAction(this.myOverlayConfiguration, provider));
            }
            this.add(new DeleteOverlayAction(this.myOverlayConfiguration));
            this.addSeparator();
            this.add(new UpdateOverlayAction(this.myOverlayConfiguration));
            this.add(new ToggleCachedOverlayAction(this.myOverlayConfiguration, this.myRepaint));
            this.add(new CancelOverlayAction(this.myOverlayConfiguration, this.myRepaint));
        }
        return true;
    }

    @VisibleForTesting
    static class ToggleOverlayAction
    extends AnAction
    implements Toggleable {
        @NotNull
        private final OverlayEntry myOverlayEntry;
        @NotNull
        private final OverlayConfiguration myOverlayConfiguration;

        ToggleOverlayAction(@NotNull OverlayConfiguration overlayConfiguration, @NotNull String title2, @NotNull OverlayEntry overlayEntry, boolean checked) {
            super(title2, null, overlayEntry.getOverlayProvider().getPluginIcon());
            this.myOverlayEntry = overlayEntry;
            this.myOverlayConfiguration = overlayConfiguration;
            this.getTemplatePresentation().putClientProperty("selected", (Object)checked);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayEntry currentOverlay = this.myOverlayConfiguration.getCurrentOverlayEntry();
            if (this.myOverlayEntry.equals(currentOverlay)) {
                this.myOverlayConfiguration.clearCurrentOverlay();
            } else {
                this.myOverlayConfiguration.showPlaceholder();
                Promise<OverlayData> promise = this.myOverlayEntry.getOverlayProvider().getOverlay(this.myOverlayEntry.getId());
                promise.onSuccess(result2 -> {
                    if (this.myOverlayConfiguration.isPlaceholderVisible()) {
                        result2.setOverlayProvider(this.myOverlayEntry.getOverlayProvider());
                        this.myOverlayConfiguration.updateOverlay((OverlayData)result2);
                    }
                });
                promise.onError(t -> {
                    if (this.myOverlayConfiguration.isPlaceholderVisible()) {
                        this.myOverlayConfiguration.hidePlaceholder();
                        if (t instanceof OverlayNotFoundException) {
                            this.myOverlayConfiguration.removeOverlayFromList(this.myOverlayEntry);
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "The overlay you requested does not exist anymore.", NotificationType.ERROR));
                        } else {
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "There was an error fetching the overlay. Please try again.", NotificationType.ERROR));
                        }
                    }
                });
            }
        }
    }

    public static class AddOverlayAction
    extends AnAction {
        @NotNull
        private final OverlayProvider myOverlayProvider;
        @NotNull
        private final OverlayConfiguration myOverlayConfiguration;

        AddOverlayAction(@NotNull OverlayConfiguration overlayConfiguration, @NotNull OverlayProvider provider) {
            super("Add " + provider.getPluginName() + " Overlay...", null, StudioIcons.LayoutInspector.Toolbar.LOAD_OVERLAY);
            this.myOverlayProvider = provider;
            this.myOverlayConfiguration = overlayConfiguration;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myOverlayConfiguration.showPlaceholder();
            Promise<OverlayData> promise = this.myOverlayProvider.addOverlay();
            promise.onSuccess(result2 -> {
                if (this.myOverlayConfiguration.isPlaceholderVisible()) {
                    result2.setOverlayProvider(this.myOverlayProvider);
                    this.myOverlayConfiguration.addOverlay((OverlayData)result2);
                }
            });
            promise.onError(t -> {
                if (this.myOverlayConfiguration.isPlaceholderVisible()) {
                    this.myOverlayConfiguration.hidePlaceholder();
                    Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "There was an error fetching the overlay. Please try again.", NotificationType.ERROR));
                }
            });
        }
    }

    @VisibleForTesting
    static class DeleteOverlayAction
    extends AnAction {
        @NotNull
        private final OverlayConfiguration myOverlayConfiguration;

        DeleteOverlayAction(@NotNull OverlayConfiguration overlayConfiguration) {
            super("Delete Overlay...", null, StudioIcons.Common.DELETE);
            this.myOverlayConfiguration = overlayConfiguration;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(!this.myOverlayConfiguration.getAllOverlays().isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<OverlayData> overlays = this.myOverlayConfiguration.getAllOverlays();
            ChooseOverlayDialog chooser = new ChooseOverlayDialog(overlays, "Choose overlay", "Choose the overlay you want to delete");
            chooser.show();
            List chosen = chooser.getChosenElements();
            this.myOverlayConfiguration.removeOverlays(chosen);
        }
    }

    public static class UpdateOverlayAction
    extends AnAction {
        @NotNull
        private final OverlayConfiguration myOverlayConfiguration;

        public UpdateOverlayAction(@NotNull OverlayConfiguration overlayConfiguration) {
            super("Reload Overlay", "Reload the current overlay", StudioIcons.LayoutEditor.Motion.LOOP);
            this.myOverlayConfiguration = overlayConfiguration;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(this.myOverlayConfiguration.isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayEntry currentOverlay = this.myOverlayConfiguration.getCurrentOverlayEntry();
            if (this.myOverlayConfiguration.getOverlayImage() != null && !this.myOverlayConfiguration.isPlaceholderVisible()) {
                this.myOverlayConfiguration.showPlaceholder();
                Promise<OverlayData> promise = currentOverlay.getOverlayProvider().getOverlay(currentOverlay.getId());
                promise.onSuccess(result2 -> {
                    if (this.myOverlayConfiguration.isPlaceholderVisible()) {
                        result2.setOverlayProvider(currentOverlay.getOverlayProvider());
                        this.myOverlayConfiguration.updateOverlay((OverlayData)result2);
                    }
                });
                promise.onError(t -> {
                    if (this.myOverlayConfiguration.isPlaceholderVisible()) {
                        this.myOverlayConfiguration.hidePlaceholder();
                        if (t instanceof OverlayNotFoundException) {
                            this.myOverlayConfiguration.removeOverlayFromList(currentOverlay);
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "The overlay you requested does not exist anymore.", NotificationType.ERROR));
                        } else {
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "There was an error fetching the overlay. Please try again.", NotificationType.ERROR));
                        }
                    }
                });
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Update error", "There is no overlay to be updated. Please select an overlay before trying to update it.", NotificationType.WARNING));
            }
        }
    }

    public static class ToggleCachedOverlayAction
    extends AnAction {
        OverlayConfiguration myOverlayConfiguration;
        Runnable myRepaint;

        public ToggleCachedOverlayAction(@NotNull OverlayConfiguration overlayConfiguration, @NotNull Runnable repaint) {
            super("Toggle Overlay", "Toggle current overlay on/off", StudioIcons.LayoutEditor.Toolbar.LAYER);
            this.myOverlayConfiguration = overlayConfiguration;
            this.myRepaint = repaint;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(this.myOverlayConfiguration.isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (this.myOverlayConfiguration.getOverlayImage() != null && !this.myOverlayConfiguration.isPlaceholderVisible()) {
                if (!this.myOverlayConfiguration.getOverlayVisibility()) {
                    this.myOverlayConfiguration.showCachedOverlay();
                } else {
                    this.myOverlayConfiguration.hideCachedOverlay();
                }
                this.myRepaint.run();
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error toggling overlay", "There was no overlay to be toggled. Please select an overlay first.", NotificationType.WARNING));
            }
        }
    }

    public static class CancelOverlayAction
    extends AnAction {
        private final OverlayConfiguration myOverlayConfiguration;
        private final Runnable myRepaint;

        public CancelOverlayAction(@NotNull OverlayConfiguration overlayConfiguration, @NotNull Runnable repaint) {
            super("Cancel Overlay", "Disable current overlay", StudioIcons.LayoutInspector.Toolbar.CLEAR_OVERLAY);
            this.myOverlayConfiguration = overlayConfiguration;
            this.myRepaint = repaint;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(this.myOverlayConfiguration.isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (this.myOverlayConfiguration.isOverlayPresent()) {
                this.myOverlayConfiguration.clearCurrentOverlay();
                this.myRepaint.run();
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error cancelling overlay action", "There is no overlay action to be cancelled.", NotificationType.WARNING));
            }
        }
    }
}

