/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.importer.QualifierMatcherKt;
import com.android.tools.idea.ui.resourcemanager.model.Mapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0016\u0012\u001e\u0010\b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\t\"\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher;", "", "mappers", "", "Lcom/android/tools/idea/ui/resourcemanager/model/Mapper;", "Lcom/android/ide/common/resources/configuration/ResourceQualifier;", "<init>", "(Ljava/util/Set;)V", "mapper", "", "([Lcom/android/tools/idea/ui/resourcemanager/model/Mapper;)V", "parsePath", "Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher$Result;", "path", "", "baseFolderConfigMatch", "Result", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nQualifierMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QualifierMatcher.kt\ncom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1863#2,2:149\n1611#2,9:151\n1863#2:160\n1864#2:162\n1620#2:163\n774#2:164\n865#2,2:165\n774#2:167\n865#2,2:168\n1#3:161\n*S KotlinDebug\n*F\n+ 1 QualifierMatcher.kt\ncom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher\n*L\n79#1:149,2\n99#1:151,9\n99#1:160\n99#1:162\n99#1:163\n117#1:164\n117#1:165,2\n127#1:167\n127#1:168,2\n99#1:161\n*E\n"})
public final class QualifierMatcher {
    @NotNull
    private final Set<Mapper<ResourceQualifier>> mappers;

    public QualifierMatcher(@NotNull Set<? extends Mapper<? extends ResourceQualifier>> mappers) {
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        this.mappers = mappers;
    }

    public /* synthetic */ QualifierMatcher(Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set2 = SetsKt.emptySet();
        }
        this(set2);
    }

    public QualifierMatcher(Mapper<? extends ResourceQualifier> ... mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this(SetsKt.setOf((Object[])Arrays.copyOf(mapper, mapper.length)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result parsePath(@NotNull String path) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.mappers.isEmpty()) {
            return this.baseFolderConfigMatch(path);
        }
        Set qualifiers = new LinkedHashSet();
        Set unusedMappers = CollectionsKt.toMutableSet((Iterable)this.mappers);
        StringBuffer finalFileName = new StringBuffer();
        Matcher matcher = ((Mapper)CollectionsKt.first((Iterable)this.mappers)).getPattern().matcher(path);
        Iterable iterable = this.mappers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mapper it = (Mapper)element$iv;
            boolean bl = false;
            matcher.usePattern(it.getPattern());
            if (!matcher.find()) continue;
            MatchResult matchResult = matcher.toMatchResult();
            Intrinsics.checkNotNullExpressionValue((Object)matchResult, (String)"toMatchResult(...)");
            Object qualifier = it.getQualifier(it.getValue(matchResult));
            if (qualifier != null) {
                qualifiers.add(qualifier);
                unusedMappers.remove(it);
            }
            matcher.appendReplacement(finalFileName, "");
        }
        $this$forEach$iv = unusedMappers;
        boolean $i$f$mapNotNull = false;
        Iterator iterator2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            Mapper it = (Mapper)element$iv$iv;
            boolean bl2 = false;
            if (it.getDefaultQualifier() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)qualifiers);
        matcher.appendTail(finalFileName);
        if (!((Collection)qualifiers).isEmpty()) {
            ResourceManagerTracking.INSTANCE.logDensityInferred();
        }
        String string = finalFileName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Result result2 = this.baseFolderConfigMatch(string);
        qualifiers.addAll((Collection)result2.getQualifiers());
        return new Result(result2.getResourceName(), qualifiers);
    }

    /*
     * WARNING - void declaration
     */
    private final Result baseFolderConfigMatch(String path) {
        void $this$filterTo$iv$iv;
        String resourceName;
        void $this$filterTo$iv$iv2;
        String string = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String fileName = string;
        String[] stringArray = new String[]{"-"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)fileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        String[] destination$iv$iv = (String[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nameSplit = (List)destination$iv$iv;
        if (nameSplit.size() > 1) {
            String string2 = FileUtil.sanitizeFileName((String)((String)nameSplit.get(0)));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sanitizeFileName(...)");
            resourceName = string2;
            Set qualifiers = QualifierMatcherKt.access$getQualifiersFromFolder(CollectionsKt.drop((Iterable)nameSplit, (int)1));
            if (qualifiers != null) {
                return new Result(resourceName, qualifiers);
            }
        }
        String string3 = FileUtil.sanitizeFileName((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sanitizeFileName(...)");
        resourceName = string3;
        String string4 = PathUtil.getFileName((String)PathUtil.getParentPath((String)path));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFileName(...)");
        String parent = string4;
        destination$iv$iv = new String[]{"-"};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)parent, (String[])destination$iv$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter2 = false;
        Iterable iterable2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)it);
            if (!bl3) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List parentSplit = (List)destination$iv$iv2;
        Set set2 = QualifierMatcherKt.access$getQualifiersFromFolder(parentSplit);
        if (set2 == null && (set2 = QualifierMatcherKt.access$getQualifiersFromFolder(CollectionsKt.drop((Iterable)parentSplit, (int)1))) == null) {
            set2 = SetsKt.emptySet();
        }
        Set qualifiers = set2;
        return new Result(resourceName, qualifiers);
    }

    public QualifierMatcher() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher$Result;", "", "resourceName", "", "qualifiers", "", "Lcom/android/ide/common/resources/configuration/ResourceQualifier;", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getResourceName", "()Ljava/lang/String;", "getQualifiers", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    public static final class Result {
        @NotNull
        private final String resourceName;
        @NotNull
        private final Set<ResourceQualifier> qualifiers;

        public Result(@NotNull String resourceName, @NotNull Set<? extends ResourceQualifier> qualifiers) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            this.resourceName = resourceName;
            this.qualifiers = qualifiers;
        }

        @NotNull
        public final String getResourceName() {
            return this.resourceName;
        }

        @NotNull
        public final Set<ResourceQualifier> getQualifiers() {
            return this.qualifiers;
        }

        @NotNull
        public final String component1() {
            return this.resourceName;
        }

        @NotNull
        public final Set<ResourceQualifier> component2() {
            return this.qualifiers;
        }

        @NotNull
        public final Result copy(@NotNull String resourceName, @NotNull Set<? extends ResourceQualifier> qualifiers) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            return new Result(resourceName, qualifiers);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                string = result2.resourceName;
            }
            if ((n & 2) != 0) {
                set2 = result2.qualifiers;
            }
            return result2.copy(string, set2);
        }

        @NotNull
        public String toString() {
            return "Result(resourceName=" + this.resourceName + ", qualifiers=" + this.qualifiers + ")";
        }

        public int hashCode() {
            int result2 = this.resourceName.hashCode();
            result2 = result2 * 31 + ((Object)this.qualifiers).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.resourceName, (Object)result2.resourceName)) {
                return false;
            }
            return Intrinsics.areEqual(this.qualifiers, result2.qualifiers);
        }
    }
}

