/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J6\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/RasterAssetRenderer;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "<init>", "()V", "isFileSupported", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getImage", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/image/BufferedImage;", "module", "Lcom/intellij/openapi/module/Module;", "dimension", "Ljava/awt/Dimension;", "context", "", "intellij.android.core"})
public final class RasterAssetRenderer
implements DesignAssetRenderer {
    @Override
    public boolean isFileSupported(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String[] stringArray = ImageIO.getReaderFormatNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getReaderFormatNames(...)");
        return ArraysKt.contains((Object[])stringArray, (Object)file.getExtension());
    }

    @Override
    @NotNull
    public CompletableFuture<? extends BufferedImage> getImage(@NotNull VirtualFile file, @Nullable Module module, @NotNull Dimension dimension2, @Nullable Object context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dimension2, (String)"dimension");
        CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> RasterAssetRenderer.getImage$lambda$0(file, dimension2));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final BufferedImage getImage$lambda$0(VirtualFile $file, Dimension $dimension) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageUtils.readImageAtScale((InputStream)$file.getInputStream(), (Dimension)$dimension);
        }
        catch (NullPointerException e) {
            bufferedImage = null;
        }
        return bufferedImage;
    }
}

