/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetData;
import com.android.tools.idea.ui.resourcemanager.rendering.DefaultAssetDataProvider;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/ColorAssetDataProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/DefaultAssetDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/resources/ResourceResolver;)V", "getAssetSetData", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetData;", "assetSet", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "intellij.android.core"})
public final class ColorAssetDataProvider
extends DefaultAssetDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final ResourceResolver resourceResolver;

    public ColorAssetDataProvider(@NotNull Project project, @NotNull ResourceResolver resourceResolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
        this.project = project;
        this.resourceResolver = resourceResolver;
    }

    @Override
    @NotNull
    public AssetData getAssetSetData(@NotNull ResourceAssetSet assetSet) {
        Intrinsics.checkNotNullParameter((Object)assetSet, (String)"assetSet");
        AssetData defaultData = super.getAssetSetData(assetSet);
        Asset asset = assetSet.getHighestDensityAsset();
        Set colors = CollectionsKt.toSet((Iterable)IdeResourcesUtil.resolveMultipleColors((RenderResources)this.resourceResolver, DesignAssetKt.resolveValue(this.resourceResolver, asset), this.project));
        String subtitle = colors.size() == 1 ? ResourcesUtil.colorToString((Color)((Color)CollectionsKt.first((Iterable)colors))) : "Multiple colors";
        return new AssetData(defaultData.getTitle(), subtitle, defaultData.getMetadata());
    }
}

