/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.ui;

import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetPreviewManager;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.ResourceFileGenerator;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.AssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ColorAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.DrawableAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StudioResourcesModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.ChildView;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchImporterPresenterKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010(\u001a\u00020)H&J\u001c\u0010*\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\f\u0012\n +*\u0004\u0018\u00010\u001f0\u001f0\u001dH\u0004J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0-J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0-J<\u0010/\u001a6\u0012$\u0012\"\u0012\u000e\u0012\f0$\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\b1\u0012\u000e\u0012\f0%\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\b10#\u0012\f\u0012\n +*\u0004\u0018\u00010&0&0\u001dH\u0004J\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#0-J\u0018\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#0-J\u0010\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R*\u0010\"\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#\u0012\u0004\u0012\u00020&0\u001dX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010!\u00a8\u00067"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ResourcesPresenter;", "", "project", "Lcom/intellij/openapi/project/Project;", "assetPreviewManager", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;)V", "getAssetPreviewManager", "()Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;", "view", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ChildView;", "getView", "()Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ChildView;", "setView", "(Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ChildView;)V", "importAll", "", "getImportAll", "()Z", "setImportAll", "(Z)V", "drawableFileGenerator", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/builders/ResourceFileGenerator;", "resources", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/StudioResourcesModel;", "getResources", "()Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/StudioResourcesModel;", "filesToDrawableAssets", "", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/DrawableAssetModel;", "getFilesToDrawableAssets", "()Ljava/util/Map;", "colorsToColorAssets", "Lkotlin/Pair;", "Ljava/awt/Color;", "", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/ColorAssetModel;", "getColorsToColorAssets", "populateView", "", "generateDrawableFiles", "kotlin.jvm.PlatformType", "getDisplayableDrawables", "", "getSelectedDrawables", "generateColorPairs", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getDisplayableColors", "getSelectedColors", "getAsset", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/AssetModel;", "file", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSketchImporterPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SketchImporterPresenter.kt\ncom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ResourcesPresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1187#2,2:241\n1261#2,4:243\n774#2:247\n865#2,2:248\n1187#2,2:250\n1261#2,4:252\n774#2:256\n865#2,2:257\n*S KotlinDebug\n*F\n+ 1 SketchImporterPresenter.kt\ncom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ResourcesPresenter\n*L\n173#1:241,2\n173#1:243,4\n182#1:247\n182#1:248,2\n192#1:250,2\n192#1:252,4\n201#1:256\n201#1:257,2\n*E\n"})
public abstract class ResourcesPresenter {
    @NotNull
    private final AssetPreviewManager assetPreviewManager;
    public ChildView view;
    private boolean importAll;
    @NotNull
    private final ResourceFileGenerator drawableFileGenerator;

    public ResourcesPresenter(@NotNull Project project, @NotNull AssetPreviewManager assetPreviewManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)assetPreviewManager, (String)"assetPreviewManager");
        this.assetPreviewManager = assetPreviewManager;
        this.importAll = true;
        this.drawableFileGenerator = new ResourceFileGenerator(project);
    }

    @NotNull
    public final AssetPreviewManager getAssetPreviewManager() {
        return this.assetPreviewManager;
    }

    @NotNull
    public final ChildView getView() {
        ChildView childView = this.view;
        if (childView != null) {
            return childView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    public final void setView(@NotNull ChildView childView) {
        Intrinsics.checkNotNullParameter((Object)childView, (String)"<set-?>");
        this.view = childView;
    }

    public final boolean getImportAll() {
        return this.importAll;
    }

    public final void setImportAll(boolean bl) {
        this.importAll = bl;
    }

    @NotNull
    public abstract StudioResourcesModel getResources();

    @NotNull
    protected abstract Map<ResourceAssetSet, DrawableAssetModel> getFilesToDrawableAssets();

    @NotNull
    protected abstract Map<Pair<Color, String>, ColorAssetModel> getColorsToColorAssets();

    public abstract void populateView();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<ResourceAssetSet, DrawableAssetModel> generateDrawableFiles() {
        Map map2;
        ImmutableList<DrawableAssetModel> immutableList = this.getResources().getDrawableAssets();
        if (immutableList != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = (Iterable)immutableList;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                DrawableAssetModel it = (DrawableAssetModel)element$iv$iv;
                boolean bl = false;
                LightVirtualFile lightVirtualFile = this.drawableFileGenerator.generateDrawableFile(it);
                Intrinsics.checkNotNullExpressionValue((Object)lightVirtualFile, (String)"generateDrawableFile(...)");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Pair pair = TuplesKt.to((Object)SketchImporterPresenterKt.access$toAsset(lightVirtualFile, string), (Object)it);
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceAssetSet> getDisplayableDrawables() {
        List list;
        Set<ResourceAssetSet> files2 = this.getFilesToDrawableAssets().keySet();
        if (this.importAll) {
            list = CollectionsKt.toList((Iterable)files2);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = files2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ResourceAssetSet it = (ResourceAssetSet)element$iv$iv;
                boolean bl = false;
                DrawableAssetModel drawableAssetModel = this.getFilesToDrawableAssets().get(it);
                if (!(drawableAssetModel != null ? drawableAssetModel.isExportable() : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final List<ResourceAssetSet> getSelectedDrawables() {
        return this.getView().getSelectedDrawables();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<Pair<Color, String>, ColorAssetModel> generateColorPairs() {
        Map map2;
        ImmutableList<ColorAssetModel> immutableList = this.getResources().getColorAssets();
        if (immutableList != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = (Iterable)immutableList;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                ColorAssetModel it = (ColorAssetModel)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)TuplesKt.to((Object)it.getColor(), (Object)it.getName()), (Object)it);
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Color, String>> getDisplayableColors() {
        List list;
        Set<Pair<Color, String>> colors = this.getColorsToColorAssets().keySet();
        if (this.importAll) {
            list = CollectionsKt.toList((Iterable)colors);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = colors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                ColorAssetModel colorAssetModel = this.getColorsToColorAssets().get(it);
                if (!(colorAssetModel != null ? colorAssetModel.isExportable() : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final List<Pair<Color, String>> getSelectedColors() {
        return this.getView().getSelectedColors();
    }

    @Nullable
    public final AssetModel getAsset(@NotNull ResourceAssetSet file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getFilesToDrawableAssets().get(file);
    }
}

