/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.components.DslLabel;
import com.intellij.ui.dsl.builder.components.DslLabelType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0014J\n\u0010\"\u001a\u0004\u0018\u00010!H\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\b\u0010%\u001a\u00020\u001eH\u0002J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u000fH\u0002J\b\u0010(\u001a\u00020\u001eH\u0002J\b\u0010)\u001a\u00020\u000fH\u0002J\b\u0010*\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "dialogTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "maxRecordingDurationMillis", "", "onStop", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;ILjava/lang/Runnable;)V", "alarm", "Lcom/intellij/util/Alarm;", "recordingStartTime", "", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "value", "recordingTimeMillis", "setRecordingTimeMillis", "(J)V", "recordingLabelText", "setRecordingLabelText", "(Ljava/lang/String;)V", "recordingLabel", "Ljavax/swing/text/JTextComponent;", "stopButton", "Ljavax/swing/JButton;", "init", "", "show", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "createContentPaneBorder", "Ljavax/swing/border/Border;", "stopRecordingTimer", "recordingTimeText", "timeMillis", "updateRecordingTime", "millisUntilNextSecondTick", "createPanel", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nScreenRecorderDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenRecorderDialog.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorderDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class ScreenRecorderDialog
extends DialogWrapper {
    @NotNull
    private final String dialogTitle;
    private final int maxRecordingDurationMillis;
    @NotNull
    private final Runnable onStop;
    @NotNull
    private final Alarm alarm;
    private long recordingStartTime;
    @NotNull
    private final DialogPanel panel;
    private long recordingTimeMillis;
    @NotNull
    private String recordingLabelText;
    private JTextComponent recordingLabel;
    private JButton stopButton;

    public ScreenRecorderDialog(@NotNull String dialogTitle, @NotNull Project project, int maxRecordingDurationMillis, @NotNull Runnable onStop) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)onStop, (String)"onStop");
        super(project, false, DialogWrapper.IdeModalityType.MODELESS);
        this.dialogTitle = dialogTitle;
        this.maxRecordingDurationMillis = maxRecordingDurationMillis;
        this.onStop = onStop;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.alarm = new Alarm(disposable);
        this.panel = this.createPanel();
        this.recordingLabelText = this.recordingTimeText(this.recordingTimeMillis);
        this.init();
    }

    private final void setRecordingTimeMillis(long value2) {
        this.recordingTimeMillis = value2;
        this.setRecordingLabelText(this.recordingTimeText(value2));
    }

    private final void setRecordingLabelText(String value2) {
        this.recordingLabelText = value2;
        JTextComponent jTextComponent = this.recordingLabel;
        if (jTextComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingLabel");
            jTextComponent = null;
        }
        jTextComponent.setText(value2);
    }

    protected void init() {
        super.init();
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.getRootPane().setBorder((Border)JBUI.Borders.empty());
        this.panel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        WindowRoundedCornersManager.configure((DialogWrapper)this);
        this.pack();
    }

    public void show() {
        super.show();
        this.recordingStartTime = System.currentTimeMillis();
        this.alarm.addRequest(this::stopRecordingTimer, this.maxRecordingDurationMillis, ModalityState.any());
        this.alarm.addRequest(this::updateRecordingTime, 1000, ModalityState.any());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.panel;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    private final void stopRecordingTimer() {
        this.alarm.cancelAllRequests();
        this.onStop.run();
        this.setRecordingLabelText(AndroidAdbUiBundle.message("screenrecord.action.stopping", new Object[0]));
        JButton jButton = this.stopButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stopButton");
            jButton = null;
        }
        jButton.setEnabled(false);
    }

    private final String recordingTimeText(long timeMillis) {
        int seconds = (int)(timeMillis / (long)1000);
        Object[] objectArray = new Object[1];
        Locale locale = Locale.getDefault();
        String string = "%02d:%02d";
        Object[] objectArray2 = new Object[]{seconds / 60, seconds % 60};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        return AndroidAdbUiBundle.message("screenrecord.dialog.progress", objectArray);
    }

    private final void updateRecordingTime() {
        this.setRecordingTimeMillis(System.currentTimeMillis() - this.recordingStartTime);
        this.alarm.addRequest(this::updateRecordingTime, this.millisUntilNextSecondTick(), ModalityState.any());
    }

    private final long millisUntilNextSecondTick() {
        return (long)1000 - this.recordingTimeMillis % (long)1000;
    }

    /*
     * WARNING - void declaration
     */
    private final DialogPanel createPanel() {
        void $this$createPanel_u24lambda_u240;
        DslLabel dslLabel;
        DialogPanel dialogPanel = ComponentsKt.DialogPanel$default((String)this.dialogTitle, null, (int)2, null);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setText(this.dialogTitle);
        titlePanel.setActive(true);
        WindowMoveListener moveListener2 = new WindowMoveListener(titlePanel){

            protected Component getView(Component component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                Container container = SwingUtilities.getAncestorOfClass(DialogWrapperDialog.class, component);
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getAncestorOfClass(...)");
                return container;
            }
        };
        moveListener2.installTo((Component)titlePanel);
        dialogPanel.add((Component)titlePanel, (Object)"North");
        BorderLayoutPanel centerPanel = new BorderLayoutPanel();
        centerPanel.setBorder((Border)JBUI.Borders.empty((int)15, (int)10));
        DslLabel dslLabel2 = dslLabel = new DslLabel(DslLabelType.LABEL);
        ScreenRecorderDialog screenRecorderDialog = this;
        boolean bl = false;
        $this$createPanel_u24lambda_u240.setText(this.recordingTimeText(this.recordingTimeMillis));
        screenRecorderDialog.recordingLabel = (JTextComponent)dslLabel;
        JTextComponent jTextComponent = this.recordingLabel;
        if (jTextComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingLabel");
            jTextComponent = null;
        }
        centerPanel.addToLeft((Component)jTextComponent);
        centerPanel.addToCenter(Box.createRigidArea(new Dimension(JBUIScale.scale((int)20), 0)));
        this.stopButton = new JButton(AndroidAdbUiBundle.message("screenrecord.dialog.stop.recording", new Object[0]));
        JButton jButton = this.stopButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stopButton");
            jButton = null;
        }
        jButton.addActionListener(arg_0 -> ScreenRecorderDialog.createPanel$lambda$1(this, arg_0));
        JButton jButton2 = this.stopButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stopButton");
            jButton2 = null;
        }
        centerPanel.addToRight((Component)jButton2);
        dialogPanel.add((Component)centerPanel, (Object)"Center");
        return dialogPanel;
    }

    private static final void createPanel$lambda$1(ScreenRecorderDialog this$0, ActionEvent it) {
        this$0.stopRecordingTimer();
    }
}

