/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.SdkConstants;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.save.PostSaveAction;
import com.android.tools.idea.ui.save.SaveConfiguration;
import com.android.tools.idea.ui.save.SaveConfigurationResolver;
import com.android.tools.idea.ui.screenshot.DeviceScreenshotSettings;
import com.android.tools.idea.ui.screenshot.DeviceScreenshotSettingsPage;
import com.android.tools.idea.ui.screenshot.DialogLocationArbiter;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotDecorationOption;
import com.android.tools.idea.ui.screenshot.ScreenshotDecorator;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotProvider;
import com.android.tools.pixelprobe.color.Colors;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceScreenshotEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.images.editor.ImageFileEditor;
import org.jetbrains.android.util.DisposableUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0012\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0003Z[\\Ba\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010;\u001a\u00020<H\u0014J\b\u0010=\u001a\u00020>H\u0014J\b\u0010?\u001a\u00020'H\u0014J\b\u0010@\u001a\u00020>H\u0014J\b\u0010A\u001a\u00020>H\u0014J\u0010\u0010B\u001a\u00020:2\u0006\u0010C\u001a\u00020:H\u0002J\b\u0010D\u001a\u00020<H\u0016J\r\u0010E\u001a\u00070'\u00a2\u0006\u0002\bFH\u0014J\n\u0010G\u001a\u0004\u0018\u00010HH\u0016J\b\u0010I\u001a\u00020>H\u0016J\u0017\u0010J\u001a\u0004\u0018\u00010K2\u000b\u0010L\u001a\u00070'\u00a2\u0006\u0002\bFH\u0016J\b\u0010M\u001a\u00020>H\u0014J\b\u0010N\u001a\u00020\u001bH\u0002J\b\u0010O\u001a\u00020>H\u0002J\u0010\u0010P\u001a\u00020>2\u0006\u0010Q\u001a\u00020\u0013H\u0002J\u0010\u0010R\u001a\u00020>2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010S\u001a\u00020>H\u0002J\b\u0010T\u001a\u00020>H\u0002J\u0012\u0010U\u001a\u00020>2\b\b\u0002\u00104\u001a\u00020\u0013H\u0002J\u0010\u0010V\u001a\u00020\b2\u0006\u0010W\u001a\u00020\u0006H\u0002J\b\u0010X\u001a\u00020>H\u0002J\b\u0010Y\u001a\u00020>H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020302X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u000606X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020806X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "processedImage", "Ljava/awt/image/BufferedImage;", "backingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "screenshotProvider", "Lcom/android/tools/idea/ui/screenshot/ScreenshotProvider;", "screenshotDecorator", "Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorator;", "framingOptions", "", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "defaultFramingOption", "", "allowImageRotation", "", "dialogLocationArbiter", "Lcom/android/tools/idea/ui/screenshot/DialogLocationArbiter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;Ljava/awt/image/BufferedImage;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/ui/screenshot/ScreenshotProvider;Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorator;Ljava/util/List;IZLcom/android/tools/idea/ui/screenshot/DialogLocationArbiter;)V", "editorProvider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "imageFileEditor", "Lorg/intellij/images/editor/ImageFileEditor;", "saveConfigResolver", "Lcom/android/tools/idea/ui/save/SaveConfigurationResolver;", "settings", "Lcom/android/tools/idea/ui/screenshot/DeviceScreenshotSettings;", "saveConfig", "Lcom/android/tools/idea/ui/save/SaveConfiguration;", "getSaveConfig", "()Lcom/android/tools/idea/ui/save/SaveConfiguration;", "saveLocation", "", "getSaveLocation", "()Ljava/lang/String;", "scale", "", "frameScreenshot", "dialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "saveLocationText", "Ljavax/swing/JEditorPane;", "decorationComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorationOption;", "rotationQuadrants", "sourceImageRef", "Ljava/util/concurrent/atomic/AtomicReference;", "displayedImageRef", "Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer$TimestampedImage;", "screenshotFile", "Ljava/nio/file/Path;", "createCenterPanel", "Ljavax/swing/JComponent;", "applyFields", "", "getHelpId", "createDefaultActions", "doOKAction", "adjustToAvoidExistingFiles", "file", "getPreferredFocusedComponent", "getDimensionServiceKey", "Lorg/jetbrains/annotations/NonNls;", "getInitialLocation", "Ljava/awt/Point;", "beforeShowCallback", "getData", "", "dataId", "dispose", "getImageFileEditorProvider", "doRefreshScreenshot", "updateImageRotation", "numQuadrants", "updateScale", "copyImageToClipboard", "configureSave", "processScreenshot", "processImage", "sourceImage", "updateEditorImage", "logScreenshotUsage", "BufferedImageTransferable", "TimestampedImage", "Companion", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nScreenshotViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotViewer.kt\ncom/android/tools/idea/ui/screenshot/ScreenshotViewer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,600:1\n31#2,2:601\n1#3:603\n25#4:604\n25#4:605\n*S KotlinDebug\n*F\n+ 1 ScreenshotViewer.kt\ncom/android/tools/idea/ui/screenshot/ScreenshotViewer\n*L\n129#1:601,2\n363#1:604\n452#1:605\n*E\n"})
public final class ScreenshotViewer
extends DialogWrapper
implements DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile backingFile;
    @NotNull
    private final ScreenshotProvider screenshotProvider;
    @NotNull
    private final ScreenshotDecorator screenshotDecorator;
    private final boolean allowImageRotation;
    @Nullable
    private final DialogLocationArbiter dialogLocationArbiter;
    @NotNull
    private final FileEditorProvider editorProvider;
    @NotNull
    private final ImageFileEditor imageFileEditor;
    @NotNull
    private final SaveConfigurationResolver saveConfigResolver;
    @NotNull
    private final DeviceScreenshotSettings settings;
    private double scale;
    private boolean frameScreenshot;
    private DialogPanel dialogPanel;
    private JEditorPane saveLocationText;
    @NotNull
    private ComboBox<ScreenshotDecorationOption> decorationComboBox;
    private int rotationQuadrants;
    @NotNull
    private final AtomicReference<ScreenshotImage> sourceImageRef;
    @NotNull
    private final AtomicReference<TimestampedImage> displayedImageRef;
    @Nullable
    private Path screenshotFile;
    @NotNull
    private static final String SCREENSHOT_VIEWER_DIMENSIONS_KEY = "ScreenshotViewer";

    public ScreenshotViewer(@NotNull Project project, @NotNull ScreenshotImage screenshotImage, @NotNull BufferedImage processedImage, @NotNull VirtualFile backingFile, @NotNull ScreenshotProvider screenshotProvider, @NotNull ScreenshotDecorator screenshotDecorator, @NotNull List<? extends FramingOption> framingOptions, int defaultFramingOption, boolean allowImageRotation, @Nullable DialogLocationArbiter dialogLocationArbiter) {
        boolean isPlayCompatibleWearScreenshot;
        boolean canClipDeviceMask;
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
        Intrinsics.checkNotNullParameter((Object)processedImage, (String)"processedImage");
        Intrinsics.checkNotNullParameter((Object)backingFile, (String)"backingFile");
        Intrinsics.checkNotNullParameter((Object)screenshotProvider, (String)"screenshotProvider");
        Intrinsics.checkNotNullParameter((Object)screenshotDecorator, (String)"screenshotDecorator");
        Intrinsics.checkNotNullParameter(framingOptions, (String)"framingOptions");
        super(project);
        this.project = project;
        this.backingFile = backingFile;
        this.screenshotProvider = screenshotProvider;
        this.screenshotDecorator = screenshotDecorator;
        this.allowImageRotation = allowImageRotation;
        this.dialogLocationArbiter = dialogLocationArbiter;
        this.editorProvider = this.getImageFileEditorProvider();
        FileEditor fileEditor = this.editorProvider.createEditor(this.project, this.backingFile);
        Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type org.intellij.images.editor.ImageFileEditor");
        this.imageFileEditor = (ImageFileEditor)fileEditor;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<SaveConfigurationResolver> serviceClass$iv = SaveConfigurationResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.saveConfigResolver = (SaveConfigurationResolver)object;
        this.settings = DeviceScreenshotSettings.Companion.getInstance();
        this.scale = this.settings.getScale$intellij_android_adb_ui();
        this.frameScreenshot = this.settings.getFrameScreenshot$intellij_android_adb_ui();
        this.decorationComboBox = new ComboBox();
        this.sourceImageRef = new AtomicReference();
        this.displayedImageRef = new AtomicReference();
        if (!(framingOptions.isEmpty() || 0 <= defaultFramingOption && defaultFramingOption < framingOptions.size())) {
            boolean $i$a$-require-ScreenshotViewer$232 = false;
            String $i$a$-require-ScreenshotViewer$232 = "Invalid defaultFramingOption:" + defaultFramingOption + " framingOptions:" + framingOptions;
            throw new IllegalArgumentException($i$a$-require-ScreenshotViewer$232.toString());
        }
        this.setModal(false);
        if (screenshotImage.getDisplayId() == SdkConstants.PRIMARY_DISPLAY_ID) {
            $i$a$-require-ScreenshotViewer$232 = new Object[]{screenshotImage.getDeviceName()};
            string = AndroidAdbUiBundle.message("screenshot.dialog.title.primary.display", $i$a$-require-ScreenshotViewer$232);
        } else {
            $i$a$-require-ScreenshotViewer$232 = new Object[]{screenshotImage.getDeviceName(), screenshotImage.getDisplayId()};
            string = AndroidAdbUiBundle.message("screenshot.dialog.title.secondary.display", $i$a$-require-ScreenshotViewer$232);
        }
        this.setTitle(string);
        this.sourceImageRef.set(screenshotImage);
        this.rotationQuadrants = screenshotImage.getScreenshotOrientationQuadrants();
        this.displayedImageRef.set(new TimestampedImage(processedImage));
        DefaultComboBoxModel<ScreenshotDecorationOption> decorationOptions = new DefaultComboBoxModel<ScreenshotDecorationOption>();
        decorationOptions.addElement(ScreenshotDecorationOption.RECTANGULAR);
        boolean bl = canClipDeviceMask = this.screenshotDecorator.getCanClipToDisplayShape() || screenshotImage.isRoundDisplay();
        if (canClipDeviceMask) {
            decorationOptions.addElement(ScreenshotDecorationOption.DISPLAY_SHAPE_CLIP);
        }
        boolean bl2 = isPlayCompatibleWearScreenshot = screenshotImage.isWear() && screenshotImage.getWidth() == screenshotImage.getHeight();
        if (isPlayCompatibleWearScreenshot) {
            decorationOptions.addElement(ScreenshotDecorationOption.PLAY_COMPATIBLE);
        }
        int frameOptionStartIndex = decorationOptions.getSize();
        for (FramingOption framingOption : framingOptions) {
            decorationOptions.addElement(new ScreenshotDecorationOption(framingOption));
        }
        this.decorationComboBox.setModel((ComboBoxModel)decorationOptions);
        if (this.frameScreenshot && this.decorationComboBox.getItemCount() > defaultFramingOption + frameOptionStartIndex) {
            this.decorationComboBox.setSelectedIndex(defaultFramingOption + frameOptionStartIndex);
        } else if (isPlayCompatibleWearScreenshot) {
            this.decorationComboBox.setSelectedItem((Object)ScreenshotDecorationOption.PLAY_COMPATIBLE);
        } else if (canClipDeviceMask) {
            this.decorationComboBox.setSelectedItem((Object)ScreenshotDecorationOption.DISPLAY_SHAPE_CLIP);
        } else {
            this.decorationComboBox.setSelectedItem((Object)ScreenshotDecorationOption.RECTANGULAR);
        }
        ActionListener decorationListener = arg_0 -> ScreenshotViewer._init_$lambda$1(this, decorationOptions, arg_0);
        this.decorationComboBox.addActionListener(decorationListener);
        this.init();
        this.updateEditorImage();
    }

    public /* synthetic */ ScreenshotViewer(Project project, ScreenshotImage screenshotImage, BufferedImage bufferedImage, VirtualFile virtualFile, ScreenshotProvider screenshotProvider, ScreenshotDecorator screenshotDecorator, List list, int n, boolean bl, DialogLocationArbiter dialogLocationArbiter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x200) != 0) {
            dialogLocationArbiter = null;
        }
        this(project, screenshotImage, bufferedImage, virtualFile, screenshotProvider, screenshotDecorator, list, n, bl, dialogLocationArbiter);
    }

    private final SaveConfiguration getSaveConfig() {
        return this.settings.getSaveConfig$intellij_android_adb_ui();
    }

    private final String getSaveLocation() {
        return this.saveConfigResolver.expandSaveLocation(this.getSaveConfig().getSaveLocation());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.dialogPanel = BuilderKt.panel(arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16(this, arg_0));
        BorderLayoutPanel sizingPanel2 = new BorderLayoutPanel(){
            private Dimension initialMinSize;

            public Dimension getMinimumSize() {
                Dimension dimension2 = this.initialMinSize;
                if (dimension2 == null) {
                    Dimension dimension3;
                    Dimension $this$getMinimumSize_u24lambda_u240 = dimension3 = super.getMinimumSize();
                    boolean bl = false;
                    $this$getMinimumSize_u24lambda_u240.height = Math.max($this$getMinimumSize_u24lambda_u240.width, $this$getMinimumSize_u24lambda_u240.height);
                    this.initialMinSize = $this$getMinimumSize_u24lambda_u240;
                    Dimension dimension4 = dimension3;
                    dimension2 = dimension4;
                    Intrinsics.checkNotNullExpressionValue((Object)dimension4, (String)"apply(...)");
                }
                return dimension2;
            }
        };
        DialogPanel dialogPanel = this.dialogPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogPanel");
            dialogPanel = null;
        }
        BorderLayoutPanel borderLayoutPanel = sizingPanel2.addToCenter((Component)dialogPanel);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToCenter(...)");
        return (JComponent)borderLayoutPanel;
    }

    protected void applyFields() {
        DialogPanel dialogPanel = this.dialogPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogPanel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        this.settings.setScale$intellij_android_adb_ui(this.scale);
        this.settings.setFrameScreenshot$intellij_android_adb_ui(this.frameScreenshot);
    }

    @NotNull
    protected String getHelpId() {
        return "org.jetbrains.android.r/studio-ui/am-screenshot.html";
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidAdbUiBundle.message("screenshot.dialog.ok.button.text", new Object[0]));
    }

    protected void doOKAction() {
        TimestampedImage timestampedImage = this.displayedImageRef.get();
        if (timestampedImage == null) {
            return;
        }
        TimestampedImage image = timestampedImage;
        String expandedFilename = this.saveConfigResolver.expandFilenamePattern(this.getSaveConfig().getSaveLocation(), this.getSaveConfig().getFilenameTemplate(), "png", image.getTimestamp(), this.settings.getScreenshotCount$intellij_android_adb_ui() + 1);
        Path path = Paths.get(expandedFilename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path file = this.adjustToAvoidExistingFiles(path);
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            ScreenshotViewer.Companion.writePng(image.getImage(), file);
            DeviceScreenshotSettings deviceScreenshotSettings = this.settings;
            int n = deviceScreenshotSettings.getScreenshotCount$intellij_android_adb_ui();
            deviceScreenshotSettings.setScreenshotCount$intellij_android_adb_ui(n + 1);
            this.screenshotFile = file;
            this.logScreenshotUsage();
        }
        catch (IOException e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            String error = string;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)error);
            objectArray[0] = error;
            Messages.showErrorDialog((Project)this.project, (String)AndroidAdbUiBundle.message("screenshot.dialog.error", objectArray), (String)AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]));
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getSaveConfig().getPostSaveAction().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                RevealFileAction.openFile((Path)file);
                break;
            }
            case 3: {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file);
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    NativeFileType.openAssociatedApplication((VirtualFile)it);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        super.doOKAction();
    }

    private final Path adjustToAvoidExistingFiles(Path file) {
        Path adjusted;
        if (!Files.exists(file, new LinkOption[0])) {
            return file;
        }
        String filename = ((Object)file.getFileName()).toString();
        String string = FileUtilRt.getNameWithoutExtension((String)filename);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String name2 = string;
        String string2 = FileUtilRt.getExtension((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
        String extension = string2;
        Path dir = file.getParent();
        int i = 0;
        do {
            adjusted = dir.resolve(name2 + " (" + ++i + ")." + extension);
        } while (Files.exists(file, new LinkOption[0]) && i <= 100);
        Intrinsics.checkNotNull((Object)adjusted);
        return adjusted;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.imageFileEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        int displayId = this.sourceImageRef.get().getDisplayId();
        return (Boolean)StudioFlags.MULTI_DISPLAY_SCREENSHOTS.get() == false || displayId == SdkConstants.PRIMARY_DISPLAY_ID ? SCREENSHOT_VIEWER_DIMENSIONS_KEY : "ScreenshotViewer." + displayId;
    }

    @Nullable
    public Point getInitialLocation() {
        DialogLocationArbiter dialogLocationArbiter = this.dialogLocationArbiter;
        return dialogLocationArbiter != null ? dialogLocationArbiter.suggestLocation(this) : null;
    }

    public void beforeShowCallback() {
        block0: {
            DialogLocationArbiter dialogLocationArbiter = this.dialogLocationArbiter;
            if (dialogLocationArbiter == null) break block0;
            dialogLocationArbiter.dialogShown(this);
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PlatformCoreDataKeys.FILE_EDITOR.is(dataId) ? this.imageFileEditor : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        this.editorProvider.disposeEditor((FileEditor)this.imageFileEditor);
        try {
            ApplicationManager.getApplication().runWriteAction(() -> ScreenshotViewer.dispose$lambda$18(this));
        }
        finally {
            super.dispose();
        }
    }

    private final FileEditorProvider getImageFileEditorProvider() {
        boolean bl;
        List providers = FileEditorProviderManager.Companion.getInstance().getProviderList(this.project, this.backingFile);
        boolean bl2 = bl = !((Collection)providers).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (FileEditorProvider provider : providers) {
            if (!Intrinsics.areEqual((Object)provider.getEditorTypeId(), (Object)"images")) continue;
            return provider;
        }
        return (FileEditorProvider)providers.get(0);
    }

    private final void doRefreshScreenshot() {
        BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.createCoroutineScope$default((Disposable)this.screenshotProvider, null, null, (int)3, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ScreenshotViewer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TasksKt.withModalProgress((Project)ScreenshotViewer.access$getProject$p(this.this$0), (String)AndroidAdbUiBundle.message("screenshot.task.step.obtain", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ ScreenshotViewer this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$withModalProgress = (CoroutineScope)this.L$0;
                                        this.L$0 = $this$withModalProgress;
                                        this.label = 1;
                                        v0 = ScreenshotViewer.access$getScreenshotProvider$p(this.this$0).captureScreenshot((Continuation<? super ScreenshotImage>)((Continuation)this));
                                        ** if (v0 != var8_2) goto lbl13
lbl12:
                                        // 1 sources

                                        return var8_2;
lbl13:
                                        // 1 sources

                                        ** GOTO lbl20
                                    }
                                    case 1: {
                                        $this$withModalProgress = (CoroutineScope)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl20:
                                            // 2 sources

                                            screenshotImage = (ScreenshotImage)v0;
                                            ScreenshotViewer.access$getSourceImageRef$p(this.this$0).set(screenshotImage);
                                            ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(com.android.tools.idea.ui.screenshot.ScreenshotViewer ), ()V)((ScreenshotViewer)this.this$0));
                                        }
                                        catch (CancellationException e) {
                                            throw e;
                                        }
                                        catch (Throwable e) {
                                            v1 = ExceptionUtil.getMessage((Throwable)e);
                                            if (v1 == null) {
                                                v1 = "javaClass";
                                            }
                                            cause = v1;
                                            var6_9 = new Object[]{cause};
                                            message = AndroidAdbUiBundle.message("screenshot.error.generic", var6_9);
                                            $i$f$thisLogger = false;
                                            v2 = Logger.getInstance(CoroutineScope.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                                            v2.error(message, e);
                                            ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$1(com.android.tools.idea.ui.screenshot.ScreenshotViewer java.lang.String ), ()V)((ScreenshotViewer)this.this$0, (String)message));
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0(ScreenshotViewer this$0) {
                                ScreenshotViewer.access$processScreenshot(this$0, ScreenshotViewer.access$getAllowImageRotation$p(this$0) ? ScreenshotViewer.access$getRotationQuadrants$p(this$0) : 0);
                            }

                            private static final void invokeSuspend$lambda$1(ScreenshotViewer this$0, String $message) {
                                Messages.showErrorDialog((Project)ScreenshotViewer.access$getProject$p(this$0), (String)$message, (String)AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]));
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void updateImageRotation(int numQuadrants) {
        this.rotationQuadrants = this.rotationQuadrants + numQuadrants & 3;
        this.processScreenshot(numQuadrants);
    }

    private final void updateScale(double scale) {
        this.scale = scale;
        ScreenshotViewer.processScreenshot$default(this, 0, 1, null);
    }

    private final void copyImageToClipboard() {
        Notification notification;
        BufferedImage currentImage = this.imageFileEditor.getImageEditor().getDocument().getValue();
        CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
        Intrinsics.checkNotNull((Object)currentImage);
        copyPasteManager.setContents((Transferable)new BufferedImageTransferable(currentImage));
        NotificationGroup notificationGroup = NotificationGroup.Companion.findRegisteredGroup("Screen Capture");
        if (notificationGroup != null && (notification = notificationGroup.createNotification(AndroidAdbUiBundle.message("screenshot.notification.copied.to.clipboard", new Object[0]), NotificationType.INFORMATION)) != null) {
            notification.notify(this.project);
        }
        this.logScreenshotUsage();
    }

    private final void configureSave() {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.project, DeviceScreenshotSettingsPage.class);
        JEditorPane jEditorPane = this.saveLocationText;
        if (jEditorPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationText");
            jEditorPane = null;
        }
        jEditorPane.setText(this.getSaveLocation());
        this.pack();
    }

    private final void processScreenshot(int rotationQuadrants) {
        ScreenshotImage screenshotImage = this.sourceImageRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)screenshotImage, (String)"get(...)");
        ScreenshotImage screenshotImage2 = screenshotImage;
        ScreenshotImage rotatedImage = ScreenshotImage.rotatedAndScaled$default(screenshotImage2, rotationQuadrants, 0.0, 2, null);
        BufferedImage processedImage = this.processImage(rotatedImage);
        ApplicationManager.getApplication().runWriteAction(() -> ScreenshotViewer.processScreenshot$lambda$20(this, processedImage));
        this.sourceImageRef.set(rotatedImage);
        this.displayedImageRef.set(new TimestampedImage(processedImage));
        this.updateEditorImage();
    }

    static /* synthetic */ void processScreenshot$default(ScreenshotViewer screenshotViewer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        screenshotViewer.processScreenshot(n);
    }

    private final BufferedImage processImage(ScreenshotImage sourceImage) {
        Object object = this.decorationComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.ui.screenshot.ScreenshotDecorationOption");
        ScreenshotDecorationOption decoration = (ScreenshotDecorationOption)object;
        return this.screenshotDecorator.decorate(ScreenshotImage.rotatedAndScaled$default(sourceImage, 0, this.scale, 1, null), decoration);
    }

    private final void updateEditorImage() {
        this.imageFileEditor.getImageEditor().getDocument().setValue(this.displayedImageRef.get().getImage());
        this.pack();
        IdeFocusManager.getInstance((Project)this.project).requestFocusInProject((Component)this.getPreferredFocusedComponent(), this.project);
    }

    private final void logScreenshotUsage() {
        ScreenshotImage screenshotImage = this.sourceImageRef.get();
        Object object = screenshotImage != null ? screenshotImage.getDeviceType() : null;
        DeviceScreenshotEvent.DeviceType usageDeviceType = switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$1[object.ordinal()]) {
            case 1 -> DeviceScreenshotEvent.DeviceType.WEAR;
            case 2 -> DeviceScreenshotEvent.DeviceType.PHONE;
            case 3 -> DeviceScreenshotEvent.DeviceType.TV;
            default -> DeviceScreenshotEvent.DeviceType.UNKNOWN_DEVICE_TYPE;
        };
        Object object2 = this.decorationComboBox.getSelectedItem();
        DeviceScreenshotEvent.DecorationOption usageDecorationOption = Intrinsics.areEqual((Object)object2, (Object)ScreenshotDecorationOption.RECTANGULAR) ? DeviceScreenshotEvent.DecorationOption.RECTANGULAR : (Intrinsics.areEqual((Object)object2, (Object)ScreenshotDecorationOption.DISPLAY_SHAPE_CLIP) ? DeviceScreenshotEvent.DecorationOption.DISPLAY_SHAPE_CLIP : (Intrinsics.areEqual((Object)object2, (Object)ScreenshotDecorationOption.PLAY_COMPATIBLE) ? DeviceScreenshotEvent.DecorationOption.PLAY_COMPATIBLE : DeviceScreenshotEvent.DecorationOption.FRAMED));
        DeviceScreenshotEvent.Builder event = DeviceScreenshotEvent.newBuilder().setDeviceType(usageDeviceType).setDecorationOption(usageDecorationOption);
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_SCREENSHOT_EVENT).setDeviceScreenshotEvent(event);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setDeviceScreenshotEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private static final void _init_$lambda$1(ScreenshotViewer this$0, DefaultComboBoxModel $decorationOptions, ActionEvent it) {
        Object object = $decorationOptions.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.ui.screenshot.ScreenshotDecorationOption");
        this$0.frameScreenshot = ((ScreenshotDecorationOption)object).getFramingOption() != null;
        ScreenshotViewer.processScreenshot$default(this$0, 0, 1, null);
    }

    private static final Unit createCenterPanel$lambda$16$lambda$8$lambda$2(ScreenshotViewer this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.doRefreshScreenshot();
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$16$lambda$8$lambda$4$lambda$3(JButton $this_applyToComponent) {
        $this_applyToComponent.setEnabled(false);
    }

    private static final Unit createCenterPanel$lambda$16$lambda$8$lambda$4(ScreenshotViewer this$0, JButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setIcon(AllIcons.Actions.Refresh);
        Disposable[] disposableArray = new Disposable[2];
        disposableArray[0] = this$0.screenshotProvider;
        Intrinsics.checkNotNullExpressionValue((Object)this$0.getDisposable(), (String)"getDisposable(...)");
        DisposableUtils.runOnDisposalOfAnyOf(disposableArray, () -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$8$lambda$4$lambda$3($this$applyToComponent));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$8$lambda$5(ScreenshotViewer this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateImageRotation(1);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$8$lambda$6(ScreenshotViewer this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateImageRotation(3);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$8$lambda$7(ScreenshotViewer this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.copyImageToClipboard();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$8(ScreenshotViewer this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(AndroidAdbUiBundle.message("screenshot.dialog.recapture.button.text", new Object[0]), arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$8$lambda$2(this$0, arg_0)).applyToComponent(arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$8$lambda$4(this$0, arg_0));
        if (this$0.allowImageRotation) {
            $this$row.button(AndroidAdbUiBundle.message("screenshot.dialog.rotate.left.button.text", new Object[0]), arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$8$lambda$5(this$0, arg_0));
            $this$row.button(AndroidAdbUiBundle.message("screenshot.dialog.rotate.right.button.text", new Object[0]), arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$8$lambda$6(this$0, arg_0));
        }
        $this$row.button(AndroidAdbUiBundle.message("screenshot.dialog.copy.button.text", new Object[0]), arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$8$lambda$7(this$0, arg_0));
        $this$row.cell((JComponent)this$0.decorationComboBox).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$9(ScreenshotViewer this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.imageFileEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$12$lambda$10(ScreenshotViewer this$0, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateScale(((Number)it.getItem()).doubleValue() / 100.0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$12$lambda$11(ScreenshotViewer this$0, ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setItem((Object)MathKt.roundToInt((double)(this$0.scale * (double)100)));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$12(ScreenshotViewer this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Integer[]{100, 50, 25};
        Row.comboBox$default((Row)$this$row, (Collection)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null).onChanged(arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$12$lambda$10(this$0, arg_0)).applyToComponent(arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$12$lambda$11(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$15$lambda$13(ScreenshotViewer this$0, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.saveLocationText = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$15$lambda$14(ScreenshotViewer this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.configureSave();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16$lambda$15(ScreenshotViewer this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)AndroidAdbUiBundle.message("screenrecord.options.save.directory", new Object[0]), (int)0, null, (int)6, null);
        Row.text$default((Row)$this$row, (String)this$0.getSaveLocation(), (int)0, null, (int)6, null).applyToComponent(arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$15$lambda$13(this$0, arg_0));
        $this$row.link(AndroidAdbUiBundle.message("configure.save.link.text", new Object[0]), arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$15$lambda$14(this$0, arg_0)).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$16(ScreenshotViewer this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$8(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$9(this$0, arg_0), (int)1, null).resizableRow();
        $this$panel.row(AndroidAdbUiBundle.message("screenshot.options.resolution", new Object[0]), arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$12(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ScreenshotViewer.createCenterPanel$lambda$16$lambda$15(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void dispose$lambda$18(ScreenshotViewer this$0) {
        try {
            this$0.backingFile.delete((Object)this$0);
        }
        catch (IOException e) {
            ScreenshotViewer $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ScreenshotViewer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processScreenshot$lambda$20(ScreenshotViewer this$0, BufferedImage $processedImage) {
        try {
            Closeable closeable = this$0.backingFile.getOutputStream((Object)this$0);
            Throwable throwable = null;
            try {
                OutputStream stream = (OutputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)stream);
                ScreenshotViewer.Companion.writePng($processedImage, stream);
                stream = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            ScreenshotViewer $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ScreenshotViewer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unexpected error while writing to " + this$0.backingFile.toNioPath(), (Throwable)e);
        }
    }

    public static final /* synthetic */ Project access$getProject$p(ScreenshotViewer $this) {
        return $this.project;
    }

    public static final /* synthetic */ ScreenshotProvider access$getScreenshotProvider$p(ScreenshotViewer $this) {
        return $this.screenshotProvider;
    }

    public static final /* synthetic */ AtomicReference access$getSourceImageRef$p(ScreenshotViewer $this) {
        return $this.sourceImageRef;
    }

    public static final /* synthetic */ void access$processScreenshot(ScreenshotViewer $this, int rotationQuadrants) {
        $this.processScreenshot(rotationQuadrants);
    }

    public static final /* synthetic */ boolean access$getAllowImageRotation$p(ScreenshotViewer $this) {
        return $this.allowImageRotation;
    }

    public static final /* synthetic */ int access$getRotationQuadrants$p(ScreenshotViewer $this) {
        return $this.rotationQuadrants;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer$BufferedImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljava/awt/image/BufferedImage;)V", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "dataFlavor", "getTransferData", "intellij.android.adb.ui"})
    private static final class BufferedImageTransferable
    implements Transferable {
        @NotNull
        private final BufferedImage image;

        public BufferedImageTransferable(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.imageFlavor, (String)"imageFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor dataFlavor) {
            Intrinsics.checkNotNullParameter((Object)dataFlavor, (String)"dataFlavor");
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        @NotNull
        public BufferedImage getTransferData(@NotNull DataFlavor dataFlavor) throws UnsupportedFlavorException {
            Intrinsics.checkNotNullParameter((Object)dataFlavor, (String)"dataFlavor");
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.image;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer$Companion;", "", "<init>", "()V", "SCREENSHOT_VIEWER_DIMENSIONS_KEY", "", "Lorg/jetbrains/annotations/NonNls;", "getDefaultDecoration", "Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorationOption;", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "screenshotDecorator", "Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorator;", "defaultFramingOption", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "writePng", "", "image", "Ljava/awt/image/BufferedImage;", "outFile", "Ljava/nio/file/Path;", "outputStream", "Ljava/io/OutputStream;", "deflate", "", "data", "intellij.android.adb.ui"})
    @SourceDebugExtension(value={"SMAP\nScreenshotViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotViewer.kt\ncom/android/tools/idea/ui/screenshot/ScreenshotViewer$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,600:1\n40#2,3:601\n*S KotlinDebug\n*F\n+ 1 ScreenshotViewer.kt\ncom/android/tools/idea/ui/screenshot/ScreenshotViewer$Companion\n*L\n519#1:601,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScreenshotDecorationOption getDefaultDecoration(@NotNull ScreenshotImage screenshotImage, @NotNull ScreenshotDecorator screenshotDecorator, @Nullable FramingOption defaultFramingOption) {
            Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
            Intrinsics.checkNotNullParameter((Object)screenshotDecorator, (String)"screenshotDecorator");
            boolean $i$f$service = false;
            Class<DeviceScreenshotSettings> serviceClass$iv = DeviceScreenshotSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            boolean frameScreenshot = ((DeviceScreenshotSettings)object).getFrameScreenshot$intellij_android_adb_ui();
            boolean canClipDeviceMask = screenshotDecorator.getCanClipToDisplayShape() || screenshotImage.isRoundDisplay();
            boolean isPlayCompatibleWearScreenshot = screenshotImage.isWear() && screenshotImage.getWidth() == screenshotImage.getHeight();
            return frameScreenshot && defaultFramingOption != null ? new ScreenshotDecorationOption(defaultFramingOption) : (canClipDeviceMask ? ScreenshotDecorationOption.DISPLAY_SHAPE_CLIP : (isPlayCompatibleWearScreenshot ? ScreenshotDecorationOption.PLAY_COMPATIBLE : ScreenshotDecorationOption.RECTANGULAR));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writePng(BufferedImage image, Path outFile) throws IOException {
            try {
                Closeable closeable = Files.newOutputStream(outFile, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OutputStream stream = (OutputStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)stream);
                    Companion.writePng(image, stream);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                Files.deleteIfExists(outFile);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writePng(BufferedImage image, OutputStream outputStream) throws IOException {
            ImageTypeSpecifier imageType = ImageTypeSpecifier.createFromRenderedImage(image);
            Iterator<ImageWriter> iterator2 = ImageIO.getImageWriters(imageType, "png");
            if (!iterator2.hasNext()) {
                throw new IOException("Failed to find PNG writer");
            }
            ImageWriter imageWriter = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)imageWriter, (String)"next(...)");
            ImageWriter pngWriter = imageWriter;
            Closeable closeable = ImageIO.createImageOutputStream(outputStream);
            Throwable throwable = null;
            try {
                ImageOutputStream stream = (ImageOutputStream)closeable;
                boolean bl = false;
                pngWriter.setOutput(stream);
                try {
                    ColorSpace colorSpace = image.getColorModel().getColorSpace();
                    if (colorSpace instanceof ICC_ColorSpace) {
                        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
                        ImageWriteParam writeParams = pngWriter.getDefaultWriteParam();
                        IIOMetadata metadata = pngWriter.getDefaultImageMetadata(type, writeParams);
                        Node node = metadata.getAsTree("javax_imageio_png_1.0");
                        IIOMetadataNode metadataNode = new IIOMetadataNode("iCCP");
                        byte[] byArray = ((ICC_ColorSpace)colorSpace).getProfile().getData();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
                        metadataNode.setUserObject(Companion.deflate(byArray));
                        metadataNode.setAttribute("profileName", Colors.getIccProfileDescription((ICC_Profile)((ICC_ColorSpace)colorSpace).getProfile()));
                        metadataNode.setAttribute("compressionMethod", "deflate");
                        node.appendChild(metadataNode);
                        metadata.setFromTree("javax_imageio_png_1.0", node);
                        pngWriter.write(new IIOImage(image, null, metadata));
                    } else {
                        pngWriter.write(image);
                    }
                }
                finally {
                    pngWriter.dispose();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final byte[] deflate(byte[] data2) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(data2.length);
            Deflater deflater = new Deflater();
            deflater.setInput(data2);
            deflater.finish();
            byte[] buffer = new byte[4096];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                out.write(buffer, 0, count);
            }
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer$TimestampedImage;", "", "image", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljava/awt/image/BufferedImage;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "timestamp", "Ljava/time/Instant;", "getTimestamp", "()Ljava/time/Instant;", "intellij.android.adb.ui"})
    private static final class TimestampedImage {
        @NotNull
        private final BufferedImage image;
        @NotNull
        private final Instant timestamp;

        public TimestampedImage(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.timestamp = instant;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PostSaveAction.values().length];
            try {
                nArray[PostSaveAction.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostSaveAction.SHOW_IN_FOLDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostSaveAction.OPEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DeviceType.values().length];
            try {
                nArray[DeviceType.WEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.HANDHELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.TV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

