/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.dwf.dom.raw;

import com.android.tools.idea.wear.dwf.WFFConstants;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.BooleanConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.ColorConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.ListConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.PhotosConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.UnknownConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.UserConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.DataSource;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.PatternedDataSource;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.PsiImplUtilKt;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.StaticDataSource;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.WFFExpressionDataSource;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000f\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u0001\u001a\u0016\u0010\u0000\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000bH\u0007\u001a\n\u0010\f\u001a\u00020\r*\u00020\r\u001a\u0013\u0010\u000e\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u000f\u001a\u00020\r\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0011*\u00020\u0012\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0012\u001a\f\u0010\u0016\u001a\u00020\u0011*\u00020\u0017H\u0002\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0017H\u0002\u001a\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0019*\u00020\u0017H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0017H\u0002\u00a8\u0006\u001d"}, d2={"insertBracketsAroundIfNeeded", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "Lorg/jetbrains/annotations/NotNull;", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "extractUserConfigurations", "", "Lcom/android/tools/idea/wear/dwf/dom/raw/configurations/UserConfiguration;", "Lcom/intellij/psi/xml/XmlFile;", "removeSurroundingQuotes", "", "createDataSourceLookupElement", "lookupString", "isUserConfiguration", "", "Lcom/android/tools/idea/wear/dwf/dom/raw/expressions/WFFExpressionDataSource;", "isReference", "findDataSourceDefinition", "Lcom/android/tools/idea/wear/dwf/dom/raw/expressions/DataSource;", "isComplicationDataSource", "Lcom/intellij/psi/PsiElement;", "findComplicationDataSource", "Lcom/android/tools/idea/wear/dwf/dom/raw/expressions/StaticDataSource;", "findStaticDataSource", "findPatternDataSource", "Lcom/android/tools/idea/wear/dwf/dom/raw/expressions/PatternedDataSource;", "intellij.android.wear-dwf"})
@SourceDebugExtension(value={"SMAP\nRawWatchFaceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawWatchFaceUtils.kt\ncom/android/tools/idea/wear/dwf/dom/raw/RawWatchFaceUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n10065#2:171\n10487#2,5:172\n3829#2:187\n4344#2,2:188\n1611#3,9:177\n1863#3:186\n1864#3:191\n1620#3:192\n1#4:190\n1#4:193\n*S KotlinDebug\n*F\n+ 1 RawWatchFaceUtils.kt\ncom/android/tools/idea/wear/dwf/dom/raw/RawWatchFaceUtilsKt\n*L\n94#1:171\n94#1:172,5\n104#1:187\n104#1:188,2\n97#1:177,9\n97#1:186\n97#1:191\n97#1:192\n97#1:190\n*E\n"})
public final class RawWatchFaceUtilsKt {
    @NotNull
    public static final LookupElementBuilder insertBracketsAroundIfNeeded(@NotNull LookupElementBuilder $this$insertBracketsAroundIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$insertBracketsAroundIfNeeded, (String)"<this>");
        LookupElementBuilder lookupElementBuilder = $this$insertBracketsAroundIfNeeded.withInsertHandler(RawWatchFaceUtilsKt::insertBracketsAroundIfNeeded$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        return lookupElementBuilder;
    }

    public static final void insertBracketsAroundIfNeeded(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        StringBuilder textWithBrackets = new StringBuilder();
        String string = lookupElement.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"[", (boolean)false, (int)2, null)) {
            textWithBrackets.append("[");
        }
        textWithBrackets.append(lookupElement.getLookupString());
        String string2 = lookupElement.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)"]", (boolean)false, (int)2, null)) {
            textWithBrackets.append("]");
        }
        boolean hasOpenBracket = context.getStartOffset() > 0 && context.getDocument().getCharsSequence().charAt(context.getStartOffset() - 1) == '[';
        int startOffset = hasOpenBracket ? context.getStartOffset() - 1 : context.getStartOffset();
        boolean hasExtraCloseBracket = context.getTailOffset() < context.getDocument().getTextLength() && context.getDocument().getCharsSequence().charAt(context.getTailOffset()) == ']';
        int tailOffset = hasExtraCloseBracket ? context.getTailOffset() + 1 : context.getTailOffset();
        context.getDocument().replaceString(startOffset, tailOffset, (CharSequence)textWithBrackets.toString());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @RequiresReadLock
    @NotNull
    public static final List<UserConfiguration> extractUserConfigurations(@NotNull XmlFile $this$extractUserConfigurations) {
        Intrinsics.checkNotNullParameter((Object)$this$extractUserConfigurations, (String)"<this>");
        v0 = $this$extractUserConfigurations.getRootTag();
        if (!Intrinsics.areEqual((Object)(v0 != null ? v0.getName() : null), (Object)"WatchFace")) {
            return CollectionsKt.emptyList();
        }
        v1 = $this$extractUserConfigurations.getRootTag();
        if (v1 != null && (v1 = v1.findSubTags("UserConfigurations")) != null) {
            $this$flatMap$iv = v1;
            $i$f$flatMap = false;
            var7_3 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            var11_10 = ((void)$this$flatMapTo$iv$iv).length;
            for (var10_8 = 0; var10_8 < var11_10; ++var10_8) {
                it = element$iv$iv = $this$flatMapTo$iv$iv[var10_8];
                $i$a$-flatMap-RawWatchFaceUtilsKt$extractUserConfigurations$userConfigurationTags$1 = false;
                v2 = it.getSubTags();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getSubTags(...)");
                list$iv$iv = ArraysKt.toList((Object[])v2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        userConfigurationTags = (List)destination$iv$iv;
        $this$mapNotNull$iv = userConfigurationTags;
        $i$f$mapNotNull = false;
        var4_19 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var9_7 = $this$forEach$iv$iv$iv.iterator();
        while (var9_7.hasNext()) {
            block26: {
                block25: {
                    element$iv$iv = element$iv$iv$iv = var9_7.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    userConfigurationTag = (XmlTag)element$iv$iv;
                    $i$a$-mapNotNull-RawWatchFaceUtilsKt$extractUserConfigurations$1 = false;
                    v3 /* !! */  = userConfigurationTag.getAttribute("id");
                    if (v3 /* !! */  != null && (v3 /* !! */  = v3 /* !! */ .getValue()) != null) break block25;
                    v4 = null;
                    break block26;
                }
                id /* !! */  = v3 /* !! */ ;
                var16_21 = userConfigurationTag.getName();
                tmp = -1;
                switch (var16_21.hashCode()) {
                    case -1021801869: {
                        if (var16_21.equals("ColorConfiguration")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -802904872: {
                        if (var16_21.equals("ListConfiguration")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1608089045: {
                        if (var16_21.equals("PhotosConfiguration")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -497848882: {
                        if (var16_21.equals("BooleanConfiguration")) {
                            tmp = 4;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v5 = userConfigurationTag.getSubTags();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getSubTags(...)");
                        var17_22 = (IntRange)v5;
                        $i$f$filter = false;
                        var19_25 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (void element$iv$iv : $this$filterTo$iv$iv) {
                            it = (XmlTag)element$iv$iv;
                            $i$a$-filter-RawWatchFaceUtilsKt$extractUserConfigurations$1$availableColorIndices$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"ColorOption")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        for (XmlTag colorOptionTag : (Iterable)((List)destination$iv$iv)) {
                            $i$a$-firstNotNullOfOrNull-RawWatchFaceUtilsKt$extractUserConfigurations$1$availableColorIndices$2 = false;
                            v6 /* !! */  = colorOptionTag.getAttribute("colors");
                            if (v6 /* !! */  != null && (v6 /* !! */  = v6 /* !! */ .getValue()) != null) {
                                var21_29 = (CharSequence)v6 /* !! */ ;
                                var22_31 = new Regex("\\s+");
                                var23_32 = 0;
                                v7 = var22_31.split(var21_29, var23_32);
                            } else {
                                v7 = null;
                            }
                            if ((var19_25 = v7) == null) continue;
                            v8 = var19_25;
                            ** GOTO lbl100
                        }
                        v8 = null;
lbl100:
                        // 2 sources

                        var27_36 = v8;
                        availableColorIndices = var27_36 != null && (var17_22 = CollectionsKt.getIndices((Collection)var27_36)) != null ? var17_22 : IntRange.Companion.getEMPTY();
                        Intrinsics.checkNotNull((Object)userConfigurationTag);
                        v4 = new ColorConfiguration((String)id /* !! */ , userConfigurationTag, availableColorIndices);
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)userConfigurationTag);
                        v4 = new ListConfiguration((String)id /* !! */ , userConfigurationTag);
                        break;
                    }
                    case 4: {
                        Intrinsics.checkNotNull((Object)userConfigurationTag);
                        v4 = new BooleanConfiguration((String)id /* !! */ , userConfigurationTag);
                        break;
                    }
                    case 3: {
                        Intrinsics.checkNotNull((Object)userConfigurationTag);
                        v4 = new PhotosConfiguration((String)id /* !! */ , userConfigurationTag);
                        break;
                    }
                    default: {
                        Intrinsics.checkNotNull((Object)userConfigurationTag);
                        v4 = new UnknownConfiguration((String)id /* !! */ , userConfigurationTag);
                    }
                }
            }
            if (v4 == null) continue;
            it$iv$iv = v4;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String removeSurroundingQuotes(@NotNull String $this$removeSurroundingQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$removeSurroundingQuotes, (String)"<this>");
        return StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)$this$removeSurroundingQuotes, (CharSequence)"\""), (CharSequence)"'");
    }

    @NotNull
    public static final LookupElementBuilder createDataSourceLookupElement(@NotNull String lookupString) {
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        Object[] objectArray = new String[]{lookupString, "[" + lookupString + "]"};
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)lookupString).withLookupStrings((Collection)CollectionsKt.listOf((Object[])objectArray)).withPresentableText("[" + lookupString + "]");
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withPresentableText(...)");
        return RawWatchFaceUtilsKt.insertBracketsAroundIfNeeded(lookupElementBuilder);
    }

    public static final boolean isUserConfiguration(@NotNull WFFExpressionDataSource $this$isUserConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$isUserConfiguration, (String)"<this>");
        String string = $this$isUserConfiguration.getId().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.startsWith$default((String)string, (String)"CONFIGURATION.", (boolean)false, (int)2, null);
    }

    public static final boolean isReference(@NotNull WFFExpressionDataSource $this$isReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isReference, (String)"<this>");
        String string = $this$isReference.getId().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.startsWith$default((String)string, (String)"REFERENCE.", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final DataSource findDataSourceDefinition(@NotNull WFFExpressionDataSource $this$findDataSourceDefinition) {
        DataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)$this$findDataSourceDefinition, (String)"<this>");
        PsiElement psiElement = $this$findDataSourceDefinition.getId();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getId(...)");
        if (RawWatchFaceUtilsKt.isComplicationDataSource(psiElement)) {
            PsiElement psiElement2 = $this$findDataSourceDefinition.getId();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getId(...)");
            dataSource = RawWatchFaceUtilsKt.findComplicationDataSource(psiElement2);
        } else {
            PsiElement psiElement3 = $this$findDataSourceDefinition.getId();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getId(...)");
            StaticDataSource staticDataSource = RawWatchFaceUtilsKt.findStaticDataSource(psiElement3);
            if (staticDataSource != null) {
                dataSource = staticDataSource;
            } else {
                PsiElement psiElement4 = $this$findDataSourceDefinition.getId();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getId(...)");
                dataSource = RawWatchFaceUtilsKt.findPatternDataSource(psiElement4);
            }
        }
        return dataSource;
    }

    private static final boolean isComplicationDataSource(PsiElement $this$isComplicationDataSource) {
        String string = $this$isComplicationDataSource.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.startsWith$default((String)string, (String)"COMPLICATION.", (boolean)false, (int)2, null);
    }

    private static final StaticDataSource findComplicationDataSource(PsiElement $this$findComplicationDataSource) {
        StaticDataSource staticDataSource;
        XmlTag xmlTag = PsiImplUtilKt.getParentComplicationTag($this$findComplicationDataSource);
        String complicationType = xmlTag != null && (xmlTag = xmlTag.getAttribute("type")) != null ? xmlTag.getValue() : null;
        Set<StaticDataSource> set2 = WFFConstants.DataSources.INSTANCE.getCOMPLICATION_BY_TYPE().get(complicationType);
        if (set2 != null) {
            Object v2;
            block3: {
                Iterable iterable = set2;
                for (Object t : iterable) {
                    StaticDataSource it = (StaticDataSource)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)$this$findComplicationDataSource.getText())) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            staticDataSource = v2;
        } else {
            staticDataSource = null;
        }
        return staticDataSource;
    }

    private static final StaticDataSource findStaticDataSource(PsiElement $this$findStaticDataSource) {
        return WFFConstants.DataSources.INSTANCE.getALL_STATIC_BY_ID().get($this$findStaticDataSource.getText());
    }

    private static final PatternedDataSource findPatternDataSource(PsiElement $this$findPatternDataSource) {
        Object v2;
        block1: {
            Iterable iterable = WFFConstants.DataSources.INSTANCE.getALL_PATTERNS();
            for (Object t : iterable) {
                PatternedDataSource it = (PatternedDataSource)t;
                boolean bl = false;
                Regex regex = it.getPattern();
                String string = $this$findPatternDataSource.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!regex.matches((CharSequence)string)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final void insertBracketsAroundIfNeeded$lambda$0(InsertionContext context, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        RawWatchFaceUtilsKt.insertBracketsAroundIfNeeded(context, lookupElement);
    }
}

