/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentCategoryTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentTreeNode;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/welcome/install/AndroidPlatformSdkComponentTreeNode;", "Lcom/android/tools/idea/welcome/install/InstallableSdkComponentTreeNode;", "name", "", "description", "myVersion", "Lcom/android/sdklib/AndroidVersion;", "myIsDefaultPlatform", "", "installUpdates", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/sdklib/AndroidVersion;ZZ)V", "requiredSdkPackages", "", "getRequiredSdkPackages", "()Ljava/util/Collection;", "optionalSdkPackages", "getOptionalSdkPackages", "sdkComponentsMetricKind", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SdkInstallationMetrics$SdkComponentKind;", "findLatestCompatibleBuildTool", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "isOptionalForSdkLocation", "isSelectedByDefault", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidPlatformSdkComponentTreeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPlatformSdkComponentTreeNode.kt\ncom/android/tools/idea/welcome/install/AndroidPlatformSdkComponentTreeNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class AndroidPlatformSdkComponentTreeNode
extends InstallableSdkComponentTreeNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;

    public AndroidPlatformSdkComponentTreeNode(@NotNull String name2, @NotNull String description2, @NotNull AndroidVersion myVersion, boolean myIsDefaultPlatform, boolean installUpdates) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)myVersion, (String)"myVersion");
        super(name2, description2, installUpdates);
        this.myVersion = myVersion;
        this.myIsDefaultPlatform = myIsDefaultPlatform;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        List requests2;
        block0: {
            Object[] objectArray = new String[]{DetailsTypes.getPlatformPath((AndroidVersion)this.myVersion)};
            requests2 = CollectionsKt.mutableListOf((Object[])objectArray);
            String string = this.findLatestCompatibleBuildTool();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            requests2.add(it);
        }
        return requests2;
    }

    @Override
    @NotNull
    protected Collection<String> getOptionalSdkPackages() {
        return CollectionsKt.listOf((Object)DetailsTypes.getSourcesPath((AndroidVersion)this.myVersion));
    }

    @Override
    @NotNull
    public SetupWizardEvent.SdkInstallationMetrics.SdkComponentKind sdkComponentsMetricKind() {
        return SetupWizardEvent.SdkInstallationMetrics.SdkComponentKind.ANDROID_PLATFORM;
    }

    private final String findLatestCompatibleBuildTool() {
        Revision revision = null;
        String path = null;
        for (RemotePackage remote : this.getRepositoryPackages().getRemotePackages().values()) {
            Revision testRevision;
            String string = remote.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"build-tools", (boolean)false, (int)2, null) || (testRevision = remote.getVersion()).getMajor() != this.myVersion.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
            revision = testRevision;
            path = remote.getPath();
        }
        return path;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)installContext, (String)"installContext");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
    }

    @Override
    public boolean isOptionalForSdkLocation() {
        List locals = AndroidPlatformSdkComponentTreeNode.Companion.getInstalledPlatformVersions(this.sdkHandler);
        if (locals.isEmpty()) {
            return !this.myIsDefaultPlatform;
        }
        for (AndroidVersion androidVersion : locals) {
            int apiLevel = androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00132\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/welcome/install/AndroidPlatformSdkComponentTreeNode$Companion;", "", "<init>", "()V", "getPlatformToInstall", "Lcom/android/tools/idea/welcome/install/AndroidPlatformSdkComponentTreeNode;", "remotePackages", "", "Lcom/android/repository/api/RemotePackage;", "installUpdates", "", "api", "", "getInstalledPlatformVersions", "", "Lcom/android/sdklib/AndroidVersion;", "handler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "createSubtree", "Lcom/android/tools/idea/welcome/install/SdkComponentTreeNode;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final AndroidPlatformSdkComponentTreeNode getPlatformToInstall(Collection<? extends RemotePackage> remotePackages, boolean installUpdates, int api) {
            AndroidVersion version2 = new AndroidVersion(api).withBaseExtensionLevel();
            Intrinsics.checkNotNull((Object)version2);
            String versionName2 = AndroidVersionUtils.getFullReleaseName((AndroidVersion)version2, (boolean)true, (boolean)true);
            String description2 = "Android platform libraries for targeting platform: " + versionName2;
            return new AndroidPlatformSdkComponentTreeNode(versionName2, description2, version2, !version2.isPreview(), installUpdates);
        }

        private final List<AndroidVersion> getInstalledPlatformVersions(AndroidSdkHandler handler2) {
            List result2 = new ArrayList();
            if (handler2 != null) {
                RepositoryPackages packages = handler2.getRepoManagerAndLoadSynchronously((ProgressIndicator)new StudioLoggerProgressIndicator(AndroidPlatformSdkComponentTreeNode.class)).getPackages();
                for (LocalPackage p : packages.getLocalPackages().values()) {
                    if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
                    TypeDetails typeDetails = p.getTypeDetails();
                    Intrinsics.checkNotNull((Object)typeDetails, (String)"null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
                    AndroidVersion androidVersion = ((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"getAndroidVersion(...)");
                    result2.add(androidVersion);
                }
            }
            return result2;
        }

        @JvmOverloads
        @NotNull
        public final SdkComponentTreeNode createSubtree(@NotNull Collection<? extends RemotePackage> remotePackages, boolean installUpdates, int api) {
            Intrinsics.checkNotNullParameter(remotePackages, (String)"remotePackages");
            AndroidPlatformSdkComponentTreeNode platformToInstall = this.getPlatformToInstall(remotePackages, installUpdates, api);
            return new SdkComponentCategoryTreeNode("Android SDK Platform", "SDK components for creating applications for different Android platforms", CollectionsKt.listOf((Object)platformToInstall));
        }

        public static /* synthetic */ SdkComponentTreeNode createSubtree$default(Companion companion, Collection collection2, boolean bl, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                Object t = StudioFlags.NPW_COMPILE_SDK_VERSION.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                n = ((Number)t).intValue();
            }
            return companion.createSubtree(collection2, bl, n);
        }

        @JvmOverloads
        @NotNull
        public final SdkComponentTreeNode createSubtree(@NotNull Collection<? extends RemotePackage> remotePackages, boolean installUpdates) {
            Intrinsics.checkNotNullParameter(remotePackages, (String)"remotePackages");
            return com.android.tools.idea.welcome.install.AndroidPlatformSdkComponentTreeNode$Companion.createSubtree$default(this, remotePackages, installUpdates, 0, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

