/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.annotations.concurrency.Slow;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Uninstaller;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.ThrottledProgressWrapper;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.ApplicationUtils;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.install.CheckSdkOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallSdkComponentsOperation;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Function;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ>\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018J.\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J&\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/welcome/install/SdkComponentInstaller;", "", "<init>", "()V", "getPackagesToInstall", "", "Lcom/android/repository/api/RemotePackage;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "components", "", "Lcom/android/tools/idea/welcome/install/InstallableSdkComponentTreeNode;", "installComponents", "", "installableSdkComponents", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "installerTimestamp", "", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "localHandler", "destination", "Ljava/io/File;", "installPackages", "packages", "downloader", "Lcom/android/repository/api/Downloader;", "progress", "Lcom/android/repository/api/ProgressIndicator;", "ensureSdkPackagesUninstalled", "packageNames", "SetPreference", "ConfigureComponents", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSdkComponentInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkComponentInstaller.kt\ncom/android/tools/idea/welcome/install/SdkComponentInstaller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1368#2:216\n1454#2,5:217\n1557#2:222\n1628#2,3:223\n1557#2:226\n1628#2,3:227\n1863#2,2:230\n1557#2:232\n1628#2,3:233\n1863#2,2:236\n*S KotlinDebug\n*F\n+ 1 SdkComponentInstaller.kt\ncom/android/tools/idea/welcome/install/SdkComponentInstaller\n*L\n49#1:216\n49#1:217,5\n50#1:222\n50#1:223,3\n113#1:226\n113#1:227,3\n114#1:230,2\n170#1:232\n170#1:233,3\n171#1:236,2\n*E\n"})
public final class SdkComponentInstaller {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemotePackage> getPackagesToInstall(@NotNull AndroidSdkHandler sdkHandler, @NotNull Iterable<? extends InstallableSdkComponentTreeNode> components) throws SdkQuickfixUtils.PackageResolutionException {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        InstallableSdkComponentTreeNode it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)progress2);
        Iterable<? extends InstallableSdkComponentTreeNode> $this$flatMap$iv = components;
        boolean $i$f$flatMap = false;
        Iterable<? extends InstallableSdkComponentTreeNode> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (InstallableSdkComponentTreeNode)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getPackagesToInstall();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List requests2 = (List)destination$iv$iv;
        List<UpdatablePackage> list = SdkQuickfixUtils.resolve(requests2, sdkManager.getPackages());
        Intrinsics.checkNotNullExpressionValue(list, (String)"resolve(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (UpdatablePackage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            RemotePackage remotePackage = it.getRemote();
            Intrinsics.checkNotNull((Object)remotePackage);
            collection2.add(remotePackage);
        }
        return (List)destination$iv$iv;
    }

    public final void installComponents(@NotNull Collection<? extends InstallableSdkComponentTreeNode> installableSdkComponents, @NotNull InstallContext installContext, @Nullable String installerTimestamp, @NotNull ModalityState modalityState, @NotNull AndroidSdkHandler localHandler, @NotNull File destination) throws WizardException {
        Intrinsics.checkNotNullParameter(installableSdkComponents, (String)"installableSdkComponents");
        Intrinsics.checkNotNullParameter((Object)installContext, (String)"installContext");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)localHandler, (String)"localHandler");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (installableSdkComponents.isEmpty()) {
            installContext.print("Nothing to do!", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        double INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE = 1.0;
        InstallSdkComponentsOperation install2 = new InstallSdkComponentsOperation(installContext, localHandler, installableSdkComponents, this, INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE);
        try {
            install2.then(new SetPreference(installerTimestamp, modalityState)).then(new ConfigureComponents(installContext, installableSdkComponents, localHandler)).then(new CheckSdkOperation(installContext)).execute(destination);
        }
        catch (InstallationCancelledException e) {
            installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    public final void installPackages(@NotNull AndroidSdkHandler sdkHandler, @NotNull List<? extends RemotePackage> packages, @NotNull Downloader downloader, @NotNull ProgressIndicator progress2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        RepoManager sdkManager = sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        ThrottledProgressWrapper throttledProgress = new ThrottledProgressWrapper(progress2);
        double progressMax = 0.0;
        double progressIncrement = 0.9 / ((double)packages.size() * 2.0);
        BasicInstallerFactory factory2 = new BasicInstallerFactory();
        Iterable iterable = packages;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RemotePackage remotePackage = (RemotePackage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(factory2.createInstaller((RemotePackage)it, sdkManager, downloader));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Installer installer = (Installer)element$iv;
            boolean bl = false;
            if (installer.prepare(throttledProgress.createSubProgress(progressMax += progressIncrement))) {
                installer.complete(throttledProgress.createSubProgress(progressMax + progressIncrement));
            }
            throttledProgress.setFraction(progressMax += progressIncrement);
        }
        ProgressIndicator progressIndicator = throttledProgress.createSubProgress(1.0);
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"createSubProgress(...)");
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progressIndicator, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    public final void ensureSdkPackagesUninstalled(@NotNull AndroidSdkHandler sdkHandler, @NotNull Collection<String> packageNames, @NotNull ProgressIndicator progress2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        RepoManager sdkManager = sdkHandler.getRepoManagerAndLoadSynchronously(progress2);
        Map localPackages = sdkManager.getPackages().getLocalPackages();
        List packagesToUninstall = new ArrayList();
        for (String packageName : packageNames) {
            LocalPackage p = (LocalPackage)localPackages.get(packageName);
            if (p != null) {
                packagesToUninstall.add(p);
                continue;
            }
            progress2.logInfo("Package '" + packageName + "' does not appear to be installed - ignoring");
        }
        double progressMax = 0.0;
        double progressIncrement = 0.9 / ((double)packagesToUninstall.size() * 2.0);
        InstallerFactory factory2 = (InstallerFactory)new BasicInstallerFactory();
        Iterable iterable = packagesToUninstall;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalPackage localPackage = (LocalPackage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(factory2.createUninstaller((LocalPackage)it, sdkManager));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Uninstaller uninstaller = (Uninstaller)element$iv;
            boolean bl = false;
            if (uninstaller.prepare(progress2.createSubProgress(progressMax += progressIncrement))) {
                uninstaller.complete(progress2.createSubProgress(progressMax + progressIncrement));
            }
            progress2.setFraction(progressMax += progressIncrement);
        }
        ProgressIndicator progressIndicator = progress2.createSubProgress(1.0);
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"createSubProgress(...)");
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progressIndicator, null, null);
        progress2.setFraction(1.0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/welcome/install/SdkComponentInstaller$ConfigureComponents;", "Lcom/google/common/base/Function;", "Ljava/io/File;", "myInstallContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "mySelectedComponents", "", "Lcom/android/tools/idea/welcome/install/InstallableSdkComponentTreeNode;", "mySdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "<init>", "(Lcom/android/tools/idea/welcome/install/InstallContext;Ljava/util/Collection;Lcom/android/sdklib/repository/AndroidSdkHandler;)V", "apply", "input", "intellij.android.core"})
    private static final class ConfigureComponents
    implements Function<File, File> {
        @NotNull
        private final InstallContext myInstallContext;
        @NotNull
        private final Collection<InstallableSdkComponentTreeNode> mySelectedComponents;
        @NotNull
        private final AndroidSdkHandler mySdkHandler;

        public ConfigureComponents(@NotNull InstallContext myInstallContext, @NotNull Collection<? extends InstallableSdkComponentTreeNode> mySelectedComponents, @NotNull AndroidSdkHandler mySdkHandler) {
            Intrinsics.checkNotNullParameter((Object)myInstallContext, (String)"myInstallContext");
            Intrinsics.checkNotNullParameter(mySelectedComponents, (String)"mySelectedComponents");
            Intrinsics.checkNotNullParameter((Object)mySdkHandler, (String)"mySdkHandler");
            this.myInstallContext = myInstallContext;
            this.mySelectedComponents = mySelectedComponents;
            this.mySdkHandler = mySdkHandler;
        }

        @NotNull
        public File apply(@NotNull File input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            for (InstallableSdkComponentTreeNode component : this.mySelectedComponents) {
                component.configure(this.myInstallContext, this.mySdkHandler);
            }
            return input2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/welcome/install/SdkComponentInstaller$SetPreference;", "Lcom/google/common/base/Function;", "Ljava/io/File;", "myInstallerTimestamp", "", "myModalityState", "Lcom/intellij/openapi/application/ModalityState;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/application/ModalityState;)V", "apply", "input", "intellij.android.core"})
    private static final class SetPreference
    implements Function<File, File> {
        @Nullable
        private final String myInstallerTimestamp;
        @NotNull
        private final ModalityState myModalityState;

        public SetPreference(@Nullable String myInstallerTimestamp, @NotNull ModalityState myModalityState) {
            Intrinsics.checkNotNullParameter((Object)myModalityState, (String)"myModalityState");
            this.myInstallerTimestamp = myInstallerTimestamp;
            this.myModalityState = myModalityState;
        }

        @NotNull
        public File apply(@NotNull File input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            ApplicationUtils.invokeWriteActionAndWait(this.myModalityState, () -> SetPreference.apply$lambda$0(input2, this));
            return input2;
        }

        private static final void apply$lambda$0(File $input, SetPreference this$0) {
            IdeSdks.getInstance().setAndroidSdkPath($input);
            AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this$0.myInstallerTimestamp);
        }
    }
}

