/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.tools.idea.welcome.install.InstallContext;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkManagerProgressIndicatorIntegration
extends ProgressIndicatorAdapter {
    private final ProgressIndicator myIndicator;
    private final InstallContext myContext;
    private StringBuffer myErrors = new StringBuffer();

    public SdkManagerProgressIndicatorIntegration(@NotNull ProgressIndicator indicator, @NotNull InstallContext context) {
        this.myIndicator = indicator;
        this.myContext = context;
    }

    public boolean isCanceled() {
        return this.myIndicator.isCanceled();
    }

    public void cancel() {
        this.myIndicator.cancel();
    }

    public double getFraction() {
        return this.myIndicator.getFraction();
    }

    public void setFraction(double progress2) {
        this.myIndicator.setFraction(progress2);
    }

    public void setText(@Nullable String title2) {
        this.myIndicator.setText(title2);
    }

    public void setSecondaryText(@Nullable String s) {
        this.myIndicator.setText2(s);
    }

    public void logInfo(@NotNull String s) {
        this.myContext.print(s, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void logError(@NotNull String s, @Nullable Throwable e) {
        if (e != null) {
            String message = String.format("%s: %s\n", e.getClass().getName(), e.getMessage());
            this.myErrors.append(message);
            this.myContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
        }
        this.myContext.print(s, ConsoleViewContentType.ERROR_OUTPUT);
        this.myErrors.append(s);
    }

    public void logWarning(@NotNull String s, @Nullable Throwable e) {
        String message;
        if (e != null) {
            message = String.format("%s: %s\n", e.getClass().getName(), e.getMessage());
            this.myContext.print(message, ConsoleViewContentType.LOG_WARNING_OUTPUT);
            this.myErrors.append(message);
        }
        message = String.format("Warning: %s\n", s);
        this.myContext.print(message, ConsoleViewContentType.LOG_WARNING_OUTPUT);
        this.myErrors.append(message);
    }

    public String getErrors() {
        return this.myErrors.toString();
    }
}

