/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.annotations.concurrency.UiThread;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentTreeNode;
import com.android.tools.idea.welcome.wizard.SdkComponentsStepController;
import com.android.tools.idea.welcome.wizard.SdkComponentsStepUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0018J\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\u0018H&J\b\u0010\u001d\u001a\u00020\u0018H&J\b\u0010\u001e\u001a\u00020\u0018H&J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u001c\u0010&\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010!H&J\u0016\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u0006\u0010,\u001a\u00020\u0018J\u0016\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020\u0018H&R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00062"}, d2={"Lcom/android/tools/idea/welcome/wizard/SdkComponentsStepController;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "rootNode", "Lcom/android/tools/idea/welcome/install/SdkComponentTreeNode;", "localSdkHandlerProperty", "Lcom/android/tools/idea/observable/core/ObjectValueProperty;", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;Lcom/android/tools/idea/welcome/install/SdkComponentTreeNode;Lcom/android/tools/idea/observable/core/ObjectValueProperty;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "loadingJob", "Lkotlinx/coroutines/Job;", "userEditedPath", "", "sdkDirectoryValidationResult", "Lcom/android/tools/adtui/validation/Validator$Result;", "wasForcedVisible", "loading", "dispose", "", "startLoading", "stopLoading", "loadingError", "onLoadingStarted", "onLoadingFinished", "onLoadingError", "validate", "path", "", "componentsSize", "", "getComponentsSize", "()J", "setError", "icon", "Ljavax/swing/Icon;", "message", "isStepVisible", "isCustomInstall", "warnIfRequiredComponentsUnavailable", "onPathUpdated", "sdkPath", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "reloadLicenseAgreementStep", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSdkComponentsStepController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkComponentsStepController.kt\ncom/android/tools/idea/welcome/wizard/SdkComponentsStepController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public abstract class SdkComponentsStepController
implements Disposable {
    @Nullable
    private final Project project;
    @NotNull
    private final FirstRunWizardMode mode;
    @NotNull
    private final SdkComponentTreeNode rootNode;
    @NotNull
    private final ObjectValueProperty<AndroidSdkHandler> localSdkHandlerProperty;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Job loadingJob;
    private boolean userEditedPath;
    @NotNull
    private Validator.Result sdkDirectoryValidationResult;
    private boolean wasForcedVisible;
    private boolean loading;

    public SdkComponentsStepController(@Nullable Project project, @NotNull FirstRunWizardMode mode, @NotNull SdkComponentTreeNode rootNode, @NotNull ObjectValueProperty<AndroidSdkHandler> localSdkHandlerProperty) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter(localSdkHandlerProperty, (String)"localSdkHandlerProperty");
        this.project = project;
        this.mode = mode;
        this.rootNode = rootNode;
        this.localSdkHandlerProperty = localSdkHandlerProperty;
        this.coroutineScope = CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        this.sdkDirectoryValidationResult = Validator.Result.OK;
    }

    public void dispose() {
    }

    public final void startLoading() {
        this.loading = true;
        this.onLoadingStarted();
    }

    public final void stopLoading() {
        this.loading = false;
        this.onLoadingFinished();
    }

    public final void loadingError() {
        this.loading = false;
        this.onLoadingError();
    }

    public abstract void onLoadingStarted();

    public abstract void onLoadingFinished();

    public abstract void onLoadingError();

    public final boolean validate(@NotNull String path) {
        String message;
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!(((CharSequence)path).length() == 0)) {
            this.userEditedPath = true;
        }
        PathValidator pathValidator = PathValidator.Companion.forAndroidSdkLocation();
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.sdkDirectoryValidationResult = pathValidator.validate(path2);
        Validator.Severity severity = this.sdkDirectoryValidationResult.getSeverity();
        boolean ok2 = severity == Validator.Severity.OK;
        String it = string = this.sdkDirectoryValidationResult.getMessage();
        boolean bl = false;
        String string2 = message = !ok2 ? string : null;
        if (ok2) {
            File filesystem = SdkComponentsStepUtils.getTargetFilesystem(path);
            if (filesystem != null && filesystem.getFreeSpace() < this.getComponentsSize()) {
                severity = Validator.Severity.ERROR;
                message = "Target drive does not have enough free space.";
            } else if (SdkComponentsStepUtils.isNonEmptyNonSdk(path)) {
                severity = Validator.Severity.WARNING;
                message = "Target folder is neither empty nor does it point to an existing SDK installation.";
            } else if (SdkComponentsStepUtils.isExistingSdk(path)) {
                severity = Validator.Severity.WARNING;
                message = "An existing Android SDK was detected. The setup wizard will only download missing or outdated SDK components.";
            }
        }
        it = string = message;
        Icon icon = severity.getIcon();
        SdkComponentsStepController sdkComponentsStepController = this;
        boolean bl2 = false;
        boolean bl3 = this.userEditedPath;
        sdkComponentsStepController.setError(icon, bl3 ? string : null);
        if (this.loading) {
            return false;
        }
        return this.sdkDirectoryValidationResult.getSeverity() != Validator.Severity.ERROR;
    }

    /*
     * WARNING - void declaration
     */
    public final long getComponentsSize() {
        Iterable iterable = this.rootNode.getChildrenToInstall();
        long l = 0L;
        for (Object t : iterable) {
            void it;
            InstallableSdkComponentTreeNode installableSdkComponentTreeNode = (InstallableSdkComponentTreeNode)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getDownloadSize();
            l = l2 + l3;
        }
        return l;
    }

    public abstract void setError(@Nullable Icon var1, @Nullable String var2);

    public final boolean isStepVisible(boolean isCustomInstall, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.wasForcedVisible) {
            return true;
        }
        if (this.mode.hasValidSdkLocation()) {
            return false;
        }
        if (isCustomInstall) {
            return true;
        }
        this.validate(path);
        this.wasForcedVisible = this.sdkDirectoryValidationResult.getSeverity() != Validator.Severity.OK;
        return this.wasForcedVisible;
    }

    public final void warnIfRequiredComponentsUnavailable() {
        if (!SdkComponentTreeNode.Companion.areAllRequiredComponentsAvailable(this.rootNode)) {
            Messages.showWarningDialog((String)"Some required components are not available.\nYou can continue, but some functionality may not work correctly until they are installed.", (String)"Required Component Missing");
        }
    }

    public final boolean onPathUpdated(@NotNull String sdkPath, @NotNull ModalityState modalityState) {
        File currentSdkLocation;
        Intrinsics.checkNotNullParameter((Object)sdkPath, (String)"sdkPath");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        File sdkLocation = new File(sdkPath);
        Path path = this.localSdkHandlerProperty.get().getLocation();
        File file = currentSdkLocation = path != null ? path.toFile() : null;
        if (!FileUtil.filesEqual((File)currentSdkLocation, (File)sdkLocation)) {
            if (((CharSequence)sdkPath).length() == 0) {
                return false;
            }
            AndroidSdkHandler localHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), (Path)this.localSdkHandlerProperty.get().toCompatiblePath(sdkLocation));
            this.localSdkHandlerProperty.set(localHandler);
            StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
            this.startLoading();
            Job job2 = this.loadingJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.loadingJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(localHandler, progress2, this, modalityState, null){
                int label;
                final /* synthetic */ AndroidSdkHandler $localHandler;
                final /* synthetic */ StudioLoggerProgressIndicator $progress;
                final /* synthetic */ SdkComponentsStepController this$0;
                final /* synthetic */ ModalityState $modalityState;
                {
                    this.$localHandler = $localHandler;
                    this.$progress = $progress;
                    this.this$0 = $receiver;
                    this.$modalityState = $modalityState;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            RepoManager.loadSynchronously$default((RepoManager)this.$localHandler.getRepoManager((ProgressIndicator)this.$progress), (long)RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, arg_0 -> onPathUpdated.1.invokeSuspend$lambda$0(this.this$0, this.$localHandler, this.$modalityState, arg_0), () -> onPathUpdated.1.invokeSuspend$lambda$1(this.this$0, this.$modalityState), (ProgressRunner)((ProgressRunner)new StudioProgressRunner(false, "Finding Available SDK Components", SdkComponentsStepController.access$getProject$p(this.this$0), null, 8, null)), (Downloader)new StudioDownloader(), (SettingsController)StudioSettingsController.getInstance(), (int)2, null);
                            BuildersKt.launch$default((CoroutineScope)SdkComponentsStepController.access$getCoroutineScope$p(this.this$0), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus(ModalityKt.asContextElement((ModalityState)this.$modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ SdkComponentsStepController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.this$0.reloadLicenseAgreementStep();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$0(SdkComponentsStepController this$0, AndroidSdkHandler $localHandler, ModalityState $modalityState, RepositoryPackages it) {
                    SdkComponentTreeNode sdkComponentTreeNode = SdkComponentsStepController.access$getRootNode$p(this$0);
                    Intrinsics.checkNotNull((Object)$localHandler);
                    sdkComponentTreeNode.updateState($localHandler);
                    BuildersKt.launch$default((CoroutineScope)SdkComponentsStepController.access$getCoroutineScope$p(this$0), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus(ModalityKt.asContextElement((ModalityState)$modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                        int label;
                        final /* synthetic */ SdkComponentsStepController this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.this$0.stopLoading();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }

                private static final void invokeSuspend$lambda$1(SdkComponentsStepController this$0, ModalityState $modalityState) {
                    BuildersKt.launch$default((CoroutineScope)SdkComponentsStepController.access$getCoroutineScope$p(this$0), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus(ModalityKt.asContextElement((ModalityState)$modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                        int label;
                        final /* synthetic */ SdkComponentsStepController this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.this$0.loadingError();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }), (int)2, null);
            return true;
        }
        return false;
    }

    public abstract void reloadLicenseAgreementStep();

    public static final /* synthetic */ Project access$getProject$p(SdkComponentsStepController $this) {
        return $this.project;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(SdkComponentsStepController $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ SdkComponentTreeNode access$getRootNode$p(SdkComponentsStepController $this) {
        return $this.rootNode;
    }
}

