/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.annotations.concurrency.UiThread;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.wizard.ConfirmFirstRunWizardCloseDialog;
import com.android.tools.idea.welcome.wizard.FirstRunWelcomeStep;
import com.android.tools.idea.welcome.wizard.FirstRunWizardModel;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.InstallComponentsProgressStep;
import com.android.tools.idea.welcome.wizard.InstallSummaryStep;
import com.android.tools.idea.welcome.wizard.InstallationTypeWizardStep;
import com.android.tools.idea.welcome.wizard.LinuxKvmInfoStep;
import com.android.tools.idea.welcome.wizard.MissingSdkAlertStep;
import com.android.tools.idea.welcome.wizard.SdkComponentsStep;
import com.android.tools.idea.welcome.wizard.deprecated.CancelableWelcomeWizard;
import com.android.tools.idea.welcome.wizard.deprecated.WelcomeScreenWindowListener;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.StudioWizardDialogBuilder;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/welcome/wizard/StudioFirstRunWelcomeScreen;", "Lcom/intellij/openapi/wm/WelcomeScreen;", "mode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "sdkComponentInstaller", "Lcom/android/tools/idea/welcome/install/SdkComponentInstaller;", "tracker", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;", "<init>", "(Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;Lcom/android/tools/idea/welcome/install/SdkComponentInstaller;Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;)V", "modelWizard", "Lcom/android/tools/idea/wizard/model/ModelWizard;", "mainPanel", "Ljavax/swing/JComponent;", "frame", "Ljavax/swing/JFrame;", "setupWizard", "", "getWelcomePanel", "setupFrame", "dispose", "closeDialog", "shouldPreventWizardCancel", "", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nStudioFirstRunWelcomeScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioFirstRunWelcomeScreen.kt\ncom/android/tools/idea/welcome/wizard/StudioFirstRunWelcomeScreen\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,248:1\n75#2:249\n*S KotlinDebug\n*F\n+ 1 StudioFirstRunWelcomeScreen.kt\ncom/android/tools/idea/welcome/wizard/StudioFirstRunWelcomeScreen\n*L\n225#1:249\n*E\n"})
public final class StudioFirstRunWelcomeScreen
implements WelcomeScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirstRunWizardMode mode;
    @NotNull
    private final SdkComponentInstaller sdkComponentInstaller;
    @NotNull
    private final FirstRunWizardTracker tracker;
    private ModelWizard modelWizard;
    @Nullable
    private JComponent mainPanel;
    @Nullable
    private JFrame frame;

    public StudioFirstRunWelcomeScreen(@NotNull FirstRunWizardMode mode, @NotNull SdkComponentInstaller sdkComponentInstaller, @NotNull FirstRunWizardTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)sdkComponentInstaller, (String)"sdkComponentInstaller");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.mode = mode;
        this.sdkComponentInstaller = sdkComponentInstaller;
        this.tracker = tracker;
    }

    private final void setupWizard() {
        File initialSdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(this.mode);
        Path path = initialSdkLocation.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        FirstRunWizardModel model = new FirstRunWizardModel(this.mode, path, true, this.sdkComponentInstaller, this.tracker);
        this.modelWizard = Companion.buildWizard(model, this.mode, this::shouldPreventWizardCancel, this.tracker);
        ModelWizard modelWizard2 = this.modelWizard;
        if (modelWizard2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modelWizard");
            modelWizard2 = null;
        }
        ModelWizardDialog modelWizardDialog = new StudioWizardDialogBuilder(modelWizard2, "").setCancellationPolicy(ModelWizardDialog.CancellationPolicy.CAN_CANCEL_UNTIL_CAN_FINISH).setUndecorated(true).build();
        this.mainPanel = modelWizardDialog.getContentPanel();
        modelWizardDialog.getPeer().setContentPane((JComponent)new JPanel());
        Disposer.register((Disposable)((Disposable)this), (Disposable)modelWizardDialog.getDisposable());
        Disposable disposable = (Disposable)this;
        ModelWizard modelWizard3 = this.modelWizard;
        if (modelWizard3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modelWizard");
            modelWizard3 = null;
        }
        Disposer.register((Disposable)disposable, (Disposable)modelWizard3);
        ModelWizard modelWizard4 = this.modelWizard;
        if (modelWizard4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modelWizard");
            modelWizard4 = null;
        }
        modelWizard4.addResultListener(new ModelWizard.WizardListener(this){
            final /* synthetic */ StudioFirstRunWelcomeScreen this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWizardFinished(ModelWizard.WizardResult wizardResult) {
                Intrinsics.checkNotNullParameter((Object)((Object)wizardResult), (String)"wizardResult");
                StudioFirstRunWelcomeScreen.access$closeDialog(this.this$0);
                StudioFirstRunWelcomeScreen.access$getTracker$p(this.this$0).trackWizardFinished(wizardResult == ModelWizard.WizardResult.FINISHED ? SetupWizardEvent.CompletionStatus.FINISHED : SetupWizardEvent.CompletionStatus.CANCELED);
            }
        });
    }

    @NotNull
    public JComponent getWelcomePanel() {
        this.tracker.trackWizardStarted();
        if (this.mainPanel == null) {
            ApplicationManager.getApplication().invokeAndWait(() -> StudioFirstRunWelcomeScreen.getWelcomePanel$lambda$0(this));
        }
        JComponent jComponent = this.mainPanel;
        Intrinsics.checkNotNull((Object)jComponent);
        return jComponent;
    }

    public void setupFrame(@NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
        JFrame $this$setupFrame_u24lambda_u241 = frame;
        boolean bl = false;
        $this$setupFrame_u24lambda_u241.setTitle(IdeInfo.getInstance().isAndroidStudio() ? AndroidBundle.message("android.as.wizard.welcome.dialog.title", new Object[0]) : AndroidBundle.message("android.ij.wizard.welcome.dialog.title", new Object[0]));
        $this$setupFrame_u24lambda_u241.pack();
        $this$setupFrame_u24lambda_u241.setLocationRelativeTo(null);
        WelcomeScreenWindowListener.install($this$setupFrame_u24lambda_u241, new CancelableWelcomeWizard(this){
            final /* synthetic */ StudioFirstRunWelcomeScreen this$0;
            {
                this.this$0 = $receiver;
            }

            @UiThread
            public void cancel() {
                ModelWizard modelWizard2 = StudioFirstRunWelcomeScreen.access$getModelWizard$p(this.this$0);
                if (modelWizard2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modelWizard");
                    modelWizard2 = null;
                }
                modelWizard2.cancel();
            }

            @UiThread
            public boolean isActive() {
                ModelWizard modelWizard2 = StudioFirstRunWelcomeScreen.access$getModelWizard$p(this.this$0);
                if (modelWizard2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modelWizard");
                    modelWizard2 = null;
                }
                return !modelWizard2.isFinished();
            }
        });
    }

    public void dispose() {
    }

    private final void closeDialog() {
        JFrame jFrame = this.frame;
        if (jFrame != null) {
            jFrame.setVisible(false);
        }
        JFrame jFrame2 = this.frame;
        if (jFrame2 != null) {
            jFrame2.dispose();
        }
        boolean $i$f$isHeadlessEnvironment = false;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            WelcomeFrame.Companion.showNow();
        }
    }

    private final boolean shouldPreventWizardCancel() {
        ConfirmFirstRunWizardCloseDialog.Result result2 = ConfirmFirstRunWizardCloseDialog.show();
        return switch (result2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1 -> {
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.mode.getInstallerTimestamp());
                yield false;
            }
            case 2 -> false;
            case 3 -> true;
            default -> throw new RuntimeException("Invalid Close result");
        };
    }

    private static final void getWelcomePanel$lambda$0(StudioFirstRunWelcomeScreen this$0) {
        this$0.setupWizard();
    }

    public static final /* synthetic */ void access$closeDialog(StudioFirstRunWelcomeScreen $this) {
        $this.closeDialog();
    }

    public static final /* synthetic */ FirstRunWizardTracker access$getTracker$p(StudioFirstRunWelcomeScreen $this) {
        return $this.tracker;
    }

    public static final /* synthetic */ ModelWizard access$getModelWizard$p(StudioFirstRunWelcomeScreen $this) {
        return $this.modelWizard;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/welcome/wizard/StudioFirstRunWelcomeScreen$Companion;", "", "<init>", "()V", "buildWizard", "Lcom/android/tools/idea/wizard/model/ModelWizard;", "model", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel;", "mode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "cancelInterceptor", "Ljava/util/function/BooleanSupplier;", "tracker", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelWizard buildWizard(@NotNull FirstRunWizardModel model, @NotNull FirstRunWizardMode mode, @NotNull BooleanSupplier cancelInterceptor, @NotNull FirstRunWizardTracker tracker) {
            ModelWizard.Builder builder;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)cancelInterceptor, (String)"cancelInterceptor");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            LicenseAgreementModel licenseAgreementModel = new LicenseAgreementModel(model.getSdkInstallLocationProperty());
            InstallComponentsProgressStep progressStep2 = new InstallComponentsProgressStep(model, licenseAgreementModel, tracker);
            ModelWizard.Builder $this$buildWizard_u24lambda_u240 = builder = new ModelWizard.Builder(new ModelWizardStep[0]);
            boolean bl = false;
            if (mode == FirstRunWizardMode.NEW_INSTALL) {
                $this$buildWizard_u24lambda_u240.addStep(new FirstRunWelcomeStep(model, tracker));
                if (model.isStandardInstallSupported()) {
                    $this$buildWizard_u24lambda_u240.addStep(new InstallationTypeWizardStep(model, tracker));
                }
            }
            if (mode == FirstRunWizardMode.MISSING_SDK) {
                $this$buildWizard_u24lambda_u240.addStep(new MissingSdkAlertStep(tracker));
            }
            Supplier<Collection<RemotePackage>> supplier = model.getPackagesToInstallSupplier();
            JBInsets jBInsets = JBUI.emptyInsets();
            Boolean bl2 = (Boolean)StudioFlags.NPW_ACCEPT_ALL_LICENSES.get();
            LicenseAgreementStep licenseAgreementStep2 = new LicenseAgreementStep(licenseAgreementModel, supplier, tracker, jBInsets, bl2){
                final /* synthetic */ FirstRunWizardTracker $tracker;
                {
                    this.$tracker = $tracker;
                    Intrinsics.checkNotNull((Object)$super_call_param$2);
                    super($licenseAgreementModel, $supplier, $super_call_param$1, $super_call_param$2);
                }

                protected void onShowing() {
                    super.onShowing();
                    this.$tracker.trackStepShowing(SetupWizardEvent.WizardStep.WizardStepKind.LICENSE_AGREEMENT);
                }
            };
            $this$buildWizard_u24lambda_u240.addStep(new SdkComponentsStep(model, null, mode, licenseAgreementStep2, tracker));
            if (mode != FirstRunWizardMode.INSTALL_HANDOFF) {
                $this$buildWizard_u24lambda_u240.addStep(new InstallSummaryStep(model, supplier, tracker));
                $this$buildWizard_u24lambda_u240.addStep(licenseAgreementStep2);
            }
            if (SystemInfo.isLinux && !HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated() && mode == FirstRunWizardMode.NEW_INSTALL) {
                $this$buildWizard_u24lambda_u240.addStep(new LinuxKvmInfoStep(tracker));
            }
            $this$buildWizard_u24lambda_u240.addStep(progressStep2);
            ModelWizard modelWizard2 = builder.build();
            modelWizard2.setCancelInterceptor(() -> Companion.buildWizard$lambda$1(progressStep2, cancelInterceptor));
            Intrinsics.checkNotNull((Object)modelWizard2);
            return modelWizard2;
        }

        private static final boolean buildWizard$lambda$1(InstallComponentsProgressStep $progressStep, BooleanSupplier $cancelInterceptor) {
            boolean bl;
            if ($progressStep.isRunning()) {
                $progressStep.getProgressIndicator().cancel();
                bl = true;
            } else {
                bl = $cancelInterceptor.getAsBoolean();
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfirmFirstRunWizardCloseDialog.Result.values().length];
            try {
                nArray[ConfirmFirstRunWizardCloseDialog.Result.Skip.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfirmFirstRunWizardCloseDialog.Result.Rerun.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfirmFirstRunWizardCloseDialog.Result.DoNotClose.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

