/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.welcome.wizard.SdkComponentsTableModel;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class SdkComponentsStepForm
implements Disposable {
    private JPanel myContents;
    private JBTable myComponentsTable;
    private JTextPane myComponentDescription;
    private JLabel myNeededSpace;
    private JLabel myAvailableSpace;
    private JLabel myErrorMessage;
    private TextFieldWithBrowseButton myPath;
    private JBLoadingPanel myContentPanel;
    private JPanel myBody;

    public SdkComponentsStepForm() {
        try {
            this.setupUI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myPath.setEditable(false);
        if (!IdeInfo.getInstance().isGameTools()) {
            this.myPath.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Android SDK").withDescription("Select Android SDK install directory"));
        }
        JBFont smallLabelFont = JBUI.Fonts.smallFont();
        this.myNeededSpace.setFont((Font)smallLabelFont);
        this.myAvailableSpace.setFont((Font)smallLabelFont);
        this.myErrorMessage.setText(null);
    }

    public TextFieldWithBrowseButton getPath() {
        return this.myPath;
    }

    private void createUIComponents() {
        Splitter splitter = new Splitter(false, 0.5f, 0.2f, 0.8f);
        this.myBody = splitter;
        this.myComponentsTable = new JBTable();
        this.myComponentDescription = new JTextPane();
        splitter.setShowDividerIcon(false);
        splitter.setShowDividerControls(false);
        this.myContentPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.myContentPanel.add((Component)this.myComponentsTable, (Object)"Center");
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myContentPanel, (boolean)false));
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myComponentDescription, (boolean)false));
        this.myComponentDescription.setFont(StartupUiUtil.getLabelFont());
        this.myComponentDescription.setEditable(false);
        this.myComponentDescription.setBorder(BorderFactory.createEmptyBorder(WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE));
    }

    public void setTableModel(@NotNull SdkComponentsTableModel sdkComponentsTableModel) {
        this.myComponentsTable.setModel((TableModel)sdkComponentsTableModel);
        this.myComponentsTable.setTableHeader(null);
        this.myComponentsTable.getSelectionModel().addListSelectionListener(e -> {
            int row = this.myComponentsTable.getSelectedRow();
            this.myComponentDescription.setText(row < 0 ? "" : sdkComponentsTableModel.getComponentDescription(row));
        });
    }

    public JBTable getComponentsTable() {
        return this.myComponentsTable;
    }

    public JPanel getContents() {
        return this.myContents;
    }

    public void setDiskSpace(String diskSpace) {
        this.myAvailableSpace.setText("Available disk space: " + diskSpace);
    }

    public void setDownloadSize(Long downloadSize) {
        this.myNeededSpace.setText(String.format("Total download size: %s", WelcomeUiUtils.getSizeLabel(downloadSize)));
    }

    public void startLoading() {
        this.myContentPanel.startLoading();
    }

    public void stopLoading() {
        this.myContentPanel.stopLoading();
    }

    public void setLoadingText(String text2) {
        this.myContentPanel.setLoadingText(text2);
    }

    public void setErrorIcon(Icon icon) {
        this.myErrorMessage.setIcon(icon);
    }

    public void setErrorMessage(@Nullable String message) {
        if (message == null) {
            this.myErrorMessage.setText(" ");
        } else {
            this.myErrorMessage.setText(this.toHtml(message));
        }
    }

    public JLabel getErrorLabel() {
        return this.myErrorMessage;
    }

    private String toHtml(String text2) {
        if (!StringUtil.isEmpty((String)text2) && !text2.startsWith("<html>")) {
            text2 = String.format("<html>%1$s</html>", text2.trim());
        }
        return text2;
    }

    public void setCellRenderer(@NotNull TableCellRenderer renderer2) {
        this.getTableColumn().setCellRenderer(renderer2);
    }

    public void setCellEditor(@NotNull TableCellEditor editor) {
        this.getTableColumn().setCellEditor(editor);
    }

    private TableColumn getTableColumn() {
        return this.myComponentsTable.getColumnModel().getColumn(0);
    }

    public void dispose() {
    }

    private void setupUI() {
        this.createUIComponents();
        this.myContents = new JPanel();
        this.myContents.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        label1.setText("Check the components you want to update/install. Click Next to continue.");
        this.myContents.add((Component)label1, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myContents.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null, 0, false));
        this.myContents.add((Component)this.myBody, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Android SDK Location:");
        this.myContents.add((Component)label2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myPath = new TextFieldWithBrowseButton();
        this.myContents.add((Component)this.myPath, new GridConstraints(4, 0, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContents.add((Component)panel1, new GridConstraints(3, 1, 2, 1, 0, 3, 0, 3, null, null, null, 0, false));
        this.myNeededSpace = new JLabel();
        this.myNeededSpace.setText("Total download size: 5.1Gb");
        panel1.add((Component)this.myNeededSpace, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.myAvailableSpace = new JLabel();
        this.myAvailableSpace.setText("Available disk space: 23.0Gb");
        panel1.add((Component)this.myAvailableSpace, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myErrorMessage = new JLabel();
        this.myErrorMessage.setText("Label");
        this.myContents.add((Component)this.myErrorMessage, new GridConstraints(5, 0, 1, 2, 8, 0, 1, 0, null, null, null, 0, false));
        label2.setLabelFor((Component)this.myPath);
    }

    public JComponent getRootComponent() {
        return this.myContents;
    }
}

