/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.PanelFactory;
import com.android.tools.idea.whatsnew.assistant.ActionButtonMetricsEventBuilder;
import com.android.tools.idea.whatsnew.assistant.WhatsNewUpdateStatusPanelFactory;
import com.google.common.base.Stopwatch;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.WhatsNewAssistantUpdateEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WhatsNewMetricsTracker {
    private static final Key<MetricsEventBuilder> METRICS_BUILDER_KEY = Key.create((String)"WhatsNewMetricsTracker");

    @NotNull
    public static WhatsNewMetricsTracker getInstance() {
        return Objects.requireNonNull((WhatsNewUpdateStatusPanelFactory)PanelFactory.EP_NAME.findExtension(WhatsNewUpdateStatusPanelFactory.class)).getMetricsTracker();
    }

    void open(@NotNull Project project, boolean isAutoOpened) {
        MetricsEventBuilder metrics = (MetricsEventBuilder)project.getUserData(METRICS_BUILDER_KEY);
        if (metrics == null) {
            metrics = new MetricsEventBuilder();
            project.putUserData(METRICS_BUILDER_KEY, (Object)metrics);
            metrics.myBuilder.setAutoOpened(isAutoOpened);
            metrics.myActionButtonMetricsBuilder.generateEventsForAllCreatedBeforeActions(project).forEach(metrics::addActionButtonEvent);
        }
    }

    @Nullable
    private MetricsEventBuilder getMetricsBuilder(@NotNull Project project) {
        return (MetricsEventBuilder)project.getUserData(METRICS_BUILDER_KEY);
    }

    void clearDataFor(@NotNull Project project) {
        project.putUserData(METRICS_BUILDER_KEY, null);
    }

    void updateFlow(@NotNull Project project) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.myBuilder.setUpdateFlow(true);
        }
    }

    void scrolledToBottom(@NotNull Project project) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.scrolledToBottom();
        }
    }

    public void actionButtonCreated(@NotNull Project project, @NotNull String actionKey) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.addActionButtonEvent(metrics.myActionButtonMetricsBuilder.actionCreated(project, actionKey));
        }
    }

    public void clickActionButton(@NotNull Project project, @NotNull String actionKey) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.addActionButtonEvent(metrics.myActionButtonMetricsBuilder.clickAction(project, actionKey));
        }
    }

    public void stateUpdateActionButton(@NotNull Project project, @NotNull String actionKey) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.addActionButtonEvent(metrics.myActionButtonMetricsBuilder.stateUpdateAction(project, actionKey));
        }
    }

    public void dismissed(@NotNull Project project) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.myBuilder.setDismissed(true);
        }
    }

    public void setUpdateTime(@NotNull Project project) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.setUpdateTime();
        }
    }

    void close(@NotNull Project project) {
        MetricsEventBuilder metrics = this.getMetricsBuilder(project);
        if (metrics != null) {
            metrics.buildAndLog();
            project.putUserData(METRICS_BUILDER_KEY, null);
        }
    }

    private static class MetricsEventBuilder {
        @NotNull
        final WhatsNewAssistantUpdateEvent.Builder myBuilder = WhatsNewAssistantUpdateEvent.newBuilder();
        @NotNull
        final Stopwatch myStopwatch = Stopwatch.createStarted();
        @NotNull
        final ActionButtonMetricsEventBuilder myActionButtonMetricsBuilder = new ActionButtonMetricsEventBuilder();

        private MetricsEventBuilder() {
        }

        private void setUpdateTime() {
            this.myBuilder.setTimeToUpdateMs(this.myStopwatch.elapsed().toMillis());
        }

        private void scrolledToBottom() {
            this.myBuilder.setScrolledToBottom(true);
            this.myBuilder.setTimeToScrolledToBottom(this.myStopwatch.elapsed().toMillis());
        }

        private void buildAndLog() {
            this.myBuilder.setTimeToCloseMs(this.myStopwatch.elapsed().toMillis());
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WHATS_NEW_ASSISTANT_UPDATE_EVENT).setWhatsNewAssistantUpdateEvent(this.myBuilder));
        }

        public void addActionButtonEvent(WhatsNewAssistantUpdateEvent.ActionButtonEvent.Builder actionButtonEvent) {
            this.myBuilder.addActionButtonEvents(actionButtonEvent.setTimeFromWnaOpen(this.myStopwatch.elapsed().toMillis()));
        }
    }
}

