/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.AssistantToolWindowService;
import com.android.tools.idea.assistant.OpenAssistSidePanelAction;
import com.android.tools.idea.whatsnew.assistant.WhatsNewBundleCreator;
import com.android.tools.idea.whatsnew.assistant.WhatsNewMetricsTracker;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.WhatsNewAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class WhatsNewSidePanelAction
extends OpenAssistSidePanelAction
implements DumbAware {
    @NotNull
    private final AnAction myAction = new WhatsNewAction();
    @NotNull
    private final Runnable myBrowseToWhatsNewUrl;

    private WhatsNewSidePanelAction() {
        this(WhatsNewSidePanelAction::browseToWhatsNewUrl);
    }

    @VisibleForTesting
    WhatsNewSidePanelAction(@NotNull Runnable browseToWhatsNewUrl) {
        this.myBrowseToWhatsNewUrl = browseToWhatsNewUrl;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabled(false);
        } else if (!presentation.isEnabled()) {
            presentation.setEnabled(true);
        }
        this.myAction.update(e);
        presentation.setDescription(AndroidBundle.message("whatsnew.action.custom.description", ApplicationNamesInfo.getInstance().getFullProductName()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return this.myAction.getActionUpdateThread();
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        this.openWhatsNewSidePanel(event.getProject(), false);
    }

    void openWhatsNewSidePanel(@Nullable Project project, boolean isAutoOpened) {
        WhatsNewBundleCreator bundleCreator = (WhatsNewBundleCreator)AssistantBundleCreator.EP_NAME.findExtension(WhatsNewBundleCreator.class);
        if (project == null) {
            Logger.getInstance(WhatsNewSidePanelAction.class).info("project is null, browsing to URL instead");
            this.myBrowseToWhatsNewUrl.run();
            return;
        }
        if (bundleCreator == null) {
            Logger.getInstance(WhatsNewSidePanelAction.class).info("bundleCreator is null, browsing to URL instead");
            this.myBrowseToWhatsNewUrl.run();
            return;
        }
        if (bundleCreator.shouldNotShowWhatsNew()) {
            Logger.getInstance(WhatsNewSidePanelAction.class).info("should not show panel, browsing to URL instead");
            this.myBrowseToWhatsNewUrl.run();
            return;
        }
        WhatsNewToolWindowListener.fireOpenEvent(project, isAutoOpened);
        this.openWindow("DeveloperServices.WhatsNewAssistant", project);
    }

    private static void browseToWhatsNewUrl() {
        BrowserUtil.browse((String)ExternalProductResourceUrls.getInstance().getWhatIsNewPageUrl().toString());
    }

    public static class WhatsNewToolWindowListener
    implements ToolWindowManagerListener {
        @NotNull
        private final Project myProject;
        private boolean isOpen;

        public WhatsNewToolWindowListener(@NotNull Project project) {
            this.myProject = project;
            this.isOpen = true;
            Disposable disposable = (Disposable)project.getService(AssistantToolWindowService.class);
            MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect(disposable);
            connection2.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

                public void projectClosed(@NotNull Project project) {
                    if (!project.equals(myProject)) {
                        return;
                    }
                    if (isOpen) {
                        WhatsNewToolWindowListener.fireClosedEvent(myProject);
                        isOpen = false;
                    }
                }
            });
        }

        public void toolWindowUnregistered(@NotNull String id2, @NotNull ToolWindow toolWindow) {
            if (id2.equals("Assistant")) {
                WhatsNewMetricsTracker.getInstance().clearDataFor(this.myProject);
            }
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window2 = toolWindowManager.getToolWindow("Assistant");
                if (window2 == null) {
                    return;
                }
                if (!"DeveloperServices.WhatsNewAssistant".equals(window2.getHelpId())) {
                    return;
                }
                if (this.isOpen && !window2.isVisible()) {
                    WhatsNewToolWindowListener.fireClosedEvent(this.myProject);
                    this.isOpen = false;
                } else if (!this.isOpen && window2.isVisible()) {
                    WhatsNewToolWindowListener.fireOpenEvent(this.myProject, false);
                    this.isOpen = true;
                }
            });
        }

        private static void fireOpenEvent(@NotNull Project project, boolean isAutoOpened) {
            WhatsNewMetricsTracker.getInstance().open(project, isAutoOpened);
        }

        private static void fireClosedEvent(@NotNull Project project) {
            WhatsNewMetricsTracker.getInstance().close(project);
        }
    }
}

