/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.nativeSymbolizer;

import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.nativeSymbolizer.Symbol;
import com.android.tools.nativeSymbolizer.SymbolFilesLocator;
import com.intellij.openapi.Disposable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/nativeSymbolizer/LlvmSymbolizer;", "Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;", "symbolizerExe", "", "symLocator", "Lcom/android/tools/nativeSymbolizer/SymbolFilesLocator;", "timeoutMsc", "", "<init>", "(Ljava/lang/String;Lcom/android/tools/nativeSymbolizer/SymbolFilesLocator;J)V", "procHolder", "Lcom/android/tools/nativeSymbolizer/LlvmSymbolizer$ProcessHolder;", "executor", "Ljava/util/concurrent/ExecutorService;", "symbolize", "Lcom/android/tools/nativeSymbolizer/Symbol;", "abiArch", "module", "Ljava/io/File;", "offset", "getProcHolder", "formatRequest", "symFile", "parseResponse", "response", "", "start", "", "stop", "ProcessHolder", "native-symbolizer"})
@SourceDebugExtension(value={"SMAP\nLlvmSymbolizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlvmSymbolizer.kt\ncom/android/tools/nativeSymbolizer/LlvmSymbolizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n774#2:162\n865#2,2:163\n*S KotlinDebug\n*F\n+ 1 LlvmSymbolizer.kt\ncom/android/tools/nativeSymbolizer/LlvmSymbolizer\n*L\n53#1:162\n53#1:163,2\n*E\n"})
public final class LlvmSymbolizer
implements NativeSymbolizer {
    @NotNull
    private final String symbolizerExe;
    @NotNull
    private final SymbolFilesLocator symLocator;
    private final long timeoutMsc;
    @Nullable
    private ProcessHolder procHolder;
    @NotNull
    private final ExecutorService executor;

    public LlvmSymbolizer(@NotNull String symbolizerExe, @NotNull SymbolFilesLocator symLocator, long timeoutMsc) {
        Intrinsics.checkNotNullParameter((Object)symbolizerExe, (String)"symbolizerExe");
        Intrinsics.checkNotNullParameter((Object)symLocator, (String)"symLocator");
        this.symbolizerExe = symbolizerExe;
        this.symLocator = symLocator;
        this.timeoutMsc = timeoutMsc;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.executor = executorService;
    }

    public /* synthetic */ LlvmSymbolizer(String string, SymbolFilesLocator symbolFilesLocator, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 5000L;
        }
        this(string, symbolFilesLocator, l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Symbol symbolize(@NotNull String abiArch, @NotNull File module, long offset) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)abiArch, (String)"abiArch");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List<File> symFiles = this.symLocator.getFiles(abiArch);
        Iterable $this$filter$iv = symFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)FilesKt.getNameWithoutExtension((File)it), (Object)FilesKt.getNameWithoutExtension((File)module))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (File symFile : (List)destination$iv$iv) {
            String request = this.formatRequest(symFile, offset);
            ProcessHolder holder = this.getProcHolder();
            Future<List> future2 = this.executor.submit(() -> LlvmSymbolizer.symbolize$lambda$1(holder, request));
            List response2 = null;
            try {
                List list = future2.get(this.timeoutMsc, TimeUnit.MILLISECONDS);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
                response2 = list;
            }
            catch (TimeoutException e) {
                NativeSymbolizerKt.getLogger().warn("llvm-symbolizer timed out", (Throwable)e);
                this.stop();
                continue;
            }
            catch (ExecutionException e) {
                NativeSymbolizerKt.getLogger().warn("llvm-symbolizer communication failed", (Throwable)e);
                this.stop();
                continue;
            }
            Symbol result2 = this.parseResponse(response2, module);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private final ProcessHolder getProcHolder() {
        ProcessHolder holder = this.procHolder;
        if (holder == null || !holder.getProcess().isAlive()) {
            this.start();
            ProcessHolder processHolder = this.procHolder;
            Intrinsics.checkNotNull((Object)processHolder);
            holder = processHolder;
        }
        return holder;
    }

    private final String formatRequest(File symFile, long offset) {
        String string = symFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String escapedPath = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        Object[] objectArray = new Object[]{escapedPath, offset};
        String string2 = String.format("\"%s\" 0x%x\n", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final Symbol parseResponse(List<String> response2, File module) {
        if (response2.isEmpty()) {
            return null;
        }
        String name2 = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first(response2)))).toString();
        if (((CharSequence)name2).length() == 0 || Intrinsics.areEqual((Object)name2, (Object)"??")) {
            return null;
        }
        if (response2.size() < 2) {
            String string = module.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return new Symbol(name2, string, null, 0, 12, null);
        }
        String locationLine = ((Object)StringsKt.trim((CharSequence)response2.get(1))).toString();
        int indexBeforeColumn = StringsKt.lastIndexOf$default((CharSequence)locationLine, (char)':', (int)0, (boolean)false, (int)6, null);
        if (indexBeforeColumn < 2) {
            String string = module.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return new Symbol(name2, string, null, 0, 12, null);
        }
        int indexBeforeLine = StringsKt.lastIndexOf$default((CharSequence)locationLine, (char)':', (int)(indexBeforeColumn - 1), (boolean)false, (int)4, null);
        if (indexBeforeColumn < 1) {
            String string = module.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return new Symbol(name2, string, null, 0, 12, null);
        }
        String string = locationLine.substring(0, indexBeforeLine);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String sourceFile = string;
        String string2 = locationLine.substring(indexBeforeLine + 1, indexBeforeColumn);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        Integer n = StringsKt.toIntOrNull((String)string2);
        int lineNumber = n != null ? n : 0;
        String string3 = module.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        return new Symbol(name2, string3, sourceFile, lineNumber);
    }

    private final void start() {
        if (this.procHolder != null) {
            this.stop();
        }
        String[] stringArray = new String[]{this.symbolizerExe};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        Process process2 = builder.start();
        if (!process2.isAlive()) {
            throw new IOException("Symbolizer process is not alive. Executable: " + this.symbolizerExe);
        }
        OutputStreamWriter stdin = new OutputStreamWriter(process2.getOutputStream(), Charsets.UTF_8);
        BufferedReader stdout = new BufferedReader(new InputStreamReader(process2.getInputStream(), Charsets.UTF_8));
        Intrinsics.checkNotNull((Object)process2);
        this.procHolder = new ProcessHolder(process2, stdout, stdin);
    }

    @Override
    public void stop() {
        ProcessHolder processHolder = this.procHolder;
        if (processHolder != null) {
            processHolder.dispose();
        }
        this.procHolder = null;
    }

    private static final List symbolize$lambda$1(ProcessHolder $holder, String $request) {
        CharSequence charSequence;
        $holder.getStdin().write($request);
        $holder.getStdin().flush();
        List response2 = new ArrayList();
        String responseLine = null;
        while (!((charSequence = (CharSequence)(responseLine = $holder.getStdout().readLine())) == null || charSequence.length() == 0)) {
            response2.add(responseLine);
        }
        return response2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/nativeSymbolizer/LlvmSymbolizer$ProcessHolder;", "Lcom/intellij/openapi/Disposable;", "process", "Ljava/lang/Process;", "stdout", "Ljava/io/BufferedReader;", "stdin", "Ljava/io/OutputStreamWriter;", "<init>", "(Ljava/lang/Process;Ljava/io/BufferedReader;Ljava/io/OutputStreamWriter;)V", "getProcess", "()Ljava/lang/Process;", "getStdout", "()Ljava/io/BufferedReader;", "getStdin", "()Ljava/io/OutputStreamWriter;", "dispose", "", "native-symbolizer"})
    private static final class ProcessHolder
    implements Disposable {
        @NotNull
        private final Process process;
        @NotNull
        private final BufferedReader stdout;
        @NotNull
        private final OutputStreamWriter stdin;

        public ProcessHolder(@NotNull Process process2, @NotNull BufferedReader stdout, @NotNull OutputStreamWriter stdin) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
            this.process = process2;
            this.stdout = stdout;
            this.stdin = stdin;
        }

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        @NotNull
        public final BufferedReader getStdout() {
            return this.stdout;
        }

        @NotNull
        public final OutputStreamWriter getStdin() {
            return this.stdin;
        }

        public void dispose() {
            this.process.destroy();
        }
    }
}

