/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.tools.preview.config.DeviceConfig;
import com.android.tools.preview.config.DeviceConfigKt;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.ReferenceConfigsKt;
import com.android.tools.preview.config.WindowSizeData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\"\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"toPx", "", "", "density", "Lcom/android/resources/Density;", "DeviceWindowsNames", "", "", "getDeviceWindowsNames", "()Ljava/util/Map;", "PREDEFINED_WINDOW_SIZES_DEFINITIONS", "", "Lcom/android/tools/preview/config/WindowSizeData;", "getPREDEFINED_WINDOW_SIZES_DEFINITIONS", "()Ljava/util/List;", "intellij.android.preview-elements"})
@SourceDebugExtension(value={"SMAP\nWindowSizeData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowSizeData.kt\ncom/android/tools/preview/config/WindowSizeDataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1557#2:66\n1628#2,3:67\n*S KotlinDebug\n*F\n+ 1 WindowSizeData.kt\ncom/android/tools/preview/config/WindowSizeDataKt\n*L\n51#1:66\n51#1:67,3\n*E\n"})
public final class WindowSizeDataKt {
    @NotNull
    private static final Map<String, String> DeviceWindowsNames;
    @NotNull
    private static final List<WindowSizeData> PREDEFINED_WINDOW_SIZES_DEFINITIONS;

    public static final int toPx(double $this$toPx, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return MathKt.roundToInt((double)($this$toPx * ((double)density.getDpiValue() / 160.0)));
    }

    @NotNull
    public static final Map<String, String> getDeviceWindowsNames() {
        return DeviceWindowsNames;
    }

    @NotNull
    public static final List<WindowSizeData> getPREDEFINED_WINDOW_SIZES_DEFINITIONS() {
        return PREDEFINED_WINDOW_SIZES_DEFINITIONS;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_device_class_phone", (Object)"Medium Phone"), TuplesKt.to((Object)"_device_class_foldable", (Object)"Foldable"), TuplesKt.to((Object)"_device_class_tablet", (Object)"Medium Tablet"), TuplesKt.to((Object)"_device_class_desktop", (Object)"Desktop")};
        DeviceWindowsNames = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$map$iv = DeviceConfigKt.getReferenceDeviceIds().entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String deviceClassName = (String)entry.getValue();
            DeviceConfig config = ReferenceConfigsKt.getDeviceConfigFor(deviceClassName);
            String string2 = config.getDeviceId();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = DeviceWindowsNames.get(deviceClassName)) == null) {
                string = "Custom";
            }
            double d = config.getWidth();
            double d2 = config.getHeight();
            Density density = Density.create((int)config.getDpi());
            Intrinsics.checkNotNullExpressionValue((Object)density, (String)"create(...)");
            collection2.add(new WindowSizeData(string2, string, d, d2, density, switch (WhenMappings.$EnumSwitchMapping$0[config.getOrientation().ordinal()]) {
                case 1 -> ScreenOrientation.PORTRAIT;
                case 2 -> ScreenOrientation.LANDSCAPE;
                default -> throw new NoWhenBranchMatchedException();
            }));
        }
        PREDEFINED_WINDOW_SIZES_DEFINITIONS = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.portrait.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.landscape.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

