/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.rendering.parsers.TagSnapshot;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

public class LayoutMetadata {
    public static final String DEFAULT_EXPANDABLE_LIST_ITEM = "simple_expandable_list_item_2";
    public static final String DEFAULT_LIST_ITEM = "simple_list_item_2";
    public static final String DEFAULT_SPINNER_ITEM = "simple_spinner_item";
    public static final String KEY_LV_ITEM = "listitem";
    public static final String KEY_LV_HEADER = "listheader";
    public static final String KEY_LV_FOOTER = "listfooter";
    public static final String KEY_LV_COLUMN = "numColumns";
    public static final String KEY_FRAGMENT_LAYOUT = "layout";

    private LayoutMetadata() {
    }

    public static String getProperty(@NotNull XmlPullParser parser, @NotNull String name2) {
        String value2 = parser.getAttributeValue("http://schemas.android.com/tools", name2);
        if (value2 != null && value2.isEmpty()) {
            value2 = null;
        }
        return value2;
    }

    public static String getProperty(@NotNull Node node, @NotNull String name2) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String value2 = element.getAttributeNS("http://schemas.android.com/tools", name2);
            if (value2 != null && value2.isEmpty()) {
                value2 = null;
            }
            return value2;
        }
        return null;
    }

    public static String getProperty(@NotNull TagSnapshot node, @NotNull String name2) {
        String value2 = node.getAttribute(name2, "http://schemas.android.com/tools");
        if (value2 != null && value2.isEmpty()) {
            value2 = null;
        }
        return value2;
    }

    private static String stripLayoutPrefix(String layout) {
        if (layout.startsWith("@android:layout/")) {
            layout = layout.substring("@android:layout/".length());
        } else if (layout.startsWith("@layout/")) {
            layout = layout.substring("@layout/".length());
        }
        return layout;
    }

    public static String getListAdapterViewFqcn(@NotNull Class<?> clz) {
        String fqcn = clz.getName();
        if (fqcn.endsWith("ListView") || fqcn.equals("android.widget.GridView") || fqcn.equals("android.widget.Spinner")) {
            return fqcn;
        }
        if (fqcn.startsWith("android.")) {
            return null;
        }
        Class<?> superClass = clz.getSuperclass();
        if (superClass != null) {
            return LayoutMetadata.getListAdapterViewFqcn(superClass);
        }
        return null;
    }

    public static AdapterBinding getNodeBinding(Object viewObject, Map<String, String> attributes) {
        String listFqcn;
        if (attributes == null) {
            return null;
        }
        String header = attributes.get(KEY_LV_HEADER);
        String footer = attributes.get(KEY_LV_FOOTER);
        String layout = attributes.get(KEY_LV_ITEM);
        int count = 12;
        if (viewObject != null && (listFqcn = LayoutMetadata.getListAdapterViewFqcn(viewObject.getClass())) != null && listFqcn.endsWith("GridView")) {
            int multiplier = 2;
            String columns2 = attributes.get(KEY_LV_COLUMN);
            if (columns2 != null && !columns2.isEmpty() && !columns2.equals("auto_fit")) {
                try {
                    int c = Integer.parseInt(columns2);
                    if (c >= 1 && c <= 10) {
                        multiplier = c;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            count *= multiplier;
        }
        return LayoutMetadata.getNodeBinding(viewObject, header, footer, layout, count);
    }

    private static AdapterBinding getNodeBinding(Object viewObject, String header, String footer, String layout, int count) {
        if (layout != null || header != null || footer != null) {
            boolean isFramework;
            AdapterBinding binding = new AdapterBinding(count);
            if (header != null) {
                isFramework = header.startsWith("@android:layout/");
                binding.addHeader(new ResourceReference(ResourceNamespace.fromBoolean((boolean)isFramework), ResourceType.LAYOUT, LayoutMetadata.stripLayoutPrefix(header)));
            }
            if (footer != null) {
                isFramework = footer.startsWith("@android:layout/");
                binding.addFooter(new ResourceReference(ResourceNamespace.fromBoolean((boolean)isFramework), ResourceType.LAYOUT, LayoutMetadata.stripLayoutPrefix(footer)));
            }
            if (layout != null) {
                isFramework = layout.startsWith("@android:layout/");
                if (isFramework) {
                    layout = layout.substring("@android:layout/".length());
                } else if (layout.startsWith("@layout/")) {
                    layout = layout.substring("@layout/".length());
                }
                binding.addItem(new DataBindingItem(layout, isFramework, 1));
            } else if (viewObject != null) {
                String listFqcn = LayoutMetadata.getListAdapterViewFqcn(viewObject.getClass());
                if (listFqcn != null) {
                    if (listFqcn.endsWith("ExpandableListView")) {
                        binding.addItem(new DataBindingItem(DEFAULT_EXPANDABLE_LIST_ITEM, true, 1));
                    } else {
                        binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
                    }
                }
            } else {
                binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
            }
            return binding;
        }
        return null;
    }
}

