/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.NoDeviceException;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderContext;
import com.android.tools.rendering.RenderExecutor;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.RenderingBundle;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.classloading.ClassTransform;
import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.imagepool.ImagePoolFactory;
import com.android.tools.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.android.tools.rendering.tracking.RenderTaskAllocationTrackerImpl;
import com.android.tools.rendering.tracking.StackTraceCapture;
import com.android.tools.sdk.LayoutlibFactory;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class RenderService
implements Disposable {
    private static final Object ourExecutorLock = new Object();
    private static RenderExecutor ourExecutor = RenderService.getOrCreateExecutor();
    private static final String JDK_INSTALL_URL = "https://developer.android.com/preview/setup-sdk.html#java8";
    private final Object myCredential = new Object();
    private final ImagePool myImagePool = ImagePoolFactory.createImagePool();
    private final Consumer<RenderTaskBuilder> myConfigureBuilder;
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static RenderExecutor getOrCreateExecutor() {
        Object object = ourExecutorLock;
        synchronized (object) {
            if (ourExecutor == null) {
                ourExecutor = RenderExecutor.create();
            }
            return ourExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RenderExecutor getExistingExecutor() {
        Object object = ourExecutorLock;
        synchronized (object) {
            return ourExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void initializeRenderExecutor() {
        Object object = ourExecutorLock;
        synchronized (object) {
            ourExecutor = RenderExecutor.create();
        }
    }

    public static void shutdownRenderExecutor() {
        RenderExecutor currentExecutor = RenderService.getExistingExecutor();
        if (currentExecutor != null) {
            currentExecutor.shutdown();
        }
    }

    @TestOnly
    public static void shutdownRenderExecutor(long timeoutSeconds) {
        RenderExecutor currentExecutor = RenderService.getExistingExecutor();
        if (currentExecutor != null) {
            currentExecutor.shutdown(timeoutSeconds);
        }
    }

    @NotNull
    public static RenderAsyncActionExecutor getRenderAsyncActionExecutor() {
        return RenderService.getOrCreateExecutor();
    }

    @TestOnly
    public static StackTraceElement[] getCurrentExecutionStackTrace() {
        return RenderService.getOrCreateExecutor().currentStackTrace();
    }

    public RenderService(@NotNull Consumer<RenderTaskBuilder> configureBuilder) {
        this.myConfigureBuilder = configureBuilder;
    }

    @NotNull
    public RenderLogger createLogger(@Nullable Project project, boolean logFramework, @NotNull RenderProblem.ActionFixFactory fixFactory, @NotNull Supplier<HtmlLinkManager> linkManagerFactory) {
        return new RenderLogger(project, this.myCredential, logFramework, fixFactory, linkManagerFactory);
    }

    @NotNull
    public RenderLogger createLogger(@Nullable Project project) {
        return new RenderLogger(project);
    }

    @NotNull
    public RenderLogger getNopLogger() {
        return RenderLogger.NOP_RENDER_LOGGER;
    }

    @NotNull
    public RenderTaskBuilder taskBuilder(@NotNull RenderModelModule module, @NotNull Configuration configuration2, @NotNull RenderLogger logger) {
        RenderTaskBuilder builder = new RenderTaskBuilder(module, configuration2, this.myImagePool, this.myCredential, logger);
        this.myConfigureBuilder.accept(builder);
        return builder;
    }

    public void dispose() {
        this.myImagePool.dispose();
    }

    public static boolean isBusy() {
        RenderExecutor currentExecutor = RenderService.getExistingExecutor();
        return currentExecutor != null && currentExecutor.isBusy();
    }

    public static boolean isRenderThread() {
        RenderExecutor currentExecutor = RenderService.getExistingExecutor();
        return currentExecutor != null && currentExecutor.isRenderThread();
    }

    @NotNull
    public static ViewInfo getSafeBounds(@NotNull ViewInfo view) {
        int left2 = Math.abs(view.getLeft());
        int right = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom = Math.abs(view.getBottom());
        if (left2 < 0x2000000 && right < 0x2000000 && top < 0x2000000 && bottom < 0x2000000) {
            return view;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }

    @Nullable
    public static RenderXmlTag getXmlTag(@NotNull ViewInfo view) {
        Object cookie = view.getCookie();
        if (cookie != null) {
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof RenderXmlTag) {
                return (RenderXmlTag)cookie;
            }
        }
        return null;
    }

    @NotNull
    public ImagePool getSharedImagePool() {
        return this.myImagePool;
    }

    private static Logger getLogger() {
        return Logger.getInstance(RenderService.class);
    }

    public static class RenderTaskBuilder {
        private final RenderContext myContext;
        private final Object myCredential;
        @NotNull
        private ImagePool myImagePool;
        @Nullable
        private RenderXmlFile myXmlFile;
        @NotNull
        private final RenderLogger myLogger;
        @Nullable
        private ILayoutPullParserFactory myParserFactory;
        private boolean isSecurityManagerEnabled = true;
        private float myQuality = 1.0f;
        private boolean showDecorations = true;
        private boolean showWithToolsVisibilityAndPosition = true;
        private int myMaxRenderWidth = -1;
        private int myMaxRenderHeight = -1;
        private boolean enableLayoutScanner = false;
        private boolean forceMonochromeIcon = false;
        private SessionParams.RenderingMode myRenderingMode = null;
        private boolean useTransparentBackground = false;
        private Function<Object, List<ViewInfo>> myCustomContentHierarchyParser = null;
        private boolean privateClassLoader = false;
        private Collection<String> classesToPreload = Collections.emptyList();
        private ClassTransform myAdditionalProjectTransform = ClassTransform.getIdentity();
        private ClassTransform myAdditionalNonProjectTransform = ClassTransform.getIdentity();
        @NotNull
        private Runnable myOnNewModuleClassLoader = () -> {};
        private boolean reportOutOfDateUserClasses = true;
        @NotNull
        private RenderAsyncActionExecutor.RenderingTopic myTopic = RenderAsyncActionExecutor.RenderingTopic.NOT_SPECIFIED;
        private boolean useCustomInflater = true;
        private RenderTask.TestEventListener myTestEventListener = RenderTask.NOP_TEST_EVENT_LISTENER;
        private float animationDurationScale = 1.0f;

        private RenderTaskBuilder(@NotNull RenderModelModule module, @NotNull Configuration configuration2, @NotNull ImagePool defaultImagePool, @NotNull Object credential, @NotNull RenderLogger logger) {
            this.myContext = new RenderContext(module, configuration2);
            this.myImagePool = defaultImagePool;
            this.myCredential = credential;
            this.myLogger = logger;
        }

        @NotNull
        public RenderTaskBuilder preloadClasses(Collection<String> classesToPreload) {
            this.classesToPreload = classesToPreload;
            return this;
        }

        @NotNull
        public RenderTaskBuilder usePrivateClassLoader() {
            this.privateClassLoader = true;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withPsiFile(@NotNull RenderXmlFile xmlFile) {
            this.myXmlFile = xmlFile;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withParserFactory(@NotNull ILayoutPullParserFactory parserFactory) {
            this.myParserFactory = parserFactory;
            return this;
        }

        public RenderTaskBuilder withLayoutScanner(Boolean enableLayoutScanner) {
            this.enableLayoutScanner = enableLayoutScanner;
            return this;
        }

        public RenderTaskBuilder withForceMonochromeIcon(Boolean forceMonochromeIcon) {
            this.forceMonochromeIcon = forceMonochromeIcon;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableImagePool() {
            this.myImagePool = ImagePoolFactory.getNonPooledPool();
            return this;
        }

        @NotNull
        public RenderTaskBuilder withQuality(float quality) {
            this.myQuality = quality;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
            this.myMaxRenderWidth = maxRenderWidth;
            this.myMaxRenderHeight = maxRenderHeight;
            return this;
        }

        @TestOnly
        @VisibleForTesting
        @NotNull
        public RenderTaskBuilder disableSecurityManager() {
            this.isSecurityManagerEnabled = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableDecorations() {
            this.showDecorations = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableToolsVisibilityAndPosition() {
            this.showWithToolsVisibilityAndPosition = false;
            return this;
        }

        public RenderTaskBuilder disableAnimation() {
            this.animationDurationScale = 0.0f;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
            this.myRenderingMode = renderingMode;
            return this;
        }

        @NotNull
        public RenderTaskBuilder useTransparentBackground() {
            this.useTransparentBackground = true;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setProjectClassesTransform(@NotNull ClassTransform transform2) {
            this.myAdditionalProjectTransform = transform2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setNonProjectClassesTransform(@NotNull ClassTransform transform2) {
            this.myAdditionalNonProjectTransform = transform2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setOnNewClassLoader(@NotNull Runnable runnable2) {
            this.myOnNewModuleClassLoader = runnable2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder doNotReportOutOfDateUserClasses() {
            this.reportOutOfDateUserClasses = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withTopic(@NotNull RenderAsyncActionExecutor.RenderingTopic topic) {
            this.myTopic = topic;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setUseCustomInflater(boolean useCustomInflater) {
            this.useCustomInflater = useCustomInflater;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setCustomContentHierarchyParser(@NotNull Function<Object, List<ViewInfo>> parser) {
            this.myCustomContentHierarchyParser = parser;
            return this;
        }

        @TestOnly
        @NotNull
        public RenderTaskBuilder setTestEventListener(@NotNull RenderTask.TestEventListener testEventListener) {
            this.myTestEventListener = testEventListener;
            return this;
        }

        @NotNull
        public CompletableFuture<RenderTask> build() {
            return this.build(Disposer.newCheckedDisposable());
        }

        @NotNull
        public CompletableFuture<RenderTask> build(@NotNull CheckedDisposable disposable) {
            RenderTaskAllocationTrackerImpl tracker = new RenderTaskAllocationTrackerImpl(this.myContext.getModule().getEnvironment().isInTest());
            StackTraceCapture stackTraceCaptureElement = tracker.captureAllocationStackTrace();
            return CompletableFuture.supplyAsync(() -> {
                LayoutLibrary layoutLib;
                RenderModelModule module = this.myContext.getModule();
                if (module.isDisposed()) {
                    RenderService.getLogger().warn("Module was already disposed");
                    return null;
                }
                IAndroidTarget target2 = this.myContext.getConfiguration().getTarget();
                if (module.getAndroidPlatform() == null) {
                    this.myContext.getModule().getEnvironment().reportMissingSdkDependency(this.myLogger);
                    return null;
                }
                if (target2 == null) {
                    this.myLogger.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, "No render target was chosen"));
                    return null;
                }
                try {
                    if (disposable.isDisposed()) {
                        return null;
                    }
                    layoutLib = LayoutlibFactory.getLayoutLibrary(target2, module.getAndroidPlatform(), module.getEnvironment().getLayoutlibContext());
                }
                catch (UnsupportedJavaRuntimeException e) {
                    RenderProblem.Html javaVersionProblem = RenderProblem.create(ProblemSeverity.ERROR);
                    javaVersionProblem.getHtmlBuilder().add(e.getPresentableMessage()).newline().addLink("Install a supported JDK", RenderService.JDK_INSTALL_URL);
                    this.myLogger.addMessage(javaVersionProblem);
                    return null;
                }
                catch (RenderingException e) {
                    String message = e.getPresentableMessage();
                    message = message != null ? message : RenderingBundle.message("android.layout.preview.default.error.message", new Object[0]);
                    this.myLogger.addMessage(RenderProblem.createHtml(ProblemSeverity.ERROR, message, this.myLogger.getLinkManager(), e, module.getEnvironment().getActionFixFactory()));
                    return null;
                }
                if (disposable.isDisposed()) {
                    return null;
                }
                RenderTask task2 = null;
                try {
                    task2 = new RenderTask(this.myContext, this.myLogger, layoutLib, this.myCredential, this.myContext.getModule().getEnvironment().getCrashReporter(), this.myImagePool, this.myParserFactory, this.isSecurityManagerEnabled, this.myQuality, stackTraceCaptureElement, tracker, this.privateClassLoader, this.myAdditionalProjectTransform, this.myAdditionalNonProjectTransform, this.myOnNewModuleClassLoader, this.classesToPreload, this.reportOutOfDateUserClasses, this.myTopic, this.useCustomInflater, this.myTestEventListener, this.animationDurationScale);
                    if (this.myXmlFile != null) {
                        task2.setXmlFile(this.myXmlFile);
                    }
                    task2.setDecorations(this.showDecorations).setShowWithToolsVisibilityAndPosition(this.showWithToolsVisibilityAndPosition).setEnableLayoutScanner(this.enableLayoutScanner).setForceMonochromeIcon(this.forceMonochromeIcon);
                    if (this.myMaxRenderWidth != -1 && this.myMaxRenderHeight != -1) {
                        task2.setMaxRenderSize(this.myMaxRenderWidth, this.myMaxRenderHeight);
                    }
                    if (this.useTransparentBackground) {
                        task2.setTransparentBackground();
                    }
                    if (this.myRenderingMode != null) {
                        task2.setRenderingMode(this.myRenderingMode);
                    }
                    if (this.myCustomContentHierarchyParser != null) {
                        task2.setCustomContentHierarchyParser(this.myCustomContentHierarchyParser);
                    }
                    if (disposable.isDisposed()) {
                        task2.dispose();
                        return null;
                    }
                    return task2;
                }
                catch (NoDeviceException e) {
                    this.myLogger.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, "No device selected"));
                    return null;
                }
                catch (IncorrectOperationException | AssertionError | IllegalStateException e) {
                    if (task2 != null) {
                        task2.dispose();
                    }
                    if (!module.isDisposed()) {
                        throw e;
                    }
                    return null;
                }
            }, AppExecutorUtil.getAppExecutorService());
        }
    }
}

