/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.classloading.ModuleClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001e\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SNAPSHOT_KT_FQN", "", "FONT_REQUEST_WORKER_FQN", "WINDOW_RECOMPOSER_ANDROID_KT_FQN", "LOCAL_BROADCAST_MANAGER_FQN", "GAP_WORKER_CLASS_NAME", "INTERNAL_PACKAGE", "ANDROID_UI_DISPATCHER_FQN", "ANDROID_UI_DISPATCHER_COMPANION_FQN", "COMBINED_CONTEXT_FQN", "dispose", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Lcom/android/ide/common/rendering/api/RenderSession;", "classLoader", "Lcom/android/tools/rendering/classloading/ModuleClassLoader;", "disposeIfCompose", "", "viewInfo", "Lcom/android/ide/common/rendering/api/ViewInfo;", "disposeMethod", "Ljava/lang/reflect/Method;", "findToRunTrampolined", "", "findSnapshotKtObserversField", "fieldName", "findLocalBroadcastManagerInstance", "Ljava/lang/reflect/Field;", "clearFontRequestWorker", "clearGapWorkerCache", "clearCompositions", "intellij.android.rendering"})
@JvmName(name="RenderSessionCleaner")
@SourceDebugExtension(value={"SMAP\nRenderSessionCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderSessionCleaner.kt\ncom/android/tools/rendering/RenderSessionCleaner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n1#2:322\n2945#3,12:323\n1863#4,2:335\n*S KotlinDebug\n*F\n+ 1 RenderSessionCleaner.kt\ncom/android/tools/rendering/RenderSessionCleaner\n*L\n314#1:323,12\n315#1:335,2\n*E\n"})
public final class RenderSessionCleaner {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SNAPSHOT_KT_FQN = "androidx.compose.runtime.snapshots.SnapshotKt";
    @NotNull
    private static final String FONT_REQUEST_WORKER_FQN = "androidx.core.provider.FontRequestWorker";
    @NotNull
    private static final String WINDOW_RECOMPOSER_ANDROID_KT_FQN = "androidx.compose.ui.platform.WindowRecomposer_androidKt";
    @NotNull
    private static final String LOCAL_BROADCAST_MANAGER_FQN = "androidx.localbroadcastmanager.content.LocalBroadcastManager";
    @NotNull
    private static final String GAP_WORKER_CLASS_NAME = "androidx.recyclerview.widget.GapWorker";
    @NotNull
    private static final String INTERNAL_PACKAGE = "_layoutlib_._internal_.";
    @NotNull
    private static final String ANDROID_UI_DISPATCHER_FQN = "androidx.compose.ui.platform.AndroidUiDispatcher";
    @NotNull
    private static final String ANDROID_UI_DISPATCHER_COMPANION_FQN = "androidx.compose.ui.platform.AndroidUiDispatcher$Companion";
    @NotNull
    private static final String COMBINED_CONTEXT_FQN = "_layoutlib_._internal_.kotlin.coroutines.CombinedContext";

    @NotNull
    public static final CompletableFuture<Void> dispose(@NotNull RenderSession $this$dispose, @NotNull ModuleClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)$this$dispose, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Optional<Object> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        Optional<Object> disposeMethod = optional;
        Ref.ObjectRef applyObserversRef = new Ref.ObjectRef();
        Ref.ObjectRef globalWriteObserversRef = new Ref.ObjectRef();
        Ref.ObjectRef toRunTrampolinedRef = new Ref.ObjectRef();
        if (classLoader.hasLoadedClass("androidx.compose.ui.tooling.ComposeViewAdapter")) {
            Object $this$dispose_u24lambda_u244;
            Object $this$dispose_u24lambda_u243;
            Object $this$dispose_u24lambda_u242;
            try {
                Class<?> composeViewAdapter = classLoader.loadClass("androidx.compose.ui.tooling.ComposeViewAdapter");
                Optional<Object> optional2 = Arrays.stream(composeViewAdapter.getMethods()).filter(arg_0 -> RenderSessionCleaner.dispose$lambda$1(RenderSessionCleaner::dispose$lambda$0, arg_0)).findFirst();
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"findFirst(...)");
                disposeMethod = optional2;
            }
            catch (ClassNotFoundException ex) {
                LOG.debug("androidx.compose.ui.tooling.ComposeViewAdapter class not found", (Throwable)ex);
            }
            if (disposeMethod.isEmpty()) {
                LOG.warn("Unable to find dispose method in ComposeViewAdapter");
            }
            try {
                Class<?> windowRecomposer = classLoader.loadClass(WINDOW_RECOMPOSER_ANDROID_KT_FQN);
                Field animationScaleField = windowRecomposer.getDeclaredField("animationScale");
                animationScaleField.setAccessible(true);
                Object animationScale = animationScaleField.get(windowRecomposer);
                if (animationScale instanceof Map) {
                    TypeIntrinsics.asMutableMap((Object)animationScale).clear();
                }
            }
            catch (ReflectiveOperationException ex) {
                LOG.debug("Unable to dispose the recompose animationScale", (Throwable)ex);
            }
            applyObserversRef.element = new WeakReference(RenderSessionCleaner.findSnapshotKtObserversField(classLoader, "applyObservers"));
            globalWriteObserversRef.element = new WeakReference(RenderSessionCleaner.findSnapshotKtObserversField(classLoader, "globalWriteObservers"));
            toRunTrampolinedRef.element = new WeakReference(RenderSessionCleaner.findToRunTrampolined(classLoader));
            RenderSession ex = $this$dispose;
            try {
                Unit unit;
                $this$dispose_u24lambda_u242 = ex;
                boolean bl = false;
                Collection collection2 = (Collection)((WeakReference)applyObserversRef.element).get();
                if (collection2 != null) {
                    collection2.clear();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                $this$dispose_u24lambda_u242 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                $this$dispose_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            ex = $this$dispose;
            try {
                Unit unit;
                $this$dispose_u24lambda_u243 = ex;
                boolean bl = false;
                Collection collection3 = (Collection)((WeakReference)globalWriteObserversRef.element).get();
                if (collection3 != null) {
                    collection3.clear();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                $this$dispose_u24lambda_u243 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                $this$dispose_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            ex = $this$dispose;
            try {
                Unit unit;
                $this$dispose_u24lambda_u244 = ex;
                boolean bl = false;
                Collection collection4 = (Collection)((WeakReference)toRunTrampolinedRef.element).get();
                if (collection4 != null) {
                    collection4.clear();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                $this$dispose_u24lambda_u244 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                $this$dispose_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        WeakReference<Field> broadcastManagerInstanceField = new WeakReference<Field>(RenderSessionCleaner.findLocalBroadcastManagerInstance(classLoader));
        disposeMethod.ifPresent(arg_0 -> RenderSessionCleaner.dispose$lambda$6(RenderSessionCleaner::dispose$lambda$5, arg_0));
        Optional<Object> finalDisposeMethod = disposeMethod;
        return RenderService.getRenderAsyncActionExecutor().runAsyncAction(RenderAsyncActionExecutor.RenderingTopic.CLEAN, () -> RenderSessionCleaner.dispose$lambda$11(finalDisposeMethod, applyObserversRef, globalWriteObserversRef, toRunTrampolinedRef, broadcastManagerInstanceField, $this$dispose));
    }

    private static final void disposeIfCompose(ViewInfo viewInfo, Method disposeMethod) {
        Class<?> viewObject = viewInfo.getViewObject();
        Class<?> clazz2 = viewObject;
        if (!Intrinsics.areEqual((Object)(clazz2 != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getName() : null), (Object)"androidx.compose.ui.tooling.ComposeViewAdapter")) {
            return;
        }
        try {
            disposeMethod.invoke(viewObject, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            LOG.warn("Unexpected error while disposing compose view", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            LOG.warn("Unexpected error while disposing compose view", (Throwable)ex);
        }
    }

    private static final Collection<?> findToRunTrampolined(ModuleClassLoader classLoader) {
        try {
            Class<?> clazz22;
            Method method2;
            if (!classLoader.hasLoadedClass(ANDROID_UI_DISPATCHER_FQN)) {
                LOG.warn("Unexpected: androidx.compose.ui.tooling.ComposeViewAdapter is loaded and androidx.compose.ui.platform.AndroidUiDispatcher is not");
                return null;
            }
            Class<?> uiDispatcher = classLoader.loadClass(ANDROID_UI_DISPATCHER_FQN);
            if (!classLoader.hasLoadedClass(ANDROID_UI_DISPATCHER_COMPANION_FQN)) {
                LOG.warn("Unexpected: androidx.compose.ui.platform.AndroidUiDispatcher is loaded and androidx.compose.ui.platform.AndroidUiDispatcher$Companion is not");
                return null;
            }
            String ANDROID_UI_DISPATCHER_COMPANION_VALUE_FQN = "androidx.compose.ui.platform.AndroidUiDispatcher$Companion$Main$2";
            if (classLoader.hasLoadedClass(ANDROID_UI_DISPATCHER_COMPANION_VALUE_FQN)) {
                Class<?> uiDispatcherCompanionValue = classLoader.loadClass(ANDROID_UI_DISPATCHER_COMPANION_VALUE_FQN);
                try {
                    Field instanceField = uiDispatcherCompanionValue.getField("INSTANCE");
                    if (instanceField.get(null) == null) {
                        LOG.warn("Unexpected: uninitialized AndroidUiDispatcher.Main");
                    }
                }
                catch (ReflectiveOperationException instanceField) {
                    // empty catch block
                }
            }
            Class<?> uiDispatcherCompanion = classLoader.loadClass(ANDROID_UI_DISPATCHER_COMPANION_FQN);
            Field uiDispatcherCompanionField = uiDispatcher.getDeclaredField("Companion");
            Object uiDispatcherCompanionObj = uiDispatcherCompanionField.get(null);
            Method $this$findToRunTrampolined_u24lambda_u2412 = method2 = uiDispatcherCompanion.getDeclaredMethod("getMain", new Class[0]);
            boolean clazz22 = false;
            $this$findToRunTrampolined_u24lambda_u2412.setAccessible(true);
            Method getMainMethod = method2;
            Object mainObj = getMainMethod.invoke(uiDispatcherCompanionObj, new Object[0]);
            try {
                clazz22 = classLoader.loadClass(COMBINED_CONTEXT_FQN);
            }
            catch (ClassNotFoundException e) {
                clazz22 = classLoader.loadClass(StringsKt.removePrefix((String)COMBINED_CONTEXT_FQN, (CharSequence)INTERNAL_PACKAGE));
            }
            Class<?> combinedContext = clazz22;
            Field $this$findToRunTrampolined_u24lambda_u2413 = e = combinedContext.getDeclaredField("element");
            boolean bl = false;
            $this$findToRunTrampolined_u24lambda_u2413.setAccessible(true);
            Field elementField = e;
            Object uiDispatcherObj = elementField.get(mainObj);
            Field $this$findToRunTrampolined_u24lambda_u2414 = bl = uiDispatcher.getDeclaredField("toRunTrampolined");
            boolean bl2 = false;
            $this$findToRunTrampolined_u24lambda_u2414.setAccessible(true);
            Field toRunTrampolinedField = bl;
            Object toRunTrampolinedObj = toRunTrampolinedField.get(uiDispatcherObj);
            if (TypeIntrinsics.isMutableCollection((Object)toRunTrampolinedObj)) {
                return (Collection)toRunTrampolinedObj;
            }
            LOG.warn("AndroidUiDispatcher.toRunTrampolined found but it is not a MutableCollection");
        }
        catch (ReflectiveOperationException ex) {
            LOG.warn("Unable to find AndroidUiDispatcher.toRunTrampolined", (Throwable)ex);
        }
        return null;
    }

    private static final Collection<?> findSnapshotKtObserversField(ModuleClassLoader classLoader, String fieldName) {
        try {
            Class<?> snapshotKt = classLoader.loadClass(SNAPSHOT_KT_FQN);
            Field observersField = snapshotKt.getDeclaredField(fieldName);
            observersField.setAccessible(true);
            Object applyObservers = observersField.get(null);
            if (TypeIntrinsics.isMutableCollection((Object)applyObservers)) {
                return (Collection)applyObservers;
            }
            LOG.warn("SnapshotsKt." + fieldName + " found but it is not a Collection");
        }
        catch (ReflectiveOperationException ex) {
            LOG.warn("Unable to find SnapshotsKt." + fieldName, (Throwable)ex);
        }
        return null;
    }

    private static final Field findLocalBroadcastManagerInstance(ModuleClassLoader classLoader) {
        Field field2;
        try {
            Field field3;
            Class<?> broadcastManagerClass = classLoader.loadClass(LOCAL_BROADCAST_MANAGER_FQN);
            Field $this$findLocalBroadcastManagerInstance_u24lambda_u2415 = field3 = broadcastManagerClass.getDeclaredField("mInstance");
            boolean bl = false;
            $this$findLocalBroadcastManagerInstance_u24lambda_u2415.setAccessible(true);
            field2 = field3;
        }
        catch (ReflectiveOperationException ex) {
            LOG.debug("Unable to find androidx.localbroadcastmanager.content.LocalBroadcastManager.mInstance", (Throwable)ex);
            field2 = null;
        }
        return field2;
    }

    public static final void clearFontRequestWorker(@NotNull ModuleClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        if (!classLoader.hasLoadedClass(FONT_REQUEST_WORKER_FQN)) {
            return;
        }
        try {
            Class<?> fontRequestWorker = classLoader.loadClass(FONT_REQUEST_WORKER_FQN);
            Field pendingRepliesField = fontRequestWorker.getDeclaredField("PENDING_REPLIES");
            pendingRepliesField.setAccessible(true);
            Object pendingReplies = pendingRepliesField.get(fontRequestWorker);
            pendingReplies.getClass().getMethod("clear", new Class[0]).invoke(pendingReplies, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            LOG.debug("Unable to dispose the PENDING_REPLIES", (Throwable)ex);
        }
    }

    public static final void clearGapWorkerCache(@NotNull ModuleClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        String string = AndroidXConstants.RECYCLER_VIEW.newName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newName(...)");
        if (!classLoader.hasLoadedClass(string)) {
            String string2 = AndroidXConstants.RECYCLER_VIEW.oldName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"oldName(...)");
            if (!classLoader.hasLoadedClass(string2)) {
                return;
            }
        }
        try {
            Class<?> gapWorkerClass = classLoader.loadClass(GAP_WORKER_CLASS_NAME);
            Field gapWorkerField = gapWorkerClass.getDeclaredField("sGapWorker");
            gapWorkerField.setAccessible(true);
            RenderService.getRenderAsyncActionExecutor().runAsyncAction(RenderAsyncActionExecutor.RenderingTopic.CLEAN, () -> RenderSessionCleaner.clearGapWorkerCache$lambda$16(gapWorkerField));
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
    }

    public static final void clearCompositions(@NotNull ModuleClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        if (!classLoader.hasLoadedClass("androidx.compose.runtime.Recomposer")) {
            return;
        }
        try {
            Class<?> recomposerClass = classLoader.loadClass("androidx.compose.runtime.Recomposer");
            Field field2 = recomposerClass.getDeclaredField("_runningRecomposers");
            Object $this$clearCompositions_u24lambda_u2417 = field2;
            boolean bl = false;
            ((Field)$this$clearCompositions_u24lambda_u2417).setAccessible(true);
            Object runningRecomposers = field2.get(null);
            Method $this$clearCompositions_u24lambda_u2418 = bl = runningRecomposers.getClass().getMethod("getValue", new Class[0]);
            boolean bl2 = false;
            $this$clearCompositions_u24lambda_u2418.setAccessible(true);
            $this$clearCompositions_u24lambda_u2417 = bl.invoke(runningRecomposers, new Object[0]);
            Intrinsics.checkNotNull((Object)$this$clearCompositions_u24lambda_u2417, (String)"null cannot be cast to non-null type kotlin.collections.Set<*>");
            Set currentRunningSet = (Set)$this$clearCompositions_u24lambda_u2417;
            if (!((Collection)currentRunningSet).isEmpty()) {
                Object recomposerCompanion = recomposerClass.getField("Companion").get(null);
                Class<?> recomposerCompanionClass = classLoader.loadClass("androidx.compose.runtime.Recomposer$Companion");
                Method[] methodArray = recomposerCompanionClass.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                Object[] $this$single$iv = methodArray;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    Method it = (Method)element$iv;
                    boolean bl3 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"removeRunning", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Array contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Array contains no element matching the predicate.");
                }
                Method removeRunning = (Method)single$iv;
                Iterable $this$forEach$iv = currentRunningSet;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl4 = false;
                    Object[] objectArray = new Object[]{recomposerCompanion, it};
                    removeRunning.invoke(null, objectArray);
                }
            }
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
    }

    private static final boolean dispose$lambda$0(Method m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        String string = m.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"dispose", (boolean)false, (int)2, null);
    }

    private static final boolean dispose$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit dispose$lambda$5(Method m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m.setAccessible(true);
        return Unit.INSTANCE;
    }

    private static final void dispose$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void dispose$lambda$11$lambda$9$lambda$8$lambda$7(Method $m, ViewInfo v) {
        ViewInfo viewInfo = v;
        Intrinsics.checkNotNull((Object)viewInfo);
        Method method2 = $m;
        Intrinsics.checkNotNull((Object)method2);
        RenderSessionCleaner.disposeIfCompose(viewInfo, method2);
    }

    private static final void dispose$lambda$11$lambda$9$lambda$8(RenderSession $this_dispose, Method $m) {
        $this_dispose.getRootViews().forEach(arg_0 -> RenderSessionCleaner.dispose$lambda$11$lambda$9$lambda$8$lambda$7($m, arg_0));
    }

    private static final Unit dispose$lambda$11$lambda$9(RenderSession $this_dispose, Method m) {
        $this_dispose.execute(() -> RenderSessionCleaner.dispose$lambda$11$lambda$9$lambda$8($this_dispose, m));
        return Unit.INSTANCE;
    }

    private static final void dispose$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void dispose$lambda$11(Optional $finalDisposeMethod, Ref.ObjectRef $applyObserversRef, Ref.ObjectRef $globalWriteObserversRef, Ref.ObjectRef $toRunTrampolinedRef, WeakReference $broadcastManagerInstanceField, RenderSession $this_dispose) {
        Object object;
        Object object2;
        $finalDisposeMethod.ifPresent(arg_0 -> RenderSessionCleaner.dispose$lambda$11$lambda$10(arg_0 -> RenderSessionCleaner.dispose$lambda$11$lambda$9($this_dispose, arg_0), arg_0));
        Object object3 = (WeakReference)$applyObserversRef.element;
        if (object3 != null && (object3 = (Collection)((Reference)object3).get()) != null) {
            object3.clear();
        }
        if ((object2 = (WeakReference)$globalWriteObserversRef.element) != null && (object2 = (Collection)((Reference)object2).get()) != null) {
            object2.clear();
        }
        if ((object = (WeakReference)$toRunTrampolinedRef.element) != null && (object = (Collection)((Reference)object).get()) != null) {
            object.clear();
        }
        Field field2 = (Field)$broadcastManagerInstanceField.get();
        if (field2 != null) {
            field2.set(null, null);
        }
        $this_dispose.dispose();
    }

    private static final void clearGapWorkerCache$lambda$16(Field $gapWorkerField) {
        try {
            Object object = $gapWorkerField.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.ThreadLocal<*>");
            ThreadLocal gapWorkerFieldValue = (ThreadLocal)object;
            gapWorkerFieldValue.set(null);
            LOG.debug("GapWorker was cleared");
        }
        catch (IllegalAccessException e) {
            LOG.debug((Throwable)e);
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"RenderSessionDisposer");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

