/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\f\u001a\u00020\u00052\b\b\u0001\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0010J1\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/rendering/RenderingBundle;", "", "<init>", "()V", "BUNDLE_NAME", "", "ourBundle", "Ljava/lang/ref/Reference;", "Ljava/util/ResourceBundle;", "bundle", "getBundle", "()Ljava/util/ResourceBundle;", "message", "key", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "readFromBundleAndFormat", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "intellij.android.rendering"})
public final class RenderingBundle {
    @NotNull
    public static final RenderingBundle INSTANCE = new RenderingBundle();
    @NonNls
    @NotNull
    private static final String BUNDLE_NAME = "messages.RenderingBundle";
    @Nullable
    private static Reference<ResourceBundle> ourBundle;

    private RenderingBundle() {
    }

    private final ResourceBundle getBundle() {
        ResourceBundle bundle;
        Reference<ResourceBundle> reference = ourBundle;
        ResourceBundle resourceBundle = bundle = reference != null ? reference.get() : null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @JvmStatic
    @NotNull
    public static final String message(@PropertyKey(resourceBundle="messages.RenderingBundle") @NotNull String key, Object ... params2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        ResourceBundle resourceBundle = INSTANCE.getBundle();
        Intrinsics.checkNotNull((Object)resourceBundle);
        return INSTANCE.readFromBundleAndFormat(resourceBundle, key, Arrays.copyOf(params2, params2.length));
    }

    private final String readFromBundleAndFormat(ResourceBundle bundle, String key, Object ... params2) {
        String rawValue = bundle.getString(key);
        Locale locale = bundle.getLocale();
        MessageFormat format = new MessageFormat(rawValue, locale);
        String string = format.format(params2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

