/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.classloading;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.rendering.classloading.ClassBinaryCache;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0007R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u00060\u000bR\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0013\u001aB\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016 \u0015* \u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/rendering/classloading/ClassBinaryCacheManager;", "", "ticker", "Lcom/google/common/base/Ticker;", "maxWeight", "", "expireMinutes", "<init>", "(Lcom/google/common/base/Ticker;JJ)V", "scopeCaches", "Ljava/util/WeakHashMap;", "Lcom/android/tools/rendering/classloading/ClassBinaryCacheManager$ModuleClassCache;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "libraryPath2ClassFqns", "", "", "", "classFqn2LibraryPath", "globalCache", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "", "getCache", "Lcom/android/tools/rendering/classloading/ClassBinaryCache;", "scope", "ModuleClassCache", "Companion", "intellij.android.rendering"})
public final class ClassBinaryCacheManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakHashMap<Object, ModuleClassCache> scopeCaches = new WeakHashMap();
    @NotNull
    private ReentrantLock lock = new ReentrantLock();
    @NotNull
    private final Map<String, Set<String>> libraryPath2ClassFqns = new LinkedHashMap();
    @NotNull
    private final Map<String, String> classFqn2LibraryPath = new LinkedHashMap();
    private final Cache<String, byte[]> globalCache;
    @NotNull
    private static final ClassBinaryCacheManager globalManager;

    private ClassBinaryCacheManager(Ticker ticker, long maxWeight, long expireMinutes) {
        this.globalCache = CacheBuilder.newBuilder().ticker(ticker).concurrencyLevel(1).maximumWeight(maxWeight).weigher((arg_0, arg_1) -> ClassBinaryCacheManager.globalCache$lambda$1(ClassBinaryCacheManager::globalCache$lambda$0, arg_0, arg_1)).expireAfterAccess(Duration.ofMinutes(expireMinutes)).removalListener(arg_0 -> ClassBinaryCacheManager.globalCache$lambda$5(arg_0 -> ClassBinaryCacheManager.globalCache$lambda$4(this, arg_0), arg_0)).build();
    }

    @AnyThread
    @NotNull
    public final synchronized ClassBinaryCache getCache(@NotNull Object scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ModuleClassCache moduleClassCache = this.scopeCaches.computeIfAbsent(scope, arg_0 -> ClassBinaryCacheManager.getCache$lambda$6(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)moduleClassCache, (String)"computeIfAbsent(...)");
        return moduleClassCache;
    }

    private static final int globalCache$lambda$0(String string, byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return value2.length;
    }

    private static final int globalCache$lambda$1(Function2 $tmp0, Object key, Object value2) {
        return ((Number)$tmp0.invoke(key, value2)).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit globalCache$lambda$4(ClassBinaryCacheManager this$0, RemovalNotification it) {
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl = false;
            Map<String, String> map2 = this$0.classFqn2LibraryPath;
            Object object = it.getKey();
            String string = (String)TypeIntrinsics.asMutableMap(map2).remove(object);
            if (string != null) {
                String url = string;
                boolean bl2 = false;
                Set<String> set2 = this$0.libraryPath2ClassFqns.get(url);
                if (set2 != null) {
                    Collection collection2 = set2;
                    Object object2 = it.getKey();
                    TypeIntrinsics.asMutableCollection((Object)collection2).remove(object2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return Unit.INSTANCE;
    }

    private static final void globalCache$lambda$5(Function1 $tmp0, RemovalNotification notification) {
        $tmp0.invoke((Object)notification);
    }

    private static final ModuleClassCache getCache$lambda$6(ClassBinaryCacheManager this$0, Object it) {
        return this$0.new ModuleClassCache();
    }

    @JvmStatic
    @NotNull
    public static final ClassBinaryCacheManager getInstance() {
        return Companion.getInstance();
    }

    public /* synthetic */ ClassBinaryCacheManager(Ticker ticker, long maxWeight, long expireMinutes, DefaultConstructorMarker $constructor_marker) {
        this(ticker, maxWeight, expireMinutes);
    }

    static {
        Ticker ticker = Ticker.systemTicker();
        Intrinsics.checkNotNullExpressionValue((Object)ticker, (String)"systemTicker(...)");
        globalManager = new ClassBinaryCacheManager(ticker, 100000000L, 30L);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0007J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/rendering/classloading/ClassBinaryCacheManager$Companion;", "", "<init>", "()V", "globalManager", "Lcom/android/tools/rendering/classloading/ClassBinaryCacheManager;", "getInstance", "getTestInstance", "ticker", "Lcom/google/common/base/Ticker;", "maxWeight", "", "expireMinutes", "intellij.android.rendering"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClassBinaryCacheManager getInstance() {
            return globalManager;
        }

        @TestOnly
        @NotNull
        public final ClassBinaryCacheManager getTestInstance(@NotNull Ticker ticker, long maxWeight, long expireMinutes) {
            Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
            return new ClassBinaryCacheManager(ticker, maxWeight, expireMinutes, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/rendering/classloading/ClassBinaryCacheManager$ModuleClassCache;", "Lcom/android/tools/rendering/classloading/ClassBinaryCache;", "<init>", "(Lcom/android/tools/rendering/classloading/ClassBinaryCacheManager;)V", "libraryPaths", "", "", "notCurrentDependency", "", "path", "get", "", "fqcn", "transformationId", "getCachingKey", "put", "", "libraryPath", "data", "setDependencies", "paths", "", "intellij.android.rendering"})
    @SourceDebugExtension(value={"SMAP\nClassBinaryCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassBinaryCacheManager.kt\ncom/android/tools/rendering/classloading/ClassBinaryCacheManager$ModuleClassCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n1863#3,2:127\n*S KotlinDebug\n*F\n+ 1 ClassBinaryCacheManager.kt\ncom/android/tools/rendering/classloading/ClassBinaryCacheManager$ModuleClassCache\n*L\n87#1:127,2\n*E\n"})
    private final class ModuleClassCache
    implements ClassBinaryCache {
        @NotNull
        private Set<String> libraryPaths = SetsKt.emptySet();

        private final synchronized boolean notCurrentDependency(String path) {
            return !CollectionsKt.contains((Iterable)this.libraryPaths, (Object)path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public byte[] get(@NotNull String fqcn, @NotNull String transformationId) {
            String $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22;
            Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
            Intrinsics.checkNotNullParameter((Object)transformationId, (String)"transformationId");
            String key = this.getCachingKey(fqcn, transformationId);
            Object object = ClassBinaryCacheManager.this.lock;
            ClassBinaryCacheManager classBinaryCacheManager = ClassBinaryCacheManager.this;
            object.lock();
            try {
                boolean $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22 = false;
                $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22 = (String)classBinaryCacheManager.classFqn2LibraryPath.get(key);
            }
            finally {
                object.unlock();
            }
            String libraryPath = $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22;
            if (this.notCurrentDependency(libraryPath)) {
                String string = libraryPath;
                if (string != null) {
                    Set $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$1$22;
                    object = string;
                    classBinaryCacheManager = ClassBinaryCacheManager.this;
                    Object it = object;
                    boolean bl = false;
                    Object object2 = classBinaryCacheManager.lock;
                    object2.lock();
                    try {
                        boolean $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$1$22 = false;
                        $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$1$22 = (Set)classBinaryCacheManager.libraryPath2ClassFqns.remove(libraryPath);
                    }
                    finally {
                        object2.unlock();
                    }
                    Set set2 = $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$1$22;
                    if (set2 != null) {
                        void $this$forEach$iv;
                        object2 = set2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String it2 = (String)element$iv;
                            boolean bl2 = false;
                            classBinaryCacheManager.globalCache.invalidate((Object)it2);
                        }
                    }
                }
                return null;
            }
            return (byte[])ClassBinaryCacheManager.this.globalCache.getIfPresent((Object)key);
        }

        private final String getCachingKey(String fqcn, String transformationId) {
            return transformationId + ":" + fqcn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(@NotNull String fqcn, @NotNull String transformationId, @NotNull String libraryPath, @NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
            Intrinsics.checkNotNullParameter((Object)transformationId, (String)"transformationId");
            Intrinsics.checkNotNullParameter((Object)libraryPath, (String)"libraryPath");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            String key = this.getCachingKey(fqcn, transformationId);
            Lock lock = ClassBinaryCacheManager.this.lock;
            ClassBinaryCacheManager classBinaryCacheManager = ClassBinaryCacheManager.this;
            lock.lock();
            try {
                boolean bl = false;
                classBinaryCacheManager.classFqn2LibraryPath.put(key, libraryPath);
                boolean bl2 = classBinaryCacheManager.libraryPath2ClassFqns.computeIfAbsent(libraryPath, arg_0 -> ModuleClassCache.put$lambda$6$lambda$5(ModuleClassCache::put$lambda$6$lambda$4, arg_0)).add(fqcn);
            }
            finally {
                lock.unlock();
            }
            ClassBinaryCacheManager.this.globalCache.put((Object)key, (Object)data2);
        }

        @Override
        @AnyThread
        public synchronized void setDependencies(@NotNull Collection<String> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            this.libraryPaths = CollectionsKt.toSet((Iterable)paths);
        }

        @Override
        @Nullable
        public byte[] get(@NotNull String fqcn) {
            return ClassBinaryCache.super.get(fqcn);
        }

        @Override
        public void put(@NotNull String fqcn, @NotNull String libraryPath, @NotNull byte[] data2) {
            ClassBinaryCache.super.put(fqcn, libraryPath, data2);
        }

        private static final Set put$lambda$6$lambda$4(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set put$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }
    }
}

