/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.log;

import com.android.tools.rendering.api.RenderModelModuleLoggingId;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogAnonymizerUtil {
    private static final String SALT = Integer.toString(new SecureRandom().nextInt());

    @NotNull
    public static String anonymize(@Nullable RenderModelModuleLoggingId module) {
        if (module == null) {
            return "null";
        }
        if (module.isDisposed()) {
            return "<disposed>";
        }
        return "module:" + Hashing.sha256().hashString((CharSequence)(SALT + module.getName()), StandardCharsets.UTF_8).toString();
    }
}

