/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerConfigResourceMap
implements ListMultimap<String, ResourceItem> {
    private final Map<String, List<ResourceItem>> myMap = new LinkedHashMap<String, List<ResourceItem>>();
    private int mySize = 0;
    @NotNull
    private final ResourceItemComparator myComparator;
    @Nullable
    private Values myValues;

    PerConfigResourceMap(@NotNull ResourceItemComparator comparator) {
        this.myComparator = comparator;
    }

    @NotNull
    public List<ResourceItem> get(@Nullable String key) {
        List<ResourceItem> items = this.myMap.get(key);
        return items == null ? ImmutableList.of() : items;
    }

    @NotNull
    public Set<String> keySet() {
        return this.myMap.keySet();
    }

    @NotNull
    public Multiset<String> keys() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Collection<ResourceItem> values() {
        Values values = this.myValues;
        if (values == null) {
            this.myValues = values = new Values();
        }
        return values;
    }

    @NotNull
    public Collection<Map.Entry<String, ResourceItem>> entries() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<ResourceItem> removeAll(@Nullable Object key) {
        List<ResourceItem> removed = this.myMap.remove(key);
        if (removed != null) {
            this.mySize -= removed.size();
        }
        return removed == null ? ImmutableList.of() : removed;
    }

    boolean removeIf(@NotNull String key, @NotNull Predicate<? super ResourceItem> filter2) {
        List<ResourceItem> list = this.myMap.get(key);
        if (list == null) {
            return false;
        }
        int oldSize = list.size();
        boolean removed = list.removeIf(filter2);
        this.mySize += list.size() - oldSize;
        if (list.isEmpty()) {
            this.myMap.remove(key);
        }
        return removed;
    }

    public void clear() {
        this.myMap.clear();
        this.mySize = 0;
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean containsKey(@Nullable Object key) {
        return this.myMap.containsKey(key);
    }

    public boolean containsValue(@Nullable Object value2) {
        throw new UnsupportedOperationException();
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value2) {
        throw new UnsupportedOperationException();
    }

    public boolean put(@NotNull String key, @NotNull ResourceItem item) {
        List list = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
        int oldSize = list.size();
        list.add(item);
        this.mySize += list.size() - oldSize;
        return true;
    }

    public boolean remove(@Nullable Object key, @Nullable Object value2) {
        throw new UnsupportedOperationException();
    }

    public boolean putAll(@NotNull String key, @NotNull Iterable<? extends ResourceItem> items) {
        if (items instanceof Collection) {
            if (((Collection)items).isEmpty()) {
                return false;
            }
            List list = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
            int oldSize = list.size();
            boolean added = list.addAll((Collection)items);
            this.mySize += list.size() - oldSize;
            return added;
        }
        boolean added = false;
        List list = null;
        int oldSize = 0;
        for (ResourceItem resourceItem : items) {
            if (list == null) {
                list = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
                oldSize = list.size();
            }
            added = list.add(resourceItem);
        }
        if (list != null) {
            this.mySize += list.size() - oldSize;
        }
        return added;
    }

    public boolean putAll(Multimap<? extends String, ? extends ResourceItem> multimap) {
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            String key = (String)entry.getKey();
            Collection items = (Collection)entry.getValue();
            if (items.isEmpty()) continue;
            List list = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
            int oldSize = list.size();
            list.addAll(items);
            this.mySize += list.size() - oldSize;
        }
        return !multimap.isEmpty();
    }

    @NotNull
    public List<ResourceItem> replaceValues(@Nullable String key, @NotNull Iterable<? extends ResourceItem> values) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Map<String, Collection<ResourceItem>> asMap() {
        return this.myMap;
    }

    public static class ResourceItemComparator
    implements Comparator<ResourceItem> {
        private final Comparator<ResourceItem> myPriorityComparator;

        ResourceItemComparator(@NotNull Collection<SingleNamespaceResourceRepository> repositories) {
            this.myPriorityComparator = new ResourcePriorityComparator(repositories);
        }

        @Override
        public int compare(@NotNull ResourceItem item1, @NotNull ResourceItem item2) {
            int c = item1.getConfiguration().compareTo(item2.getConfiguration());
            if (c != 0) {
                return c;
            }
            return this.myPriorityComparator.compare(item1, item2);
        }

        private static class ResourcePriorityComparator
        implements Comparator<ResourceItem> {
            private final Object2IntMap<SingleNamespaceResourceRepository> repositoryOrdering;

            ResourcePriorityComparator(@NotNull Collection<SingleNamespaceResourceRepository> repositories) {
                this.repositoryOrdering = new Object2IntOpenHashMap(repositories.size());
                int i = 0;
                for (SingleNamespaceResourceRepository repository2 : repositories) {
                    this.repositoryOrdering.put((Object)repository2, i++);
                }
            }

            @Override
            public int compare(@NotNull ResourceItem item1, @NotNull ResourceItem item2) {
                return Integer.compare(this.getOrdering(item1), this.getOrdering(item2));
            }

            private int getOrdering(@NotNull ResourceItem item) {
                int ordering = this.repositoryOrdering.getInt((Object)item.getRepository());
                assert (ordering >= 0);
                return ordering;
            }
        }
    }

    private class Values
    extends AbstractCollection<ResourceItem> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<ResourceItem> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int size() {
            return PerConfigResourceMap.this.mySize;
        }

        private class ValuesIterator
        implements Iterator<ResourceItem> {
            private final Iterator<List<ResourceItem>> myOuterCursor;
            private List<ResourceItem> myCurrentList;
            private int myInnerCursor;

            private ValuesIterator() {
                this.myOuterCursor = PerConfigResourceMap.this.myMap.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.myCurrentList != null || this.myOuterCursor.hasNext();
            }

            @Override
            public ResourceItem next() {
                if (this.myCurrentList == null) {
                    this.myCurrentList = this.myOuterCursor.next();
                    this.myInnerCursor = 0;
                }
                try {
                    ResourceItem item = this.myCurrentList.get(this.myInnerCursor);
                    if (++this.myInnerCursor >= this.myCurrentList.size()) {
                        this.myCurrentList = null;
                    }
                    return item;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
        }
    }

    private class PerConfigResourceList
    extends AbstractList<ResourceItem> {
        private final List<List<ResourceItem>> myResourceItems = new ArrayList<List<ResourceItem>>();

        private PerConfigResourceList() {
        }

        @Override
        @NotNull
        public ResourceItem get(int index) {
            return this.myResourceItems.get(index).get(0);
        }

        @Override
        public int size() {
            return this.myResourceItems.size();
        }

        @Override
        public boolean add(@NotNull ResourceItem item) {
            this.add(item, 0);
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends ResourceItem> items) {
            if (items.isEmpty()) {
                return false;
            }
            if (items.size() == 1) {
                return this.add(items.iterator().next());
            }
            List<ResourceItem> sortedItems = this.sortedItems(items);
            int start2 = 0;
            for (ResourceItem item : sortedItems) {
                start2 = this.add(item, start2);
            }
            return true;
        }

        private int add(ResourceItem item, int start2) {
            int index = this.findConfigIndex(item, start2, this.myResourceItems.size());
            if (index < 0) {
                this.myResourceItems.add(index ^= 0xFFFFFFFF, (List<ResourceItem>)new SmartList((Object)item));
            } else {
                List<ResourceItem> nested = this.myResourceItems.get(index);
                int i = nested.size();
                while (--i >= 0 && PerConfigResourceMap.this.myComparator.myPriorityComparator.compare(item, nested.get(i)) <= 0) {
                }
                nested.add(i + 1, item);
            }
            return index;
        }

        @Override
        public void clear() {
            this.myResourceItems.clear();
        }

        @Override
        public boolean remove(@Nullable Object item) {
            assert (item != null);
            int index = this.remove((ResourceItem)item, this.myResourceItems.size());
            return index >= 0;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> items) {
            if (items.isEmpty()) {
                return false;
            }
            if (items.size() == 1) {
                return this.remove(items.iterator().next());
            }
            List<ResourceItem> itemsToDelete = this.sortedItems(items);
            boolean modified = false;
            int end = this.myResourceItems.size();
            int i = itemsToDelete.size();
            while (--i >= 0) {
                int index = this.remove(itemsToDelete.get(i), end);
                if (index > 0) {
                    modified = true;
                    end = index;
                    continue;
                }
                end = ~index;
            }
            return modified;
        }

        @Override
        public boolean removeIf(@NotNull Predicate<? super ResourceItem> filter2) {
            boolean removed = false;
            int i = this.myResourceItems.size();
            while (--i >= 0) {
                List<ResourceItem> nested = this.myResourceItems.get(i);
                int j = nested.size();
                while (--j >= 0) {
                    ResourceItem item = nested.get(j);
                    if (!filter2.test((ResourceItem)item)) continue;
                    nested.remove(j);
                    removed = true;
                }
                if (!nested.isEmpty()) continue;
                this.myResourceItems.remove(i);
            }
            return removed;
        }

        private int remove(@NotNull ResourceItem item, int end) {
            int index = this.findConfigIndex(item, 0, end);
            if (index < 0) {
                return index;
            }
            List<ResourceItem> nested = this.myResourceItems.get(index);
            if (!nested.remove(item)) {
                return ~(index + 1);
            }
            if (nested.isEmpty()) {
                this.myResourceItems.remove(index);
                return index;
            }
            return index + 1;
        }

        @NotNull
        private List<ResourceItem> sortedItems(@NotNull Collection<? extends ResourceItem> items) {
            ArrayList<ResourceItem> sortedItems = new ArrayList<ResourceItem>(items);
            sortedItems.sort(PerConfigResourceMap.this.myComparator);
            return sortedItems;
        }

        private int findConfigIndex(@NotNull ResourceItem item, int start2, int end) {
            FolderConfiguration config = item.getConfiguration();
            int low = start2;
            int high = end;
            while (low < high) {
                int mid = low + high >>> 1;
                FolderConfiguration value2 = this.myResourceItems.get(mid).get(0).getConfiguration();
                int c = value2.compareTo(config);
                if (c < 0) {
                    low = mid + 1;
                    continue;
                }
                if (c > 0) {
                    high = mid;
                    continue;
                }
                return mid;
            }
            return ~low;
        }
    }
}

