/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res.ids;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.res.ResourceNamespacing;
import com.android.tools.res.ids.FrameworkResourceIdsProvider;
import com.android.tools.res.ids.ResourceIdManager;
import com.android.tools.res.ids.ResourceIdManagerBaseKt;
import com.android.tools.res.ids.ResourceIdManagerModelModule;
import com.android.tools.res.ids.SingleNamespaceIdMapping;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001.B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0017\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\b\u0010)\u001a\u00020\fH\u0016J\u0016\u0010*\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lcom/android/tools/res/ids/ResourceIdManagerBase;", "Lcom/android/tools/res/ids/ResourceIdManager;", "module", "Lcom/android/tools/res/ids/ResourceIdManagerModelModule;", "searchFrameworkIds", "", "frameworkResourceIdsProvider", "Lcom/android/tools/res/ids/FrameworkResourceIdsProvider;", "<init>", "(Lcom/android/tools/res/ids/ResourceIdManagerModelModule;ZLcom/android/tools/res/ids/FrameworkResourceIdsProvider;)V", "(Lcom/android/tools/res/ids/ResourceIdManagerModelModule;Z)V", "generationCounter", "", "nextPackageId", "", "perNamespaceProviders", "Ljava/util/HashMap;", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "Lcom/android/tools/res/ids/ResourceIdManagerBase$IdProvider;", "Lkotlin/collections/HashMap;", "resetProviders", "", "dynamicToIdMap", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lcom/android/ide/common/rendering/api/ResourceReference;", "dynamicFromIdMap", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "compiledIds", "Lcom/android/tools/res/ids/SingleNamespaceIdMapping;", "frameworkIds", "finalIdsUsed", "getFinalIdsUsed", "()Z", "findById", "id", "", "getCompiledId", "resource", "(Lcom/android/ide/common/rendering/api/ResourceReference;)Ljava/lang/Integer;", "getOrGenerateId", "resetDynamicIds", "getGeneration", "resetCompiledIds", "rClassProvider", "Ljava/util/function/Consumer;", "Lcom/android/tools/res/ids/ResourceIdManager$RClassParser;", "IdProvider", "intellij.android.render-resources"})
@SourceDebugExtension(value={"SMAP\nResourceIdManagerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceIdManagerBase.kt\ncom/android/tools/res/ids/ResourceIdManagerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,513:1\n1#2:514\n381#3,7:515\n*S KotlinDebug\n*F\n+ 1 ResourceIdManagerBase.kt\ncom/android/tools/res/ids/ResourceIdManagerBase\n*L\n479#1:515,7\n*E\n"})
public class ResourceIdManagerBase
implements ResourceIdManager {
    @NotNull
    private final ResourceIdManagerModelModule module;
    private final boolean searchFrameworkIds;
    private long generationCounter;
    private byte nextPackageId;
    @NotNull
    private final HashMap<ResourceNamespace, IdProvider> perNamespaceProviders;
    @NotNull
    private final Object2IntOpenHashMap<ResourceReference> dynamicToIdMap;
    @NotNull
    private final Int2ObjectOpenHashMap<ResourceReference> dynamicFromIdMap;
    @Nullable
    private SingleNamespaceIdMapping compiledIds;
    @NotNull
    private final SingleNamespaceIdMapping frameworkIds;

    public ResourceIdManagerBase(@NotNull ResourceIdManagerModelModule module, boolean searchFrameworkIds, @NotNull FrameworkResourceIdsProvider frameworkResourceIdsProvider) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)frameworkResourceIdsProvider, (String)"frameworkResourceIdsProvider");
        this.module = module;
        this.searchFrameworkIds = searchFrameworkIds;
        this.generationCounter = 1L;
        this.nextPackageId = (byte)2;
        this.perNamespaceProviders = new HashMap();
        this.resetProviders();
        this.dynamicToIdMap = new Object2IntOpenHashMap();
        this.dynamicFromIdMap = new Int2ObjectOpenHashMap();
        this.frameworkIds = frameworkResourceIdsProvider.loadFrameworkIds(this.module.getUseRBytecodeParsing());
    }

    public ResourceIdManagerBase(@NotNull ResourceIdManagerModelModule module, boolean searchFrameworkIds) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this(module, searchFrameworkIds, FrameworkResourceIdsProvider.Companion.createInstanceForTests());
    }

    public /* synthetic */ ResourceIdManagerBase(ResourceIdManagerModelModule resourceIdManagerModelModule, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(resourceIdManagerModelModule, bl);
    }

    private final synchronized void resetProviders() {
        this.nextPackageId = (byte)2;
        this.perNamespaceProviders.clear();
        ((Map)this.perNamespaceProviders).put(ResourceNamespace.RES_AUTO, new IdProvider(127));
        ((Map)this.perNamespaceProviders).put(ResourceNamespace.ANDROID, new IdProvider(1));
    }

    @Override
    public boolean getFinalIdsUsed() {
        return this.module.isAppOrFeature() && this.module.getNamespacing() == ResourceNamespacing.DISABLED;
    }

    @Override
    @Nullable
    public synchronized ResourceReference findById(int id2) {
        SingleNamespaceIdMapping ref;
        SingleNamespaceIdMapping singleNamespaceIdMapping = this.compiledIds;
        if (singleNamespaceIdMapping == null || (singleNamespaceIdMapping = singleNamespaceIdMapping.findById(id2)) == null) {
            singleNamespaceIdMapping = (ResourceReference)this.dynamicFromIdMap.get(id2);
        }
        if ((ref = singleNamespaceIdMapping) == null && this.searchFrameworkIds) {
            return this.frameworkIds.findById(id2);
        }
        return ref;
    }

    @Override
    @Nullable
    public synchronized Integer getCompiledId(@NotNull ResourceReference resource) {
        Integer n;
        SingleNamespaceIdMapping knownIds;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        ResourceNamespace resourceNamespace = resource.getNamespace();
        SingleNamespaceIdMapping singleNamespaceIdMapping = knownIds = Intrinsics.areEqual((Object)resourceNamespace, (Object)ResourceNamespace.ANDROID) ? this.frameworkIds : (Intrinsics.areEqual((Object)resourceNamespace, (Object)ResourceNamespace.RES_AUTO) ? this.compiledIds : null);
        if (singleNamespaceIdMapping != null) {
            int id2 = singleNamespaceIdMapping.getId(resource);
            boolean bl = false;
            n = id2 == 0 ? null : Integer.valueOf(id2);
        } else {
            n = null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int getOrGenerateId(@NotNull ResourceReference resource) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Integer compiledId = this.getCompiledId(resource);
        if (compiledId != null) {
            return compiledId;
        }
        int dynamicId = this.dynamicToIdMap.getInt((Object)resource);
        if (dynamicId != 0) {
            return dynamicId;
        }
        Map map2 = this.perNamespaceProviders;
        ResourceNamespace key$iv = resource.getNamespace();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            byte by = this.nextPackageId;
            this.nextPackageId = (byte)(by + 1);
            IdProvider answer$iv = new IdProvider(by);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        IdProvider provider = (IdProvider)object;
        ResourceType resourceType = resource.getResourceType();
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"getResourceType(...)");
        int newId = provider.getNext(resourceType);
        this.dynamicToIdMap.put((Object)resource, newId);
        this.dynamicFromIdMap.put(newId, (Object)resource);
        return newId;
    }

    @Override
    public synchronized void resetDynamicIds() {
        long l = this.generationCounter;
        this.generationCounter = l + 1L;
        this.resetProviders();
        this.dynamicToIdMap.clear();
        this.dynamicFromIdMap.clear();
    }

    @Override
    public synchronized long getGeneration() {
        return this.generationCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCompiledIds(@NotNull Consumer<ResourceIdManager.RClassParser> rClassProvider) {
        Intrinsics.checkNotNullParameter(rClassProvider, (String)"rClassProvider");
        ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"RES_AUTO");
        SingleNamespaceIdMapping temporaryCompileIds = new SingleNamespaceIdMapping(resourceNamespace);
        try {
            rClassProvider.accept(new ResourceIdManager.RClassParser(temporaryCompileIds){
                final /* synthetic */ SingleNamespaceIdMapping $temporaryCompileIds;
                {
                    this.$temporaryCompileIds = $temporaryCompileIds;
                }

                public void parseUsingReflection(Class<?> rClass) {
                    Intrinsics.checkNotNullParameter(rClass, (String)"rClass");
                    ResourceIdManagerBaseKt.loadIdsFromResourceClass$default(rClass, this.$temporaryCompileIds, false, 4, null);
                }

                public void parseBytecode(byte[] rClass, Function1<? super String, byte[]> rClassProvider) {
                    Intrinsics.checkNotNullParameter((Object)rClass, (String)"rClass");
                    Intrinsics.checkNotNullParameter(rClassProvider, (String)"rClassProvider");
                    ResourceIdManagerBaseKt.loadIdsFromResourceClassFromBytecode$default(rClass, rClassProvider, this.$temporaryCompileIds, false, 8, null);
                }
            });
        }
        finally {
            ResourceIdManagerBase resourceIdManagerBase = this;
            synchronized (resourceIdManagerBase) {
                boolean bl = false;
                this.compiledIds = temporaryCompileIds;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/res/ids/ResourceIdManagerBase$IdProvider;", "", "packageByte", "", "<init>", "(B)V", "counters", "", "getNext", "", "type", "Lcom/android/resources/ResourceType;", "toString", "", "intellij.android.render-resources"})
    private static final class IdProvider {
        private final byte packageByte;
        @NotNull
        private final short[] counters;

        public IdProvider(byte packageByte) {
            this.packageByte = packageByte;
            int n = 0;
            int n2 = ResourceType.values().length;
            short[] sArray = new short[n2];
            IdProvider idProvider = this;
            while (n < n2) {
                int n3 = n++;
                sArray[n3] = -1;
            }
            idProvider.counters = sArray;
        }

        public final int getNext(@NotNull ResourceType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            short[] sArray = this.counters;
            int n = type.ordinal();
            sArray[n] = (short)(sArray[n] + -1);
            return ResourceIdManagerBaseKt.buildResourceId(this.packageByte, (byte)(type.ordinal() + 1), sArray[n]);
        }

        @NotNull
        public String toString() {
            String string = Arrays.toString(this.counters);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

