/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2.settings;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.common.OAuthDataStore;
import com.google.gct.login2.settings.GoogleLoginSecretStore;
import com.google.gson.Gson;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@State(name="GoogleLoginApplicationSettings", storages={@Storage(value="googleLoginApplicationSettings.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002+,B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0016J&\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001bJ\u001e\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b0!0!J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\bJ\u0006\u0010%\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\bJ\b\u0010'\u001a\u0004\u0018\u00010\bJ\u0010\u0010(\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\bJ\u0006\u0010*\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "secretStore", "Lcom/google/gct/login2/settings/GoogleLoginSecretStore;", "<init>", "(Lcom/google/gct/login2/settings/GoogleLoginSecretStore;)V", "userEmail2FeaturesStore", "", "", "", "getUserEmail2FeaturesStore", "()Ljava/util/Map;", "setUserEmail2FeaturesStore", "(Ljava/util/Map;)V", "activeUser", "getActiveUser", "()Ljava/lang/String;", "setActiveUser", "(Ljava/lang/String;)V", "getState", "loadState", "", "state", "saveAllOAuthDataByUser", "userEmail", "oAuthDataList", "", "Lcom/google/gct/login2/common/OAuthDataStore;", "isStaleKey", "", "saveIncrementalOAuthData", "oAuthData", "loadOAuthData", "", "Lcom/google/gct/login2/LoginFeature;", "clearStoredOAuthData", "user", "clearAllStoredOAuthData", "saveActiveUser", "loadActiveUser", "clearActiveUserIfApplicable", "email", "clearActiveUser", "Companion", "Feature2Token", "google-login"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGoogleLoginApplicationSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginApplicationSettings.kt\ncom/google/gct/login2/settings/GoogleLoginApplicationSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,213:1\n1368#2:214\n1454#2,5:215\n1557#2:220\n1628#2,3:221\n827#2:224\n855#2,2:225\n1368#2:227\n1454#2,2:228\n1557#2:230\n1628#2,3:231\n1456#2,3:234\n1557#2:237\n1628#2,3:238\n1246#2,2:243\n1611#2,9:245\n1863#2:254\n1864#2:256\n1620#2:257\n1279#2,2:258\n1293#2,2:260\n1296#2:263\n1249#2:264\n462#3:241\n412#3:242\n1#4:255\n1#4:266\n25#5:262\n564#6:265\n*S KotlinDebug\n*F\n+ 1 GoogleLoginApplicationSettings.kt\ncom/google/gct/login2/settings/GoogleLoginApplicationSettings\n*L\n59#1:214\n59#1:215,5\n59#1:220\n59#1:221,3\n63#1:224\n63#1:225,2\n64#1:227\n64#1:228,2\n65#1:230\n65#1:231,3\n64#1:234,3\n86#1:237\n86#1:238,3\n96#1:243,2\n111#1:245,9\n111#1:254\n111#1:256\n111#1:257\n115#1:258,2\n115#1:260,2\n115#1:263\n96#1:264\n96#1:241\n96#1:242\n111#1:255\n154#1:266\n119#1:262\n154#1:265\n*E\n"})
public final class GoogleLoginApplicationSettings
implements PersistentStateComponent<GoogleLoginApplicationSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleLoginSecretStore secretStore;
    @NotNull
    private Map<String, Set<String>> userEmail2FeaturesStore;
    @Nullable
    private String activeUser;
    public static final int $stable = 8;

    public GoogleLoginApplicationSettings(@NotNull GoogleLoginSecretStore secretStore) {
        Intrinsics.checkNotNullParameter((Object)secretStore, (String)"secretStore");
        this.secretStore = secretStore;
        this.userEmail2FeaturesStore = new LinkedHashMap();
    }

    public /* synthetic */ GoogleLoginApplicationSettings(GoogleLoginSecretStore googleLoginSecretStore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            googleLoginSecretStore = new GoogleLoginSecretStore();
        }
        this(googleLoginSecretStore);
    }

    @NotNull
    public final Map<String, Set<String>> getUserEmail2FeaturesStore() {
        return this.userEmail2FeaturesStore;
    }

    public final void setUserEmail2FeaturesStore(@NotNull Map<String, Set<String>> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.userEmail2FeaturesStore = map2;
    }

    @Nullable
    public final String getActiveUser() {
        return this.activeUser;
    }

    public final void setActiveUser(@Nullable String string) {
        this.activeUser = string;
    }

    @NotNull
    public GoogleLoginApplicationSettings getState() {
        return this;
    }

    public void loadState(@NotNull GoogleLoginApplicationSettings state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveAllOAuthDataByUser(@NotNull String userEmail, @NotNull List<OAuthDataStore> oAuthDataList, boolean isStaleKey) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        OAuthDataStore it;
        void $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        Intrinsics.checkNotNullParameter(oAuthDataList, (String)"oAuthDataList");
        this.clearStoredOAuthData(userEmail);
        if (oAuthDataList.isEmpty()) {
            return;
        }
        Iterable $this$flatMap$iv2 = oAuthDataList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (OAuthDataStore)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getAllowedFeatures();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (LoginFeature)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getKey());
        }
        Set features = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = oAuthDataList;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            OAuthDataStore it2 = (OAuthDataStore)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it2.getRefreshToken();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap2 = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            OAuthDataStore oAuthDataStore = (OAuthDataStore)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = oAuthDataStore.getAllowedFeatures();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                LoginFeature loginFeature = (LoginFeature)item$iv$iv;
                Collection collection3 = destination$iv$iv3;
                boolean bl2 = false;
                String string = it3.getKey();
                String string2 = oAuthDataStore.getRefreshToken();
                Intrinsics.checkNotNull((Object)string2);
                collection3.add(TuplesKt.to((Object)string, (Object)string2));
            }
            Iterable list$iv$iv2 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        Map feature2RefreshToken = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        this.secretStore.save(Companion.getRefreshTokenKey(userEmail, features, isStaleKey), new Feature2Token(feature2RefreshToken).serialize());
        this.userEmail2FeaturesStore.put(userEmail, features);
    }

    public static /* synthetic */ void saveAllOAuthDataByUser$default(GoogleLoginApplicationSettings googleLoginApplicationSettings, String string, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        googleLoginApplicationSettings.saveAllOAuthDataByUser(string, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveIncrementalOAuthData(@NotNull OAuthDataStore oAuthData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)oAuthData, (String)"oAuthData");
        String emailKey = oAuthData.getUserEmail();
        Map map2 = this.loadOAuthData().get(oAuthData.getUserEmail());
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map previouslySavedOAuthData = map2;
        Iterable iterable = oAuthData.getAllowedFeatures();
        Map map3 = previouslySavedOAuthData;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoginFeature loginFeature = (LoginFeature)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to((Object)it, (Object)oAuthData));
        }
        Map newOAuthData = MapsKt.plus((Map)map3, (Iterable)((List)destination$iv$iv));
        GoogleLoginApplicationSettings.saveAllOAuthDataByUser$default(this, emailKey, CollectionsKt.toList((Iterable)newOAuthData.values()), false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<LoginFeature, OAuthDataStore>> loadOAuthData() {
        void $this$mapValuesTo$iv$iv;
        Map<String, Set<String>> $this$mapValues$iv = this.userEmail2FeaturesStore;
        boolean $i$f$mapValues = false;
        Map<String, Set<String>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateWith$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object object;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String user = (String)entry2.getKey();
            Set features = (Set)entry2.getValue();
            Feature2Token.Companion companion = Feature2Token.Companion;
            String string = this.secretStore.retrieve(com.google.gct.login2.settings.GoogleLoginApplicationSettings$Companion.getRefreshTokenKey$default(Companion, user, null, false, 6, null));
            if (string == null) {
                String string2;
                if (this.secretStore.retrieve(Companion.getRefreshTokenKey(user, features, true)) != null) {
                    void it;
                    String string3;
                    String string4 = string3;
                    object = companion;
                    boolean bl3 = false;
                    this.secretStore.save(com.google.gct.login2.settings.GoogleLoginApplicationSettings$Companion.getRefreshTokenKey$default(Companion, user, null, false, 6, null), (String)it);
                    this.secretStore.clear(Companion.getRefreshTokenKey(user, features, true));
                    companion = object;
                    string2 = string3;
                } else {
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = "";
                }
            }
            Feature2Token feature2Token = companion.deserialize(string);
            Iterable iterable = features;
            boolean $i$f$mapNotNull = false;
            void var24_26 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                LoginFeature it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = object2.next();
                boolean bl4 = false;
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                if (LoginFeature.Companion.getExtensionByKey(it) == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                OAuthDataStore oAuthDataStore;
                void loginFeature;
                object2 = (LoginFeature)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl7 = false;
                String string5 = feature2Token.getValue().get(loginFeature.getKey());
                if (string5 == null) {
                    GoogleLoginApplicationSettings $this$loadOAuthData_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = this;
                    boolean bl8 = false;
                    GoogleLoginApplicationSettings $this$thisLogger$iv = $this$loadOAuthData_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(GoogleLoginApplicationSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("No refresh token found for " + user + " and specific feature: " + loginFeature.getKey() + ".");
                    string5 = null;
                }
                String refreshToken = string5;
                OAuthDataStore oAuthDataStore2 = oAuthDataStore = new OAuthDataStore(user, refreshToken, SetsKt.setOf((Object)loginFeature));
                object.put(t, oAuthDataStore2);
            }
            Map map5 = result$iv;
            map4.put(k, map5);
        }
        return destination$iv$iv;
    }

    public final void clearStoredOAuthData(@NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.secretStore.clear(com.google.gct.login2.settings.GoogleLoginApplicationSettings$Companion.getRefreshTokenKey$default(Companion, user, null, false, 6, null));
        this.userEmail2FeaturesStore.remove(user);
    }

    public final void clearAllStoredOAuthData() {
        Map<String, Set<String>> map2;
        Map<String, Set<String>> $this$onEach$iv = this.userEmail2FeaturesStore;
        boolean $i$f$onEach = false;
        Map<String, Set<String>> $this$onEach_u24lambda_u242$iv = map2 = $this$onEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, Set<String>>> iterator2 = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Set<String>> element$iv;
            Map.Entry<String, Set<String>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String user = entry.getKey();
            Set<String> features = entry.getValue();
            this.secretStore.clear(com.google.gct.login2.settings.GoogleLoginApplicationSettings$Companion.getRefreshTokenKey$default(Companion, user, null, false, 6, null));
        }
        this.userEmail2FeaturesStore.clear();
    }

    public final void saveActiveUser(@NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.activeUser = user;
    }

    @Nullable
    public final String loadActiveUser() {
        return this.activeUser;
    }

    public final void clearActiveUserIfApplicable(@Nullable String email) {
        if (Intrinsics.areEqual((Object)email, (Object)this.activeUser)) {
            this.activeUser = null;
        }
    }

    public final void clearActiveUser() {
        this.activeUser = null;
    }

    public GoogleLoginApplicationSettings() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings$Companion;", "", "<init>", "()V", "getRefreshTokenKey", "", "user", "features", "", "isStaleKey", "", "google-login"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRefreshTokenKey(@NotNull String user, @NotNull Set<String> features, boolean isStaleKey) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(features, (String)"features");
            if (!isStaleKey) {
                return user + "_studio_google_login_refresh_token_key";
            }
            String feature = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)features), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
            return user + "_" + feature + "_refresh_token_key";
        }

        public static /* synthetic */ String getRefreshTokenKey$default(Companion companion, String string, Set set2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.getRefreshTokenKey(string, set2, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\u0004R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings$Feature2Token;", "", "value", "", "", "<init>", "(Ljava/util/Map;)V", "getValue", "()Ljava/util/Map;", "serialize", "Companion", "google-login"})
    @StabilityInferred(parameters=0)
    public static final class Feature2Token {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, String> value;
        public static final int $stable = 8;

        public Feature2Token(@NotNull Map<String, String> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            this.value = value2;
        }

        @NotNull
        public final Map<String, String> getValue() {
            return this.value;
        }

        @NotNull
        public final String serialize() {
            String string = new Gson().toJson(this.value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings$Feature2Token$Companion;", "", "<init>", "()V", "deserialize", "Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings$Feature2Token;", "string", "", "google-login"})
        @SourceDebugExtension(value={"SMAP\nGoogleLoginApplicationSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginApplicationSettings.kt\ncom/google/gct/login2/settings/GoogleLoginApplicationSettings$Feature2Token$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,213:1\n25#2:214\n*S KotlinDebug\n*F\n+ 1 GoogleLoginApplicationSettings.kt\ncom/google/gct/login2/settings/GoogleLoginApplicationSettings$Feature2Token$Companion\n*L\n204#1:214\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Feature2Token deserialize(@NotNull String string) {
                Map map2;
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                if (((CharSequence)string).length() == 0) {
                    return new Feature2Token(MapsKt.emptyMap());
                }
                try {
                    map2 = (Map)new Gson().fromJson(string, new HashMap().getClass());
                }
                catch (RuntimeException e) {
                    Companion $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Error parsing " + string + ": " + e);
                    map2 = MapsKt.emptyMap();
                }
                Map deserialized = map2;
                Intrinsics.checkNotNull((Object)deserialized);
                return new Feature2Token(deserialized);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

