/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableString;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.string.StringExpression;
import com.android.tools.idea.observable.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.android.tools.idea.wizard.ui.deprecated.StudioWizardStepPanel;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.samples.SamplesBrowserBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleSetupStep
extends ModelWizardStep<SampleModel> {
    private static final String DEFAULT_SAMPLE_NAME = SamplesBrowserBundle.message("sample.default.name", new Object[0]);
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings = new BindingsManager();
    private final StringProperty myProjectName;
    private final StringProperty myDir;
    private final ObservableString myNameToPathExpression;
    private JTextField myProjectNameField;
    private HyperlinkLabel myUrlField;
    private TextFieldWithBrowseButton myProjectLocationField;
    private JPanel myPanel;
    @NotNull
    private String myUrl = "";

    public SampleSetupStep(@NotNull SampleModel model) {
        super(model, SamplesBrowserBundle.message("sample.setup.title", new Object[0]));
        this.setupUI();
        this.myProjectName = new TextProperty(this.myProjectNameField);
        this.myDir = new TextProperty(this.myProjectLocationField.getTextField());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, SamplesBrowserBundle.message("sample.setup.description", new Object[0]));
        this.myNameToPathExpression = new StringExpression(new ObservableValue[]{this.myProjectName}){

            @Override
            @NotNull
            public String get() {
                return SampleSetupStep.getFileLocation((String)SampleSetupStep.this.myProjectName.get()).getAbsolutePath();
            }
        };
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myProjectNameField = new JTextField();
        this.myPanel.add((Component)this.myProjectNameField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myUrlField = new HyperlinkLabel();
        this.myPanel.add((Component)this.myUrlField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setHorizontalAlignment(10);
        jBLabel1.setText("GitHub URL:");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Project location:");
        this.myPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Application name:");
        this.myPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myProjectLocationField = new TextFieldWithBrowseButton();
        this.myPanel.add((Component)this.myProjectLocationField, new GridConstraints(2, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        jBLabel2.setLabelFor((Component)this.myProjectLocationField);
        jBLabel3.setLabelFor((Component)this.myProjectNameField);
    }

    private static String getUniqueName(String projectName) {
        File file = SampleSetupStep.getFileLocation(projectName);
        Object name2 = projectName;
        int i = 0;
        while (file.exists()) {
            name2 = projectName + ++i;
            file = SampleSetupStep.getFileLocation((String)name2);
        }
        return name2;
    }

    private static File getFileLocation(String projectName) {
        return new File(WizardUtils.getProjectLocationParent(), projectName.replaceAll("[^a-zA-Z0-9_\\-.]", ""));
    }

    public void setUrl(@NotNull String url) {
        this.myUrl = url;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myProjectNameField;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard2) {
        this.myProjectLocationField.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(SamplesBrowserBundle.message("select.project.location", new Object[0])));
        this.myBindings.bind(this.myProjectName, new TransformOptionalExpression<Sample, String>("", ((SampleModel)this.getModel()).sample()){

            @Override
            @NotNull
            protected String transform(@NotNull Sample sample) {
                String name2 = sample.getTitle();
                return SampleSetupStep.getUniqueName(StringUtil.isEmpty((String)name2) ? DEFAULT_SAMPLE_NAME : name2);
            }
        });
        BoolValueProperty isNameDirSynced = new BoolValueProperty(true);
        this.myDir.addListener(() -> isNameDirSynced.set(((String)this.myDir.get()).equals(this.myNameToPathExpression.get())));
        this.myBindings.bind(this.myDir, this.myNameToPathExpression, isNameDirSynced);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectName, projectName -> StringUtil.isEmptyOrSpaces((String)projectName) ? new Validator.Result(Validator.Severity.ERROR, SamplesBrowserBundle.message("application.name.not.set", new Object[0])) : Validator.Result.OK, new ObservableValue[0]);
        PathValidator pathValidator = PathValidator.createDefault("sample location");
        Expression<Path> myDirFile = new Expression<Path>(new ObservableValue[]{this.myDir}){

            @Override
            @NotNull
            public Path get() {
                return Paths.get((String)SampleSetupStep.this.myDir.get(), new String[0]);
            }
        };
        this.myValidatorPanel.registerValidator((ObservableValue)myDirFile, (Validator)pathValidator, new ObservableValue[0]);
    }

    @Override
    protected void onEntering() {
        this.myUrlField.setHyperlinkTarget(this.myUrl);
        this.myUrlField.setHyperlinkText(this.myUrl);
        this.myDir.set((String)this.myNameToPathExpression.get());
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        ((SampleModel)this.getModel()).projectName().setValue((String)this.myProjectName.get());
        ((SampleModel)this.getModel()).dir().setValue(new File((String)this.myDir.get()));
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }
}

