/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.CommonBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.exportSignedPackage.NewKeyForm;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseKeyDialog
extends DialogWrapper {
    private JPanel myNewKeyPanel;
    private JBRadioButton myCreateNewKeyRadioButton;
    private JBRadioButton myUseExistingKeyRadioButton;
    private JComboBox myKeyCombo;
    private JPanel myPanel;
    private final NewKeyForm myNewKeyForm = new MyNewKeyForm();
    private final Project myProject;
    private final String myKeyStorePath;
    private final char[] myKeyStorePassword;
    private final List<String> myExistingKeys;

    @Contract(mutates="param4")
    public ChooseKeyDialog(@NotNull Project project, @NotNull String keyStorePath, @NotNull char[] password, @NotNull List<String> existingKeys, @Nullable String keyToSelect) {
        super(project);
        this.setupUI();
        this.myProject = project;
        this.myKeyStorePath = keyStorePath;
        this.myKeyStorePassword = password;
        this.myExistingKeys = existingKeys;
        this.myKeyCombo.setModel(new CollectionComboBoxModel(existingKeys));
        if (keyToSelect != null && existingKeys.contains(keyToSelect)) {
            this.myKeyCombo.setSelectedItem(keyToSelect);
        }
        this.myNewKeyPanel.add((Component)this.myNewKeyForm.getContentPanel(), "Center");
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)ChooseKeyDialog.this.myNewKeyPanel, (boolean)ChooseKeyDialog.this.myCreateNewKeyRadioButton.isSelected(), (boolean)true);
            }
        };
        this.myCreateNewKeyRadioButton.addActionListener(listener2);
        this.myUseExistingKeyRadioButton.addActionListener(listener2);
        boolean useExisting = !existingKeys.isEmpty();
        this.myUseExistingKeyRadioButton.setSelected(useExisting);
        this.myCreateNewKeyRadioButton.setSelected(!useExisting);
        UIUtil.setEnabled((Component)this.myNewKeyPanel, (!useExisting ? 1 : 0) != 0, (boolean)true);
        this.setTitle("Choose Key");
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        if (this.myCreateNewKeyRadioButton.isSelected()) {
            try {
                this.myNewKeyForm.createKey();
            }
            catch (CommitStepException e) {
                Messages.showErrorDialog((Component)this.myPanel, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
                return;
            }
        }
        super.doOKAction();
    }

    @Nullable
    public String getChosenKey() {
        return this.myUseExistingKeyRadioButton.isSelected() ? (String)this.myKeyCombo.getSelectedItem() : this.myNewKeyForm.getKeyAlias();
    }

    @Nullable
    public char[] getChosenKeyPassword() {
        return this.myCreateNewKeyRadioButton.isSelected() ? this.myNewKeyForm.getKeyPassword() : null;
    }

    public boolean isNewKeyCreated() {
        return this.myCreateNewKeyRadioButton.isSelected();
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myUseExistingKeyRadioButton = new JBRadioButton();
        this.myUseExistingKeyRadioButton.setText("Use an existing key:");
        this.myUseExistingKeyRadioButton.setMnemonic('U');
        this.myUseExistingKeyRadioButton.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myUseExistingKeyRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myCreateNewKeyRadioButton = new JBRadioButton();
        this.myCreateNewKeyRadioButton.setText("Create a new key");
        this.myCreateNewKeyRadioButton.setMnemonic('N');
        this.myCreateNewKeyRadioButton.setDisplayedMnemonicIndex(9);
        this.myPanel.add((Component)this.myCreateNewKeyRadioButton, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.myNewKeyPanel = new JPanel();
        this.myNewKeyPanel.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myNewKeyPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 2, false));
        this.myKeyCombo = new JComboBox();
        this.myPanel.add((Component)this.myKeyCombo, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.myUseExistingKeyRadioButton);
        buttonGroup.add((AbstractButton)this.myCreateNewKeyRadioButton);
    }

    private class MyNewKeyForm
    extends NewKeyForm {
        private MyNewKeyForm() {
        }

        @Override
        protected List<String> getExistingKeyAliasList() {
            return ChooseKeyDialog.this.myExistingKeys;
        }

        @Override
        @NotNull
        protected Project getProject() {
            return ChooseKeyDialog.this.myProject;
        }

        @Override
        @NotNull
        protected char[] getKeyStorePassword() {
            return ChooseKeyDialog.this.myKeyStorePassword;
        }

        @Override
        @NotNull
        protected String getKeyStoreLocation() {
            return ChooseKeyDialog.this.myKeyStorePath;
        }
    }
}

