/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;

public class ChooseBundleOrApkStep
extends ExportSignedPackageWizardStep {
    public static final String DOC_URL = "https://d.android.com/r/studio-ui/dynamic-delivery/overview.html";
    private final ExportSignedPackageWizard myWizard;
    private JPanel myContentPanel;
    @VisibleForTesting
    JRadioButton myBundleButton;
    @VisibleForTesting
    JRadioButton myApkButton;
    private JPanel myBundlePanel;
    private JPanel myApkPanel;
    private HyperlinkLabel myLearnMoreLink;
    private static Method cachedGetBundleMethod = null;

    public ChooseBundleOrApkStep(ExportSignedPackageWizard wizard2) {
        this.setupUI();
        this.myWizard = wizard2;
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(wizard2.getProject());
        this.myBundleButton.setSelected(settings.BUILD_TARGET_KEY.equals(ExportSignedPackageWizard.BUNDLE.toString()));
        this.myApkButton.setSelected(settings.BUILD_TARGET_KEY.equals(ExportSignedPackageWizard.APK.toString()));
        this.myLearnMoreLink.setHyperlinkText("Learn more");
        this.myLearnMoreLink.setHyperlinkTarget(DOC_URL);
    }

    @Override
    public String getHelpId() {
        return "org.jetbrains.android.studio/publish/app-signing";
    }

    @Override
    protected void commitForNext() {
        boolean isBundle = this.myBundleButton.isSelected();
        GenerateSignedApkSettings.getInstance((Project)this.myWizard.getProject()).BUILD_TARGET_KEY = isBundle ? ExportSignedPackageWizard.BUNDLE.toString() : ExportSignedPackageWizard.APK.toString();
        this.myWizard.setTargetType(isBundle ? ExportSignedPackageWizard.BUNDLE : ExportSignedPackageWizard.APK);
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myBundlePanel = new JPanel();
        this.myBundlePanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)this.myBundlePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myBundleButton = new JRadioButton();
        Font myBundleButtonFont = this.getFont(null, 1, -1, this.myBundleButton.getFont());
        if (myBundleButtonFont != null) {
            this.myBundleButton.setFont(myBundleButtonFont);
        }
        this.myBundleButton.setSelected(true);
        this.myBundleButton.setText("Android App Bundle");
        this.myBundlePanel.add((Component)this.myBundleButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        this.loadLabelText((JLabel)jBLabel1, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.bundle.description"));
        this.myBundlePanel.add((Component)jBLabel1, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2, false));
        this.myLearnMoreLink = new HyperlinkLabel();
        this.myLearnMoreLink.setVisible(true);
        this.myBundlePanel.add((Component)this.myLearnMoreLink, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2, false));
        this.myApkPanel = new JPanel();
        this.myApkPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)this.myApkPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myApkButton = new JRadioButton();
        Font myApkButtonFont = this.getFont(null, 1, -1, this.myApkButton.getFont());
        if (myApkButtonFont != null) {
            this.myApkButton.setFont(myApkButtonFont);
        }
        this.myApkButton.setText("APK");
        this.myApkPanel.add((Component)this.myApkButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Build a signed APK that you can deploy to a device");
        this.myApkPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2, false));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 2), null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myBundleButton);
        buttonGroup.add(this.myApkButton);
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadLabelText(JLabel component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }
}

