/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.actions.GoToBundleLocationTask;
import com.android.tools.idea.gradle.model.IdeVariantBuildInformation;
import com.android.tools.idea.gradle.model.IdeVariantCore;
import com.android.tools.idea.gradle.project.build.invoker.AssembleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.SigningWizardEvent;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.android.exportSignedPackage.ChooseBundleOrApkStep;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GradleSignStep;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.exportSignedPackage.KeystoreStep;
import org.jetbrains.android.exportSignedPackage.SigningWizardUsageTrackerUtilsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ExportSignedPackageWizard
extends AbstractWizard<ExportSignedPackageWizardStep> {
    public static final TargetType BUNDLE = TargetType.BUNDLE;
    public static final TargetType APK = TargetType.APK;
    @NotNull
    private final Project myProject;
    private AndroidFacet myFacet;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;
    private String myApkPath;
    @NotNull
    private TargetType myTargetType = APK;
    private List<String> myBuildVariants;
    private GradleSigningInfo myGradleSigningInfo;

    public ExportSignedPackageWizard(@NotNull Project project, @NotNull List<AndroidFacet> facets) {
        super(AndroidBundle.message("android.export.package.wizard.title", new Object[0]), project);
        this.myProject = project;
        assert (!facets.isEmpty());
        this.myFacet = facets.get(0);
        this.addStep((Step)new ChooseBundleOrApkStep(this));
        this.addStep((Step)new KeystoreStep(this, true, facets));
        this.addStep((Step)new GradleSignStep(this));
        this.init();
    }

    protected void doOKAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        SigningWizardUsageTrackerUtilsKt.trackWizardOkAction(this.myProject);
        super.doOKAction();
        assert (this.myFacet != null);
        assert (AndroidModel.isRequired(this.myFacet));
        this.buildAndSignGradleProject();
    }

    public void doCancelAction() {
        SigningWizardUsageTrackerUtilsKt.trackWizardClosed(this.myProject);
        super.doCancelAction();
    }

    public void show() {
        SigningWizardUsageTrackerUtilsKt.trackWizardOpen(this.myProject);
        super.show();
    }

    private void buildAndSignGradleProject() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Generating Signed APKs", false, null){

            public void run(@NotNull ProgressIndicator indicator) {
                ImmutableList modules = ImmutableList.of((Object)LinkedAndroidModuleGroupUtilsKt.getMainModule(ExportSignedPackageWizard.this.myFacet.getModule()));
                Consumer<ListenableFuture<AssembleInvocationResult>> buildHandler = ExportSignedPackageWizard.this.prepareBuildResultHandler((List<Module>)modules);
                if (buildHandler == null) {
                    return;
                }
                ExportSignedPackageWizard.doBuildAndSignGradleProject(this.myProject, ExportSignedPackageWizard.this.myFacet, ExportSignedPackageWizard.this.myBuildVariants, (List<Module>)modules, ExportSignedPackageWizard.this.myGradleSigningInfo, ExportSignedPackageWizard.this.myApkPath, ExportSignedPackageWizard.this.myTargetType, buildHandler);
                SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigning(this.myProject, ExportSignedPackageWizard.toSigningTargetType(ExportSignedPackageWizard.this.myTargetType), modules.size(), ExportSignedPackageWizard.this.myBuildVariants.size());
            }
        });
    }

    private Consumer<ListenableFuture<AssembleInvocationResult>> prepareBuildResultHandler(@NotNull List<Module> modules) {
        if (this.myTargetType.equals((Object)BUNDLE)) {
            return new GoToBundleLocationTask(this.myProject, modules, "Generate Signed Bundle", this.myBuildVariants)::executeWhenBuildFinished;
        }
        return new GoToApkLocationTask(this.myProject, modules, "Generate Signed APK", this.myBuildVariants)::executeWhenBuildFinished;
    }

    protected void doNextAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doNextAction();
    }

    private boolean commitCurrentStep() {
        try {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(this.myCurrentStep))).commitForNext();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    protected int getNextStep(int stepIndex) {
        int result2 = super.getNextStep(stepIndex);
        if (result2 != this.myCurrentStep) {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(result2))).setPreviousStepIndex(this.myCurrentStep);
        }
        return result2;
    }

    protected int getPreviousStep(int stepIndex) {
        ExportSignedPackageWizardStep step2 = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(stepIndex));
        int prevStepIndex = step2.getPreviousStepIndex();
        assert (prevStepIndex >= 0);
        return prevStepIndex;
    }

    protected void updateStep() {
        int step2 = this.getCurrentStep();
        ExportSignedPackageWizardStep currentStep = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(step2));
        super.updateStep();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.getRootPane().setDefaultButton(this.getNextButton());
            JComponent component = currentStep.getPreferredFocusedComponent();
            if (component != null) {
                component.requestFocus();
            }
        });
    }

    protected String getHelpID() {
        ExportSignedPackageWizardStep step2 = (ExportSignedPackageWizardStep)this.getCurrentStepObject();
        if (step2 != null) {
            return step2.getHelpId();
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
    }

    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    public void setPrivateKey(@NotNull PrivateKey privateKey) {
        this.myPrivateKey = privateKey;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public void setCertificate(@NotNull X509Certificate certificate) {
        this.myCertificate = certificate;
    }

    public void setApkPath(@NotNull String apkPath) {
        this.myApkPath = apkPath;
    }

    public void setGradleOptions(@NotNull List<String> buildVariants) {
        this.myBuildVariants = buildVariants;
    }

    @NotNull
    public TargetType getTargetType() {
        return this.myTargetType;
    }

    public void setTargetType(@NotNull TargetType targetType) {
        this.myTargetType = targetType;
    }

    public void setGradleSigningInfo(GradleSigningInfo gradleSigningInfo) {
        this.myGradleSigningInfo = gradleSigningInfo;
    }

    private static Logger getLog() {
        return Logger.getInstance(ExportSignedPackageWizard.class);
    }

    private static SigningWizardEvent.SigningTargetType toSigningTargetType(@NotNull TargetType targetType) {
        if (targetType.equals((Object)BUNDLE)) {
            return SigningWizardEvent.SigningTargetType.TARGET_TYPE_BUNDLE;
        }
        if (targetType.equals((Object)APK)) {
            return SigningWizardEvent.SigningTargetType.TARGET_TYPE_APK;
        }
        return SigningWizardEvent.SigningTargetType.TARGET_TYPE_UNKNOWN;
    }

    @VisibleForTesting
    public static void doBuildAndSignGradleProject(Project project, AndroidFacet facet, List<String> variants, List<Module> modules, GradleSigningInfo signInfo, String apkPath, TargetType targetType, Consumer<ListenableFuture<AssembleInvocationResult>> buildResultHandler) {
        assert (project != null);
        @NotNull Module facetModule = facet.getModule();
        GradleFacet gradleFacet = GradleFacet.getInstance(facetModule);
        if (gradleFacet == null) {
            ExportSignedPackageWizard.getLog().error("Unable to get gradle project information for module: " + facetModule.getName());
            SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(project, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_MODULE_FACET);
            return;
        }
        GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(facetModule);
        if (gradleProjectPath == null) {
            ExportSignedPackageWizard.getLog().error("Unable to get gradle project information for module: " + facetModule.getName());
            SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(project, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_MODULE_FACET);
            return;
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)facetModule);
        if (StringUtil.isEmpty((String)rootProjectPath)) {
            ExportSignedPackageWizard.getLog().error("Unable to get gradle root project path for module: " + facetModule.getName());
            SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(project, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_MODULE_ROOT_PATH);
            return;
        }
        GradleAndroidModel androidModel = GradleAndroidModel.get(facet);
        if (androidModel == null) {
            ExportSignedPackageWizard.getLog().error("Unable to obtain Android project model. Did the last Gradle sync complete successfully?");
            SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(project, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_ANDROID_MODEL);
            return;
        }
        if (variants == null) {
            ExportSignedPackageWizard.getLog().error("Unable to find required information. Please check the previous steps are completed.");
            SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(project, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_VARIANTS_SELECTED);
            return;
        }
        List<String> signingProperties = ExportSignedPackageWizard.prepareSigningProperties(signInfo, apkPath);
        File rootProjectFile = new File(rootProjectPath);
        GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
        List<String> gradleTasks = ExportSignedPackageWizard.getGradleTasks(gradleProjectPath.getPath(), androidModel, variants, targetType);
        buildResultHandler.consume(gradleBuildInvoker.executeAssembleTasks(modules.toArray(new Module[0]), (List<GradleBuildInvoker.Request>)ImmutableList.of((Object)GradleBuildInvoker.Request.builder(gradleBuildInvoker.getProject(), rootProjectFile, gradleTasks, null).setCommandLineArguments(signingProperties).setMode(ExportSignedPackageWizard.getBuildModeFromTarget(targetType)).build())));
        ExportSignedPackageWizard.getLog().info("Export " + StringUtil.toUpperCase((String)targetType.toString()) + " command: " + Joiner.on((char)',').join(gradleTasks) + ", destination: " + ExportSignedPackageWizard.createProperty("android.injected.apk.location", apkPath));
    }

    @NotNull
    @VisibleForTesting
    static List<String> prepareSigningProperties(@NotNull GradleSigningInfo signingInfo, @NotNull String apkPath) {
        ArrayList<String> projectProperties = new ArrayList<String>();
        projectProperties.add(ExportSignedPackageWizard.createProperty("android.injected.signing.store.file", signingInfo.keyStoreFilePath));
        projectProperties.add(ExportSignedPackageWizard.createProperty("android.injected.signing.store.password", new String(signingInfo.keyStorePassword)));
        projectProperties.add(ExportSignedPackageWizard.createProperty("android.injected.signing.key.alias", signingInfo.keyAlias));
        projectProperties.add(ExportSignedPackageWizard.createProperty("android.injected.signing.key.password", new String(signingInfo.keyPassword)));
        projectProperties.add(ExportSignedPackageWizard.createProperty("android.injected.apk.location", apkPath));
        return projectProperties;
    }

    private static String createProperty(@NotNull String name2, @NotNull String value2) {
        return AndroidGradleSettings.createProjectProperty((String)name2, (String)value2);
    }

    @VisibleForTesting
    @Nullable
    public static BuildMode getBuildModeFromTarget(@NotNull TargetType targetType) {
        if (targetType.equals((Object)APK)) {
            return BuildMode.ASSEMBLE;
        }
        if (targetType.equals((Object)BUNDLE)) {
            return BuildMode.BUNDLE;
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public static File getApkLocation(@NotNull String apkFolderPath, @NotNull String buildType) {
        return new File(apkFolderPath, buildType);
    }

    @VisibleForTesting
    @NotNull
    public static @Unmodifiable List<String> getGradleTasks(@NotNull String gradleProjectPath, @NotNull GradleAndroidModel GradleAndroidModel2, @NotNull List<String> buildVariants, @NotNull TargetType targetType) {
        List<String> taskNames;
        if (GradleAndroidModel2.getFeatures().isBuildOutputFileSupported()) {
            taskNames = ExportSignedPackageWizard.getTaskNamesFromBuildInformation(GradleAndroidModel2, buildVariants, targetType);
        } else {
            IdeVariantCore selectedVariant = GradleAndroidModel2.getSelectedVariant();
            String selectedTaskName = ExportSignedPackageWizard.getTaskName(selectedVariant, targetType);
            if (selectedTaskName == null) {
                ExportSignedPackageWizard.getLog().warn("Could not get tasks for target " + targetType + " on variant " + selectedVariant.getName());
                return Collections.emptyList();
            }
            taskNames = ExportSignedPackageWizard.getTaskNamesFromSelectedVariant(buildVariants, selectedVariant.getName(), selectedTaskName);
        }
        return ContainerUtil.map(taskNames, name2 -> GradleProjectSystemUtil.createFullTaskName(gradleProjectPath, name2));
    }

    @NotNull
    private static List<String> getTaskNamesFromBuildInformation(@NotNull GradleAndroidModel GradleAndroidModel2, @NotNull List<String> buildVariants, @NotNull TargetType targetType) {
        ArrayList taskNames = Lists.newArrayListWithExpectedSize((int)buildVariants.size());
        Map<String, IdeVariantBuildInformation> buildInformationByVariantName = GradleAndroidModel2.getAndroidProject().getVariantsBuildInformation().stream().collect(Collectors.toMap(IdeVariantBuildInformation::getVariantName, x -> x));
        for (String variantName : buildVariants) {
            IdeVariantBuildInformation buildInformation = buildInformationByVariantName.get(variantName);
            if (buildInformation == null) {
                ExportSignedPackageWizard.getLog().warn("Could not get tasks for target " + targetType + " on variant " + variantName);
                continue;
            }
            String taskName = targetType.equals((Object)BUNDLE) ? buildInformation.getBuildInformation().getBundleTaskName() : buildInformation.getBuildInformation().getAssembleTaskName();
            taskNames.add(taskName);
        }
        return taskNames;
    }

    @VisibleForTesting
    @NotNull
    public static List<String> getTaskNamesFromSelectedVariant(@NotNull List<String> buildVariants, @NotNull String selectedVariantName, @NotNull String selectedTaskName) {
        ArrayList gradleTasks = Lists.newArrayListWithExpectedSize((int)buildVariants.size());
        for (String variantName : buildVariants) {
            String taskName = ExportSignedPackageWizard.replaceVariantFromTask(selectedTaskName, selectedVariantName, variantName);
            if (taskName != null) {
                gradleTasks.add(taskName);
                continue;
            }
            ExportSignedPackageWizard.getLog().warn("Could not replace variant " + selectedVariantName + " with " + variantName + " for task " + selectedTaskName + ".");
        }
        return gradleTasks;
    }

    @VisibleForTesting
    @Nullable
    public static String replaceVariantFromTask(@NotNull String task2, @NotNull String oldVariant, @NotNull String newVariant) {
        if (task2.indexOf(oldVariant = StringUtil.decapitalize((String)oldVariant)) == 1) {
            newVariant = StringUtil.decapitalize((String)newVariant);
            return task2.replaceFirst(oldVariant, newVariant);
        }
        if (task2.contains(oldVariant = StringUtil.capitalize((String)oldVariant))) {
            newVariant = StringUtil.capitalize((String)newVariant);
            return task2.replaceFirst(oldVariant, newVariant);
        }
        return null;
    }

    private static String getTaskName(IdeVariantCore v, TargetType targetType) {
        if (targetType.equals((Object)BUNDLE)) {
            return v.getMainArtifact().getBuildInformation().getBundleTaskName();
        }
        return v.getMainArtifact().getBuildInformation().getAssembleTaskName();
    }

    public static enum TargetType {
        APK("apk"),
        BUNDLE("bundle");

        private String name;

        private TargetType(String name2) {
            this.name = name2;
        }

        public String toString() {
            return this.name;
        }
    }
}

