/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.instantapp.InstantApps;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.facet.Facet;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ModalityUiUtil;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageUtil;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class KeystoreStep
extends ExportSignedPackageWizardStep
implements ApkSigningSettingsForm {
    public static final String MODULE_PROPERTY = "ExportedModule";
    @VisibleForTesting
    static final String KEY_STORE_PASSWORD_KEY = "KEY_STORE_PASSWORD";
    @VisibleForTesting
    static final String KEY_PASSWORD_KEY = "KEY_PASSWORD";
    private JPanel myContentPanel;
    private JButton myCreateKeyStoreButton;
    private JPasswordField myKeyStorePasswordField;
    private JPasswordField myKeyPasswordField;
    private TextFieldWithBrowseButton.NoPathCompletion myKeyAliasField;
    private JTextField myKeyStorePathField;
    private JButton myLoadKeyStoreButton;
    private JBCheckBox myRememberPasswordCheckBox;
    @VisibleForTesting
    JComboBox<AndroidFacet> myModuleCombo;
    private JPanel myGradlePanel;
    private JBLabel myGradleWarning;
    private JBLabel myKeyStorePathLabel;
    private JBLabel myKeyStorePasswordLabel;
    private JBLabel myKeyAliasLabel;
    private JBLabel myKeyPasswordLabel;
    private final ExportSignedPackageWizard myWizard;
    private final boolean myUseGradleForSigning;
    private boolean myIsBundle;
    @VisibleForTesting
    AndroidFacet mySelection;
    @VisibleForTesting
    final List<AndroidFacet> myFacets;
    private static Method cachedGetBundleMethod = null;

    public KeystoreStep(@NotNull ExportSignedPackageWizard wizard2, boolean useGradleForSigning, @NotNull List<AndroidFacet> facets) {
        this.setupUI();
        this.myWizard = wizard2;
        this.myFacets = facets;
        this.myUseGradleForSigning = useGradleForSigning;
        Project project = wizard2.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        this.myKeyStorePathField.setText(settings.KEY_STORE_PATH);
        this.myKeyAliasField.setText(settings.KEY_ALIAS);
        this.myRememberPasswordCheckBox.setSelected(settings.REMEMBER_PASSWORDS);
        if (settings.REMEMBER_PASSWORDS) {
            this.tryLoadSavedPasswords();
        }
        this.myModuleCombo.setRenderer((ListCellRenderer<AndroidFacet>)SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 == null) {
                return;
            }
            Module module = value2.getModule();
            label2.setText(module.getName());
            label2.setIcon(ModuleType.get((Module)module).getIcon());
        }));
        this.myGradleWarning.setIcon(StudioIcons.Common.WARNING_INLINE);
        this.myGradlePanel.setVisible(false);
        this.myModuleCombo.addActionListener(e -> this.updateSelection((AndroidFacet)this.myModuleCombo.getSelectedItem()));
        ExportSignedPackageUtil.initSigningSettingsForm(project, this);
    }

    public void _init() {
        super._init();
        this.myIsBundle = this.myWizard.getTargetType().equals((Object)ExportSignedPackageWizard.BUNDLE);
        this.updateModuleDropdown();
        this.myKeyStorePathField.addActionListener(action2 -> this.keyStoreSelected());
        this.myKeyAliasField.getTextField().addActionListener(action2 -> this.keyAliasSelected());
    }

    private void updateModuleDropdown() {
        List<AndroidFacet> facets = this.myIsBundle ? this.filteredFacets(this.myFacets) : this.myFacets;
        this.mySelection = null;
        this.myModuleCombo.setEnabled(facets.size() > 1);
        if (!facets.isEmpty()) {
            facets.sort(Comparator.comparing(Facet::getModule, ModuleTypeComparator.INSTANCE));
            String savedModuleName = PropertiesComponent.getInstance((Project)this.myWizard.getProject()).getValue(KeystoreStep.getModuleProperty(this.myIsBundle));
            Optional<AndroidFacet> optionalFacet = facets.stream().filter(facet -> facet.getModule().getName().equals(savedModuleName)).findFirst();
            this.mySelection = optionalFacet.orElse(facets.get(0));
            this.myModuleCombo.setModel((ComboBoxModel<AndroidFacet>)new CollectionComboBoxModel(facets, (Object)this.mySelection));
            this.updateSelection(this.mySelection);
        }
    }

    private List<AndroidFacet> filteredFacets(List<AndroidFacet> facets) {
        return facets.stream().filter(f -> !InstantApps.isInstantAppApplicationModule(f)).collect(Collectors.toList());
    }

    private void updateSelection(@Nullable AndroidFacet selectedItem) {
        PropertiesComponent.getInstance((Project)this.myWizard.getProject()).setValue(KeystoreStep.getModuleProperty(this.myIsBundle), selectedItem == null ? "" : selectedItem.getModule().getName());
        this.mySelection = selectedItem;
        this.showGradleError(!this.isGradleValid(this.myWizard.getTargetType()));
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        label1.setText("Module");
        label1.setDisplayedMnemonic('M');
        label1.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myModuleCombo = new JComboBox();
        this.myContentPanel.add(this.myModuleCombo, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JSeparator separator1 = new JSeparator();
        this.myContentPanel.add((Component)separator1, new GridConstraints(1, 0, 1, 2, 0, 1, 4, 0, new Dimension(-1, 1), new Dimension(-1, 24), new Dimension(-1, 1), 0, false));
        this.myKeyStorePathLabel = new JBLabel();
        this.myKeyStorePathLabel.setText("Key store path");
        this.myKeyStorePathLabel.setDisplayedMnemonic('K');
        this.myKeyStorePathLabel.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)this.myKeyStorePathLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myKeyStorePasswordLabel = new JBLabel();
        this.myKeyStorePasswordLabel.setText("Key store password");
        this.myKeyStorePasswordLabel.setDisplayedMnemonic('P');
        this.myKeyStorePasswordLabel.setDisplayedMnemonicIndex(10);
        this.myContentPanel.add((Component)this.myKeyStorePasswordLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myKeyStorePasswordField = new JPasswordField();
        this.myContentPanel.add((Component)this.myKeyStorePasswordField, new GridConstraints(5, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myKeyAliasLabel = new JBLabel();
        this.myKeyAliasLabel.setText("Key alias");
        this.myKeyAliasLabel.setDisplayedMnemonic('E');
        this.myKeyAliasLabel.setDisplayedMnemonicIndex(1);
        this.myContentPanel.add((Component)this.myKeyAliasLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myKeyPasswordLabel = new JBLabel();
        this.myKeyPasswordLabel.setText("Key password");
        this.myKeyPasswordLabel.setDisplayedMnemonic('W');
        this.myKeyPasswordLabel.setDisplayedMnemonicIndex(8);
        this.myContentPanel.add((Component)this.myKeyPasswordLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myKeyPasswordField = new JPasswordField();
        this.myContentPanel.add((Component)this.myKeyPasswordField, new GridConstraints(7, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myKeyAliasField = new TextFieldWithBrowseButton.NoPathCompletion();
        this.myContentPanel.add((Component)this.myKeyAliasField, new GridConstraints(6, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.myKeyStorePathField = new JTextField();
        this.myContentPanel.add((Component)this.myKeyStorePathField, new GridConstraints(2, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)panel1, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.myCreateKeyStoreButton = new JButton();
        this.myCreateKeyStoreButton.setText("Create new...");
        this.myCreateKeyStoreButton.setMnemonic('C');
        this.myCreateKeyStoreButton.setDisplayedMnemonicIndex(0);
        panel1.add((Component)this.myCreateKeyStoreButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myLoadKeyStoreButton = new JButton();
        this.myLoadKeyStoreButton.setText("Choose existing...");
        this.myLoadKeyStoreButton.setMnemonic('H');
        this.myLoadKeyStoreButton.setDisplayedMnemonicIndex(1);
        panel1.add((Component)this.myLoadKeyStoreButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myRememberPasswordCheckBox = new JBCheckBox();
        this.myRememberPasswordCheckBox.setText("Remember passwords");
        this.myRememberPasswordCheckBox.setMnemonic('R');
        this.myRememberPasswordCheckBox.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)this.myRememberPasswordCheckBox, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myGradlePanel = new JPanel();
        this.myGradlePanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myGradlePanel.setEnabled(false);
        this.myContentPanel.add((Component)this.myGradlePanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, false));
        this.myGradleWarning = new JBLabel();
        this.loadLabelText((JLabel)this.myGradleWarning, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.bundle.gradle.error"));
        this.myGradlePanel.add((Component)this.myGradleWarning, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2, false));
        label1.setLabelFor(this.myModuleCombo);
        this.myKeyStorePathLabel.setLabelFor((Component)this.myKeyStorePathField);
        this.myKeyStorePasswordLabel.setLabelFor((Component)this.myKeyStorePasswordField);
        this.myKeyAliasLabel.setLabelFor((Component)this.myKeyAliasField);
        this.myKeyPasswordLabel.setLabelFor((Component)this.myKeyPasswordField);
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadLabelText(JLabel component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    @NotNull
    static String getModuleProperty(boolean isBundle) {
        return isBundle ? "BundleExportedModule" : "ApkExportedModule";
    }

    private boolean isGradleValid(@NotNull ExportSignedPackageWizard.TargetType targetType) {
        if (!targetType.equals((Object)ExportSignedPackageWizard.BUNDLE)) {
            return true;
        }
        if (this.mySelection == null) {
            return true;
        }
        return GradleProjectSystemUtil.supportsBundleTask(this.mySelection.getModule());
    }

    private void showGradleError(boolean showError) {
        this.myKeyStorePasswordField.setVisible(!showError);
        this.myKeyPasswordField.setVisible(!showError);
        this.myKeyAliasField.setVisible(!showError);
        this.myKeyStorePathField.setVisible(!showError);
        this.myCreateKeyStoreButton.setVisible(!showError);
        this.myLoadKeyStoreButton.setVisible(!showError);
        this.myRememberPasswordCheckBox.setVisible(!showError);
        this.myKeyStorePasswordLabel.setVisible(!showError);
        this.myKeyPasswordLabel.setVisible(!showError);
        this.myKeyAliasLabel.setVisible(!showError);
        this.myKeyStorePathLabel.setVisible(!showError);
        this.myGradlePanel.setVisible(showError);
    }

    @Override
    public void keyStoreSelected() {
        this.myKeyStorePasswordField.setText(null);
        this.myKeyPasswordField.setText(null);
        this.tryLoadSavedPasswords();
    }

    @Override
    public void keyStoreCreated() {
    }

    @Override
    public void keyAliasSelected() {
        this.myKeyPasswordField.setText(null);
        this.tryLoadSavedPasswords();
    }

    @Override
    public void keyAliasCreated() {
    }

    private void tryLoadSavedPasswords() {
        String keyStorePath = this.myKeyStorePathField.getText();
        String keyAlias2 = this.myKeyAliasField.getText();
        this.executeInBackground(() -> {
            String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, keyStorePath, null);
            String keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, keyStorePath, keyAlias2);
            try {
                PasswordSafe passwordSafe = PasswordSafe.getInstance();
                KeystoreStep.retrievePassword(passwordSafe, Arrays.asList(KeystoreStep.credentialAttributesForKey(keyStorePasswordKey), KeystoreStep.createKeystoreDeprecatedAttributesPre_2021_1_1_3(keyStorePasswordKey), KeystoreStep.createDeprecatedAttributesPre_3_2(keyStorePasswordKey))).map(Credentials::getPassword).ifPresent(password -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                    if (this.myKeyStorePasswordField.getPassword().length == 0) {
                        this.myKeyStorePasswordField.setText(password.toString());
                    }
                }));
                KeystoreStep.retrievePassword(passwordSafe, Arrays.asList(KeystoreStep.credentialAttributesForKey(keyPasswordKey), KeystoreStep.createKeyDeprecatedAttributesPre_2021_1_1_3(keyPasswordKey), KeystoreStep.createDeprecatedAttributesPre_3_2(keyPasswordKey))).map(Credentials::getPassword).ifPresent(password -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                    if (this.myKeyPasswordField.getPassword().length == 0) {
                        this.myKeyPasswordField.setText(password.toString());
                    }
                }));
            }
            catch (Throwable t) {
                Logger.getInstance(KeystoreStep.class).error("Unable to use password safe", t);
            }
        });
    }

    private void executeInBackground(Runnable runnable2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        }
    }

    @Slow
    @NotNull
    private static Optional<Credentials> retrievePassword(@NotNull PasswordSafe passwordSafe, @NotNull List<CredentialAttributes> credentialAttributesToTry) {
        return credentialAttributesToTry.stream().map(attributes -> Optional.ofNullable(passwordSafe.get(attributes))).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @VisibleForTesting
    static void trySavePasswords(@NotNull String keyStoreLocation, char[] keyStorePassword, @NotNull String keyAlias2, char[] keyPassword2, boolean rememberPasswords) {
        String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, keyStoreLocation, null);
        String keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, keyStoreLocation, keyAlias2);
        try {
            PasswordSafe passwordSafe = PasswordSafe.getInstance();
            if (rememberPasswords) {
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyStorePasswordKey), new Credentials(keyStorePasswordKey, keyStorePassword));
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyPasswordKey), new Credentials(keyPasswordKey, keyPassword2));
            } else {
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyStorePasswordKey), null);
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyPasswordKey), null);
            }
            passwordSafe.set(KeystoreStep.createDeprecatedAttributesPre_3_2(keyStorePasswordKey), null);
            passwordSafe.set(KeystoreStep.createDeprecatedAttributesPre_3_2(keyPasswordKey), null);
            passwordSafe.set(KeystoreStep.createKeystoreDeprecatedAttributesPre_2021_1_1_3(keyStorePasswordKey), null);
            passwordSafe.set(KeystoreStep.createKeyDeprecatedAttributesPre_2021_1_1_3(keyPasswordKey), null);
        }
        catch (Throwable t) {
            Logger.getInstance(KeystoreStep.class).error("Unable to use password safe", t);
        }
    }

    @NotNull
    private static CredentialAttributes credentialAttributesForKey(@NotNull String key) {
        String serviceName = CredentialAttributesKt.generateServiceName((String)"APK Signing Keystore Step", (String)key);
        return new CredentialAttributes(serviceName);
    }

    @NotNull
    private static CredentialAttributes createDeprecatedAttributesPre_3_2(@NotNull String key) {
        return new CredentialAttributes(KeystoreStep.class.getName(), key);
    }

    @NotNull
    private static CredentialAttributes createKeystoreDeprecatedAttributesPre_2021_1_1_3(@NotNull String key) {
        return new CredentialAttributes("org.jetbrains.android.exportSignedPackage.KeystoreStep$KeyStorePasswordRequestor", key);
    }

    @NotNull
    private static CredentialAttributes createKeyDeprecatedAttributesPre_2021_1_1_3(@NotNull String key) {
        return new CredentialAttributes("org.jetbrains.android.exportSignedPackage.KeystoreStep$KeyPasswordRequestor", key);
    }

    @VisibleForTesting
    static String makePasswordKey(@NotNull String prefix, @NotNull String keyStorePath, @Nullable String keyAlias2) {
        return prefix + "__" + keyStorePath + (String)(keyAlias2 != null ? "__" + keyAlias2 : "");
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myKeyStorePathField.getText().isEmpty()) {
            return this.myKeyStorePathField;
        }
        if (this.myKeyStorePasswordField.getPassword().length == 0) {
            return this.myKeyStorePasswordField;
        }
        if (this.myKeyAliasField.getText().isEmpty()) {
            return this.myKeyAliasField;
        }
        if (this.myKeyPasswordField.getPassword().length == 0) {
            return this.myKeyPasswordField;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    @Override
    public String getHelpId() {
        return "org.jetbrains.android.studio/publish/app-signing#generate-key";
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        boolean rememberPasswords;
        if (!this.isGradleValid(this.myWizard.getTargetType())) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.bundle.gradle.error", new Object[0]));
        }
        String keyStoreLocation = this.myKeyStorePathField.getText().trim();
        if (keyStoreLocation.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.keystore.location.error", new Object[0]));
        }
        char[] keyStorePassword = this.myKeyStorePasswordField.getPassword();
        if (keyStorePassword.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.store.password.error", new Object[0]));
        }
        String keyAlias2 = this.myKeyAliasField.getText().trim();
        if (keyAlias2.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.alias.error", new Object[0]));
        }
        char[] keyPassword2 = this.myKeyPasswordField.getPassword();
        if (keyPassword2.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.password.error", new Object[0]));
        }
        if (this.myUseGradleForSigning) {
            this.myWizard.setGradleSigningInfo(new GradleSigningInfo(keyStoreLocation, keyStorePassword, keyAlias2, keyPassword2));
        } else {
            KeyStore keyStore = this.loadKeyStore(new File(keyStoreLocation));
            if (keyStore == null) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.keystore.error.title", new Object[0]));
            }
            this.loadKeyAndSaveToWizard(keyStore, keyAlias2, keyPassword2);
        }
        Project project = this.myWizard.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        settings.KEY_STORE_PATH = keyStoreLocation;
        settings.KEY_ALIAS = keyAlias2;
        settings.REMEMBER_PASSWORDS = rememberPasswords = this.myRememberPasswordCheckBox.isSelected();
        KeystoreStep.trySavePasswords(keyStoreLocation, keyStorePassword, keyAlias2, keyPassword2, rememberPasswords);
        this.myWizard.setFacet(this.getSelectedFacet());
    }

    private KeyStore loadKeyStore(File keystoreFile) throws CommitStepException {
        KeyStore keyStore;
        char[] password = this.myKeyStorePasswordField.getPassword();
        FileInputStream fis = null;
        AndroidUtils.checkPassword(password);
        if (!keystoreFile.isFile()) {
            throw new CommitStepException(AndroidBundle.message("android.cannot.find.file.error", keystoreFile.getPath()));
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(keystoreFile);
            keyStore.load(fis, password);
        }
        catch (Exception e) {
            throw new CommitStepException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            Arrays.fill(password, '\u0000');
        }
        return keyStore;
    }

    private void loadKeyAndSaveToWizard(KeyStore keyStore, String alias, char[] keyPassword2) throws CommitStepException {
        KeyStore.PrivateKeyEntry entry;
        try {
            assert (keyStore != null);
            entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyPassword2));
        }
        catch (Exception e) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.error.0.message", e.getLocalizedMessage()));
        }
        if (entry == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        PrivateKey privateKey = entry.getPrivateKey();
        Certificate certificate = entry.getCertificate();
        if (privateKey == null || certificate == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        this.myWizard.setPrivateKey(privateKey);
        this.myWizard.setCertificate((X509Certificate)certificate);
    }

    private AndroidFacet getSelectedFacet() {
        return (AndroidFacet)this.myModuleCombo.getSelectedItem();
    }

    @Override
    public JButton getLoadKeyStoreButton() {
        return this.myLoadKeyStoreButton;
    }

    @Override
    public JTextField getKeyStorePathField() {
        return this.myKeyStorePathField;
    }

    @Override
    public JPanel getPanel() {
        return this.myContentPanel;
    }

    @Override
    public JButton getCreateKeyStoreButton() {
        return this.myCreateKeyStoreButton;
    }

    @Override
    public JPasswordField getKeyStorePasswordField() {
        return this.myKeyStorePasswordField;
    }

    @Override
    public TextFieldWithBrowseButton getKeyAliasField() {
        return this.myKeyAliasField;
    }

    @Override
    public JPasswordField getKeyPasswordField() {
        return this.myKeyPasswordField;
    }
}

