/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.ide.common.signing.KeystoreHelper;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewKeyForm {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.exportSignedPackage.NewKeyForm");
    private static final String PKCS12_WARNING_PREFIX = "Warning:\nThe JKS keystore uses a proprietary format. It is recommended to migrate to PKCS12 which is an industry standard format using \"keytool -importkeystore -srckeystore";
    private static final String PKCS12_WARNING_SUFFIX = "-deststoretype pkcs12\".\n";
    private JPanel myContentPanel;
    private JTextField myAliasField;
    private JPasswordField myKeyPasswordField;
    private JPasswordField myConfirmKeyPasswordField;
    private JSpinner myValiditySpinner;
    private JTextField myFirstAndLastNameField;
    private JTextField myOrganizationUnitField;
    private JTextField myCityField;
    private JTextField myStateOrProvinceField;
    private JTextField myCountryCodeField;
    private JPanel myCertificatePanel;
    private JTextField myOrganizationField;
    private KeyStore myKeyStore;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;
    private static Method cachedGetBundleMethod = null;

    public NewKeyForm() {
        this.setupUI();
        this.myValiditySpinner.setModel(new SpinnerNumberModel(25, 1, 1000, 1));
        ((JSpinner.DefaultEditor)this.myValiditySpinner.getEditor()).getTextField().setColumns(2);
    }

    private int getValidity() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.myValiditySpinner.getModel();
        return model.getNumber().intValue();
    }

    public void init() {
        this.myAliasField.setText(this.generateAlias());
        this.myKeyPasswordField.setName("myKeyPasswordField");
        this.myConfirmKeyPasswordField.setName("myConfirmKeyPasswordField");
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    private boolean findNonEmptyCertificateField() {
        for (Component component : this.myCertificatePanel.getComponents()) {
            if (!(component instanceof JTextField) || ((JTextField)component).getText().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void createKey() throws CommitStepException {
        if (this.getKeyAlias().isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.alias.error", new Object[0]));
        }
        AndroidUtils.checkNewPassword(this.myKeyPasswordField, this.myConfirmKeyPasswordField);
        if (!this.findNonEmptyCertificateField()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.certificate.field.error", new Object[0]));
        }
        this.doCreateKey();
    }

    @NotNull
    private String generateAlias() {
        List<String> aliasList = this.getExistingKeyAliasList();
        String prefix = "key";
        if (aliasList == null) {
            return prefix + "0";
        }
        HashSet<String> aliasSet = new HashSet<String>();
        for (String string : aliasList) {
            aliasSet.add(StringUtil.toLowerCase((String)string));
        }
        int i = 0;
        String string;
        while (aliasSet.contains(string = prefix + i)) {
            ++i;
        }
        return string;
    }

    @Nullable
    protected abstract List<String> getExistingKeyAliasList();

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        this.loadLabelText(label1, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.new.key.alias.label"));
        this.myContentPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myAliasField = new JTextField();
        this.myContentPanel.add((Component)this.myAliasField, new GridConstraints(0, 1, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label2 = new JLabel();
        this.loadLabelText(label2, this.getMessageFromBundle("messages/AndroidBundle", "android.key.password.label"));
        this.myContentPanel.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myKeyPasswordField = new JPasswordField();
        this.myContentPanel.add((Component)this.myKeyPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label3 = new JLabel();
        this.loadLabelText(label3, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.key.validity.label"));
        this.myContentPanel.add((Component)label3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myValiditySpinner = new JSpinner();
        this.myContentPanel.add((Component)this.myValiditySpinner, new GridConstraints(2, 1, 1, 1, 8, 0, 4, 0, new Dimension(60, -1), null, null, 0, false));
        this.myCertificatePanel = new JPanel();
        this.myCertificatePanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)this.myCertificatePanel, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        this.myCertificatePanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Certificate", (int)0, (int)0, null, null));
        JLabel label4 = new JLabel();
        this.loadLabelText(label4, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.key.certificate.name.label"));
        this.myCertificatePanel.add((Component)label4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myFirstAndLastNameField = new JTextField();
        this.myCertificatePanel.add((Component)this.myFirstAndLastNameField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label5 = new JLabel();
        this.loadLabelText(label5, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.organization.unit.label"));
        this.myCertificatePanel.add((Component)label5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myOrganizationUnitField = new JTextField();
        this.myCertificatePanel.add((Component)this.myOrganizationUnitField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label6 = new JLabel();
        this.loadLabelText(label6, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.city.label"));
        this.myCertificatePanel.add((Component)label6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCityField = new JTextField();
        this.myCertificatePanel.add((Component)this.myCityField, new GridConstraints(3, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label7 = new JLabel();
        this.loadLabelText(label7, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.state.label"));
        this.myCertificatePanel.add((Component)label7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myStateOrProvinceField = new JTextField();
        this.myCertificatePanel.add((Component)this.myStateOrProvinceField, new GridConstraints(4, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label8 = new JLabel();
        this.loadLabelText(label8, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.country.code.label"));
        this.myCertificatePanel.add((Component)label8, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCountryCodeField = new JTextField();
        this.myCertificatePanel.add((Component)this.myCountryCodeField, new GridConstraints(5, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label9 = new JLabel();
        this.loadLabelText(label9, this.getMessageFromBundle("messages/AndroidBundle", "android.export.package.organization.label"));
        this.myCertificatePanel.add((Component)label9, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myOrganizationField = new JTextField();
        this.myCertificatePanel.add((Component)this.myOrganizationField, new GridConstraints(2, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label10 = new JLabel();
        this.loadLabelText(label10, this.getMessageFromBundle("messages/AndroidBundle", "android.confirm.password.label"));
        this.myContentPanel.add((Component)label10, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myConfirmKeyPasswordField = new JPasswordField();
        this.myContentPanel.add((Component)this.myConfirmKeyPasswordField, new GridConstraints(1, 3, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        label1.setLabelFor(this.myAliasField);
        label2.setLabelFor(this.myKeyPasswordField);
        label3.setLabelFor(this.myValiditySpinner);
        label4.setLabelFor(this.myFirstAndLastNameField);
        label5.setLabelFor(this.myOrganizationUnitField);
        label6.setLabelFor(this.myCityField);
        label7.setLabelFor(this.myStateOrProvinceField);
        label8.setLabelFor(this.myCountryCodeField);
        label9.setLabelFor(this.myOrganizationField);
        label10.setLabelFor(this.myConfirmKeyPasswordField);
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadLabelText(JLabel component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private static void buildDName(StringBuilder builder, String prefix, JTextField textField2) {
        String value2;
        if (textField2 != null && !(value2 = textField2.getText().trim()).isEmpty()) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(prefix);
            builder.append('=');
            builder.append(value2);
        }
    }

    private String getDName() {
        StringBuilder builder = new StringBuilder();
        NewKeyForm.buildDName(builder, "CN", this.myFirstAndLastNameField);
        NewKeyForm.buildDName(builder, "OU", this.myOrganizationUnitField);
        NewKeyForm.buildDName(builder, "O", this.myOrganizationField);
        NewKeyForm.buildDName(builder, "L", this.myCityField);
        NewKeyForm.buildDName(builder, "ST", this.myStateOrProvinceField);
        NewKeyForm.buildDName(builder, "C", this.myCountryCodeField);
        return builder.toString();
    }

    private void doCreateKey() throws CommitStepException {
        String keystoreLocation = this.getKeyStoreLocation();
        String keystorePassword = new String(this.getKeyStorePassword());
        String keyPassword2 = new String(this.getKeyPassword());
        String keyAlias2 = this.getKeyAlias();
        String dname = this.getDName();
        assert (dname != null);
        boolean createdStore = false;
        StringBuilder errorBuilder = new StringBuilder();
        StringBuilder outBuilder = new StringBuilder();
        try {
            createdStore = KeystoreHelper.createNewStore(null, (File)new File(keystoreLocation), (String)keystorePassword, (String)keyPassword2, (String)keyAlias2, (String)dname, (int)this.getValidity(), (int)2048);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            errorBuilder.append(e.getMessage()).append('\n');
        }
        int warningStartIndex = errorBuilder.indexOf(PKCS12_WARNING_PREFIX);
        int warningEndIndex = errorBuilder.indexOf(PKCS12_WARNING_SUFFIX);
        if (warningStartIndex >= 0 && warningEndIndex > warningStartIndex) {
            errorBuilder.delete(warningStartIndex, warningEndIndex + PKCS12_WARNING_SUFFIX.length());
        }
        NewKeyForm.normalizeBuilder(errorBuilder);
        NewKeyForm.normalizeBuilder(outBuilder);
        if (createdStore) {
            if (errorBuilder.length() > 0) {
                String prefix = AndroidBundle.message("android.create.new.key.error.prefix", new Object[0]);
                Messages.showErrorDialog((Component)this.myContentPanel, (String)(prefix + "\n" + errorBuilder.toString()));
            }
        } else {
            if (errorBuilder.length() > 0) {
                throw new CommitStepException(errorBuilder.toString());
            }
            if (outBuilder.length() > 0) {
                throw new CommitStepException(outBuilder.toString());
            }
            throw new CommitStepException(AndroidBundle.message("android.cannot.create.new.key.error", new Object[0]));
        }
        this.loadKeystoreAndKey(keystoreLocation, keystorePassword, keyAlias2, keyPassword2);
    }

    @NotNull
    public char[] getKeyPassword() {
        return this.myKeyPasswordField.getPassword();
    }

    @NotNull
    public String getKeyAlias() {
        return this.myAliasField.getText().trim();
    }

    @NotNull
    protected abstract Project getProject();

    @NotNull
    protected abstract char[] getKeyStorePassword();

    @NotNull
    protected abstract String getKeyStoreLocation();

    private void loadKeystoreAndKey(String keystoreLocation, String keystorePassword, String keyAlias2, String keyPassword2) throws CommitStepException {
        FileInputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(new File(keystoreLocation));
            keyStore.load(fis, keystorePassword.toCharArray());
            this.myKeyStore = keyStore;
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias2, new KeyStore.PasswordProtection(keyPassword2.toCharArray()));
            if (entry == null) {
                throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", keyAlias2));
            }
            PrivateKey privateKey = entry.getPrivateKey();
            Certificate certificate = entry.getCertificate();
            if (privateKey == null || certificate == null) {
                throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", keyAlias2));
            }
            this.myPrivateKey = privateKey;
            this.myCertificate = (X509Certificate)certificate;
        }
        catch (Exception e) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.error.0.message", e.getMessage()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void normalizeBuilder(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
    }

    @Nullable
    public KeyStore getKeyStore() {
        return this.myKeyStore;
    }

    @Nullable
    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    @Nullable
    public X509Certificate getCertificate() {
        return this.myCertificate;
    }
}

