/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.ProGuardConfigFilesPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidImportableProperty;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidFacetEditorTab
extends FacetEditorTab {
    public static final Key<String> PREV_AIDL_GEN_OUTPUT_PATH = Key.create((String)"android.prev.aidl.gen.output.path");
    private final AndroidFacetConfiguration myConfiguration;
    private final FacetEditorContext myContext;
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myRGenPathField;
    private TextFieldWithBrowseButton myAidlGenPathField;
    private JButton myResetPathsButton;
    private TextFieldWithBrowseButton myResFolderField;
    private TextFieldWithBrowseButton myAssetsFolderField;
    private TextFieldWithBrowseButton myNativeLibsFolder;
    private TextFieldWithBrowseButton myManifestFileField;
    private JRadioButton myUseAptResDirectoryFromPathRadio;
    private JRadioButton myUseCustomSourceDirectoryRadio;
    private TextFieldWithBrowseButton myCustomAptSourceDirField;
    private JCheckBox myIsLibraryProjectCheckbox;
    private JPanel myAaptCompilerPanel;
    private ComboboxWithBrowseButton myApkPathCombo;
    private JLabel myApkPathLabel;
    private JRadioButton myRunProcessResourcesRadio;
    private JRadioButton myCompileResourcesByIdeRadio;
    private JLabel myManifestFileLabel;
    private JLabel myResFolderLabel;
    private JLabel myAssetsFolderLabel;
    private JLabel myNativeLibsFolderLabel;
    private JLabel myAidlGenPathLabel;
    private JLabel myRGenPathLabel;
    private TextFieldWithBrowseButton myCustomDebugKeystoreField;
    private JBLabel myCustomKeystoreLabel;
    private JCheckBox myIncludeTestCodeAndCheckBox;
    private JBCheckBox myRunProguardCheckBox;
    private JBCheckBox myIncludeAssetsFromLibraries;
    private JBCheckBox myUseCustomManifestPackage;
    private JTextField myCustomManifestPackageField;
    private ComboBox<String> myUpdateProjectPropertiesCombo;
    private CheckBoxList<AndroidImportableProperty> myImportedOptionsList;
    private JBTabbedPane myTabbedPane;
    private JBCheckBox myEnableManifestMerging;
    private JBCheckBox myPreDexEnabledCheckBox;
    private ProGuardConfigFilesPanel myProGuardConfigFilesPanel;
    private JBCheckBox myEnableSourcesAutogenerationCheckBox;
    private JPanel myAptAutogenerationOptionsPanel;
    private JPanel myAidlAutogenerationOptionsPanel;
    private RawCommandLineEditor myAdditionalPackagingCommandLineParametersField;
    private TextFieldWithBrowseButton myProguardLogsDirectoryField;
    private JBLabel myProGuardLogsDirectoryLabel;
    private static final String MAVEN_TAB_TITLE = "Maven";
    private static Method cachedGetBundleMethod = null;

    private void setupUI() {
        this.createUIComponents();
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myResetPathsButton = new JButton();
        this.myResetPathsButton.setText("Reset paths to defaults");
        this.myContentPanel.add((Component)this.myResetPathsButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myContentPanel.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myIsLibraryProjectCheckbox = new JCheckBox();
        this.myIsLibraryProjectCheckbox.setSelected(false);
        this.loadButtonText(this.myIsLibraryProjectCheckbox, this.getMessageFromBundle("messages/AndroidBundle", "android.facet.editor.is.library.checkbox"));
        this.myContentPanel.add((Component)this.myIsLibraryProjectCheckbox, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null, 0, false));
        this.myTabbedPane = new JBTabbedPane();
        this.myContentPanel.add((Component)this.myTabbedPane, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myTabbedPane.addTab("Structure", (Component)panel1);
        this.myManifestFileLabel = new JLabel();
        this.myManifestFileLabel.setText("Manifest file:");
        this.myManifestFileLabel.setDisplayedMnemonic('M');
        this.myManifestFileLabel.setDisplayedMnemonicIndex(0);
        panel1.add((Component)this.myManifestFileLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myManifestFileField = new TextFieldWithBrowseButton();
        panel1.add((Component)this.myManifestFileField, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.myResFolderLabel = new JLabel();
        this.myResFolderLabel.setText("Resources directory:");
        this.myResFolderLabel.setDisplayedMnemonic('S');
        this.myResFolderLabel.setDisplayedMnemonicIndex(2);
        panel1.add((Component)this.myResFolderLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myResFolderField = new TextFieldWithBrowseButton();
        panel1.add((Component)this.myResFolderField, new GridConstraints(1, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.myAssetsFolderLabel = new JLabel();
        this.myAssetsFolderLabel.setText("Assets directory:");
        this.myAssetsFolderLabel.setDisplayedMnemonic('T');
        this.myAssetsFolderLabel.setDisplayedMnemonicIndex(4);
        panel1.add((Component)this.myAssetsFolderLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myAssetsFolderField = new TextFieldWithBrowseButton();
        panel1.add((Component)this.myAssetsFolderField, new GridConstraints(2, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.myNativeLibsFolderLabel = new JLabel();
        this.myNativeLibsFolderLabel.setText("Native libs directory:");
        this.myNativeLibsFolderLabel.setDisplayedMnemonic('L');
        this.myNativeLibsFolderLabel.setDisplayedMnemonicIndex(7);
        panel1.add((Component)this.myNativeLibsFolderLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myNativeLibsFolder = new TextFieldWithBrowseButton();
        panel1.add((Component)this.myNativeLibsFolder, new GridConstraints(3, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel1.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 4, 0), -1, -1));
        this.myTabbedPane.addTab("Generated Sources", (Component)panel2);
        Spacer spacer4 = new Spacer();
        panel2.add((Component)spacer4, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myAptAutogenerationOptionsPanel = new JPanel();
        this.myAptAutogenerationOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel2.add((Component)this.myAptAutogenerationOptionsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myAptAutogenerationOptionsPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)this.getMessageFromBundle("messages/AndroidBundle", "android.apt.settings.title"), (int)0, (int)0, null, null));
        this.myAaptCompilerPanel = new JPanel();
        this.myAaptCompilerPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAptAutogenerationOptionsPanel.add((Component)this.myAaptCompilerPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myRGenPathLabel = new JLabel();
        this.loadLabelText(this.myRGenPathLabel, this.getMessageFromBundle("messages/AndroidBundle", "android.dest.directory.title"));
        this.myAaptCompilerPanel.add((Component)this.myRGenPathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myRGenPathField = new TextFieldWithBrowseButton();
        this.myAaptCompilerPanel.add((Component)this.myRGenPathField, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.myCompileResourcesByIdeRadio = new JRadioButton();
        this.loadButtonText(this.myCompileResourcesByIdeRadio, this.getMessageFromBundle("messages/AndroidBundle", "android.facet.settings.compile.resources.by.ide"));
        this.myAptAutogenerationOptionsPanel.add((Component)this.myCompileResourcesByIdeRadio, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myRunProcessResourcesRadio = new JRadioButton();
        this.loadButtonText(this.myRunProcessResourcesRadio, this.getMessageFromBundle("messages/AndroidBundle", "copy.resources.from.artifacts.setting"));
        this.myAptAutogenerationOptionsPanel.add((Component)this.myRunProcessResourcesRadio, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myAidlAutogenerationOptionsPanel = new JPanel();
        this.myAidlAutogenerationOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel2.add((Component)this.myAidlAutogenerationOptionsPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myAidlAutogenerationOptionsPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"AIDL files", (int)0, (int)0, null, null));
        this.myAidlGenPathLabel = new JLabel();
        this.loadLabelText(this.myAidlGenPathLabel, this.getMessageFromBundle("messages/AndroidBundle", "android.dest.directory.title"));
        this.myAidlAutogenerationOptionsPanel.add((Component)this.myAidlGenPathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myAidlGenPathField = new TextFieldWithBrowseButton();
        this.myAidlAutogenerationOptionsPanel.add((Component)this.myAidlGenPathField, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.myEnableSourcesAutogenerationCheckBox = new JBCheckBox();
        this.myEnableSourcesAutogenerationCheckBox.setText("Generate sources automatically ");
        this.myEnableSourcesAutogenerationCheckBox.setMnemonic('O');
        this.myEnableSourcesAutogenerationCheckBox.setDisplayedMnemonicIndex(20);
        panel2.add((Component)this.myEnableSourcesAutogenerationCheckBox, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 4, 0), -1, -1));
        this.myTabbedPane.addTab("Packaging", (Component)panel3);
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        panel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)this.getMessageFromBundle("messages/AndroidBundle", "android.apk.settings.title"), (int)0, (int)0, null, null));
        this.myUseAptResDirectoryFromPathRadio = new JRadioButton();
        this.loadButtonText(this.myUseAptResDirectoryFromPathRadio, this.getMessageFromBundle("messages/AndroidBundle", "android.generate.r.java.by.res.dir"));
        panel4.add((Component)this.myUseAptResDirectoryFromPathRadio, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.myUseCustomSourceDirectoryRadio = new JRadioButton();
        this.loadButtonText(this.myUseCustomSourceDirectoryRadio, this.getMessageFromBundle("messages/AndroidBundle", "android.use.custom.r.java.source.dir"));
        panel4.add((Component)this.myUseCustomSourceDirectoryRadio, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myCustomAptSourceDirField = new TextFieldWithBrowseButton();
        panel4.add((Component)this.myCustomAptSourceDirField, new GridConstraints(1, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        this.myIncludeAssetsFromLibraries = new JBCheckBox();
        this.myIncludeAssetsFromLibraries.setText("Include assets from dependencies into APK");
        panel4.add((Component)this.myIncludeAssetsFromLibraries, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.myUseCustomManifestPackage = new JBCheckBox();
        this.loadButtonText((AbstractButton)this.myUseCustomManifestPackage, this.getMessageFromBundle("messages/AndroidBundle", "android.aapt.use.custom.package.name"));
        panel4.add((Component)this.myUseCustomManifestPackage, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCustomManifestPackageField = new JTextField();
        panel4.add((Component)this.myCustomManifestPackageField, new GridConstraints(3, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myEnableManifestMerging = new JBCheckBox();
        this.myEnableManifestMerging.setText("Enable manifest merging");
        panel4.add((Component)this.myEnableManifestMerging, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Additional command line parameters:");
        panel4.add((Component)jBLabel1, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myAdditionalPackagingCommandLineParametersField = new RawCommandLineEditor();
        panel4.add((Component)this.myAdditionalPackagingCommandLineParametersField, new GridConstraints(5, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        panel3.add((Component)spacer5, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myIncludeTestCodeAndCheckBox = new JCheckBox();
        this.loadButtonText(this.myIncludeTestCodeAndCheckBox, this.getMessageFromBundle("messages/AndroidBundle", "android.facet.settings.pack.test.sources"));
        panel3.add((Component)this.myIncludeTestCodeAndCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.myCustomKeystoreLabel = new JBLabel();
        this.loadLabelText((JLabel)this.myCustomKeystoreLabel, this.getMessageFromBundle("messages/AndroidBundle", "android.facet.settings.custom.debug.keystore.label"));
        panel3.add((Component)this.myCustomKeystoreLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCustomDebugKeystoreField = new TextFieldWithBrowseButton();
        panel3.add((Component)this.myCustomDebugKeystoreField, new GridConstraints(2, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        this.myApkPathLabel = new JLabel();
        this.loadLabelText(this.myApkPathLabel, this.getMessageFromBundle("messages/AndroidBundle", "android.facet.settings.apk.path.label"));
        panel3.add((Component)this.myApkPathLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myApkPathCombo = new ComboboxWithBrowseButton();
        panel3.add((Component)this.myApkPathCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myPreDexEnabledCheckBox = new JBCheckBox();
        this.myPreDexEnabledCheckBox.setText("Pre-dex external jars and Android library dependencies");
        panel3.add((Component)this.myPreDexEnabledCheckBox, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 4, 0), -1, -1));
        this.myTabbedPane.addTab("ProGuard", (Component)panel5);
        this.myRunProguardCheckBox = new JBCheckBox();
        this.loadButtonText((AbstractButton)this.myRunProguardCheckBox, this.getMessageFromBundle("messages/AndroidBundle", "android.facet.settings.run.proguard"));
        panel5.add((Component)this.myRunProguardCheckBox, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        Spacer spacer6 = new Spacer();
        panel5.add((Component)spacer6, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        panel5.add((Component)this.myProGuardConfigFilesPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.myProGuardLogsDirectoryLabel = new JBLabel();
        this.myProGuardLogsDirectoryLabel.setText("Proguard logs directory:");
        panel5.add((Component)this.myProGuardLogsDirectoryLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myProguardLogsDirectoryField = new TextFieldWithBrowseButton();
        panel5.add((Component)this.myProguardLogsDirectoryField, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myTabbedPane.addTab(MAVEN_TAB_TITLE, (Component)panel6);
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Import following options from pom.xml:");
        panel6.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myImportedOptionsList = new CheckBoxList();
        panel6.add((Component)this.myImportedOptionsList, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Update \"project.properties\" file automatically:");
        jBLabel3.setDisplayedMnemonic('D');
        jBLabel3.setDisplayedMnemonicIndex(2);
        this.myContentPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myUpdateProjectPropertiesCombo = new ComboBox();
        this.myContentPanel.add((Component)this.myUpdateProjectPropertiesCombo, new GridConstraints(1, 1, 1, 1, 0, 0, 2, 0, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.myContentPanel.add((Component)spacer7, new GridConstraints(1, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        jBLabel1.setLabelFor((Component)this.myAdditionalPackagingCommandLineParametersField);
        this.myApkPathLabel.setLabelFor((Component)this.myApkPathCombo);
        this.myProGuardLogsDirectoryLabel.setLabelFor((Component)this.myProguardLogsDirectoryField);
        jBLabel3.setLabelFor(this.myUpdateProjectPropertiesCombo);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myUseAptResDirectoryFromPathRadio);
        buttonGroup.add(this.myUseCustomSourceDirectoryRadio);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myCompileResourcesByIdeRadio);
        buttonGroup.add(this.myRunProcessResourcesRadio);
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadLabelText(JLabel component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void loadButtonText(AbstractButton component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent getRootComponent() {
        return this.myContentPanel;
    }

    public AndroidFacetEditorTab(FacetEditorContext context, AndroidFacetConfiguration androidFacetConfiguration) {
        try {
            this.setupUI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Project project = context.getProject();
        this.myConfiguration = androidFacetConfiguration;
        this.myContext = context;
        this.myManifestFileLabel.setLabelFor((Component)this.myManifestFileField);
        this.myResFolderLabel.setLabelFor((Component)this.myResFolderField);
        this.myAssetsFolderLabel.setLabelFor((Component)this.myAssetsFolderField);
        this.myNativeLibsFolderLabel.setLabelFor((Component)this.myNativeLibsFolder);
        this.myAidlGenPathLabel.setLabelFor((Component)this.myAidlGenPathField);
        this.myRGenPathLabel.setLabelFor((Component)this.myRGenPathField);
        this.myCustomKeystoreLabel.setLabelFor((Component)this.myCustomDebugKeystoreField);
        AndroidFacet facet = (AndroidFacet)this.myContext.getFacet();
        this.myRGenPathField.addActionListener((ActionListener)new MyGenSourceFieldListener(this.myRGenPathField, AndroidRootUtil.getAptGenSourceRootPath(facet)));
        this.myAidlGenPathField.addActionListener((ActionListener)new MyGenSourceFieldListener(this.myAidlGenPathField, AndroidRootUtil.getAidlGenSourceRootPath(facet)));
        Module module = this.myContext.getModule();
        this.myManifestFileField.addActionListener((ActionListener)new MyFolderFieldListener(this.myManifestFileField, AndroidRootUtil.getPrimaryManifestFile(facet), true, new MyManifestFilter()));
        this.myResFolderField.addActionListener((ActionListener)new MyFolderFieldListener(this.myResFolderField, AndroidRootUtil.getResourceDir(facet), false, null));
        this.myAssetsFolderField.addActionListener((ActionListener)new MyFolderFieldListener(this.myAssetsFolderField, AndroidRootUtil.getAssetsDir(facet), false, null));
        this.myNativeLibsFolder.addActionListener((ActionListener)new MyFolderFieldListener(this.myNativeLibsFolder, AndroidRootUtil.getLibsDir(facet), false, null));
        this.myRunProguardCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.myProGuardConfigFilesPanel.setEnabled(AndroidFacetEditorTab.this.myRunProguardCheckBox.isSelected());
            }
        });
        this.myCustomDebugKeystoreField.addActionListener((ActionListener)new MyFolderFieldListener(this.myCustomDebugKeystoreField, null, true, null));
        this.myResetPathsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetConfiguration configuration2 = new AndroidFacetConfiguration();
                Module module = AndroidFacetEditorTab.this.myContext.getModule();
                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                if (contentRoots.length == 1) {
                    AndroidUtils.setUpAndroidFacetConfiguration(module, configuration2, contentRoots[0].getPath());
                }
                AndroidFacetEditorTab.this.resetOptions(configuration2);
            }
        });
        this.myEnableSourcesAutogenerationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.updateAutogenerationPanels();
            }
        });
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.myCustomAptSourceDirField.setEnabled(AndroidFacetEditorTab.this.myUseCustomSourceDirectoryRadio.isSelected());
            }
        };
        this.myUseCustomSourceDirectoryRadio.addActionListener(listener2);
        this.myUseAptResDirectoryFromPathRadio.addActionListener(listener2);
        this.myIsLibraryProjectCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.updateLibAndAppSpecificFields();
            }
        });
        listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.updateAptPanel();
            }
        };
        this.myRunProcessResourcesRadio.addActionListener(listener2);
        this.myCompileResourcesByIdeRadio.addActionListener(listener2);
        this.myApkPathLabel.setLabelFor((Component)this.myApkPathCombo);
        JComboBox apkPathComboBoxComponent = this.myApkPathCombo.getComboBox();
        apkPathComboBoxComponent.setEditable(true);
        apkPathComboBoxComponent.setModel(new DefaultComboBoxModel<String>(AndroidFacetEditorTab.getDefaultApks(module)));
        apkPathComboBoxComponent.setMinimumSize(new Dimension(JBUI.scale((int)10), apkPathComboBoxComponent.getMinimumSize().height));
        apkPathComboBoxComponent.setPreferredSize(new Dimension(JBUI.scale((int)10), apkPathComboBoxComponent.getPreferredSize().height));
        this.myApkPathCombo.addBrowseFolderListener(project, new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                return file.isDirectory() || "apk".equals(file.getExtension());
            }
        });
        this.myUseCustomManifestPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacetEditorTab.this.myCustomManifestPackageField.setEnabled(AndroidFacetEditorTab.this.myUseCustomManifestPackage.isSelected());
            }
        });
        this.myUpdateProjectPropertiesCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{"", Boolean.TRUE.toString(), Boolean.FALSE.toString()}));
        this.myUpdateProjectPropertiesCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"No", value2 -> value2.isEmpty() ? "Ask" : (Boolean.parseBoolean(value2) ? "Yes" : "No")));
        this.buildImportedOptionsList();
        int mavenTabIndex = this.myTabbedPane.indexOfTab(MAVEN_TAB_TITLE);
        assert (mavenTabIndex >= 0);
        this.myProguardLogsDirectoryField.addActionListener((ActionListener)new MyFolderFieldListener(this.myProguardLogsDirectoryField, null, false, null));
    }

    @Nullable
    private void updateLibAndAppSpecificFields() {
        boolean lib = this.myIsLibraryProjectCheckbox.isSelected();
        this.myAssetsFolderField.setEnabled(!lib);
        this.myEnableManifestMerging.setEnabled(!lib);
        this.myIncludeAssetsFromLibraries.setEnabled(!lib);
        this.myUseCustomManifestPackage.setEnabled(!lib);
        this.myCustomManifestPackageField.setEnabled(!lib && this.myUseCustomManifestPackage.isSelected());
        this.myAdditionalPackagingCommandLineParametersField.setEnabled(!lib);
        this.myRunProguardCheckBox.setEnabled(!lib);
        this.myProGuardConfigFilesPanel.setEnabled(!lib && this.myRunProguardCheckBox.isSelected());
        this.myApkPathLabel.setEnabled(!lib);
        this.myApkPathCombo.setEnabled(!lib);
        this.myCustomKeystoreLabel.setEnabled(!lib);
        this.myCustomDebugKeystoreField.setEnabled(!lib);
        this.myPreDexEnabledCheckBox.setEnabled(!lib);
        this.myProGuardLogsDirectoryLabel.setEnabled(!lib);
        this.myProguardLogsDirectoryField.setEnabled(!lib);
    }

    private void updateAutogenerationPanels() {
        UIUtil.setEnabled((Component)this.myAidlAutogenerationOptionsPanel, (boolean)this.myEnableSourcesAutogenerationCheckBox.isSelected(), (boolean)true);
        this.updateAptPanel();
    }

    private void buildImportedOptionsList() {
        this.myImportedOptionsList.setItems(Arrays.asList(AndroidImportableProperty.values()), (Function)new Function<AndroidImportableProperty, String>(){

            public String fun(AndroidImportableProperty property2) {
                return property2.getDisplayName();
            }
        });
    }

    private void updateAptPanel() {
        if (!this.myEnableSourcesAutogenerationCheckBox.isSelected()) {
            UIUtil.setEnabled((Component)this.myAptAutogenerationOptionsPanel, (boolean)false, (boolean)true);
        } else {
            UIUtil.setEnabled((Component)this.myAptAutogenerationOptionsPanel, (boolean)true, (boolean)true);
            boolean enabled = !this.myRunProcessResourcesRadio.isVisible() || !this.myRunProcessResourcesRadio.isSelected();
            UIUtil.setEnabled((Component)this.myAaptCompilerPanel, (boolean)enabled, (boolean)true);
        }
    }

    private static String[] getDefaultApks(@NotNull Module module) {
        ArrayList<String> result2 = new ArrayList<String>();
        String path = AndroidCompileUtil.getOutputPackage(module);
        if (path != null) {
            result2.add(path);
        }
        return ArrayUtil.toStringArray(result2);
    }

    @Nls
    public String getDisplayName() {
        return "Android SDK Settings";
    }

    @NotNull
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        if (this.myIsLibraryProjectCheckbox.isSelected() != (this.myConfiguration.getState().PROJECT_TYPE == 1)) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_APT, this.myRGenPathField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL, this.myAidlGenPathField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().MANIFEST_FILE_RELATIVE_PATH, this.myManifestFileField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().RES_FOLDER_RELATIVE_PATH, this.myResFolderField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().ASSETS_FOLDER_RELATIVE_PATH, this.myAssetsFolderField.getText())) {
            return true;
        }
        if (this.checkRelativePath(this.myConfiguration.getState().LIBS_FOLDER_RELATIVE_PATH, this.myNativeLibsFolder.getText())) {
            return true;
        }
        if (!this.myConfiguration.getState().CUSTOM_DEBUG_KEYSTORE_PATH.equals(this.getSelectedCustomKeystorePath())) {
            return true;
        }
        if (this.myConfiguration.getState().PACK_TEST_CODE != this.myIncludeTestCodeAndCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfiguration.getState().RUN_PROGUARD != this.myRunProguardCheckBox.isSelected()) {
            return true;
        }
        if (!this.myProGuardConfigFilesPanel.getUrls().equals(this.myConfiguration.getState().myProGuardCfgFiles)) {
            return true;
        }
        if (this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE != this.myUseCustomManifestPackage.isSelected()) {
            return true;
        }
        if (!this.myCustomManifestPackageField.getText().trim().equals(this.myConfiguration.getState().CUSTOM_MANIFEST_PACKAGE)) {
            return true;
        }
        return this.checkRelativePath(this.myConfiguration.getState().PROGUARD_LOGS_FOLDER_RELATIVE_PATH, this.myProguardLogsDirectoryField.getText());
    }

    @NotNull
    private String getSelectedCustomKeystorePath() {
        String path = this.myCustomDebugKeystoreField.getText().trim();
        return !path.isEmpty() ? VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)path)) : "";
    }

    private boolean checkRelativePath(String relativePathFromConfig, String absPathFromTextField) {
        String pathFromTextField;
        String pathFromConfig = relativePathFromConfig;
        if (pathFromConfig != null && !pathFromConfig.isEmpty()) {
            pathFromConfig = this.toAbsolutePath(pathFromConfig);
        }
        return !FileUtil.pathsEqual((String)pathFromConfig, (String)(pathFromTextField = absPathFromTextField.trim()));
    }

    @Nullable
    private String toRelativePath(String absPath) {
        absPath = FileUtil.toSystemIndependentName((String)absPath);
        @SystemIndependent String moduleDirPath = AndroidRootUtil.getModuleDirPath(this.myContext.getModule());
        if (moduleDirPath != null) {
            return FileUtil.getRelativePath((String)moduleDirPath, (String)absPath, (char)'/');
        }
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.project.modules.android.facet";
    }

    public void apply() throws ConfigurationException {
        if (!this.isModified()) {
            return;
        }
        String absGenPathR = this.myRGenPathField.getText().trim();
        String absGenPathAidl = this.myAidlGenPathField.getText().trim();
        if (absGenPathR.isEmpty() || absGenPathAidl.isEmpty()) {
            throw new ConfigurationException("Please specify source root for autogenerated files");
        }
        String relativeGenPathR = this.getAndCheckRelativePath(absGenPathR, false);
        this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_APT = "/" + relativeGenPathR;
        String relativeGenPathAidl = this.getAndCheckRelativePath(absGenPathAidl, false);
        String newIdlDestDir = "/" + relativeGenPathAidl;
        this.myContext.getFacet().putUserData(PREV_AIDL_GEN_OUTPUT_PATH, (Object)this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL);
        this.myConfiguration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL = newIdlDestDir;
        String absManifestPath = this.myManifestFileField.getText().trim();
        if (absManifestPath.isEmpty()) {
            throw new ConfigurationException("Manifest file not specified");
        }
        String manifestRelPath = this.getAndCheckRelativePath(absManifestPath, true);
        if (!"AndroidManifest.xml".equals(AndroidUtils.getSimpleNameByRelativePath(manifestRelPath))) {
            throw new ConfigurationException("Manifest file must have name AndroidManifest.xml");
        }
        this.myConfiguration.getState().MANIFEST_FILE_RELATIVE_PATH = "/" + manifestRelPath;
        String absResPath = this.myResFolderField.getText().trim();
        if (absResPath.isEmpty()) {
            throw new ConfigurationException("Resources folder not specified");
        }
        this.myConfiguration.getState().RES_FOLDER_RELATIVE_PATH = "/" + this.getAndCheckRelativePath(absResPath, false);
        String absAssetsPath = this.myAssetsFolderField.getText().trim();
        this.myConfiguration.getState().ASSETS_FOLDER_RELATIVE_PATH = !absAssetsPath.isEmpty() ? "/" + this.getAndCheckRelativePath(absAssetsPath, false) : "";
        String absApkPath = (String)this.myApkPathCombo.getComboBox().getEditor().getItem();
        this.myConfiguration.getState().APK_PATH = absApkPath.isEmpty() ? "" : "/" + this.getAndCheckRelativePath(absApkPath, false);
        String absLibsPath = this.myNativeLibsFolder.getText().trim();
        this.myConfiguration.getState().LIBS_FOLDER_RELATIVE_PATH = !absLibsPath.isEmpty() ? "/" + this.getAndCheckRelativePath(absLibsPath, false) : "";
        this.myConfiguration.getState().CUSTOM_DEBUG_KEYSTORE_PATH = this.getSelectedCustomKeystorePath();
        this.myConfiguration.getState().PROJECT_TYPE = this.myIsLibraryProjectCheckbox.isSelected() ? 1 : 0;
        this.myConfiguration.getState().PACK_TEST_CODE = this.myIncludeTestCodeAndCheckBox.isSelected();
        this.myConfiguration.getState().RUN_PROGUARD = this.myRunProguardCheckBox.isSelected();
        this.myConfiguration.getState().myProGuardCfgFiles = this.myProGuardConfigFilesPanel.getUrls();
        boolean useCustomAptSrc = this.myUseCustomSourceDirectoryRadio.isSelected();
        this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE = this.myUseCustomManifestPackage.isSelected();
        this.myConfiguration.getState().CUSTOM_MANIFEST_PACKAGE = this.myCustomManifestPackageField.getText().trim();
        String absAptSourcePath = this.myCustomAptSourceDirField.getText().trim();
        if (useCustomAptSrc && absAptSourcePath.isEmpty()) {
            throw new ConfigurationException("Resources folder not specified");
        }
        String absProguardLogsPath = this.myProguardLogsDirectoryField.getText().trim();
        this.myConfiguration.getState().PROGUARD_LOGS_FOLDER_RELATIVE_PATH = !absProguardLogsPath.isEmpty() ? "/" + this.getAndCheckRelativePath(absProguardLogsPath, false) : "";
    }

    private String getAndCheckRelativePath(String absPath, boolean checkExists) throws ConfigurationException {
        if (absPath.indexOf(47) < 0 && absPath.indexOf(File.separatorChar) < 0) {
            throw new ConfigurationException(AndroidBundle.message("file.must.be.under.module.error", FileUtil.toSystemDependentName((String)absPath)));
        }
        String relativeGenPathR = this.toRelativePath(absPath);
        if (relativeGenPathR == null || relativeGenPathR.isEmpty()) {
            throw new ConfigurationException(AndroidBundle.message("file.must.be.under.module.error", FileUtil.toSystemDependentName((String)absPath)));
        }
        if (checkExists && LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)absPath)) == null) {
            throw new ConfigurationException(AndroidBundle.message("android.file.not.exist.error", FileUtil.toSystemDependentName((String)absPath)));
        }
        return relativeGenPathR;
    }

    public void reset() {
        this.myIsLibraryProjectCheckbox.setSelected(this.myConfiguration.getState().PROJECT_TYPE == 1);
        this.resetOptions(this.myConfiguration);
    }

    private void resetOptions(AndroidFacetConfiguration configuration2) {
        String aptGenPath = configuration2.getState().GEN_FOLDER_RELATIVE_PATH_APT;
        String aptAbspath = !aptGenPath.isEmpty() ? this.toAbsolutePath(aptGenPath) : "";
        this.myRGenPathField.setText(aptAbspath != null ? aptAbspath : "");
        String aidlGenPath = configuration2.getState().GEN_FOLDER_RELATIVE_PATH_AIDL;
        String aidlAbsPath = !aidlGenPath.isEmpty() ? this.toAbsolutePath(aidlGenPath) : "";
        this.myAidlGenPathField.setText(aidlAbsPath != null ? aidlAbsPath : "");
        String manifestPath = configuration2.getState().MANIFEST_FILE_RELATIVE_PATH;
        String manifestAbsPath = !manifestPath.isEmpty() ? this.toAbsolutePath(manifestPath) : "";
        this.myManifestFileField.setText(manifestAbsPath != null ? manifestAbsPath : "");
        String resPath = configuration2.getState().RES_FOLDER_RELATIVE_PATH;
        String resAbsPath = !resPath.isEmpty() ? this.toAbsolutePath(resPath) : "";
        this.myResFolderField.setText(resAbsPath != null ? resAbsPath : "");
        String assetsPath = configuration2.getState().ASSETS_FOLDER_RELATIVE_PATH;
        String assetsAbsPath = !assetsPath.isEmpty() ? this.toAbsolutePath(assetsPath) : "";
        this.myAssetsFolderField.setText(assetsAbsPath != null ? assetsAbsPath : "");
        String libsPath = configuration2.getState().LIBS_FOLDER_RELATIVE_PATH;
        String libsAbsPath = !libsPath.isEmpty() ? this.toAbsolutePath(libsPath) : "";
        this.myNativeLibsFolder.setText(libsAbsPath != null ? libsAbsPath : "");
        this.myCustomDebugKeystoreField.setText(FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configuration2.getState().CUSTOM_DEBUG_KEYSTORE_PATH)));
        boolean runProguard = configuration2.getState().RUN_PROGUARD;
        this.myRunProguardCheckBox.setSelected(runProguard);
        this.myProGuardConfigFilesPanel.setUrls(configuration2.getState().myProGuardCfgFiles);
        String apkPath = configuration2.getState().APK_PATH;
        String apkAbsPath = !apkPath.isEmpty() ? this.toAbsolutePath(apkPath) : "";
        this.myApkPathCombo.getComboBox().getEditor().setItem(apkAbsPath != null ? apkAbsPath : "");
        this.myRunProcessResourcesRadio.setVisible(false);
        this.myCompileResourcesByIdeRadio.setVisible(false);
        this.myIncludeTestCodeAndCheckBox.setSelected(this.myConfiguration.getState().PACK_TEST_CODE);
        this.myUseCustomManifestPackage.setSelected(this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE);
        this.myCustomManifestPackageField.setEnabled(this.myConfiguration.getState().USE_CUSTOM_MANIFEST_PACKAGE);
        this.myCustomManifestPackageField.setText(this.myConfiguration.getState().CUSTOM_MANIFEST_PACKAGE);
        String proguardLogsPath = configuration2.getState().PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        String proguardLogsAbsPath = !proguardLogsPath.isEmpty() ? this.toAbsolutePath(proguardLogsPath) : "";
        this.myProguardLogsDirectoryField.setText(proguardLogsAbsPath != null ? proguardLogsAbsPath : "");
        this.updateAutogenerationPanels();
        int mavenTabIndex = this.myTabbedPane.indexOfTab(MAVEN_TAB_TITLE);
        if (mavenTabIndex >= 0) {
            this.myTabbedPane.removeTabAt(mavenTabIndex);
        }
        this.updateLibAndAppSpecificFields();
    }

    @Nullable
    private String toAbsolutePath(String genRelativePath) {
        if (genRelativePath == null) {
            return null;
        }
        if (genRelativePath.isEmpty()) {
            return "";
        }
        @SystemIndependent String moduleDirPath = AndroidRootUtil.getModuleDirPath(this.myContext.getModule());
        if (moduleDirPath == null) {
            return null;
        }
        String path = PathUtil.getCanonicalPath((String)new File(moduleDirPath, genRelativePath).getPath());
        return path != null ? PathUtil.getLocalPath((String)path) : null;
    }

    private void createUIComponents() {
        this.myProGuardConfigFilesPanel = new ProGuardConfigFilesPanel(){

            @Override
            @Nullable
            protected AndroidFacet getFacet() {
                return (AndroidFacet)AndroidFacetEditorTab.this.myContext.getFacet();
            }
        };
    }

    private VirtualFile[] chooserDirsUnderModule(@Nullable VirtualFile initialFile, final boolean chooseFile, final @Nullable Condition<VirtualFile> filter2) {
        String p;
        if (initialFile == null) {
            initialFile = this.myContext.getModule().getModuleFile();
        }
        if (initialFile == null && (p = AndroidRootUtil.getModuleDirPath(this.myContext.getModule())) != null) {
            initialFile = LocalFileSystem.getInstance().findFileByPath(p);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(chooseFile, !chooseFile, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                if (!file.isDirectory() && !chooseFile) {
                    return false;
                }
                return filter2 == null || filter2.value((Object)file);
            }
        };
        return FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Component)this.myContentPanel, (Project)this.myContext.getProject(), (VirtualFile)initialFile);
    }

    private class MyGenSourceFieldListener
    implements ActionListener {
        private final TextFieldWithBrowseButton myTextField;
        private final String myDefaultPath;

        private MyGenSourceFieldListener(TextFieldWithBrowseButton textField2, String defaultPath) {
            this.myTextField = textField2;
            this.myDefaultPath = defaultPath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Module module = AndroidFacetEditorTab.this.myContext.getModule();
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length == 0) {
                return;
            }
            VirtualFile initialFile = null;
            String path = this.myTextField.getText().trim();
            if (path.isEmpty()) {
                path = this.myDefaultPath;
            }
            if (path != null) {
                initialFile = LocalFileSystem.getInstance().findFileByPath(path);
            }
            if (initialFile == null) {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
                VirtualFile[] sourceRoots = manager.getSourceRoots();
                if (sourceRoots.length > 0) {
                    initialFile = sourceRoots[0];
                } else {
                    String p;
                    initialFile = module.getModuleFile();
                    if (initialFile == null && (p = AndroidRootUtil.getModuleDirPath(AndroidFacetEditorTab.this.myContext.getModule())) != null) {
                        initialFile = LocalFileSystem.getInstance().findFileByPath(p);
                    }
                }
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor2.setRoots(contentRoots);
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)AndroidFacetEditorTab.this.myContentPanel, (Project)AndroidFacetEditorTab.this.myContext.getProject(), (VirtualFile)initialFile);
            if (file != null) {
                this.myTextField.setText(FileUtil.toSystemDependentName((String)file.getPath()));
            }
        }
    }

    private class MyFolderFieldListener
    implements ActionListener {
        private final TextFieldWithBrowseButton myTextField;
        private final VirtualFile myDefaultDir;
        private final boolean myChooseFile;
        private final Condition<VirtualFile> myFilter;

        public MyFolderFieldListener(TextFieldWithBrowseButton textField2, VirtualFile defaultDir, @Nullable boolean chooseFile, Condition<VirtualFile> filter2) {
            this.myTextField = textField2;
            this.myDefaultDir = defaultDir;
            this.myChooseFile = chooseFile;
            this.myFilter = filter2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile[] files2;
            VirtualFile initialFile = null;
            String path = this.myTextField.getText().trim();
            if (path.isEmpty()) {
                VirtualFile dir = this.myDefaultDir;
                String string = path = dir != null ? dir.getPath() : null;
            }
            if (path != null) {
                initialFile = LocalFileSystem.getInstance().findFileByPath(path);
            }
            if ((files2 = AndroidFacetEditorTab.this.chooserDirsUnderModule(initialFile, this.myChooseFile, this.myFilter)).length > 0) {
                assert (files2.length == 1);
                this.myTextField.setText(FileUtil.toSystemDependentName((String)files2[0].getPath()));
            }
        }
    }

    private static class MyManifestFilter
    implements Condition<VirtualFile> {
        private MyManifestFilter() {
        }

        public boolean value(VirtualFile file) {
            return file.isDirectory() || file.getName().equals("AndroidManifest.xml");
        }
    }

    public static final class Provider
    implements AndroidFacetConfiguration.EditorTabProvider {
        public FacetEditorTab createFacetEditorTab(@NotNull FacetEditorContext editorContext, @NotNull AndroidFacetConfiguration configuration2) {
            return new AndroidFacetEditorTab(editorContext, configuration2);
        }
    }
}

