/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.module.AndroidModuleInfo;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageFeatureProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLanguageFeatureProvider
implements LanguageFeatureProvider {
    @NotNull
    public ThreeState isFeatureSupported(@NotNull JavaFeature feature, @NotNull PsiFile file) {
        if (JavaFeature.MULTI_CATCH == feature) {
            return ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file, 19, true));
        }
        if (JavaFeature.STREAM_OPTIONAL == feature || JavaFeature.ADVANCED_COLLECTIONS_API == feature) {
            return ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file, 24, true));
        }
        if (JavaFeature.THREAD_LOCAL_WITH_INITIAL == feature) {
            return ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file, 26, true));
        }
        return ThreeState.UNSURE;
    }

    public static boolean isApiLevelAtLeast(@Nullable PsiFile file, int minApiLevel, boolean defaultValue) {
        AndroidFacet facet;
        if (file != null && (facet = AndroidFacet.getInstance((PsiElement)file)) != null && !facet.isDisposed()) {
            AndroidModuleInfo info = StudioAndroidModuleInfo.getInstance(facet);
            return info.getMinSdkVersion().getApiLevel() >= minApiLevel;
        }
        return defaultValue;
    }
}

